/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet.java1;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.netfile.servlet.java1.FileOption;
import com.sun.portal.netfile.servlet.java1.FtpFile;
import com.sun.portal.netfile.servlet.java1.NetFileContext;
import com.sun.portal.netfile.servlet.java1.NetFileContextImpl;
import com.sun.portal.netfile.servlet.java1.NetFileException;
import com.sun.portal.netfile.servlet.java1.NetFileLogManager;
import com.sun.portal.netfile.servlet.java1.NetFileResource;
import com.sun.portal.netfile.servlet.java1.NetFileServlet;
import com.sun.portal.netfile.servlet.java1.NetFileURLDecoder;
import com.sun.portal.netfile.servlet.java1.NetWareFile;
import com.sun.portal.netfile.servlet.java1.NfsFile;
import com.sun.portal.netfile.servlet.java1.XFileFactory;
import com.sun.portal.netfile.servlet.java1.XFileInterface;
import com.sun.xfile.XFileInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NetFileOpenFileServlet
extends HttpServlet {
    private static Debug debug;
    private static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain; charset=UTF-8";
    private int bufSize = 8192;
    String nfid = "";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (debug == null) {
            debug = Debug.getInstance((String)"srapNetFile");
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGetPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGetPost(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String fileName = null;
        FileOption file_option = null;
        NetFileLogManager logManager = null;
        SSOTokenManager manager = null;
        SSOToken ssoToken = null;
        String processingType = null;
        try {
            manager = SSOTokenManager.getInstance();
            ssoToken = manager.createSSOToken(this.extractSession(req));
            processingType = this.getProcessMethod(req);
            NetFileContextImpl nfContext = new NetFileContextImpl(ssoToken);
            nfContext.determineHTMLCharset(req);
            String htmlCharset = nfContext.getHTMLCharset();
            if (logManager == null) {
                logManager = this.createLogManager(ssoToken);
            }
            if (processingType == null || processingType.equals("")) {
                HashMap parameters = this.parseHttpRequestForParameters(req);
                String requestId = this.getValue(parameters, "nfid");
                String function = this.getValue(parameters, "function");
                String locale = this.getValue(parameters, "locale");
                List dataValues = this.getFromSession(ssoToken, requestId);
                String encoding = (String)dataValues.get(4);
                file_option = new FileOption(logManager, encoding);
                NetFileResource resourceBundle = this.getUserLocaleBundle(file_option, locale, encoding);
                fileName = (String)dataValues.get(6);
                String returnType = this.getReturnType(fileName, resourceBundle, logManager, ssoToken, encoding);
                if (function.equals("viewFile")) {
                    this.setContentTypeForOpen(res, fileName, returnType, htmlCharset);
                } else if (function.equals("downloadFile")) {
                    this.setContentTypeForDownload(res, fileName, htmlCharset);
                }
                this.openFile(dataValues, encoding, ssoToken, req, res, resourceBundle, logManager, htmlCharset, function);
                return;
            }
            if (processingType.equalsIgnoreCase("ObjectProcessor")) {
                if (!this.validateSession(res, ssoToken, nfContext)) {
                    this.processInitialRequest(req, res, null);
                    return;
                }
                this.processInitialRequest(req, res, ssoToken);
                return;
            }
        }
        catch (NetFileException e) {
            debug.error("Exception while fetching files", (Throwable)e);
            file_option.doError(e.getMessage(file_option.getPlatformLocalisedBundle()));
        }
        catch (Exception e) {
            debug.error("Exception opening file " + fileName, (Throwable)e);
        }
        finally {
            file_option = null;
        }
    }

    private void processInitialRequest(HttpServletRequest req, HttpServletResponse res, SSOToken ssoToken) throws Exception {
        PrintWriter pw = null;
        try {
            res.setContentType("application/octet-stream");
            pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), "UTF8")));
            if (ssoToken == null) {
                pw.println("ERROR: Unable to Open File.");
                pw.close();
                pw = null;
                return;
            }
            Hashtable requestData = this.unmarshallRequestData(req);
            this.addToSession(ssoToken, requestData);
            pw.println("Success");
            pw.close();
            pw = null;
        }
        catch (NetFileException nfe) {
            this.writeErrorDebug("Failed processing initial request - " + nfe.toString(), null);
        }
    }

    private Hashtable unmarshallRequestData(HttpServletRequest request) throws Exception {
        Hashtable<String, Object> returnData = new Hashtable<String, Object>();
        ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)request.getInputStream());
        Hashtable requestData = (Hashtable)objectInputStream.readObject();
        Enumeration enumeration = requestData.keys();
        String key = "";
        Object value = null;
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            value = requestData.get(key);
            if (value == null) continue;
            returnData.put(key, value);
        }
        return returnData;
    }

    private String getValue(HashMap reqParams, String key) throws Exception {
        Object o = reqParams.get(key);
        if (o == null) {
            return null;
        }
        String sa_value = (String)o;
        return sa_value;
    }

    private String getProcessMethod(HttpServletRequest request) {
        return request.getHeader("NetFileOpenFileProcessMethod");
    }

    private NetFileResource getUserLocaleBundle(FileOption file_option, String s_locale, String s_machine_encoding) throws Exception {
        NetFileResource nfr_user_locale_i18n_bucket = null;
        nfr_user_locale_i18n_bucket = s_locale == null ? file_option.getPlatformLocalisedBundle() : NetFileResource.getInstance("srapNetFileAppletJava1", s_locale);
        return nfr_user_locale_i18n_bucket;
    }

    private String getReturnType(String fileName, NetFileResource nfr_user_locale_i18n_bucket, NetFileLogManager logManager, SSOToken token, String s_machine_encoding) throws Exception {
        int i_index_of_dot = fileName.lastIndexOf(46);
        String suffix = fileName.substring(i_index_of_dot + 1, fileName.length());
        FileOption file_option = new FileOption(logManager, s_machine_encoding);
        file_option.setSSOToken(token);
        return file_option.getFileContentType(suffix, nfr_user_locale_i18n_bucket);
    }

    private void setContentTypeForOpen(HttpServletResponse res, String filename, String returntype, String HTMLcharsetname) throws Exception {
        if (returntype == null || returntype.trim().length() == 0) {
            res.setContentType("application/octet-stream; charset=" + HTMLcharsetname);
        } else {
            res.setContentType(returntype.trim() + "; charset=" + HTMLcharsetname);
        }
        res.setHeader("Content-Disposition", "filename=" + filename);
    }

    private void setContentTypeForDownload(HttpServletResponse res, String filename, String HTMLcharsetname) {
        res.setHeader("Content-Type", "application/octet-stream; charset=" + HTMLcharsetname);
        res.setHeader("Content-Disposition", "attachment; filename=" + filename);
        res.setHeader("Content-Transfer-Encoding", HTMLcharsetname);
    }

    private void addToSession(SSOToken ssoToken, Hashtable data) throws NetFileException {
        StringBuffer sb = new StringBuffer();
        String username = (String)data.get("username");
        String passwrd = (String)data.get("pass");
        String machnam = (String)data.get("machine");
        String machtyp = (String)data.get("type");
        String encoding = (String)data.get("machine_encoding");
        String VMSnam = (String)data.get("VMS");
        String mainfilename = (String)data.get("filename");
        String dir = (String)data.get("dir");
        String domainname = (String)data.get("domain");
        this.nfid = (String)data.get("nfid");
        sb.append(username).append('\n');
        if (passwrd == null || passwrd.equals("")) {
            sb.append("").append('\n');
        } else {
            sb.append(passwrd).append('\n');
        }
        sb.append(machnam).append('\n');
        sb.append(machtyp).append('\n');
        sb.append(encoding).append('\n');
        sb.append(VMSnam).append('\n');
        sb.append(mainfilename).append('\n');
        if (dir == null || dir.equals("")) {
            sb.append("").append('\n');
        } else {
            sb.append(dir).append('\n');
        }
        if (domainname == null || domainname.equals("")) {
            sb.append("").append('\n');
        } else {
            sb.append(domainname).append('\n');
        }
        try {
            ssoToken.setProperty(this.nfid, sb.toString());
        }
        catch (SSOException ssoe) {
            throw new NetFileException("Data could not be added to the session. Cannot proceed further with open/download");
        }
    }

    private List getFromSession(SSOToken ssoToken, String szRequestID) throws NetFileException {
        String value = null;
        try {
            value = ssoToken.getProperty(szRequestID);
        }
        catch (SSOException ssoe) {
            this.writeErrorDebug("SSOException in getting the stored property", ssoe);
            throw new NetFileException("Exception occured in retrieving data from the session. Cannot proceed further with open/download");
        }
        if (value == null) {
            throw new NetFileException("Data could not be retrieved from the session. Cannot proceed further with open/download");
        }
        ArrayList<String> dataVals = new ArrayList<String>();
        if (value.equals("")) {
            throw new NetFileException("Data could not be retrieved from the session. Cannot proceed further with open/download");
        }
        int beginIndex = 0;
        int curIndex = 0;
        while ((curIndex = value.indexOf(10, beginIndex)) != -1) {
            String dataElement = value.substring(beginIndex, curIndex);
            dataVals.add(dataElement);
            beginIndex = curIndex + 1;
        }
        return dataVals;
    }

    void openFile(List dataValues, String encoding, SSOToken ssoToken, HttpServletRequest req, HttpServletResponse res, NetFileResource nfRes, NetFileLogManager logManager, String htmlCharset, String szFunction) throws NetFileException {
        NetWareFile nwfile = null;
        FtpFile gff = null;
        NfsFile gfs = null;
        XFileInterface gpc = null;
        String username = (String)dataValues.get(0);
        String password = (String)dataValues.get(1);
        String machine = (String)dataValues.get(2);
        String machineType = (String)dataValues.get(3);
        String share = (String)dataValues.get(5);
        String mainFileName = (String)dataValues.get(6);
        String directory = (String)dataValues.get(7);
        String domain = (String)dataValues.get(8);
        String functionName = "";
        if (szFunction.equals("viewFile")) {
            functionName = nfRes.getString("openFileLog");
        } else if (szFunction.equals("downloadFile") || szFunction.equals("downloadFolder")) {
            functionName = nfRes.getString("downloadFileLog");
        }
        try {
            if (machineType.indexOf("NETWARE", 0) >= 0) {
                nwfile = new NetWareFile(logManager, encoding);
                InputStream instream = nwfile.getInputFTPStream(username, password, machine, share, mainFileName, directory);
                ServletOutputStream outstream = res.getOutputStream();
                this.readWriteBytes(instream, (OutputStream)outstream);
            } else if (machineType.indexOf("WIN", 0) >= 0 || machineType.indexOf("NT", 0) >= 0) {
                gpc = XFileFactory.getInstance().newXFileInstance(logManager, encoding, ssoToken);
                InputStream instream = gpc.getInputStream(username, password, domain, machine, share, directory, mainFileName, nfRes);
                ServletOutputStream outstream = res.getOutputStream();
                this.readWriteBytes(instream, (OutputStream)outstream);
            } else if (machineType.indexOf("FTP", 0) >= 0) {
                gff = new FtpFile(logManager, encoding);
                InputStream instream = gff.getInputFTPStream(username, password, machine, share, mainFileName, directory);
                ServletOutputStream outstream = res.getOutputStream();
                this.readWriteBytes(instream, (OutputStream)outstream);
                gff.closeFtpFile();
            } else if (machineType.indexOf("NFS", 0) >= 0) {
                gfs = new NfsFile(logManager, encoding);
                XFileInputStream instream = gfs.getNFSInputStream(username, password, share, machine, mainFileName, directory);
                ServletOutputStream outstream = res.getOutputStream();
                this.readWriteBytes((InputStream)instream, (OutputStream)outstream);
            }
            this.doLog(logManager, nfRes.getString("successLog.1", new Object[]{functionName, mainFileName, username, machine, share, directory}));
            return;
        }
        catch (NetFileException nfe) {
            this.writeErrorDebug("Problem getting file - ", nfe);
            this.doLog(logManager, nfRes.getString("failureLog.1", new Object[]{functionName, mainFileName, username, machine, share, directory}));
            try {
                if (szFunction.equals("downloadFolder")) {
                    this.writeErrorBytes("NetFileOpenFileError:" + nfe.getMessage(), res);
                }
                this.writeErrorHTML(res, htmlCharset, nfRes, nfe.getMessage(), mainFileName, szFunction);
            }
            catch (IOException ioe) {
                return;
            }
        }
        catch (Exception e) {
            this.writeErrorDebug("Problem getting file -- ", e);
            this.doLog(logManager, nfRes.getString("failureLog.1", new Object[]{functionName, mainFileName, username, machine, share, directory}));
            try {
                if (szFunction.equals("downloadFolder")) {
                    this.writeErrorBytes("NetFileOpenFileError:" + e.getMessage(), res);
                }
                this.writeErrorHTML(res, htmlCharset, nfRes, nfRes.getString("nofs.1"), mainFileName, szFunction);
            }
            catch (IOException ioe) {
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readWriteBytes(InputStream instream, OutputStream outstream) throws IOException {
        byte[] buf = new byte[this.bufSize];
        try {
            try {
                int len;
                while ((len = instream.read(buf)) > -1) {
                    outstream.write(buf, 0, len);
                }
                Object var7_5 = null;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw ioe;
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            try {
                if (outstream != null) {
                    outstream.close();
                }
                if (instream == null) throw throwable;
                instream.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        if (outstream != null) {
            outstream.close();
        }
        if (instream == null) return;
        instream.close();
        return;
    }

    private HashMap parseHttpRequestForParameters(HttpServletRequest req) throws Exception {
        String szQueryString = req.getQueryString();
        StringTokenizer stTokens = new StringTokenizer(szQueryString, "&");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        NetFileURLDecoder decoder = new NetFileURLDecoder();
        while (stTokens.hasMoreTokens()) {
            String token = stTokens.nextToken();
            int index = token.indexOf(61);
            if (index <= 0) continue;
            String key = token.substring(0, index);
            String value = "";
            if (++index < token.length()) {
                value = token.substring(index, token.length());
            }
            if (value != null) {
                value = decoder.decode(value, "UTF8");
            }
            paramMap.put(key, value);
        }
        return paramMap;
    }

    private boolean validateSession(HttpServletResponse res, SSOToken ssoToken, NetFileContext nfContext) {
        PrintWriter out = null;
        try {
            if (nfContext.isSessionValid(ssoToken) && nfContext.isExecutable(ssoToken)) {
                return true;
            }
            if (out == null) {
                res.setContentType(CONTENT_TYPE_TEXT_PLAIN);
                out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), "UTF8")));
            }
            out.println("ERROR: Session is Invalid or no policy to execute ");
            out.close();
            return false;
        }
        catch (Exception e) {
            if (out == null) {
                try {
                    res.setContentType(CONTENT_TYPE_TEXT_PLAIN);
                    out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), "UTF8")));
                }
                catch (Exception e1) {
                    return false;
                }
            }
            out.println("ERROR:" + e.getMessage());
            debug.error("General Exception in NetFileOpenFileServlet", (Throwable)e);
            return false;
        }
    }

    private String extractSession(HttpServletRequest req) {
        String session = null;
        session = req.getHeader("nfid");
        Cookie[] cookie = req.getCookies();
        if (cookie != null) {
            for (int i = 0; i < cookie.length; ++i) {
                if (!cookie[i].getName().equalsIgnoreCase(SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro"))) continue;
                session = cookie[i].getValue();
                if (!NetFileServlet.isEncoded) continue;
                session = URLDecoder.decode(session);
            }
        }
        return session;
    }

    private PrintWriter getWriter(HttpServletResponse res, String charset) throws IOException {
        if (charset == null) {
            res.setContentType("text/html");
            return res.getWriter();
        }
        res.setContentType("text/html; charset=" + charset);
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), charset)));
    }

    private void writeErrorHTML(HttpServletResponse res, String htmlCharset, NetFileResource nfRes, String msg, String mainfilename, String szFunction) throws IOException {
        PrintWriter out = this.getWriter(res, htmlCharset);
        res.setHeader("Cache-Control", "max-age=0");
        String bgcolors = nfRes.getString("bgcolorS");
        String textcolors = nfRes.getString("textcolorS");
        out.println("<html><head><title>" + nfRes.getString("nftitle") + "</title></head>");
        out.print("<body text='");
        out.print(textcolors);
        out.print("'");
        out.print(" bgcolor='");
        out.print(bgcolors);
        out.print("'>");
        out.println("<h2>" + nfRes.getString("nftitle") + "</h2>");
        out.print("<p><b>" + nfRes.getString("nfmsg.1"));
        if (szFunction.equals("downloadFile")) {
            out.print(' ' + nfRes.getString("nofs.3") + ' ' + mainfilename);
        } else if (szFunction.equals("viewFile")) {
            out.print(' ' + nfRes.getString("nofs.2") + ' ' + mainfilename);
        } else if (szFunction.equals("ERROR:")) {
            out.print(' ' + nfRes.getString("nfs.1") + ' ');
        }
        out.println("</FONT>&nbsp; <br><br>");
        out.println(msg + "  </b></p>");
        out.println("</html>");
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void writeErrorBytes(String msg, HttpServletResponse res) {
        block11: {
            ServletOutputStream os = null;
            res.setHeader("Content-Type", "text/html");
            os = res.getOutputStream();
            byte[] byteMsg = msg.getBytes("ISO-8859-1");
            os.write(byteMsg);
            Object var6_6 = null;
            try {
                if (os != null) {
                    os.close();
                }
                break block11;
            }
            catch (IOException ioe2) {
                this.writeErrorDebug("Exception while closing output stream-", ioe2);
            }
            break block11;
            {
                catch (IOException ioe) {
                    this.writeErrorDebug("Exception while getting output stream-", ioe);
                    Object var6_7 = null;
                    try {
                        if (os != null) {
                            os.close();
                        }
                        break block11;
                    }
                    catch (IOException ioe2) {
                        this.writeErrorDebug("Exception while closing output stream-", ioe2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException ioe2) {
                    this.writeErrorDebug("Exception while closing output stream-", ioe2);
                }
                throw throwable;
            }
        }
    }

    private void writeErrorDebug(String szError, Throwable e) {
        if (debug != null) {
            if (e != null) {
                debug.error(szError, e);
            } else {
                debug.error(szError);
            }
        }
    }

    private NetFileLogManager createLogManager(SSOToken ssoToken) {
        String tokenId = ssoToken.getTokenID().toString();
        try {
            Object obj = NetFileServlet.logManagerCache.get(tokenId);
            if (obj == null) {
                NetFileLogManager logMgr = new NetFileLogManager(ssoToken);
                NetFileServlet.logManagerCache.put(tokenId, logMgr);
                return logMgr;
            }
            return (NetFileLogManager)obj;
        }
        catch (Exception e) {
            debug.error("Unable to create LogManager for ssoToken - " + tokenId);
            return null;
        }
    }

    private void doLog(NetFileLogManager logManager, String msg) {
        if (logManager == null) {
            this.writeErrorDebug("LogManager is null", null);
            return;
        }
        logManager.doLog(msg);
    }
}

