/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet.java1;

import com.iplanet.am.util.Debug;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NetFileHostDenialProcessor {
    private Debug debug;
    private char c_eol = (char)10;
    private String s_empty_string = "";

    public NetFileHostDenialProcessor() {
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
    }

    public String getHostName(String s_host_data) {
        int i_index_of_name = s_host_data.indexOf("machine_name=");
        if (i_index_of_name < 0) {
            return s_host_data.trim();
        }
        i_index_of_name = "machine_name=".length();
        int i_index_of_eol = s_host_data.indexOf(this.c_eol, i_index_of_name);
        return s_host_data.substring(i_index_of_name, i_index_of_eol).trim();
    }

    public boolean isHostDenied(String s_user_added_host_share, InetAddress[] ia_denied_hosts) throws Exception {
        boolean b_is_denied = false;
        if (ia_denied_hosts == null) {
            throw new NullPointerException("null denied host list");
        }
        if (s_user_added_host_share == null) {
            throw new NullPointerException("null host information");
        }
        if (ia_denied_hosts.length < 1) {
            this.debug.message("Came here");
        } else {
            String s_machine_name = this.getHostName(s_user_added_host_share);
            InetAddress[] ia_host_added_by_user = InetAddress.getAllByName(s_machine_name);
            b_is_denied = this.isHostDenied(ia_host_added_by_user, ia_denied_hosts);
        }
        this.debug.message("Host denied=" + b_is_denied);
        return b_is_denied;
    }

    public InetAddress[] getDeniedHostsAddresses(List l_denied_hosts) {
        ArrayList<InetAddress> al_denied_hosts = new ArrayList<InetAddress>();
        if (l_denied_hosts.isEmpty()) {
            return null;
        }
        Iterator it_denied_hosts = l_denied_hosts.iterator();
        while (it_denied_hosts.hasNext()) {
            try {
                String s_host_name = (String)it_denied_hosts.next();
                if (s_host_name.trim().equals(this.s_empty_string)) continue;
                InetAddress[] ia_address_of_host = InetAddress.getAllByName(s_host_name);
                for (int i = 0; i < ia_address_of_host.length; ++i) {
                    al_denied_hosts.add(ia_address_of_host[i]);
                }
            }
            catch (Exception e) {
                this.debug.error("Error getting inet address of the host", (Throwable)e);
            }
        }
        InetAddress[] ia_denied_addresses = new InetAddress[al_denied_hosts.size()];
        it_denied_hosts = al_denied_hosts.iterator();
        int i = 0;
        while (it_denied_hosts.hasNext()) {
            ia_denied_addresses[i] = (InetAddress)it_denied_hosts.next();
            ++i;
        }
        return ia_denied_addresses;
    }

    public boolean isHostDenied(InetAddress[] ia_host_added_by_user, InetAddress[] ia_denied_hosts) {
        for (int i_index_into_user_inet_add = 0; i_index_into_user_inet_add < ia_host_added_by_user.length; ++i_index_into_user_inet_add) {
            for (int i = 0; i < ia_denied_hosts.length; ++i) {
                if (!ia_host_added_by_user[i_index_into_user_inet_add].equals(ia_denied_hosts[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isHostAllowed(List accessList, List deniedList, String szGivenHostName, InetAddress[] hostIAddresses, boolean useGivenHostName) {
        boolean allowed = false;
        try {
            boolean matchFound = false;
            List list = deniedList;
            Iterator iter = null;
            String denyString = null;
            String hostName = null;
            String hostAddr = null;
            if (list != null) {
                iter = list.iterator();
                block2: while (iter.hasNext()) {
                    denyString = iter.next().toString().trim().toLowerCase();
                    if (denyString.equals("*")) {
                        allowed = false;
                        matchFound = true;
                        break;
                    }
                    for (int i = 0; i < hostIAddresses.length; ++i) {
                        hostName = useGivenHostName ? szGivenHostName.trim().toLowerCase() : hostIAddresses[i].getHostName().trim().toLowerCase();
                        hostAddr = hostIAddresses[i].getHostAddress();
                        if (this.wildcardMatch(hostName, denyString)) {
                            allowed = false;
                            matchFound = true;
                            continue block2;
                        }
                        if (!this.wildcardMatch(hostAddr, denyString)) continue;
                        allowed = false;
                        matchFound = true;
                        continue block2;
                    }
                }
            }
            if (!matchFound && (list = accessList) != null) {
                iter = list.iterator();
                block4: while (iter.hasNext()) {
                    String allowString = iter.next().toString().trim().toLowerCase();
                    if (allowString.equals("*")) {
                        allowed = true;
                        matchFound = true;
                        break;
                    }
                    for (int i = 0; i < hostIAddresses.length; ++i) {
                        hostName = useGivenHostName ? szGivenHostName.trim().toLowerCase() : hostIAddresses[i].getHostName().trim().toLowerCase();
                        hostAddr = hostIAddresses[i].getHostAddress();
                        if (this.wildcardMatch(hostName, allowString)) {
                            allowed = true;
                            matchFound = true;
                            continue block4;
                        }
                        if (!this.wildcardMatch(hostAddr, allowString)) continue;
                        allowed = true;
                        matchFound = true;
                        continue block4;
                    }
                }
            }
            if (!matchFound) {
                allowed = false;
            }
            if (!allowed && this.debug.messageEnabled()) {
                this.debug.message("Host " + hostName + " is not allowed");
            }
        }
        catch (Exception e) {
            if (this.debug.messageEnabled()) {
                this.debug.error("Error in detecting host is allowed", (Throwable)e);
            }
            allowed = false;
        }
        return allowed;
    }

    private boolean wildcardMatch(String str1, String str2) {
        int beginIndex1 = 0;
        int endIndex1 = 0;
        int beginIndex2 = 0;
        int endIndex2 = 0;
        int strlen1 = str1.length();
        int strlen2 = str2.length();
        String substr = null;
        if (str1 == null || str2 == null) {
            return false;
        }
        if (str1.trim().length() == 0 || str2.trim().length() == 0) {
            return false;
        }
        endIndex2 = str2.indexOf(42, beginIndex2);
        if (endIndex2 != -1) {
            substr = str2.substring(beginIndex2, endIndex2);
            if (endIndex2 > beginIndex2) {
                if ((beginIndex1 = str1.indexOf(substr, beginIndex1)) == -1) {
                    return false;
                }
                if (beginIndex1 != beginIndex2) {
                    return false;
                }
            }
            beginIndex1 += endIndex2 - beginIndex2;
            if (endIndex2 >= strlen2 - 1) {
                return true;
            }
            beginIndex2 = endIndex2 + 1;
        } else {
            beginIndex1 = str1.indexOf(str2);
            if (beginIndex1 == -1) {
                return false;
            }
            return beginIndex1 == beginIndex2;
        }
        while ((endIndex2 = str2.indexOf(42, beginIndex2)) != -1) {
            substr = str2.substring(beginIndex2, endIndex2);
            if (endIndex2 > beginIndex2 && (beginIndex1 = str1.indexOf(substr, beginIndex1)) == -1) {
                return false;
            }
            beginIndex1 += endIndex2 - beginIndex2;
            if (endIndex2 >= strlen2 - 1) {
                return true;
            }
            beginIndex2 = endIndex2 + 1;
        }
        substr = str2.substring(beginIndex2, strlen2);
        endIndex1 = str1.lastIndexOf(substr, strlen1 - 1);
        if (endIndex1 == -1) {
            return false;
        }
        return beginIndex1 <= endIndex1;
    }

    String getFQHostName(String hostName, String defaultSubDomainAndDomain) {
        int index = hostName.indexOf(46);
        if (index == -1) {
            return this.getNewHostName(hostName, defaultSubDomainAndDomain);
        }
        if (index == hostName.lastIndexOf(46)) {
            return this.getNewHostName(hostName, defaultSubDomainAndDomain);
        }
        return hostName;
    }

    String getNewHostName(String hostName, String defaultSubDomainAndDomain) {
        String newHost = null;
        if (defaultSubDomainAndDomain == null || defaultSubDomainAndDomain.trim().length() == 0) {
            return hostName.trim();
        }
        newHost = defaultSubDomainAndDomain.charAt(0) == '.' ? hostName + defaultSubDomainAndDomain : hostName + '.' + defaultSubDomainAndDomain;
        return newHost.trim();
    }
}

