/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet.java1;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.DecryptAction;
import com.sun.portal.netfile.servlet.java1.NetFileAttributeExtractor;
import com.sun.portal.netfile.servlet.java1.NetFileContext;
import com.sun.portal.netfile.servlet.java1.NetFileException;
import com.sun.portal.netfile.servlet.java1.NetFileHostDenialProcessor;
import com.sun.portal.netfile.servlet.java1.NetFileLogManager;
import com.sun.portal.netfile.servlet.java1.NetFileResource;
import com.sun.portal.netfile.servlet.java1.WinFile;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class NetFileHostDataProcessor {
    public NetFileLogManager logMgr;
    private Debug debug;
    private char c_eol = (char)10;
    private String s_empty_string;
    private List allowedHosts;
    private List deniedHosts;
    private List listOfHosts;
    private List commondata;
    private String defaultDomain = this.s_empty_string = "";
    private Object[] localHostAddrs;
    private SSOToken ssoToken;
    private NetFileResource nfRes;
    private ArrayList invalidHosts;

    public NetFileHostDataProcessor(NetFileLogManager logMgr, SSOToken token, NetFileResource nfres) {
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
        this.logMgr = logMgr;
        this.ssoToken = token;
        this.nfRes = nfres;
        this.localHostAddrs = this.getRPaddrs();
        this.invalidHosts = new ArrayList();
    }

    StringBuffer processHostsData(StringBuffer returnbufstr, NetFileContext nfContext, NetFileAttributeExtractor nfAttrs, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        ArrayList al_denied_hosts;
        InetAddress[] ia_denied_hosts;
        block22: {
            List listCommonHosts = null;
            this.loadHostDataSets(nfAttrs);
            NetFileHostDenialProcessor nfhdp = new NetFileHostDenialProcessor();
            ia_denied_hosts = this.deniedHosts != null && !this.deniedHosts.isEmpty() ? nfhdp.getDeniedHostsAddresses(this.deniedHosts) : new InetAddress[]{};
            if (this.commondata != null && !this.commondata.isEmpty()) {
                listCommonHosts = this.commondata;
            }
            al_denied_hosts = new ArrayList();
            try {
                if (listCommonHosts != null && !listCommonHosts.isEmpty()) {
                    HashMap ht_hosts_shares_set_by_admin = this.parseCommonHostsData(listCommonHosts, nfContext, nfr_user_locale_i18n_bucket);
                    Iterator e_machine_type_password_shares = this.listOfHosts.iterator();
                    while (e_machine_type_password_shares.hasNext()) {
                        String s_user_added_host_share = (String)e_machine_type_password_shares.next();
                        s_user_added_host_share = this.getDecryptedHostInfo(s_user_added_host_share);
                        String s_host_name = this.getMachineName(s_user_added_host_share);
                        String szFQHostName = nfhdp.getFQHostName(s_host_name, this.defaultDomain);
                        InetAddress[] hostIAddresses = null;
                        try {
                            hostIAddresses = this.getInetAddresses(szFQHostName);
                        }
                        catch (UnknownHostException uhe) {
                            this.debug.error("Exception in determining the host address", (Throwable)uhe);
                            this.invalidHosts.add(s_host_name);
                            continue;
                        }
                        if (this.isLocalHost(hostIAddresses)) continue;
                        if (nfhdp.isHostAllowed(this.allowedHosts, this.deniedHosts, szFQHostName, hostIAddresses, true)) {
                            if (ia_denied_hosts != null && nfhdp.isHostDenied(hostIAddresses, ia_denied_hosts)) {
                                al_denied_hosts.add(s_host_name);
                            }
                        } else {
                            al_denied_hosts.add(s_host_name);
                        }
                        try {
                            HashMap ht_matching_host = this.getMatchingHost(szFQHostName, ht_hosts_shares_set_by_admin);
                            if (ht_matching_host != null) {
                                s_user_added_host_share = this.mergeHost(s_user_added_host_share, ht_matching_host);
                                this.removeValue(ht_hosts_shares_set_by_admin, ht_matching_host);
                            }
                        }
                        catch (Exception e) {
                            this.debug.error("Error in merging hosts", (Throwable)e);
                        }
                        returnbufstr.append("sunPortalNetFileHostTypePassShare=").append(s_user_added_host_share).append(this.c_eol);
                    }
                    Object[] o_hosts_and_denied_hosts = this.addUnmergedHosts(nfhdp, ht_hosts_shares_set_by_admin, al_denied_hosts, ia_denied_hosts);
                    String s_common_hosts_not_added_by_user = (String)o_hosts_and_denied_hosts[0];
                    al_denied_hosts = (ArrayList)o_hosts_and_denied_hosts[1];
                    returnbufstr.append(s_common_hosts_not_added_by_user).append(this.c_eol);
                    break block22;
                }
                if (this.listOfHosts.isEmpty()) break block22;
                Iterator e_machine_type_password_shares = this.listOfHosts.iterator();
                while (e_machine_type_password_shares.hasNext()) {
                    String s_user_added_host_share = (String)e_machine_type_password_shares.next();
                    s_user_added_host_share = this.getDecryptedHostInfo(s_user_added_host_share);
                    String s_host_name = this.getMachineName(s_user_added_host_share);
                    String szFQHostName = nfhdp.getFQHostName(s_host_name, this.defaultDomain);
                    InetAddress[] hostIAddresses = null;
                    try {
                        hostIAddresses = this.getInetAddresses(szFQHostName);
                    }
                    catch (UnknownHostException uhe) {
                        this.debug.error("Exception in determining the host address", (Throwable)uhe);
                        this.invalidHosts.add(s_host_name);
                        continue;
                    }
                    if (this.isLocalHost(hostIAddresses)) continue;
                    if (nfhdp.isHostAllowed(this.allowedHosts, this.deniedHosts, szFQHostName, hostIAddresses, true)) {
                        if (ia_denied_hosts != null) {
                            if (nfhdp.isHostDenied(s_user_added_host_share, ia_denied_hosts)) {
                                al_denied_hosts.add(s_host_name);
                            }
                            returnbufstr.append("sunPortalNetFileHostTypePassShare=").append(s_user_added_host_share).append(this.c_eol);
                            continue;
                        }
                        returnbufstr.append("sunPortalNetFileHostTypePassShare=").append(s_user_added_host_share).append(this.c_eol);
                        continue;
                    }
                    returnbufstr.append("sunPortalNetFileHostTypePassShare=").append(s_user_added_host_share).append(this.c_eol);
                    al_denied_hosts.add(s_host_name);
                }
            }
            catch (Exception e) {
                this.debug.error("Exception extracting common data or host data or in merging them", (Throwable)e);
            }
        }
        if (ia_denied_hosts != null) {
            for (int i = 0; i < al_denied_hosts.size(); ++i) {
                returnbufstr.append("iplanet-srap-netfile-denied-host=").append((String)al_denied_hosts.get(i)).append(this.c_eol);
            }
        }
        if (!this.invalidHosts.isEmpty()) {
            returnbufstr.append("sunPortalNetFileInvalidHosts=" + this.invalidHosts.toString());
            returnbufstr.append("\n");
        }
        return returnbufstr;
    }

    void removeValue(HashMap ht_contaier, HashMap ht_contained) {
        Object key;
        if (ht_contaier.containsValue(ht_contained) && (key = ht_contained.get("machine_name")) != null) {
            Object o = ht_contaier.remove(key);
            if (this.debug.messageEnabled()) {
                this.debug.message("Removed " + key);
            }
        }
    }

    Object[] addUnmergedHosts(NetFileHostDenialProcessor nfhdp, HashMap ht_hosts_added_by_admin, ArrayList al_denied_hosts, InetAddress[] ia_denied_hosts) throws NetFileException {
        Collection keys = ht_hosts_added_by_admin.values();
        Iterator i_keys = keys.iterator();
        StringBuffer sb_host_data = new StringBuffer();
        while (i_keys.hasNext()) {
            try {
                HashMap ht_admin_added_host = (HashMap)i_keys.next();
                String s_host_name = (String)ht_admin_added_host.get("machine_name");
                String szFQHostName = nfhdp.getFQHostName(s_host_name.trim(), this.defaultDomain);
                InetAddress[] hostIAddresses = null;
                try {
                    hostIAddresses = this.getInetAddresses(szFQHostName);
                }
                catch (UnknownHostException uhe) {
                    this.debug.error("Exception in determining the host address", (Throwable)uhe);
                    this.invalidHosts.add(s_host_name);
                    continue;
                }
                if (this.isLocalHost(hostIAddresses)) continue;
                if (nfhdp.isHostAllowed(this.allowedHosts, this.deniedHosts, szFQHostName, hostIAddresses, true)) {
                    if (nfhdp.isHostDenied(szFQHostName, ia_denied_hosts)) {
                        al_denied_hosts.add(s_host_name);
                    }
                } else {
                    al_denied_hosts.add(s_host_name);
                }
                this.filterWinAdminShares(ht_admin_added_host, null);
                sb_host_data.append("sunPortalNetFileHostTypePassShare=");
                StringBuffer sb_host_name = new StringBuffer();
                sb_host_name.append("machine_name=").append(s_host_name).append(this.c_eol);
                sb_host_data = this.mergeAttribute("machine_name", "machine_name=", ht_admin_added_host, sb_host_data);
                sb_host_data = this.mergeAttribute("machine_type", "machine_type=", ht_admin_added_host, sb_host_data);
                sb_host_data = this.mergeAttribute("machine_encoding", "machine_encoding=", ht_admin_added_host, sb_host_data);
                sb_host_data = this.mergeAttribute("machine_domain", "machine_domain=", ht_admin_added_host, sb_host_data);
                sb_host_data = this.mergeAttribute("machine_password", "machine_password=", ht_admin_added_host, sb_host_data);
                sb_host_data = this.mergeAttribute("machine_user_name", "machine_user_name=", ht_admin_added_host, sb_host_data);
                if (ht_admin_added_host.get("shares") == null) {
                    sb_host_data.append(this.c_eol).append(this.c_eol);
                    continue;
                }
                if (ht_admin_added_host.get("share_passwords") == null) {
                    sb_host_data.append(this.c_eol).append(this.c_eol);
                    continue;
                }
                ArrayList v_common_shares = (ArrayList)ht_admin_added_host.get("shares");
                ArrayList v_share_passwords = (ArrayList)ht_admin_added_host.get("share_passwords");
                if (!v_common_shares.isEmpty() || !v_share_passwords.isEmpty()) {
                    int i_num_shares = v_common_shares.size();
                    for (int i = 0; i < i_num_shares; ++i) {
                        sb_host_data.append("share_name=").append((String)v_common_shares.get(i)).append(this.c_eol).append("share_password=").append((String)v_share_passwords.get(i)).append(this.c_eol);
                    }
                }
                sb_host_data.append(this.c_eol).append(this.c_eol);
            }
            catch (Exception e) {
                this.debug.error("Exception in common hosts unmerged with the hosts added by the user", (Throwable)e);
            }
        }
        return new Object[]{sb_host_data.toString(), al_denied_hosts};
    }

    StringBuffer mergeAttribute(String s_attribute_name, String attribute_tag, HashMap ht_host_data, StringBuffer sb_host_data) {
        Object o_temp = ht_host_data.get(s_attribute_name);
        String s_temp = this.s_empty_string;
        if (o_temp != null) {
            s_temp = (String)o_temp;
        }
        sb_host_data.append(attribute_tag).append(s_temp).append(this.c_eol);
        return sb_host_data;
    }

    InetAddress[] getAllInetAddresses(String s_host_name) throws Exception {
        return InetAddress.getAllByName(s_host_name.trim());
    }

    HashMap parseCommonHostsData(List listCommonHosts, NetFileContext nfContext, NetFileResource nfr_user_locale_i18n_bucket) {
        int i_common_hosts = listCommonHosts.size();
        HashMap<String, HashMap> ht_common_hosts_data = new HashMap<String, HashMap>(i_common_hosts * 2);
        for (int i = 0; i < i_common_hosts; ++i) {
            try {
                Object o_host_name;
                String s_common_host_data = (String)listCommonHosts.get(i);
                HashMap ht_s_common_host_data = this.parseHost(s_common_host_data, "\n");
                if (ht_s_common_host_data == null || (o_host_name = ht_s_common_host_data.get("machine_name")) == null) continue;
                String s_host_name = (String)o_host_name;
                ht_common_hosts_data.put(s_host_name, ht_s_common_host_data);
                continue;
            }
            catch (NetFileException e) {
                this.debug.message("Unable to parse common host data" + e.getMessage(nfr_user_locale_i18n_bucket));
                continue;
            }
            catch (Throwable e) {
                this.debug.message("Unable to parse common host data", e);
            }
        }
        return ht_common_hosts_data;
    }

    String mergeHost(String s_user_added_host_share, HashMap ht_matching_common_host) throws NetFileException {
        HashMap ht_user_added_host = this.parseHost(s_user_added_host_share, "\n");
        this.filterWinAdminShares(ht_matching_common_host, ht_user_added_host);
        StringBuffer sb_host_data = new StringBuffer();
        sb_host_data.append("machine_name=").append(ht_user_added_host.get("machine_name")).append(this.c_eol);
        boolean b_are_types_different = this.areTypeDifferent(ht_matching_common_host, ht_user_added_host);
        sb_host_data = this.mergeAttribute(sb_host_data, "machine_type", "machine_type", ht_matching_common_host, ht_user_added_host);
        sb_host_data = this.mergeAttribute(sb_host_data, "machine_encoding", "machine_encoding", ht_matching_common_host, ht_user_added_host);
        sb_host_data = this.mergeAttribute(sb_host_data, "machine_domain", "machine_domain", ht_matching_common_host, ht_user_added_host);
        sb_host_data = this.mergeAttribute(sb_host_data, "machine_password", "machine_password", ht_matching_common_host, ht_user_added_host);
        sb_host_data = this.mergeAttribute(sb_host_data, "machine_user_name", "machine_user_name", ht_matching_common_host, ht_user_added_host);
        ArrayList v_shares = (ArrayList)ht_user_added_host.get("shares");
        ArrayList v_passwords = (ArrayList)ht_user_added_host.get("share_passwords");
        ArrayList v_common_shares = (ArrayList)ht_matching_common_host.get("shares");
        ArrayList v_common_share_passwords = (ArrayList)ht_matching_common_host.get("share_passwords");
        if (!b_are_types_different) {
            ArrayList[] v_share_data = this.mergeShares(v_shares, v_passwords, v_common_shares, v_common_share_passwords);
            v_shares = v_share_data[0];
            v_passwords = v_share_data[1];
        }
        int i_num_shares = v_shares.size();
        for (int i = 0; i < i_num_shares; ++i) {
            sb_host_data.append("share_name=").append((String)v_shares.get(i)).append(this.c_eol).append("share_password=").append((String)v_passwords.get(i)).append(this.c_eol);
        }
        sb_host_data.append(this.c_eol);
        return sb_host_data.toString();
    }

    boolean areTypeDifferent(HashMap ht_matching_common_host, HashMap ht_user_added_host) {
        Object o_common_type = ht_matching_common_host.get("machine_type");
        if (o_common_type == null) {
            return false;
        }
        return !((String)ht_user_added_host.get("machine_type")).equals((String)o_common_type);
    }

    ArrayList[] mergeShares(ArrayList v_shares, ArrayList v_passwords, ArrayList v_common_shares, ArrayList v_common_share_passwords) {
        Iterator e_shares = v_shares.iterator();
        while (e_shares.hasNext()) {
            String s_share = (String)e_shares.next();
            if (!v_common_shares.contains(s_share)) continue;
            v_common_shares.remove(s_share);
        }
        Iterator e_common_shares = v_common_shares.iterator();
        Iterator e_common_share_passwords = v_common_share_passwords.iterator();
        while (e_common_shares.hasNext()) {
            v_shares.add(e_common_shares.next());
            if (e_common_share_passwords.hasNext()) {
                v_passwords.add((String)e_common_share_passwords.next());
                continue;
            }
            v_passwords.add(this.s_empty_string);
        }
        return new ArrayList[]{v_shares, v_passwords};
    }

    StringBuffer mergeAttribute(StringBuffer sb_host_data, String attribute_name1, String attribute_name2, HashMap ht_matching_common_host, HashMap ht_user_added_host) {
        sb_host_data.append(attribute_name1).append("=");
        Object o_temp = ht_user_added_host.get(attribute_name1);
        if (o_temp == null) {
            o_temp = ht_matching_common_host.get(attribute_name2);
        }
        if (o_temp != null) {
            sb_host_data.append((String)o_temp);
        }
        sb_host_data.append(this.c_eol);
        return sb_host_data;
    }

    HashMap parseHost(String s_user_added_host_share, String separator) throws NetFileException {
        StringTokenizer st_tokens = new StringTokenizer(s_user_added_host_share, separator);
        HashMap<String, Object> ht_host = new HashMap<String, Object>(st_tokens.countTokens() * 2);
        try {
            ArrayList<String> v_shares = new ArrayList<String>();
            ArrayList<String> v_share_passwords = new ArrayList<String>();
            ht_host.put("shares", v_shares);
            ht_host.put("share_passwords", v_share_passwords);
            while (st_tokens.hasMoreTokens()) {
                String token = st_tokens.nextToken();
                if (token.startsWith("machine_name=")) {
                    String s_name = this.removePrefix("machine_name=", token);
                    s_name = this.removeCtrlMChar(s_name);
                    ht_host.put("machine_name", s_name);
                    InetAddress[] ia_common_host = this.getAllInetAddresses(s_name);
                    ht_host.put("all_inet_addresses", ia_common_host);
                    continue;
                }
                if (token.startsWith("machine_type=")) {
                    ht_host.put("machine_type", this.removeCtrlMChar(this.removePrefix("machine_type=", token)));
                    continue;
                }
                if (token.startsWith("machine_encoding=")) {
                    ht_host.put("machine_encoding", this.removeCtrlMChar(this.removePrefix("machine_encoding=", token)));
                    continue;
                }
                if (token.startsWith("machine_domain=")) {
                    ht_host.put("machine_domain", this.removeCtrlMChar(this.removePrefix("machine_domain=", token)));
                    continue;
                }
                if (token.startsWith("machine_password=")) {
                    ht_host.put("machine_password", this.removeCtrlMChar(this.removePrefix("machine_password=", token)));
                    continue;
                }
                if (token.startsWith("machine_user_name=")) {
                    ht_host.put("machine_user_name", this.removeCtrlMChar(this.removePrefix("machine_user_name=", token)));
                    continue;
                }
                if (!token.startsWith("share_name=")) continue;
                v_shares.add(this.removeCtrlMChar(this.removePrefix("share_name=", token)));
                String s_password = st_tokens.nextToken();
                v_share_passwords.add(this.removeCtrlMChar(this.removePrefix("share_password=", s_password)));
            }
        }
        catch (Exception e) {
            this.debug.error("Unable to parse host data", (Throwable)e);
            throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "illegal_machine_data_format", s_user_added_host_share});
        }
        return ht_host;
    }

    String removePrefix(String prefix, String string) throws NetFileException {
        if (!string.startsWith(prefix)) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "illegal_machine_data_format");
        }
        return string.substring(prefix.length(), string.length());
    }

    HashMap getMatchingHost(String s_host_added_by_user, HashMap ht_host_shares_set_by_admin) {
        try {
            InetAddress ia_host_added_by_user = InetAddress.getByName(s_host_added_by_user);
            Collection c_keys = ht_host_shares_set_by_admin.values();
            Iterator i_keys = c_keys.iterator();
            while (i_keys.hasNext()) {
                HashMap ht_host = (HashMap)i_keys.next();
                Object o_inet_addresses = ht_host.get("all_inet_addresses");
                if (o_inet_addresses == null) {
                    return null;
                }
                InetAddress[] ia_host = (InetAddress[])o_inet_addresses;
                if (!ia_host[0].equals(ia_host_added_by_user)) continue;
                this.debug.message("Got matching host");
                return ht_host;
            }
        }
        catch (Exception e) {
            this.debug.message("Exception while finding host matching a given host among common hosts by IP", (Throwable)e);
            return null;
        }
        return null;
    }

    private String getMachineName(String s_user_added_host_share) throws Exception {
        String s_machine_name = null;
        if (s_user_added_host_share == null) {
            throw new NullPointerException("null host information");
        }
        int i_index_of_name = s_user_added_host_share.indexOf("machine_name=");
        if (i_index_of_name < -1) {
            throw new Exception("Invalid host data - does not contain machine name");
        }
        i_index_of_name = "machine_name=".length();
        int i_index_of_eol = s_user_added_host_share.indexOf(this.c_eol, i_index_of_name);
        if (i_index_of_eol <= i_index_of_name) {
            throw new Exception("Invalid host data - machine name does not end in \\n");
        }
        s_machine_name = s_user_added_host_share.substring(i_index_of_name, i_index_of_eol);
        return s_machine_name;
    }

    List getAllowedHostsList(NetFileAttributeExtractor nfAttrs) {
        return nfAttrs.getStringList("sunPortalNetFileAllowedHostList");
    }

    List getDeniedHostsList(NetFileAttributeExtractor nfAttrs) {
        return nfAttrs.getStringList("sunPortalNetFileDeniedHostList");
    }

    List getCommonHosts(NetFileAttributeExtractor nfAttrs) {
        ArrayList<String> decryptedNetFileHosts = null;
        List encryptedHosts = nfAttrs.getStringList("sunPortalNetFileCommonHostData");
        if (encryptedHosts != null && !encryptedHosts.isEmpty()) {
            decryptedNetFileHosts = new ArrayList<String>();
            Iterator hosts = encryptedHosts.iterator();
            while (hosts.hasNext()) {
                decryptedNetFileHosts.add(this.getDecryptedHostInfo((String)hosts.next()));
            }
        }
        return decryptedNetFileHosts;
    }

    List getUserAddedHostsList(NetFileAttributeExtractor nfAttrs) {
        return nfAttrs.getStringList("sunPortalNetFileHostTypePassShare");
    }

    String getDecryptedHostInfo(String szEncryptedHostInfo) {
        return (String)AccessController.doPrivileged(new DecryptAction(szEncryptedHostInfo));
    }

    InetAddress[] getInetAddresses(String szHost) throws UnknownHostException {
        return InetAddress.getAllByName(szHost);
    }

    void setDefaultDomain(String szDefaultDomain) {
        this.defaultDomain = szDefaultDomain;
    }

    void loadHostDataSets(NetFileAttributeExtractor nfAttrs) {
        this.deniedHosts = this.getDeniedHostsList(nfAttrs);
        if (this.debug.messageEnabled()) {
            this.debug.message("Denied hosts are " + this.deniedHosts);
        }
        this.allowedHosts = this.getAllowedHostsList(nfAttrs);
        if (this.debug.messageEnabled()) {
            this.debug.message("Allowed hosts are " + this.allowedHosts);
        }
        this.commondata = this.getCommonHosts(nfAttrs);
        this.listOfHosts = this.getUserAddedHostsList(nfAttrs);
    }

    boolean isLocalHost(InetAddress[] hostIAddresses) {
        if (this.localHostAddrs == null || this.localHostAddrs.length < 1) {
            return true;
        }
        for (int i = 0; i < hostIAddresses.length; ++i) {
            for (int k = 0; k < this.localHostAddrs.length; ++k) {
                if (!((String)this.localHostAddrs[k]).trim().equals(hostIAddresses[i].getHostAddress().trim())) continue;
                if (this.debug.messageEnabled()) {
                    this.debug.message(hostIAddresses[i].getHostName() + " is a local host");
                }
                return true;
            }
        }
        return false;
    }

    Object[] getRPaddrs() {
        ArrayList<String> rpHostIP = new ArrayList<String>();
        String configparam = "";
        try {
            int c;
            Runtime rt = Runtime.getRuntime();
            StringBuffer buftxt = new StringBuffer(80);
            String[] progarr = new String[]{"/sbin/ifconfig", "-a"};
            Process shellconn = rt.exec(progarr);
            InputStream shellout = shellconn.getInputStream();
            while ((c = shellout.read()) > -1) {
                char chtxt = (char)c;
                buftxt.append(chtxt);
            }
            rt = null;
            shellout.close();
            shellout = null;
            shellconn.destroy();
            shellconn = null;
            configparam = buftxt.toString();
        }
        catch (IOException ex) {
            this.debug.error("FileOption IOException in getrpaddrs: ", (Throwable)ex);
            rpHostIP.add("Failed Execution: " + ex);
            Object rt = null;
            return rpHostIP.toArray();
        }
        if (configparam.equals("")) {
            this.debug.message("Cannot get local machine hostname.");
            rpHostIP.add("Cannot get local machine hostname.");
            return rpHostIP.toArray();
        }
        StringTokenizer pars = new StringTokenizer(configparam, "\n");
        int parscnt = pars.countTokens();
        String[] hostip = new String[100];
        int inetindx = 0;
        int inetmaskindx = 0;
        for (int j = 0; j < parscnt; ++j) {
            hostip[j] = pars.nextToken();
            inetindx = hostip[j].indexOf("inet", 0);
            inetmaskindx = hostip[j].indexOf("netmask", 0);
            if (inetindx < 0 || inetmaskindx < 0) continue;
            rpHostIP.add(hostip[j].substring(inetindx + 5, inetmaskindx));
        }
        return rpHostIP.toArray();
    }

    private void filterWinAdminShares(HashMap commonHost, HashMap userSavedHost) throws NetFileException {
        ArrayList oSharesList = (ArrayList)commonHost.remove("shares");
        ArrayList oSharePwdsList = (ArrayList)commonHost.remove("share_passwords");
        if (oSharesList == null) {
            return;
        }
        if (oSharePwdsList == null) {
            return;
        }
        ArrayList sharesList = oSharesList;
        ArrayList sharePwdsList = oSharePwdsList;
        if (sharesList.isEmpty()) {
            return;
        }
        if (sharePwdsList.isEmpty()) {
            return;
        }
        Iterator shares = sharesList.iterator();
        Iterator pwds = sharePwdsList.iterator();
        if (userSavedHost == null) {
            if (this.isWinType((String)commonHost.get("machine_type"))) {
                this.verifySharesAccess((String)commonHost.get("machine_user_name"), (String)commonHost.get("machine_password"), (String)commonHost.get("machine_name"), (String)commonHost.get("machine_domain"), (String)commonHost.get("machine_encoding"), shares, pwds);
            }
        } else if (this.isSameType((String)commonHost.get("machine_type"), (String)userSavedHost.get("machine_type"))) {
            this.verifySharesAccess((String)userSavedHost.get("machine_user_name"), (String)userSavedHost.get("machine_password"), (String)userSavedHost.get("machine_name"), (String)commonHost.get("machine_domain"), (String)commonHost.get("machine_encoding"), shares, pwds);
        }
        commonHost.put("shares", sharesList);
        commonHost.put("share_passwords", sharePwdsList);
    }

    private void verifySharesAccess(String userName, String machPwd, String machineName, String domain, String encoding, Iterator shares, Iterator pwds) throws NetFileException {
        String actualEncoding = encoding.substring(encoding.indexOf("(") + 1, encoding.indexOf(")"));
        WinFile winFile = new WinFile(this.logMgr, actualEncoding, this.ssoToken);
        while (shares.hasNext() && pwds.hasNext()) {
            String share = (String)shares.next();
            if (share.trim().endsWith("$")) {
                boolean accessible = this.isShareAccessible(winFile, userName, machineName, domain, share, (String)pwds.next());
                if (!accessible) {
                    shares.remove();
                    pwds.remove();
                    continue;
                }
                if (!this.debug.messageEnabled()) continue;
                this.debug.message("Access to share - " + share + " is allowed to user " + userName);
                continue;
            }
            pwds.next();
        }
    }

    private boolean isShareAccessible(WinFile winFile, String userName, String machineName, String domain, String shareName, String sharePwd) {
        return winFile.isShareAccessible(userName, sharePwd, machineName, shareName, domain, this.nfRes);
    }

    private boolean isSameType(String commonHostType, String userSavedHostType) {
        if (commonHostType.equalsIgnoreCase(userSavedHostType)) {
            return this.isWinType(commonHostType);
        }
        return false;
    }

    private boolean isWinType(String type) {
        return type.equalsIgnoreCase("WIN") || type.equalsIgnoreCase("NT");
    }

    private String removeCtrlMChar(String szValue) {
        int i = szValue.lastIndexOf(10);
        int j = szValue.lastIndexOf(13);
        if (i < 0 && j < 0) {
            return szValue;
        }
        if (j < 0 && i >= 0) {
            return szValue.substring(0, i);
        }
        return szValue.substring(0, j);
    }
}

