/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet.java1;

import com.iplanet.am.util.AMClientDetector;
import com.iplanet.am.util.Debug;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.netfile.servlet.java1.NetFileContext;
import com.sun.portal.netfile.servlet.java1.NetFileContextImpl;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public class NetFileApplet
extends HttpServlet {
    public static Debug debug = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (debug == null) {
            debug = Debug.getInstance((String)"srapNetFile");
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block11: {
            SSOTokenManager manager = null;
            SSOToken ssoToken = null;
            Locale userLocale = null;
            ResourceBundle userRes = null;
            String htmlCharset = null;
            try {
                manager = SSOTokenManager.getInstance();
                ssoToken = manager.createSSOToken(req);
                String qs = req.getQueryString();
                Hashtable qsParams = HttpUtils.parseQueryString((String)qs);
                if (qsParams == null) {
                    this.getDefaultResourceValues(req, userRes, userLocale, htmlCharset);
                    this.writeErrorHTML(req, res, userRes, htmlCharset, userRes.getString("noparams"));
                    return;
                }
                NetFileContextImpl nfSession = new NetFileContextImpl(ssoToken);
                if (nfSession == null) {
                    this.getDefaultResourceValues(req, userRes, userLocale, htmlCharset);
                    this.writeErrorHTML(req, res, userRes, htmlCharset, userRes.getString("sessionerror"));
                    return;
                }
                if (nfSession.isSessionValid(ssoToken)) {
                    String[] szReferFrom = (String[])qsParams.get("Refer");
                    nfSession.determineHTMLCharset(req);
                    htmlCharset = nfSession.getHTMLCharset();
                    if (htmlCharset == null || htmlCharset.equals("")) {
                        htmlCharset = "ISO-8859-1";
                    }
                    userRes = this.getUserResourceValues(req, nfSession, userLocale);
                    if (szReferFrom != null) {
                        if (nfSession.isExecutable(ssoToken)) {
                            if (szReferFrom[0].equals("java1")) {
                                this.writeJava1AppletHTML(req, res, userRes, htmlCharset, ssoToken.getTokenID().toString());
                            } else if (szReferFrom[0].equals("java2")) {
                                this.writeJava2AppletHTML(req, res, userRes, htmlCharset, ssoToken.getTokenID().toString());
                            }
                            break block11;
                        }
                        this.writeErrorHTML(req, res, userRes, htmlCharset, userRes.getString("nopermission"));
                        return;
                    }
                    this.writeErrorHTML(req, res, userRes, htmlCharset, userRes.getString("noparams"));
                    return;
                }
                userRes = this.getUserResourceValues(req, nfSession, userLocale);
                this.writeErrorHTML(req, res, userRes, htmlCharset, userRes.getString("sessionerror"));
                return;
            }
            catch (SSOException ssoe) {
                ssoe.printStackTrace();
                this.getDefaultResourceValues(req, userRes, userLocale, htmlCharset);
                this.writeErrorHTML(req, res, userRes, htmlCharset, userRes.getString("sessionerror"));
            }
        }
    }

    private void writeJava1AppletHTML(HttpServletRequest req, HttpServletResponse res, ResourceBundle userResources, String charset, String sznfID) throws IOException {
        String staticURL = this.getStaticUrl(req);
        String dynaURL = this.getDynamicUrl(req);
        if (debug.messageEnabled()) {
            debug.message("Charset is " + charset);
        }
        PrintWriter out = this.getWriter(res, charset);
        res.setHeader("Pragma", "no-cache");
        res.setHeader("Cache-Control", "max-age=0");
        String bgcolors = userResources.getString("bgcolorS");
        String textcolors = userResources.getString("textcolorS");
        out.println("<html><head><title>" + userResources.getString("nftitle") + "</title></head>");
        out.print("<body text='");
        out.print(textcolors);
        out.print("'");
        out.print(" bgcolor='");
        out.print(bgcolors);
        out.print("'>");
        out.println("<h2>" + userResources.getString("nftitle") + "</h2>");
        String qs = req.getQueryString();
        if (qs != null && qs.indexOf("exit") != -1) {
            out.println("<HEAD><SCRIPT LANGUAGE=\"Javascript\">window.close();</SCRIPT></HEAD>");
        } else {
            String agent = req.getHeader("user-agent");
            out.println("<p><b>" + userResources.getString("nftext") + "</p></b>");
            out.println("<applet code=NetFileApplet.class codebase=" + staticURL + "/netfile archive=nfuijava1.jar alt=\"NetFile Java1\" height=2 width=1 MAYSCRIPT>");
            out.println("<param name=cabbase value=\"" + staticURL + "/netfile/nfuijava1.cab\">");
            out.println("<param name=nfid value=\"" + sznfID + "\">");
            out.println("<param name=agent value=\"" + agent + "\">");
            out.println("<param name=uploadURL value=" + dynaURL + "/NetFileUploadServlet>");
            out.println("<param name=NetFileURL value=" + dynaURL + "/NetFileServlet>");
            out.println("<param name=InitURL value=" + dynaURL + "/NetFileServlet>");
            out.println("<param name=exitURL value=" + dynaURL + "/NetFileApplet?exitP=exit>");
            out.println("<param name=OpenFileURL value=" + dynaURL + "/NetFileOpenFileServlet>");
            out.println("</applet>");
        }
        out.println("</html>");
        out.close();
    }

    private void writeJava2AppletHTML(HttpServletRequest req, HttpServletResponse res, ResourceBundle userResources, String charset, String sznfID) throws IOException {
        String szDynaURL = this.getDynamicUrl(req);
        String szStaticURL = this.getStaticUrl(req);
        String agent = req.getHeader("user-agent");
        PrintWriter out = this.getWriter(res, charset);
        res.setHeader("Pragma", "no-cache");
        res.setHeader("Cache-Control", "max-age=0");
        String bgcolors = userResources.getString("bgcolorS");
        String textcolors = userResources.getString("textcolorS");
        out.println("<html><head><title>" + userResources.getString("nftitle") + "</title></head>");
        out.print("<body text='");
        out.print(textcolors);
        out.print("'");
        out.print(" bgcolor='");
        out.print(bgcolors);
        out.print("'>");
        String qs = req.getQueryString();
        if (qs != null && qs.indexOf("exit") != -1) {
            out.println("<h2>" + userResources.getString("nfexit") + "</h2>");
            out.println("<SCRIPT LANGUAGE=\"Javascript\">window.close();</SCRIPT>");
        } else {
            out.println("<h2>" + userResources.getString("nfmsg") + "</h2>");
            out.println("<p><b>" + userResources.getString("nftext") + "</p></b>");
            out.println("<applet code=NetFileApplet.class codebase=" + szStaticURL + "/netfile archive=nfuijava2.jar alt=\"NetFile Java2\" height=2 width=1 MAYSCRIPT>");
            out.println("<param name=nfid value=\"" + sznfID + "\">");
            out.println("<param name=agent value=\"" + agent + "\">");
            out.println("<param name=UploadURL value=" + szDynaURL + "/NetFileController?action=upload&stream=plain>");
            out.println("<param name=NetFileURL value=" + szDynaURL + "/NetFileController>");
            out.println("<param name=OpenFileURL value=" + szDynaURL + "/NetFileController?action=open&stream=object>");
            out.println("<param name=NFProto value=HTTP_JAVA_SERIALIZE>");
            out.println("<param name=NoVMMessage value=\"" + userResources.getString("NoVMMessage") + "\">");
            out.println("<param name=exitURL value=" + szDynaURL + "/NetFileApplet?Refer=java2&exitP=exit>");
            out.println("</applet>");
        }
        out.println("</body>");
        out.println("</html>");
        out.close();
    }

    private void writeErrorHTML(HttpServletRequest req, HttpServletResponse res, ResourceBundle userResources, String charset, String szError) throws IOException {
        PrintWriter out = this.getWriter(res, charset);
        res.setHeader("Cache-Control", "max-age=0");
        String bgcolors = userResources.getString("bgcolorS");
        String textcolors = userResources.getString("textcolorS");
        out.println("<html><head><title>" + userResources.getString("nftitle") + "</title></head>");
        out.print("<body text='");
        out.print(textcolors);
        out.print("'");
        out.print(" bgcolor='");
        out.print(bgcolors);
        out.print("'>");
        out.println("<h2>" + userResources.getString("nftitle") + "</h2>");
        out.println("<p><b> " + szError + "  </p></b>");
        out.println("</html>");
        out.close();
    }

    private String getStaticUrl(HttpServletRequest req) {
        return this.getServletConfig().getServletContext().getInitParameter("staticContext");
    }

    private String getDynamicUrl(HttpServletRequest req) {
        String s = req.getServletPath();
        int i = s.lastIndexOf("/");
        return req.getContextPath() + s.substring(0, i);
    }

    private PrintWriter getWriter(HttpServletResponse res, String charset) throws IOException {
        if (charset == null) {
            res.setContentType("text/html");
            return res.getWriter();
        }
        res.setContentType("text/html; charset=" + charset);
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), charset)));
    }

    private ResourceBundle getUserResourceValues(HttpServletRequest req, NetFileContext nfSession, Locale locale) {
        locale = nfSession.getUserLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle("srapNetFileServletJava1", locale);
    }

    private void getDefaultResourceValues(HttpServletRequest req, ResourceBundle bundle, Locale locale, String charset) {
        locale = Locale.getDefault();
        AMClientDetector amCD = new AMClientDetector();
        String clientType = amCD.getClientType(req);
        try {
            Client clientObj = Client.getInstance((String)clientType);
            charset = clientObj.getCharset(locale);
        }
        catch (ClientException ce) {
            // empty catch block
        }
        if (charset == null || charset.equals("")) {
            charset = "ISO-8859-1";
        }
        bundle = ResourceBundle.getBundle("srapNetFileServletJava1", locale);
    }
}

