/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet.java1;

import com.iplanet.am.util.Debug;
import com.sun.portal.netfile.servlet.java1.FileOption;
import com.sun.portal.netfile.servlet.java1.FullFtpClient;
import com.sun.portal.netfile.servlet.java1.NetFileException;
import com.sun.portal.netfile.servlet.java1.NetFileLogManager;
import com.sun.portal.netfile.servlet.java1.NetFileResource;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import sun.net.TelnetInputStream;
import sun.net.TelnetOutputStream;

class FtpFile {
    protected NetFileLogManager logMgr = null;
    private NetFileResource nfRes = null;
    protected static Debug debug = null;
    protected String s_machine_encoding;
    protected FullFtpClient ffc = null;
    protected FullFtpClient ffcOne = null;
    protected int i_number_of_directories_traversed;
    protected ArrayList alSearchResults = new ArrayList();

    FtpFile(NetFileLogManager log_Mgr, String s_machine_encoding) {
        this.logMgr = log_Mgr;
        this.i_number_of_directories_traversed = 0;
        this.s_machine_encoding = s_machine_encoding;
        if (debug == null) {
            debug = Debug.getInstance((String)"srapNetFile");
        }
    }

    String[] ftpDir(String usernam, String passwrd, String machnam, String VMSnam, String pattern, String dir_nam, int maxsrchdir, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        this.nfRes = nfr_user_locale_i18n_bucket;
        this.ffc = this.initialiseFtpClient(usernam, passwrd, machnam, VMSnam, dir_nam);
        this.search(usernam, passwrd, machnam, VMSnam, pattern, dir_nam, maxsrchdir, nfr_user_locale_i18n_bucket);
        try {
            if (this.ffc != null) {
                this.ffc.quit();
            }
        }
        catch (IOException ioe) {
            debug.error("FtpFile, search -  ", (Throwable)ioe);
        }
        if (this.i_number_of_directories_traversed > maxsrchdir) {
            String[] searchResults = new String[this.alSearchResults.size() + 1];
            searchResults[0] = "EXCEED:" + nfr_user_locale_i18n_bucket.getString("maxSearch");
            for (int j = 1; j < searchResults.length; ++j) {
                searchResults[j] = (String)this.alSearchResults.get(j - 1);
            }
            return searchResults;
        }
        if (this.alSearchResults.size() == 0) {
            this.alSearchResults = null;
            return new String[]{"        "};
        }
        String[] sa_results = new String[this.alSearchResults.size()];
        for (int j = 0; j < sa_results.length; ++j) {
            sa_results[j] = (String)this.alSearchResults.get(j);
        }
        this.alSearchResults = null;
        return sa_results;
    }

    void search(String usernam, String passwrd, String machnam, String VMSnam, String pattern, String dir_nam, int maxsrchdir, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        try {
            ++this.i_number_of_directories_traversed;
            debug.message(this + ":Directory number being searched=" + this.i_number_of_directories_traversed);
            if (this.i_number_of_directories_traversed > maxsrchdir) {
                return;
            }
            String[] sa_file_listing = this.getFTPDir(usernam, passwrd, machnam, VMSnam, dir_nam, nfr_user_locale_i18n_bucket, false);
            if (sa_file_listing[0] == null || sa_file_listing.length < 0) {
                return;
            }
            for (int i = 0; i < sa_file_listing.length && this.i_number_of_directories_traversed <= maxsrchdir && sa_file_listing[i] != null; i += 4) {
                if (sa_file_listing[i].equalsIgnoreCase("d")) {
                    String s_error = "";
                    String s_directory = dir_nam + "/" + sa_file_listing[i + 1];
                    try {
                        this.search(usernam, passwrd, machnam, VMSnam, pattern, s_directory, maxsrchdir, nfr_user_locale_i18n_bucket);
                    }
                    catch (NetFileException e) {
                        s_error = "(" + e.getMessage(nfr_user_locale_i18n_bucket) + ")";
                        if (this.i_number_of_directories_traversed < maxsrchdir) continue;
                        throw e;
                    }
                    catch (Exception e) {
                        debug.error("Exception in searching directory " + s_directory + " in " + VMSnam, (Throwable)e);
                        s_error = "(" + nfr_user_locale_i18n_bucket.getString("error13") + ")";
                    }
                    if (sa_file_listing[i + 1].indexOf(pattern) <= -1) continue;
                    this.alSearchResults.add("/" + VMSnam + s_directory + "/" + s_error);
                    continue;
                }
                if (sa_file_listing[i + 1].indexOf(pattern) <= -1) continue;
                this.alSearchResults.add("/" + VMSnam + dir_nam + "/" + sa_file_listing[i + 1]);
            }
        }
        catch (NetFileException e) {
            if (this.i_number_of_directories_traversed >= maxsrchdir) {
                throw e;
            }
        }
        catch (Exception e) {
            debug.error("Exception in searching " + VMSnam + dir_nam + "/", (Throwable)e);
            throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "error13", NetFileException.KEY_IDENTIFIER_PREFIX + "textseperator", VMSnam + dir_nam + "/"});
        }
    }

    InputStream getInputFTPStream(String usernam, String passwrd, String machnam, String VMSnam, String mainfilenam, String dir_nam) throws NetFileException {
        Exception e = null;
        TelnetInputStream ftpin = null;
        try {
            this.ffc = this.initialiseFtpClient(usernam, passwrd, machnam, VMSnam, dir_nam);
            ftpin = this.ffc.get(mainfilenam);
        }
        catch (Exception ex) {
            e = ex;
        }
        this.performFinalProcessing(e, "Exceptione obtaining the FTP file", this.ffc);
        return ftpin;
    }

    OutputStream getOutputFTPStream(String usernam, String passwrd, String machnam, String VMSnam, String remotefil_arg, String dir_nam) throws NetFileException {
        return this.getOutputFTPStream(usernam, passwrd, machnam, VMSnam, remotefil_arg, dir_nam, false);
    }

    OutputStream getOutputFTPStream(String usernam, String passwrd, String machnam, String VMSnam, String remotefil_arg, String dir_nam, boolean append) throws NetFileException {
        Exception e = null;
        TelnetOutputStream ftpout = null;
        try {
            this.ffc = this.initialiseFtpClient(usernam, passwrd, machnam, VMSnam, dir_nam);
            ftpout = append ? this.ffc.append(remotefil_arg) : this.ffc.put(remotefil_arg);
        }
        catch (Exception ex) {
            e = ex;
            this.performFinalProcessing(e, "Could upload file", this.ffc);
        }
        return ftpout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeFtpFile() {
        try {
            if (this.ffc != null) {
                this.ffc.quit();
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            if (this.ffcOne != null) {
                this.ffcOne.quit();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.ffc = null;
            this.ffcOne = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    String getFTPFile(String usernam, String passwrd, String machnam, String VMSnam, String mainfilenam, String dir_nam, String tmpdir, NetFileResource nfr_user_locale_i18n_bucket, String usersession) throws NetFileException {
        FullFtpClient ffc;
        Exception e;
        String mknodfilename;
        block16: {
            ByteArrayOutputStream buftxt;
            block15: {
                int c;
                mknodfilename = "";
                String txtouting = "";
                e = null;
                ffc = null;
                buftxt = new ByteArrayOutputStream();
                byte[] buffer = new byte[8192];
                TelnetInputStream ftpout = null;
                BufferedOutputStream bos = null;
                String tempdir = tmpdir;
                Long random = new Long(System.currentTimeMillis());
                mknodfilename = tempdir + "/" + random.toString() + usernam.toUpperCase() + mainfilenam;
                File newfil = new File(mknodfilename);
                if (newfil.exists()) {
                    newfil.delete();
                }
                bos = new BufferedOutputStream(new FileOutputStream(newfil));
                ffc = this.initialiseFtpClient(usernam, passwrd, machnam, VMSnam, dir_nam);
                ftpout = ffc.get(mainfilenam);
                while ((c = ((InputStream)ftpout).read(buffer)) > -1) {
                    bos.write(buffer, 0, c);
                    buftxt.write(buffer, 0, c);
                }
                ((InputStream)ftpout).close();
                bos.flush();
                bos.close();
                ffc.closeServer();
                txtouting = buftxt.toString();
                if (!txtouting.startsWith("ERROR:") && txtouting.indexOf(nfr_user_locale_i18n_bucket.getString("permissiondenied")) < 0 && txtouting.indexOf(nfr_user_locale_i18n_bucket.getString("nosuchfile")) < 0) break block15;
                FileOption fil4 = new FileOption(this.logMgr, this.s_machine_encoding);
                fil4.doError(nfr_user_locale_i18n_bucket.getString("error6"));
                String string = "ERROR:" + nfr_user_locale_i18n_bucket.getString("error6");
                Object var25_25 = null;
                try {
                    if (buftxt != null) {
                        buftxt.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return string;
            }
            Object var25_26 = null;
            try {
                if (buftxt != null) {
                    buftxt.close();
                }
                break block16;
            }
            catch (IOException ioe) {}
            break block16;
            {
                catch (Exception ex) {
                    e = ex;
                    Object var25_27 = null;
                    try {
                        if (buftxt != null) {
                            buftxt.close();
                        }
                        break block16;
                    }
                    catch (IOException ioe) {}
                }
            }
            catch (Throwable throwable) {
                Object var25_28 = null;
                try {
                    if (buftxt != null) {
                        buftxt.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        this.performFinalProcessing(e, "Exceptione obtaining the FTP file", ffc);
        return mknodfilename;
    }

    String delFTPFile(String username, String password, String machine, String share, String file_to_delete, String directory, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        FullFtpClient ffc = null;
        Exception e = null;
        try {
            if (this.ffc == null) {
                this.ffc = ffc = this.initialiseFtpClient(username, password, machine, share, directory);
            } else {
                ffc = this.ffc;
            }
            ffc.delete(file_to_delete);
        }
        catch (Exception ex) {
            e = ex;
        }
        this.performFinalProcessing(e, "Could not delete file", ffc);
        return nfr_user_locale_i18n_bucket.getString("info5");
    }

    String reEncodeString(String string) throws Exception {
        return new String(string.getBytes(), this.s_machine_encoding);
    }

    String[] getFTPDir(String username, String password, String machname, String VMSname, String dirS, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        return this.getFTPDir(username, password, machname, VMSname, dirS, nfr_user_locale_i18n_bucket, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String[] getFTPDir(String username, String password, String machname, String VMSname, String dirS, NetFileResource nfr_user_locale_i18n_bucket, boolean closeConn) throws NetFileException {
        String[] file_listing;
        block14: {
            FullFtpClient full_ftp_client = null;
            Exception e = null;
            NetFileException nfe = null;
            file_listing = new String[]{};
            ArrayList names_list = null;
            ArrayList full_listing = null;
            if (this.ffc == null) {
                full_ftp_client = this.initialiseFtpClient(username, password, machname, VMSname, dirS);
            } else {
                full_ftp_client = this.ffc;
                full_ftp_client.cd(VMSname + dirS);
            }
            names_list = this.getNamesList(full_ftp_client);
            full_listing = this.getList(full_ftp_client, false);
            String[][] listing = this.processListings(names_list, full_listing);
            int number_of_files = names_list.size();
            file_listing = number_of_files == 0 ? new String[1] : new String[number_of_files * 4];
            int j = 0;
            for (int i = 0; i < number_of_files; ++i) {
                if (listing[i][1].equals("..") || listing[i][1].startsWith(".")) continue;
                file_listing[j++] = listing[i][0];
                file_listing[j++] = listing[i][1];
                file_listing[j++] = listing[i][3];
                file_listing[j++] = listing[i][2];
            }
            Object var19_20 = null;
            names_list = null;
            full_listing = null;
            if (!closeConn) break block14;
            try {
                full_ftp_client.quit();
            }
            catch (Exception ge) {
                // empty catch block
            }
            this.performFinalProcessingForGetFTPDir(nfe, e, "Could not obtain FTP listing", full_ftp_client);
            {
                break block14;
                catch (NetFileException ex) {
                    nfe = ex;
                    Object var19_21 = null;
                    names_list = null;
                    full_listing = null;
                    if (!closeConn) break block14;
                    try {
                        full_ftp_client.quit();
                    }
                    catch (Exception ge) {
                        // empty catch block
                    }
                    this.performFinalProcessingForGetFTPDir(nfe, e, "Could not obtain FTP listing", full_ftp_client);
                    break block14;
                }
                catch (Exception ex) {
                    e = ex;
                    Object var19_22 = null;
                    names_list = null;
                    full_listing = null;
                    if (!closeConn) break block14;
                    try {
                        full_ftp_client.quit();
                    }
                    catch (Exception ge) {
                        // empty catch block
                    }
                    this.performFinalProcessingForGetFTPDir(nfe, e, "Could not obtain FTP listing", full_ftp_client);
                }
            }
            catch (Throwable throwable) {
                Object var19_23 = null;
                names_list = null;
                full_listing = null;
                if (closeConn) {
                    try {
                        full_ftp_client.quit();
                    }
                    catch (Exception ge) {
                        // empty catch block
                    }
                    this.performFinalProcessingForGetFTPDir(nfe, e, "Could not obtain FTP listing", full_ftp_client);
                }
                throw throwable;
            }
        }
        return file_listing;
    }

    private ArrayList getNamesList(FullFtpClient full_ftp_client) throws Exception {
        return this.getList(full_ftp_client, true);
    }

    private ArrayList getList(FullFtpClient full_ftp_client, boolean names_only) throws Exception {
        if (full_ftp_client == null) {
            throw new IllegalArgumentException("null full ftp client");
        }
        TelnetInputStream list = null;
        ArrayList<String> v_list = new ArrayList<String>();
        list = names_only ? full_ftp_client.nlist() : full_ftp_client.list(true);
        InputStreamReader ipsr_list = new InputStreamReader((InputStream)list, this.s_machine_encoding);
        BufferedReader br_list = new BufferedReader(ipsr_list);
        String s_input_line = null;
        while ((s_input_line = br_list.readLine()) != null) {
            v_list.add(s_input_line);
        }
        br_list.close();
        ipsr_list.close();
        list.close();
        s_input_line = null;
        br_list = null;
        ipsr_list = null;
        list = null;
        return v_list;
    }

    private String[][] processListings(ArrayList v_file_names, ArrayList v_full_listing) throws Exception {
        int listing_size = v_full_listing.size();
        if (listing_size <= 0) {
            return new String[0][];
        }
        String last_entry = (String)v_full_listing.get(listing_size - 1);
        boolean is_windows = !last_entry.startsWith("-") && !last_entry.startsWith("d") && !last_entry.startsWith("l") && !last_entry.startsWith("d") && !last_entry.startsWith("b") && !last_entry.startsWith("c") && !last_entry.startsWith("p") && !last_entry.startsWith("s") && !last_entry.startsWith("D");
        String[][] listing = null;
        listing = is_windows ? this.processMSDirectoryListingType(v_file_names, v_full_listing) : this.processUnixDirectoryListingType(v_file_names, v_full_listing);
        return listing;
    }

    private void mergeListing(ArrayList fileListing, ArrayList fullListing) {
        int fileIndex = 0;
        int listingIndex = 0;
        while (fileIndex < fileListing.size()) {
            String fileName = (String)fileListing.get(fileIndex);
            String fullListingRow = (String)fullListing.get(listingIndex);
            if (fullListingRow.indexOf(fileName) == -1) {
                do {
                    fullListing.remove(listingIndex);
                } while ((fullListingRow = (String)fullListing.get(listingIndex)).indexOf(fileName) == -1);
                --fileIndex;
                --listingIndex;
            }
            ++fileIndex;
            ++listingIndex;
        }
    }

    private String getModifiedDateFormat(String modifiedTime) {
        Date d;
        if (modifiedTime.indexOf(45) != -1) {
            SimpleDateFormat format = new SimpleDateFormat("MM-dd-yy hh:mma");
            format.setCalendar(new GregorianCalendar(TimeZone.getDefault()));
            try {
                d = format.parse(modifiedTime);
            }
            catch (Exception e) {
                debug.error("Exception: ", (Throwable)e);
                return null;
            }
        } else {
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault());
            String[] strArray = new String[3];
            StringTokenizer stok = new StringTokenizer(modifiedTime, " ");
            int tokenCount = stok.countTokens();
            for (int i = 0; i < tokenCount; ++i) {
                strArray[i] = stok.nextToken();
            }
            calendar.set(2, this.getMonthCode(strArray[0]));
            calendar.set(5, Integer.parseInt(strArray[1]));
            String dateStr = strArray[2];
            if (dateStr.indexOf(":") != -1) {
                int colonIndex = dateStr.indexOf(":");
                String hourStr = dateStr.substring(0, colonIndex);
                String minuteStr = dateStr.substring(colonIndex + 1).trim();
                calendar.set(11, Integer.parseInt(hourStr));
                calendar.set(12, Integer.parseInt(minuteStr));
            } else {
                calendar.set(1, Integer.parseInt(dateStr.trim()));
            }
            d = calendar.getTime();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd yy, hh:mm a");
        sdf.setCalendar(new GregorianCalendar(TimeZone.getDefault()));
        return sdf.format(d);
    }

    public int getMonthCode(String month) {
        int monthCode = -1;
        if (month.equalsIgnoreCase("jan")) {
            monthCode = 0;
        } else if (month.equalsIgnoreCase("feb")) {
            monthCode = 1;
        } else if (month.equalsIgnoreCase("mar")) {
            monthCode = 2;
        } else if (month.equalsIgnoreCase("apr")) {
            monthCode = 3;
        } else if (month.equalsIgnoreCase("may")) {
            monthCode = 4;
        } else if (month.equalsIgnoreCase("jun")) {
            monthCode = 5;
        } else if (month.equalsIgnoreCase("jul")) {
            monthCode = 6;
        } else if (month.equalsIgnoreCase("aug")) {
            monthCode = 7;
        } else if (month.equalsIgnoreCase("sep")) {
            monthCode = 8;
        } else if (month.equalsIgnoreCase("oct")) {
            monthCode = 9;
        } else if (month.equalsIgnoreCase("nov")) {
            monthCode = 10;
        } else if (month.equalsIgnoreCase("dec")) {
            monthCode = 11;
        }
        return monthCode;
    }

    private String[][] processUnixDirectoryListingType(ArrayList v_file_names, ArrayList v_full_listing) throws Exception {
        if (v_file_names.size() != v_full_listing.size()) {
            this.mergeListing(v_file_names, v_full_listing);
        }
        int number_of_files = v_file_names.size();
        int full_listing_length = v_full_listing.size();
        String[][] listing = new String[number_of_files][4];
        String file_name = null;
        String full_listing_row = null;
        int i = number_of_files - 1;
        int j = full_listing_length - 1;
        while (i >= 0) {
            listing[i][1] = file_name = (String)v_file_names.get(i);
            full_listing_row = (String)v_full_listing.get(j);
            debug.message(full_listing_row);
            listing[i][0] = full_listing_row.charAt(0) == 'd' ? "d" : full_listing_row.charAt(0) + "";
            int k = -1;
            if (listing[i][0].equals("l")) {
                k = full_listing_row.indexOf(file_name + " ->") - 1;
                listing[i][1] = file_name = full_listing_row.substring(k, full_listing_row.length());
            } else {
                k = full_listing_row.lastIndexOf(file_name) - 1;
            }
            while (k >= 0 && full_listing_row.charAt(k) == ' ') {
                --k;
            }
            int end_of_date = k + 1;
            while (k >= 0 && full_listing_row.charAt(k) != ' ') {
                --k;
            }
            while (k >= 0 && full_listing_row.charAt(k) == ' ') {
                --k;
            }
            while (k >= 0 && full_listing_row.charAt(k) != ' ') {
                --k;
            }
            while (k >= 0 && full_listing_row.charAt(k) == ' ') {
                --k;
            }
            while (k >= 0 && full_listing_row.charAt(k) != ' ') {
                --k;
            }
            listing[i][2] = this.getModifiedDateFormat(full_listing_row.substring(k + 1, end_of_date));
            while (k >= 0 && full_listing_row.charAt(k) == ' ') {
                --k;
            }
            int end_of_length = k + 1;
            while (k >= 0 && full_listing_row.charAt(k) != ' ') {
                --k;
            }
            listing[i][3] = full_listing_row.substring(k + 1, end_of_length);
            --i;
            --j;
        }
        return listing;
    }

    private String[][] processMSDirectoryListingType(ArrayList v_file_names, ArrayList v_full_listing) throws Exception {
        int number_of_files = v_file_names.size();
        String[][] listing = new String[number_of_files][4];
        String full_listing_row = null;
        for (int i = number_of_files - 1; i >= 0; --i) {
            int j;
            listing[i][1] = (String)v_file_names.get(i);
            full_listing_row = (String)v_full_listing.get(i);
            if (full_listing_row.indexOf("<DIR>") > 0) {
                listing[i][3] = "0";
                listing[i][0] = "d";
            } else {
                listing[i][0] = "-";
            }
            for (j = 0; j < full_listing_row.length() && full_listing_row.charAt(j) != ' '; ++j) {
            }
            while (j < full_listing_row.length() && full_listing_row.charAt(j) == ' ') {
                ++j;
            }
            while (j < full_listing_row.length() && full_listing_row.charAt(j) != ' ') {
                ++j;
            }
            listing[i][2] = this.getModifiedDateFormat(full_listing_row.substring(0, j));
            if (listing[i][3] != null) continue;
            int start_of_length = -1;
            while (j < full_listing_row.length() && full_listing_row.charAt(j) == ' ') {
                ++j;
            }
            start_of_length = j;
            while (j < full_listing_row.length() && full_listing_row.charAt(j) != ' ') {
                ++j;
            }
            listing[i][3] = full_listing_row.substring(start_of_length, j);
        }
        return listing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void rename(String username, String password, String machine, String share, String directory, String oldFileName, String newFileName) throws NetFileException {
        block11: {
            FullFtpClient ffc = null;
            Exception e = null;
            ffc = this.initialiseFtpClient(username, password, machine, share, directory);
            ffc.rename(oldFileName, newFileName);
            Object var12_10 = null;
            try {
                if (ffc != null) {
                    ffc.closeServer();
                }
                break block11;
            }
            catch (Exception exception) {}
            break block11;
            {
                catch (Exception ex) {
                    e = ex;
                    this.performFinalProcessing(e, "Could not rename file", ffc);
                    Object var12_11 = null;
                    try {
                        if (ffc != null) {
                            ffc.closeServer();
                        }
                        break block11;
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                try {
                    if (ffc != null) {
                        ffc.closeServer();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void performFinalProcessing(Exception ex, String message_to_debug, FullFtpClient ffc) throws NetFileException {
        if (ex != null) {
            debug.error(message_to_debug, (Throwable)ex);
            if (ex instanceof FileNotFoundException) {
                throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "no_file_or_permission");
            }
            try {
                if (ffc != null) {
                    ffc.quit();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "noop_no_reason");
        }
    }

    private void performFinalProcessingForGetFTPDir(NetFileException nfe, Exception ex, String message_to_debug, FullFtpClient ffc) throws NetFileException {
        try {
            if (ffc != null) {
                ffc.quit();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (nfe != null) {
            throw nfe;
        }
        if (ex != null) {
            debug.error(message_to_debug, (Throwable)ex);
            if (ex instanceof FileNotFoundException) {
                throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "no_file_or_permission");
            }
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "noop_no_reason");
        }
    }

    private FullFtpClient initialiseFtpClient(String username, String password, String machine, String share, String directory) throws NetFileException {
        FullFtpClient ffc = null;
        try {
            ffc = new FullFtpClient(machine, this.s_machine_encoding);
            ffc.setMachineToAccess(machine);
        }
        catch (Exception ioe) {
            debug.error("Failed to Bind on Port 21 to host: " + machine, (Throwable)ioe);
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error19");
        }
        try {
            ffc.login(username, password);
        }
        catch (Exception e) {
            debug.error("Login Error to " + machine, (Throwable)e);
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error12");
        }
        try {
            ffc.cd(share + directory);
        }
        catch (Exception ioe) {
            debug.error("Cannot change to directory " + share + directory, (Throwable)ioe);
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error20");
        }
        try {
            ffc.binary();
        }
        catch (Exception ioe) {
            debug.error("Cannot change mode to binary", (Throwable)ioe);
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error20_2");
        }
        return ffc;
    }
}

