/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet.java1;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOToken;
import com.sun.portal.netfile.servlet.java1.FtpFile;
import com.sun.portal.netfile.servlet.java1.FullFtpClient;
import com.sun.portal.netfile.servlet.java1.NetFileAttributeExtractor;
import com.sun.portal.netfile.servlet.java1.NetFileCompression;
import com.sun.portal.netfile.servlet.java1.NetFileContextImpl;
import com.sun.portal.netfile.servlet.java1.NetFileException;
import com.sun.portal.netfile.servlet.java1.NetFileLogManager;
import com.sun.portal.netfile.servlet.java1.NetFileResource;
import com.sun.portal.netfile.servlet.java1.NetWareFile;
import com.sun.portal.netfile.servlet.java1.NfsFile;
import com.sun.portal.netfile.servlet.java1.SendFile;
import com.sun.portal.netfile.servlet.java1.XFileFactory;
import com.sun.portal.netfile.servlet.java1.XFileInterface;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

class FileOption {
    public static final String DEBUG_FILE = "srapNetFile";
    private static final String WIN = "WIN";
    private static final String NT = "NT";
    private static final String NFS = "NFS";
    private static final String NETWARE = "NETWARE";
    private static final String FTP = "FTP";
    private static final String ERROR = "ERROR:";
    private static final String MESSAGE_1 = " Processing of file ";
    private static final String TEXT_SEPERATOR = "textseperator";
    public static final String SERVLET_PROPERTIES = "srapNetFileServletJava1";
    public static final String APPLET_PROPERTIES = "srapNetFileAppletJava1";
    private static final String END_OF_STRING = "\u0000";
    private String[] pathinfo;
    private String s_empty_string;
    private String exerr;
    private String[] rettxt;
    private static NetFileResource nfr_platform_locale_i18n_bucket;
    private static Debug debug;
    private static String s_platform_locale_error;
    private NetFileLogManager logMgr;
    private String s_machine_encoding;
    private SSOToken ssoToken;
    private char c_eol;

    FileOption(NetFileLogManager log_Mgr, String s_machine_encoding) {
        this.exerr = this.s_empty_string = "";
        this.rettxt = new String[2];
        this.logMgr = null;
        this.ssoToken = null;
        this.c_eol = (char)10;
        this.logMgr = log_Mgr;
        this.s_machine_encoding = s_machine_encoding;
        this.pathinfo = new String[2];
        if (debug == null) {
            debug = Debug.getInstance((String)DEBUG_FILE);
        }
        try {
            FileOption.setPlatformLocaleBundle();
        }
        catch (NetFileException e) {
            debug.error("Could not obtain platform specific locale bundle properly", (Throwable)e);
        }
    }

    FileOption(NetFileLogManager log_Mgr, String s_machine_encoding, SSOToken ssoToken) {
        this.exerr = this.s_empty_string = "";
        this.rettxt = new String[2];
        this.logMgr = null;
        this.ssoToken = null;
        this.c_eol = (char)10;
        this.logMgr = log_Mgr;
        this.s_machine_encoding = s_machine_encoding;
        this.pathinfo = new String[2];
        this.setSSOToken(ssoToken);
        if (debug == null) {
            debug = Debug.getInstance((String)DEBUG_FILE);
        }
        try {
            FileOption.setPlatformLocaleBundle();
        }
        catch (NetFileException e) {
            debug.error("Could not obtain platform specific locale bundle properly", (Throwable)e);
        }
    }

    private static synchronized void setPlatformLocaleBundle() throws NetFileException {
        if (nfr_platform_locale_i18n_bucket == null && (s_platform_locale_error = (nfr_platform_locale_i18n_bucket = NetFileResource.getInstance(SERVLET_PROPERTIES)).getString("error")) == null) {
            throw new NetFileException("There is no entry for key error in srapNetFileServletJava1.properties");
        }
    }

    public void setSSOToken(SSOToken token) {
        this.ssoToken = token;
    }

    public SSOToken getSSOToken() {
        return this.ssoToken;
    }

    public String getPlatformLocalisedString(String string) {
        return nfr_platform_locale_i18n_bucket.getString(string);
    }

    public NetFileResource getPlatformLocalisedBundle() {
        if (nfr_platform_locale_i18n_bucket == null) {
            debug.error(" nfr_platform_locale_i18n_bucket not initialised yet in FileOption");
        }
        return nfr_platform_locale_i18n_bucket;
    }

    String[] expandVMS(String user_name, String password, String machine_name, String domain, String machine_type, String VMS, String temporary_directory, NetFileResource nfr_user_locale_i18n_bucket) throws Throwable {
        return this.expandDir(user_name, password, machine_name, domain, machine_type, this.s_empty_string, VMS, temporary_directory, nfr_user_locale_i18n_bucket);
    }

    String[] expandDir(String user_name, String password, String machine_name, String domain, String machine_type, String directory, String VMS, String temporary_directory, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException, Exception {
        if (user_name == null) {
            throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "invalid_user_name", NetFileException.KEY_IDENTIFIER_PREFIX + TEXT_SEPERATOR, user_name});
        }
        if (user_name.equals(this.s_empty_string)) {
            throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "invalid_user_name", NetFileException.KEY_IDENTIFIER_PREFIX + TEXT_SEPERATOR, user_name});
        }
        if (password == null) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "invalid_password");
        }
        if (machine_name == null) {
            throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "invalid_machine_name", NetFileException.KEY_IDENTIFIER_PREFIX + TEXT_SEPERATOR, machine_name});
        }
        if (machine_name.equals(this.s_empty_string)) {
            throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "invalid_machine_name", NetFileException.KEY_IDENTIFIER_PREFIX + TEXT_SEPERATOR, machine_name});
        }
        boolean is_machine_type_invalid = false;
        if (machine_type == null || machine_type.equalsIgnoreCase(this.s_empty_string)) {
            is_machine_type_invalid = true;
        } else if (!(machine_type.equals(FTP) || machine_type.equals(NFS) || machine_type.equals(WIN) || machine_type.equals(NT) || machine_type.equals(NETWARE))) {
            is_machine_type_invalid = true;
        }
        if (is_machine_type_invalid) {
            throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "invalid_machine_type", NetFileException.KEY_IDENTIFIER_PREFIX + TEXT_SEPERATOR, machine_type});
        }
        if (VMS == null || VMS.equals(this.s_empty_string)) {
            throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "invalid_vms_name", NetFileException.KEY_IDENTIFIER_PREFIX + TEXT_SEPERATOR, VMS});
        }
        if (directory == null) {
            throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "invalid_directory_name", NetFileException.KEY_IDENTIFIER_PREFIX + TEXT_SEPERATOR, directory});
        }
        if (temporary_directory == null) {
            throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "invalid_temporary_directory_name", NetFileException.KEY_IDENTIFIER_PREFIX + TEXT_SEPERATOR, directory});
        }
        if (debug.messageEnabled()) {
            debug.message("VMS is " + VMS);
            debug.message("Directory is " + directory);
            debug.message("Expanding " + VMS + directory);
        }
        if (machine_type.indexOf(NETWARE, 0) >= 0) {
            NetWareFile netwaredir = new NetWareFile(this.logMgr, this.s_machine_encoding);
            this.rettxt = netwaredir.getFTPDir(user_name, password, machine_name, VMS, directory, nfr_user_locale_i18n_bucket);
        } else if (machine_type.indexOf(WIN, 0) >= 0 || machine_type.indexOf(NT, 0) >= 0) {
            if (directory.equals(" ") || directory == null || directory.equals(this.s_empty_string)) {
                directory = "\\";
            }
            XFileInterface gpc = XFileFactory.getInstance().newXFileInstance(this.logMgr, this.s_machine_encoding, this.ssoToken);
            this.rettxt = gpc.getDirectory(user_name, password, machine_name, VMS, directory, domain, nfr_user_locale_i18n_bucket);
        } else if (machine_type.indexOf(FTP, 0) >= 0) {
            FtpFile gff = new FtpFile(this.logMgr, this.s_machine_encoding);
            this.rettxt = gff.getFTPDir(user_name, password, machine_name, VMS, directory, nfr_user_locale_i18n_bucket);
        } else if (machine_type.indexOf(NFS, 0) >= 0) {
            NfsFile gnf = new NfsFile(this.logMgr, this.s_machine_encoding);
            this.rettxt = gnf.getNFSDir(user_name, password, VMS, machine_name, directory, temporary_directory, nfr_user_locale_i18n_bucket);
        } else {
            throw new Exception(nfr_platform_locale_i18n_bucket.getString("error3"));
        }
        if (debug.messageEnabled()) {
            debug.message("Expand over");
        }
        return this.rettxt;
    }

    String openFile(String username, String password, String machname, String domain, String machtype, String dir, String VMSname, String mainfilenam, String tmpdir, NetFileResource nfr_user_locale_i18n_bucket, String usersession) throws NetFileException {
        String mainfilename = this.s_empty_string;
        String txt = this.s_empty_string;
        try {
            int indx = mainfilenam.indexOf("*", 0);
            mainfilename = indx >= 0 ? mainfilenam.substring(0, indx) : mainfilenam;
            if (machtype.equalsIgnoreCase(this.s_empty_string)) {
                throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error1");
            }
            if (debug.messageEnabled()) {
                debug.message("Getting " + mainfilename);
            }
            if (machtype.indexOf(FTP, 0) >= 0 || machtype.indexOf(NETWARE, 0) >= 0) {
                FtpFile gff = new FtpFile(this.logMgr, this.s_machine_encoding);
                txt = gff.getFTPFile(username, password, machname, VMSname, mainfilename, dir, tmpdir, nfr_user_locale_i18n_bucket, usersession);
            } else if (machtype.indexOf(WIN, 0) >= 0 || machtype.indexOf(NT, 0) >= 0) {
                if (dir.equals(" ") || dir == null || dir.equals(this.s_empty_string)) {
                    dir = "\\";
                }
                XFileInterface gpc = XFileFactory.getInstance().newXFileInstance(this.logMgr, this.s_machine_encoding, this.ssoToken);
                txt = gpc.getFile(username, password, machname, VMSname, mainfilename, dir, domain, tmpdir, nfr_user_locale_i18n_bucket);
            } else if (machtype.indexOf(NFS, 0) >= 0) {
                NfsFile gfs = new NfsFile(this.logMgr, this.s_machine_encoding);
                txt = gfs.getNFSFile(username, password, VMSname, machname, mainfilename, dir, tmpdir, nfr_user_locale_i18n_bucket);
            }
            if (txt.indexOf("FileNotFound", 0) >= 0) {
                throw new NetFileException(new String[]{mainfilename, NetFileException.KEY_IDENTIFIER_PREFIX + TEXT_SEPERATOR, NetFileException.KEY_IDENTIFIER_PREFIX + "error2"});
            }
            if (txt.toUpperCase().indexOf("ERROR", 0) >= 0) {
                throw new NetFileException(new String[]{mainfilename, NetFileException.KEY_IDENTIFIER_PREFIX + TEXT_SEPERATOR, NetFileException.KEY_IDENTIFIER_PREFIX + "error2"});
            }
            if (debug.messageEnabled()) {
                debug.message("Obtained " + txt);
            }
        }
        catch (Exception e) {
            txt = ERROR + e.getMessage();
            debug.error("Problem getting file", (Throwable)e);
        }
        return txt;
    }

    String getFileContentType(String filsuffix, NetFileResource nfr_user_locale_i18n_bucket) {
        String filesuffix = filsuffix;
        this.grepPlatinfo();
        String mimepath = this.pathinfo[1];
        String filecontenttype = this.s_empty_string;
        String mimefile = mimepath + "/mime.types";
        if (debug.messageEnabled()) {
            debug.message("The mime.types file is at " + mimefile);
        }
        if ((filecontenttype = this.mimeTypes(mimefile, filesuffix, nfr_user_locale_i18n_bucket)).equals(this.s_empty_string)) {
            return "application/octet-stream";
        }
        return filecontenttype;
    }

    String mimeTypes(String mimefile, String filesuffix, NetFileResource nfr_user_locale_i18n_bucket) {
        String mimtyp = this.s_empty_string;
        String[] tokn = new String[200];
        String sep = ",";
        String MIME_typ = this.s_empty_string;
        String fil_suffix = filesuffix.toLowerCase();
        boolean found = false;
        try {
            int c;
            File inputFile = new File(mimefile);
            StringBuffer buftxt = new StringBuffer(80);
            FileInputStream fis = new FileInputStream(inputFile);
            while ((c = fis.read()) != -1) {
                char chtxt = (char)c;
                buftxt.append(chtxt);
            }
            fis.close();
            mimtyp = buftxt.toString();
        }
        catch (FileNotFoundException e) {
            debug.error("FileOption mimetypes Filenotfound exception: ", (Throwable)e);
        }
        catch (IOException e) {
            debug.error("FileOption mimetypes IOException: ", (Throwable)e);
        }
        int indx = mimtyp.indexOf("type=", 0);
        String mimetyp = this.s_empty_string;
        if (indx >= 0) {
            mimetyp = mimtyp.substring(indx);
        }
        ArrayList<String> cache = new ArrayList<String>();
        StringTokenizer pars = new StringTokenizer(mimetyp, "\n");
        int parscnt = pars.countTokens();
        cache.clear();
        for (int i = 0; i < parscnt; ++i) {
            tokn[i] = pars.nextToken();
            cache.add(tokn[i]);
        }
        Object[] rowdata = new Object[100];
        Object[] coldata = new Object[100];
        if (cache.size() > 0) {
            for (int row = 0; row < cache.size() && !found; ++row) {
                String str_cache = (String)cache.get(row);
                StringTokenizer parsnew = new StringTokenizer(str_cache, " ");
                int parscntnew = parsnew.countTokens();
                for (int j = 0; j < parscntnew && !found; ++j) {
                    rowdata[j] = parsnew.nextToken();
                    int extindx = rowdata[j].toString().indexOf("exts=", 0);
                    if (extindx < 0) continue;
                    String extstr = rowdata[j].toString().substring(extindx);
                    StringTokenizer extpars = new StringTokenizer(extstr, sep);
                    int extparscnt = extpars.countTokens();
                    for (int s = 0; s < extparscnt && !found; ++s) {
                        coldata[s] = extpars.nextToken();
                        if (coldata[s].toString().indexOf(fil_suffix) < 0) continue;
                        int typindx = str_cache.indexOf("type=", 0);
                        MIME_typ = str_cache.substring(typindx + 5, str_cache.indexOf("exts="));
                        found = true;
                    }
                }
            }
        }
        return MIME_typ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String[] compressFile(String username, String password, String machname, String domain, String machtype, String dir_nam, String VMSname, String mainfilenam, String tmpdir, NetFileResource nfr_user_locale_i18n_bucket, String usersession, String szCompressMethod) throws Exception, NetFileException {
        String usernam = username;
        String passwrd = password;
        String machnam = machname;
        String machtyp = machtype;
        String VMSnam = VMSname;
        String mainfile_name = mainfilenam;
        String dir = dir_nam;
        String domainname = domain;
        String text = this.s_empty_string;
        try {
            try {
                if (machtyp.equalsIgnoreCase(this.s_empty_string)) {
                    throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error1");
                }
                if (mainfile_name.equals(this.s_empty_string)) {
                    throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error1");
                }
                List cachechk = this.parse(mainfile_name, "\n");
                if (cachechk.size() <= 0) {
                    debug.error("No files selected for compression");
                }
                if (cachechk.size() > 0) {
                    for (int fil_zip = 0; fil_zip < cachechk.size(); ++fil_zip) {
                        InputStream instream;
                        OutputStream outstream;
                        XFileInterface gpc;
                        block33: {
                            Object var31_33;
                            FtpFile gff = null;
                            NfsFile nfsFile = null;
                            gpc = null;
                            outstream = null;
                            instream = null;
                            if (szCompressMethod.equalsIgnoreCase("gzip")) {
                                mainfile_name = (String)cachechk.get(fil_zip) + ".gz";
                            } else if (szCompressMethod.equalsIgnoreCase("zip")) {
                                mainfile_name = (String)cachechk.get(fil_zip) + ".zip";
                            }
                            if (debug.messageEnabled()) {
                                debug.message(szCompressMethod + MESSAGE_1 + (String)cachechk.get(fil_zip));
                            }
                            if (machtyp.indexOf(FTP, 0) >= 0 || machtyp.indexOf(NETWARE, 0) >= 0) {
                                gff = new FtpFile(this.logMgr, this.s_machine_encoding);
                                instream = gff.getInputFTPStream(usernam, passwrd, machnam, VMSnam, (String)cachechk.get(fil_zip), dir);
                                outstream = gff.getOutputFTPStream(usernam, passwrd, machnam, VMSnam, mainfile_name, dir);
                            } else if (machtyp.indexOf(NFS, 0) >= 0) {
                                nfsFile = new NfsFile(this.logMgr, this.s_machine_encoding);
                                instream = nfsFile.getNFSInputStream(usernam, passwrd, VMSnam, machnam, (String)cachechk.get(fil_zip), dir);
                                outstream = nfsFile.getNFSOutputStream(usernam, passwrd, machnam, VMSnam, mainfile_name, dir);
                            } else {
                                if (machtyp.indexOf(WIN, 0) < 0 && machtyp.indexOf(NT, 0) < 0) break;
                                gpc = XFileFactory.getInstance().newXFileInstance(this.logMgr, this.s_machine_encoding, this.ssoToken);
                                instream = gpc.getInputStream(usernam, passwrd, domainname, machnam, VMSnam, dir, (String)cachechk.get(fil_zip), nfr_user_locale_i18n_bucket);
                                outstream = gpc.getOutputStream(usernam, passwrd, domainname, machnam, VMSnam, dir, mainfile_name, nfr_user_locale_i18n_bucket);
                            }
                            try {
                                try {
                                    NetFileCompression nfComp = new NetFileCompression();
                                    nfComp.setCompressMethod(szCompressMethod);
                                    nfComp.doCompress(instream, outstream, cachechk.get(fil_zip));
                                }
                                catch (Exception e) {
                                    text = ERROR;
                                    debug.error("Error in compressing file to Server " + machnam, (Throwable)e);
                                    var31_33 = null;
                                    if (gff != null) {
                                        gff.closeFtpFile();
                                        continue;
                                    }
                                    if (nfsFile != null) {
                                        nfsFile.closeNfsFile();
                                        continue;
                                    }
                                    if (gpc == null) continue;
                                    if (instream != null) {
                                        instream.close();
                                    }
                                    if (outstream == null) continue;
                                    outstream.close();
                                    continue;
                                }
                                var31_33 = null;
                                if (gff != null) {
                                    gff.closeFtpFile();
                                    continue;
                                }
                                if (nfsFile == null) break block33;
                            }
                            catch (Throwable throwable) {
                                var31_33 = null;
                                if (gff != null) {
                                    gff.closeFtpFile();
                                    throw throwable;
                                }
                                if (nfsFile != null) {
                                    nfsFile.closeNfsFile();
                                    throw throwable;
                                }
                                if (gpc == null) throw throwable;
                                if (instream != null) {
                                    instream.close();
                                }
                                if (outstream == null) throw throwable;
                                outstream.close();
                                throw throwable;
                            }
                            nfsFile.closeNfsFile();
                            continue;
                        }
                        if (gpc == null) continue;
                        if (instream != null) {
                            instream.close();
                        }
                        if (outstream == null) continue;
                        outstream.close();
                    }
                }
                Object var33_35 = null;
                if (text.startsWith(ERROR)) {
                    if (machtyp.indexOf(NETWARE) > 0 && text.indexOf(nfr_user_locale_i18n_bucket.getString("error6")) >= 0) {
                        this.doError(this.getPlatformLocalisedString("invalidfilename"));
                        this.rettxt[0] = "ERROR: " + nfr_user_locale_i18n_bucket.getString("invalidfilename");
                        this.rettxt[1] = END_OF_STRING;
                        return this.rettxt;
                    }
                    this.doError(this.getPlatformLocalisedString("error2"));
                    this.rettxt[0] = "ERROR: " + nfr_user_locale_i18n_bucket.getString("error2");
                    this.rettxt[1] = END_OF_STRING;
                    return this.rettxt;
                }
            }
            catch (Exception e) {
                debug.error("Exception compressing file", (Throwable)e);
                String[] stringArray = new String[]{"ERROR: " + nfr_user_locale_i18n_bucket.getString("error2"), END_OF_STRING};
                Object var33_36 = null;
                if (!text.startsWith(ERROR)) return stringArray;
                if (machtyp.indexOf(NETWARE) > 0 && text.indexOf(nfr_user_locale_i18n_bucket.getString("error6")) >= 0) {
                    this.doError(this.getPlatformLocalisedString("invalidfilename"));
                    this.rettxt[0] = "ERROR: " + nfr_user_locale_i18n_bucket.getString("invalidfilename");
                    this.rettxt[1] = END_OF_STRING;
                    return this.rettxt;
                }
                this.doError(this.getPlatformLocalisedString("error2"));
                this.rettxt[0] = "ERROR: " + nfr_user_locale_i18n_bucket.getString("error2");
                this.rettxt[1] = END_OF_STRING;
                return this.rettxt;
            }
        }
        catch (Throwable throwable) {
            Object var33_37 = null;
            if (!text.startsWith(ERROR)) throw throwable;
            if (machtyp.indexOf(NETWARE) > 0 && text.indexOf(nfr_user_locale_i18n_bucket.getString("error6")) >= 0) {
                this.doError(this.getPlatformLocalisedString("invalidfilename"));
                this.rettxt[0] = "ERROR: " + nfr_user_locale_i18n_bucket.getString("invalidfilename");
                this.rettxt[1] = END_OF_STRING;
                return this.rettxt;
            }
            this.doError(this.getPlatformLocalisedString("error2"));
            this.rettxt[0] = "ERROR: " + nfr_user_locale_i18n_bucket.getString("error2");
            this.rettxt[1] = END_OF_STRING;
            return this.rettxt;
        }
        this.rettxt[0] = nfr_user_locale_i18n_bucket.getString("info9");
        return this.rettxt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String mailFile(String username, String password, String machine, String domain, String machine_type, String directory, String share, String files_to_send, String mail_server, String from, String to, String reply, String cc, String bcc, String subject, String message, String debug_value, String temporary_directory, NetFileResource nfr_user_locale_i18n_bucket, String character_set, String usersession) throws NetFileException {
        if (debug.messageEnabled()) {
            debug.message("Mailing files=" + files_to_send);
        }
        HashMap<String, String> m_files_to_send = new HashMap<String, String>();
        try {
            if (from.equals(this.s_empty_string) || to.equals(this.s_empty_string)) {
                throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error41");
            }
            if (files_to_send.equals(this.s_empty_string)) {
                throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "warning9");
            }
            if (directory.trim().equals(" ") || directory == null) {
                directory = this.s_empty_string;
            }
            if (machine_type.equalsIgnoreCase(this.s_empty_string)) {
                throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error1");
            }
            List v_files_to_send = this.parse(files_to_send, "*,");
            if (v_files_to_send.size() > 0) {
                for (int fil_mail = 0; fil_mail < v_files_to_send.size(); ++fil_mail) {
                    String filename = (String)v_files_to_send.get(fil_mail);
                    String result = this.openFile(username, password, machine, domain, machine_type, directory, share, filename, temporary_directory, nfr_user_locale_i18n_bucket, usersession);
                    if (result.startsWith(ERROR)) {
                        String string = result;
                        return string;
                    }
                    m_files_to_send.put(result, filename);
                }
                SendFile sendfil = new SendFile();
                String result = sendfil.sendAttachedFile(to, from, reply, cc, bcc, mail_server, subject, message, m_files_to_send, debug_value, character_set, nfr_user_locale_i18n_bucket, files_to_send);
                debug.message("Number of files in map=" + m_files_to_send.size());
                String string = result;
                return string;
            }
            String string = nfr_user_locale_i18n_bucket.getString("no_files_to_mail");
            return string;
        }
        catch (NetFileException nfe) {
            debug.error("NetFile Exception when mailing file", (Throwable)nfe);
            String string = ERROR + nfe.getMessage(nfr_user_locale_i18n_bucket);
            return string;
        }
        catch (Exception e) {
            debug.error("Error mailing file", (Throwable)e);
            String string = ERROR + nfr_user_locale_i18n_bucket.getString("error4");
            return string;
        }
        finally {
            this.deleteFiles(m_files_to_send);
        }
    }

    private void deleteFiles(Map list_of_files) {
        if (debug.messageEnabled()) {
            debug.message("Deleting temp files");
        }
        Iterator it = list_of_files.keySet().iterator();
        while (it.hasNext()) {
            try {
                Object o_filename = it.next();
                String s_filename = (String)o_filename;
                File delFil = new File(s_filename);
                if (debug.messageEnabled()) {
                    debug.message("Deleting :" + delFil.getAbsolutePath());
                }
                if (!delFil.exists()) continue;
                delFil.delete();
            }
            catch (Exception e) {
                debug.error("Exception deleting file", (Throwable)e);
            }
        }
    }

    String[] searchFile(String username, String password, String machname, String domain, String machtype, String dir, String VMSname, String searchpattern, int maxsearchdir, String tmpdir, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        String newname = this.s_empty_string;
        String[] txt = new String[100];
        try {
            newname = machtype.indexOf(WIN, 0) >= 0 || machtype.indexOf(NT, 0) >= 0 ? VMSname + dir : (machtype.indexOf(NETWARE, 0) >= 0 ? VMSname + "/" + dir : VMSname + "/" + dir);
            if (newname.indexOf("//", 0) >= 0) {
                newname = newname.replace('/', ' ');
            }
            if (debug.messageEnabled()) {
                debug.message("Starting search in directory " + dir + " of VMS " + VMSname + " with pattern " + searchpattern);
            }
            if (machtype.indexOf(WIN, 0) >= 0 || machtype.indexOf(NT, 0) >= 0) {
                XFileInterface srpat = XFileFactory.getInstance().newXFileInstance(this.logMgr, this.s_machine_encoding, this.ssoToken);
                txt = srpat.doSearch(username, password, machname, VMSname, searchpattern, dir, domain, maxsearchdir, nfr_user_locale_i18n_bucket);
            } else if (machtype.indexOf(FTP, 0) >= 0) {
                FtpFile srpat = new FtpFile(this.logMgr, this.s_machine_encoding);
                txt = srpat.ftpDir(username, password, machname, VMSname, searchpattern, dir, maxsearchdir, nfr_user_locale_i18n_bucket);
            } else if (machtype.indexOf(NETWARE, 0) >= 0) {
                NetWareFile srpat = new NetWareFile(this.logMgr, this.s_machine_encoding);
                txt = srpat.ftpDir(username, password, machname, VMSname, searchpattern, dir, maxsearchdir, nfr_user_locale_i18n_bucket);
            } else if (machtype.indexOf(NFS, 0) >= 0) {
                NfsFile nfsFile = new NfsFile(this.logMgr, this.s_machine_encoding);
                txt = nfsFile.search(username, password, machname, VMSname, searchpattern, dir, domain, maxsearchdir, nfr_user_locale_i18n_bucket);
                if (txt.length == 0) {
                    txt = new String[]{"    "};
                }
            } else {
                txt[0] = ERROR + nfr_user_locale_i18n_bucket.getString("error1");
            }
        }
        catch (Exception e) {
            debug.error("Exception searching files", (Throwable)e);
            txt[0] = ERROR + e.getMessage();
        }
        if (debug.messageEnabled()) {
            debug.message("Search completed");
        }
        txt = this.makeSearchResultsPresentable(txt);
        return txt;
    }

    private String[] makeSearchResultsPresentable(String[] sa_results) {
        for (int i = 0; i < sa_results.length; ++i) {
            String s_result = sa_results[i];
            char c_separator = s_result.charAt(0);
            if (c_separator != '\\' && c_separator != '/') continue;
            StringTokenizer st_tokens = new StringTokenizer(s_result, this.s_empty_string + c_separator);
            StringBuffer sb_presentable_result = new StringBuffer();
            sb_presentable_result.append(c_separator);
            int i_num_tokens = st_tokens.countTokens();
            for (int j = 0; j < i_num_tokens - 1; ++j) {
                sb_presentable_result.append(st_tokens.nextToken()).append(c_separator);
            }
            sb_presentable_result.append(st_tokens.nextToken());
            if (s_result.charAt(s_result.length() - 1) == c_separator) {
                sb_presentable_result.append(c_separator);
            }
            sa_results[i] = sb_presentable_result.toString();
        }
        return sa_results;
    }

    String[] createDir(String username, String password, String machinename, String domain, String machtype, String dir, String VMSname, String newDirName, String tmpdir, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        String mkdirres = this.s_empty_string;
        String[] returnmkdirres = new String[100];
        int mk = 0;
        try {
            returnmkdirres[mk] = nfr_user_locale_i18n_bucket.getString("warning52") + newDirName + this.c_eol;
            ++mk;
            if (machtype.indexOf(WIN, 0) >= 0 || machtype.indexOf(NT, 0) >= 0) {
                XFileInterface gpc = XFileFactory.getInstance().newXFileInstance(this.logMgr, this.s_machine_encoding, this.ssoToken);
                return new String[]{gpc.doCreateDirectory(machinename, VMSname, username, password, domain, dir, newDirName, nfr_user_locale_i18n_bucket), this.s_empty_string};
            }
            if (machtype.indexOf(FTP, 0) >= 0 || machtype.indexOf(NETWARE, 0) >= 0) {
                String oldftpdir = VMSname + dir;
                StringBuffer buftxt = new StringBuffer();
                try {
                    String theLine;
                    FullFtpClient fc = new FullFtpClient(machinename, this.s_machine_encoding);
                    fc.login(username, password);
                    fc.cd(oldftpdir);
                    fc.pwd();
                    fc.mkdir(newDirName);
                    fc.setMachineToAccess(machinename);
                    BufferedReader theList = new BufferedReader(new InputStreamReader(fc.list()));
                    while ((theLine = theList.readLine()) != null) {
                        buftxt.append(theLine).append(this.c_eol);
                    }
                    mkdirres = buftxt.toString();
                    theList.close();
                    fc.closeServer();
                }
                catch (IOException ex) {
                    this.exerr = ex.toString();
                }
            } else {
                if (machtype.indexOf(NFS, 0) >= 0) {
                    return new String[]{new NfsFile(this.logMgr, this.s_machine_encoding).mkdir(machinename, VMSname, username, password, dir, newDirName, nfr_user_locale_i18n_bucket), this.s_empty_string};
                }
                this.doError(this.getPlatformLocalisedString("error3"));
                returnmkdirres[mk] = ERROR + nfr_user_locale_i18n_bucket.getString("error3");
            }
            if (this.exerr.indexOf("File exists", 0) >= 0 || this.exerr.indexOf("550", 0) >= 0) {
                this.doError(newDirName + this.getPlatformLocalisedString("error6"));
                returnmkdirres[mk] = ERROR + newDirName + nfr_user_locale_i18n_bucket.getString("error6");
                for (int k = ++mk; k < returnmkdirres.length; ++k) {
                    returnmkdirres[mk] = END_OF_STRING;
                    ++mk;
                }
                return returnmkdirres;
            }
            if (this.exerr.indexOf("LoginException", 0) >= 0 || this.exerr.indexOf("password", 0) >= 0) {
                this.doError(newDirName + this.getPlatformLocalisedString("error6"));
                returnmkdirres[mk] = ERROR + newDirName + nfr_user_locale_i18n_bucket.getString("error6");
                for (int k = ++mk; k < returnmkdirres.length; ++k) {
                    returnmkdirres[mk] = END_OF_STRING;
                    ++mk;
                }
                return returnmkdirres;
            }
            if (this.exerr.indexOf("errsrv", 0) >= 0 || this.exerr.indexOf("fail", 0) >= 0) {
                this.doError(newDirName + this.getPlatformLocalisedString("error6"));
                returnmkdirres[mk] = ERROR + newDirName + nfr_user_locale_i18n_bucket.getString("error6");
                for (int k = ++mk; k < returnmkdirres.length; ++k) {
                    returnmkdirres[mk] = END_OF_STRING;
                    ++mk;
                }
                return returnmkdirres;
            }
            if (this.exerr.indexOf("errdos", 0) >= 0 || this.exerr.indexOf("fail", 0) >= 0) {
                this.doError(newDirName + this.getPlatformLocalisedString("error6"));
                returnmkdirres[mk] = ERROR + newDirName + nfr_user_locale_i18n_bucket.getString("error6");
                for (int k = ++mk; k < returnmkdirres.length; ++k) {
                    returnmkdirres[mk] = END_OF_STRING;
                    ++mk;
                }
                return returnmkdirres;
            }
            if (this.exerr.indexOf("smbclient: not found", 0) >= 0) {
                this.doError(newDirName + this.getPlatformLocalisedString("error35"));
                returnmkdirres[mk] = ERROR + newDirName + nfr_user_locale_i18n_bucket.getString("error35");
                for (int k = ++mk; k < returnmkdirres.length; ++k) {
                    returnmkdirres[mk] = END_OF_STRING;
                    ++mk;
                }
                return returnmkdirres;
            }
            this.doLog(this.getPlatformLocalisedString("func34"));
            for (int k = mk; k < returnmkdirres.length; ++k) {
                returnmkdirres[mk] = END_OF_STRING;
                ++mk;
            }
        }
        catch (Exception e) {
            returnmkdirres[0] = ERROR + e.getMessage();
            debug.error("Error creating directory", (Throwable)e);
        }
        return returnmkdirres;
    }

    private List parse(String string, String delimiter) {
        int i_index_of_delimiter = 0;
        int i_start_index = 0;
        int i_size_of_delimiter = delimiter.length();
        ArrayList<String> v_tokens = new ArrayList<String>();
        if (debug.messageEnabled()) {
            debug.message("Parsing file names ... ");
        }
        while (i_start_index < (i_index_of_delimiter = string.indexOf(delimiter, i_start_index))) {
            String token = string.substring(i_start_index, i_index_of_delimiter);
            v_tokens.add(token);
            i_start_index = i_index_of_delimiter + i_size_of_delimiter;
        }
        if (debug.messageEnabled()) {
            debug.message("Parsing completed. File names are " + ((Object)v_tokens).toString());
        }
        return v_tokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String deleteFile(String username, String password, String machname, String domain, String machtype, String dir_nam, String VMSname, String mainfilenam, String tmpdir, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        CharSequence deletedFiles;
        FtpFile gff;
        FtpFile netware;
        block45: {
            String string;
            block44: {
                String string2;
                block43: {
                    String usernam = username;
                    String passwrd = password;
                    String machnam = machname;
                    String machtyp = machtype;
                    String VMSnam = VMSname;
                    String mainfile_name = mainfilenam;
                    String dir = dir_nam;
                    String tempdir = tmpdir;
                    String domainname = domain;
                    String txt = this.s_empty_string;
                    ArrayList<String> cachechk = new ArrayList<String>();
                    String mainfilename = this.s_empty_string;
                    int indx = 0;
                    boolean intflg = true;
                    String newstr = this.s_empty_string;
                    String oldstr = mainfile_name;
                    XFileInterface gpc = null;
                    netware = null;
                    gff = null;
                    NfsFile gfs = null;
                    try {
                        try {
                            if (mainfile_name.equals(this.s_empty_string)) {
                                this.doError(this.getPlatformLocalisedString("warning9"));
                                string2 = txt = ERROR + nfr_user_locale_i18n_bucket.getString("warning9");
                                Object var36_34 = null;
                                if (gff != null) {
                                    gff.closeFtpFile();
                                    return string2;
                                }
                                if (netware == null) return string2;
                                break block43;
                            }
                            cachechk.clear();
                            while (intflg) {
                                indx = mainfile_name.indexOf("*,", 0);
                                if (indx >= 0) {
                                    newstr = mainfile_name.substring(0, indx);
                                    cachechk.add(newstr);
                                    mainfile_name = oldstr = mainfile_name.substring(indx + 2);
                                    continue;
                                }
                                indx = oldstr.indexOf("*", 0);
                                if (indx >= 0) {
                                    newstr = oldstr.substring(0, indx);
                                    cachechk.add(newstr);
                                }
                                intflg = false;
                            }
                            if (cachechk.size() > 0) {
                                deletedFiles = new StringBuffer();
                                if (machtyp.equalsIgnoreCase(this.s_empty_string)) {
                                    this.doError(this.getPlatformLocalisedString("error1"));
                                    string = ERROR + nfr_user_locale_i18n_bucket.getString("error1");
                                    break block44;
                                }
                                if (machtyp.indexOf(NETWARE, 0) >= 0) {
                                    netware = new NetWareFile(this.logMgr, this.s_machine_encoding);
                                    for (int fil = 0; fil < cachechk.size(); ++fil) {
                                        mainfilename = (String)cachechk.get(fil);
                                        try {
                                            txt = netware.delFTPFile(usernam, passwrd, machnam, VMSnam, mainfilename, dir, nfr_user_locale_i18n_bucket);
                                        }
                                        catch (NetFileException nfe) {
                                            netware.closeFtpFile();
                                            String string3 = this.getReturnText((StringBuffer)deletedFiles, mainfilename, nfe.getMessage(nfr_platform_locale_i18n_bucket), nfr_platform_locale_i18n_bucket);
                                            Object var36_36 = null;
                                            if (gff != null) {
                                                gff.closeFtpFile();
                                                return string3;
                                            }
                                            if (netware == null) return string3;
                                            netware.closeFtpFile();
                                            return string3;
                                        }
                                        ((StringBuffer)deletedFiles).append(mainfilename).append('\n');
                                        String returnTxt = this.checkOutputForError(txt, mainfilename, nfr_user_locale_i18n_bucket);
                                        if (returnTxt == null) continue;
                                        String string4 = returnTxt;
                                        Object var36_37 = null;
                                        if (gff != null) {
                                            gff.closeFtpFile();
                                            return string4;
                                        }
                                        if (netware == null) return string4;
                                        netware.closeFtpFile();
                                        return string4;
                                    }
                                } else if (machtyp.indexOf(WIN, 0) >= 0 || machtyp.indexOf(NT, 0) >= 0) {
                                    gpc = XFileFactory.getInstance().newXFileInstance(this.logMgr, this.s_machine_encoding, this.ssoToken);
                                    for (int fil = 0; fil < cachechk.size(); ++fil) {
                                        mainfilename = (String)cachechk.get(fil);
                                        try {
                                            txt = gpc.doDeleteFile(usernam, passwrd, machnam, VMSnam, mainfilename, dir, domainname, nfr_user_locale_i18n_bucket);
                                        }
                                        catch (NetFileException nfe) {
                                            String string5 = this.getReturnText((StringBuffer)deletedFiles, mainfilename, nfe.getMessage(nfr_platform_locale_i18n_bucket), nfr_platform_locale_i18n_bucket);
                                            Object var36_38 = null;
                                            if (gff != null) {
                                                gff.closeFtpFile();
                                                return string5;
                                            }
                                            if (netware == null) return string5;
                                            netware.closeFtpFile();
                                            return string5;
                                        }
                                        ((StringBuffer)deletedFiles).append(mainfilename).append('\n');
                                        String returnTxt = this.checkOutputForError(txt, mainfilename, nfr_user_locale_i18n_bucket);
                                        if (returnTxt == null) continue;
                                        String string6 = returnTxt;
                                        Object var36_39 = null;
                                        if (gff != null) {
                                            gff.closeFtpFile();
                                            return string6;
                                        }
                                        if (netware == null) return string6;
                                        netware.closeFtpFile();
                                        return string6;
                                    }
                                } else if (machtyp.indexOf(FTP, 0) >= 0) {
                                    gff = new FtpFile(this.logMgr, this.s_machine_encoding);
                                    for (int fil = 0; fil < cachechk.size(); ++fil) {
                                        mainfilename = (String)cachechk.get(fil);
                                        try {
                                            txt = gff.delFTPFile(usernam, passwrd, machnam, VMSnam, mainfilename, dir, nfr_user_locale_i18n_bucket);
                                        }
                                        catch (NetFileException nfe) {
                                            String string7 = this.getReturnText((StringBuffer)deletedFiles, mainfilename, nfe.getMessage(nfr_platform_locale_i18n_bucket), nfr_platform_locale_i18n_bucket);
                                            Object var36_40 = null;
                                            if (gff != null) {
                                                gff.closeFtpFile();
                                                return string7;
                                            }
                                            if (netware == null) return string7;
                                            netware.closeFtpFile();
                                            return string7;
                                        }
                                        ((StringBuffer)deletedFiles).append(mainfilename).append('\n');
                                        String returnTxt = this.checkOutputForError(txt, mainfilename, nfr_user_locale_i18n_bucket);
                                        if (returnTxt == null) continue;
                                        String string8 = returnTxt;
                                        Object var36_41 = null;
                                        if (gff != null) {
                                            gff.closeFtpFile();
                                            return string8;
                                        }
                                        if (netware == null) return string8;
                                        netware.closeFtpFile();
                                        return string8;
                                    }
                                } else if (machtyp.indexOf(NFS, 0) >= 0) {
                                    gfs = new NfsFile(this.logMgr, this.s_machine_encoding);
                                    for (int fil = 0; fil < cachechk.size(); ++fil) {
                                        mainfilename = (String)cachechk.get(fil);
                                        try {
                                            txt = gfs.delNFSFile(usernam, passwrd, VMSnam, machnam, mainfilename, dir, tempdir, nfr_user_locale_i18n_bucket);
                                        }
                                        catch (NetFileException nfe) {
                                            String string9 = this.getReturnText((StringBuffer)deletedFiles, mainfilename, nfe.getMessage(nfr_platform_locale_i18n_bucket), nfr_platform_locale_i18n_bucket);
                                            Object var36_42 = null;
                                            if (gff != null) {
                                                gff.closeFtpFile();
                                                return string9;
                                            }
                                            if (netware == null) return string9;
                                            netware.closeFtpFile();
                                            return string9;
                                        }
                                        ((StringBuffer)deletedFiles).append(mainfilename).append('\n');
                                        String returnTxt = this.checkOutputForError(txt, mainfilename, nfr_user_locale_i18n_bucket);
                                        if (returnTxt == null) continue;
                                        String string10 = returnTxt;
                                        Object var36_43 = null;
                                        if (gff != null) {
                                            gff.closeFtpFile();
                                            return string10;
                                        }
                                        if (netware == null) return string10;
                                        netware.closeFtpFile();
                                        return string10;
                                    }
                                }
                            }
                            deletedFiles = txt;
                            break block45;
                        }
                        catch (Exception e) {
                            debug.error("Problem deleting file", (Throwable)e);
                            String string11 = ERROR + e.getMessage();
                            Object var36_45 = null;
                            if (gff != null) {
                                gff.closeFtpFile();
                                return string11;
                            }
                            if (netware == null) return string11;
                            netware.closeFtpFile();
                            return string11;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var36_46 = null;
                        if (gff != null) {
                            gff.closeFtpFile();
                            throw throwable;
                        }
                        if (netware == null) throw throwable;
                        netware.closeFtpFile();
                        throw throwable;
                    }
                }
                netware.closeFtpFile();
                return string2;
            }
            Object var36_35 = null;
            if (gff != null) {
                gff.closeFtpFile();
                return string;
            }
            if (netware == null) return string;
            netware.closeFtpFile();
            return string;
        }
        Object var36_44 = null;
        if (gff != null) {
            gff.closeFtpFile();
            return deletedFiles;
        }
        if (netware == null) return deletedFiles;
        netware.closeFtpFile();
        return deletedFiles;
    }

    private String getReturnText(StringBuffer deletedFiles, String mainfile, String msg, NetFileResource nfRes) {
        String returnTxt = "";
        if (deletedFiles.length() > 0) {
            returnTxt = nfRes.getString("returnTxt1") + "\n" + deletedFiles.toString() + "\n";
        }
        returnTxt = returnTxt + nfRes.getString("returnTxt2") + "\n" + mainfile + " - " + msg;
        return returnTxt;
    }

    private String checkOutputForError(String txt, String mainfilename, NetFileResource nfRes) {
        String returnStr = null;
        if (txt.indexOf("FileNotFound", 0) >= 0) {
            this.doError(this.getPlatformLocalisedString("error2"));
            returnStr = "ERROR: " + nfRes.getString("error2") + ": " + mainfilename;
        } else if (txt.indexOf("ERROR", 0) >= 0) {
            this.doError(this.getPlatformLocalisedString("error37"));
            returnStr = "ERROR: " + nfRes.getString("error37") + ": " + mainfilename;
        }
        return returnStr;
    }

    void doError(String msg) {
        if (this.logMgr == null) {
            return;
        }
        this.logMgr.doError(s_platform_locale_error + msg);
    }

    void doLog(String msg) {
        if (this.logMgr == null) {
            return;
        }
        this.logMgr.doLog(msg);
    }

    String[] grepPlatinfo() {
        NetFileContextImpl nfContext = new NetFileContextImpl(this.getSSOToken());
        Map[] prefs = nfContext.getPreferences();
        NetFileAttributeExtractor nfAttrs = new NetFileAttributeExtractor(prefs[0]);
        this.pathinfo[0] = nfAttrs.getString("sunPortalNetFileWINSServer", this.s_empty_string);
        this.pathinfo[1] = nfAttrs.getString("sunPortalNetFileMimetypesConfigFileLocation", this.s_empty_string);
        if (debug.messageEnabled()) {
            debug.message("Name resolution server and mime-types file location are " + this.pathinfo[0] + this.c_eol + this.pathinfo[1]);
        }
        return this.pathinfo;
    }

    public void downloadFolder(PrintWriter out, String[] parameters, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException, Exception {
        if (out == null) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "null_writer_to_applet_error");
        }
        if (parameters == null) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "null_parameters_error");
        }
        if (nfr_user_locale_i18n_bucket == null) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "null_localistaion_bucket_error");
        }
        if (parameters.length != 10) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "missing_parameters_error");
        }
        String[] files = this.getFilesInDirectory(parameters, nfr_user_locale_i18n_bucket);
        if (files.length < 1) {
            throw new NetFileException("empty directory");
        }
        for (int i = 0; i < files.length; ++i) {
            String file_name = files[i];
            out.println(file_name);
            out.flush();
        }
        out.println();
        out.flush();
    }

    private String[] getFilesInDirectory(String[] parameters, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException, Exception {
        String[] listing = this.expandDir(parameters[0], parameters[1], parameters[4], parameters[6], parameters[5], parameters[3], parameters[2], parameters[7], nfr_user_locale_i18n_bucket);
        if (listing == null) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unable_to_get_listing_error");
        }
        if (listing.length == 0) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "empty_directory");
        }
        if (listing[0] == null) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "empty_directory");
        }
        if (listing[0].startsWith(ERROR)) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + listing[0].substring(ERROR.length() + 1, listing[0].length()));
        }
        if (listing.length % 4 != 0) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "The array size is not multiple of 4");
        }
        return listing;
    }

    public void rename(String username, String password, String machine, String type, String domain, String share, String directory, String old_file_name, String new_file_name, String s_machine_encoding, NetFileResource nfRes) throws NetFileException {
        if (type.equals(WIN) || type.equals(NT)) {
            XFileInterface gpc = XFileFactory.getInstance().newXFileInstance(this.logMgr, s_machine_encoding, this.ssoToken);
            gpc.doRenameFile(username, password, machine, domain, share, directory, old_file_name, new_file_name, nfRes);
        } else if (type.equals(FTP) || type.equals(NETWARE)) {
            FtpFile ftpFile = new FtpFile(this.logMgr, s_machine_encoding);
            ftpFile.rename(username, password, machine, share, directory, old_file_name, new_file_name);
        } else if (type.equals(NFS)) {
            new NfsFile(this.logMgr, s_machine_encoding).rename(username, password, machine, share, directory, old_file_name, new_file_name);
        } else {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "invalid_machine_type_error");
        }
    }

    String doesFileExist(String username, String password, String machine, String type, String domain, String share, String directory, String file_name, String temporary_directory, NetFileResource nfr_user_locale_i18n_bucket) throws Exception, NetFileException {
        String[] sa_file_listing = new String[]{};
        try {
            sa_file_listing = this.expandDir(username, password, machine, domain, type, directory, share, temporary_directory, nfr_user_locale_i18n_bucket);
            if (debug.messageEnabled()) {
                debug.message("File listing obtained :" + sa_file_listing.length);
            }
        }
        catch (Exception e) {
            debug.error("Exception in getting the listing", (Throwable)e);
        }
        for (int i_file_name_pointer = 1; i_file_name_pointer < sa_file_listing.length; i_file_name_pointer += 4) {
            if (!file_name.equals(sa_file_listing[i_file_name_pointer])) continue;
            return "YES";
        }
        return "NO";
    }

    static {
        debug = null;
    }
}

