/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet.java1;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOToken;
import com.sun.portal.netfile.servlet.java1.CheckPort;
import com.sun.portal.netfile.servlet.java1.NetFileAttributeExtractor;
import com.sun.portal.netfile.servlet.java1.NetFileContext;
import com.sun.portal.netfile.servlet.java1.NetFileException;
import com.sun.portal.netfile.servlet.java1.NetFileHostDenialProcessor;
import com.sun.portal.netfile.servlet.java1.NetFileLogManager;
import com.sun.portal.netfile.servlet.java1.NetFileResource;
import com.sun.portal.netfile.servlet.java1.NetWareFile;
import com.sun.portal.netfile.servlet.java1.XFileFactory;
import com.sun.portal.netfile.servlet.java1.XFileInterface;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class AddSystemProcessor {
    Debug debug = null;
    String winsIPAddress = null;
    String[] wrnt = null;
    NetFileLogManager logMgr = null;
    NetFileContext nfContext = null;
    NetFileHostDenialProcessor nfDenyProc = null;
    NetFileResource nfRes = null;
    NetFileAttributeExtractor nfAttrs = null;
    InetAddress machhost = null;
    String type = "";
    String machpack = "";
    String machinename = "";
    String szCharSet = "";
    String szDefaultDomain = "";
    String machdomain = "";
    String machinetyp = "";
    SSOToken ssoToken = null;
    String userName = "";
    String password = "";
    String errMsg = "";

    public AddSystemProcessor(NetFileLogManager log, NetFileContext context, NetFileResource res) {
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
        this.logMgr = log;
        this.nfContext = context;
        this.nfRes = res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSystem(HashMap nfReqData, StringBuffer responseBuffer) throws NetFileException {
        this.ssoToken = (SSOToken)nfReqData.get("SSOToken");
        this.userName = (String)nfReqData.get("UserID");
        this.password = (String)nfReqData.get("Pwd");
        this.machinename = (String)nfReqData.get("SystemName");
        this.machdomain = (String)nfReqData.get("NTDomName");
        this.machinetyp = (String)nfReqData.get("SysType");
        this.szCharSet = (String)nfReqData.get("CharSet");
        if (this.debug.messageEnabled()) {
            this.debug.message("Add System " + this.machinename + "\nDomain name is " + this.machdomain + "\nRequest to add system of type " + this.machinetyp + "\nChar Set to be used is " + this.szCharSet);
        }
        this.loadPreferences();
        this.winsIPAddress = this.getWinsIPAddress();
        this.szDefaultDomain = this.getDefaultDomain();
        try {
            this.detemineHostInetAddress();
        }
        catch (Exception uhe) {
            this.errMsg = this.nfRes.getString("ash.1", new Object[]{this.machinename});
            this.doLog(this.nfRes.getString("ashLog.1", new Object[]{this.errMsg, this.userName}));
            this.debug.error(uhe.getMessage());
            responseBuffer.append("ERROR: " + this.errMsg).append('\n');
            return;
        }
        try {
            if (this.isLocalHost(this.machhost)) {
                this.errMsg = this.nfRes.getString("ash.2");
                this.doLog(this.nfRes.getString("ashLog.1", new Object[]{this.errMsg, this.userName}));
                responseBuffer.append("ERROR: " + this.errMsg).append('\n');
                return;
            }
        }
        catch (NetFileException nfe) {
            this.errMsg = this.nfRes.getString("ash.3");
            this.doLog(this.nfRes.getString("ashLog.1", new Object[]{this.errMsg, this.userName}));
            this.debug.error(nfe.getMessage());
            responseBuffer.append("ERROR: " + this.errMsg).append('\n');
            return;
        }
        try {
            ArrayList list;
            List obj = this.nfAttrs.getStringList("sunPortalNetFileDeniedHostList");
            if (obj != null && this.isDeniedHost(list = (ArrayList)obj)) {
                this.errMsg = this.nfRes.getString("ash.4", new Object[]{this.machinename});
                this.doLog(this.nfRes.getString("ashLog.1", new Object[]{this.errMsg, this.userName}));
                responseBuffer.append("ERROR: " + this.errMsg).append('\n');
                return;
            }
        }
        catch (NetFileException nfe) {
            this.errMsg = this.nfRes.getString("ash.5", new Object[]{this.machinename});
            this.doLog(this.nfRes.getString("ashLog.1", new Object[]{this.errMsg, this.userName}));
            this.debug.error(nfe.getMessage());
            responseBuffer.append("ERROR: " + this.errMsg).append('\n');
            return;
        }
        try {
            ArrayList list;
            ArrayList allowList;
            List objAllowHosts = this.nfAttrs.getStringList("sunPortalNetFileAllowedHostList");
            List obj = this.nfAttrs.getStringList("sunPortalNetFileDeniedHostList");
            if (obj != null && objAllowHosts != null && !this.isAllowedHost(allowList = (ArrayList)objAllowHosts, list = (ArrayList)obj, this.machinename.trim())) {
                if (this.debug.messageEnabled()) {
                    this.debug.message(this.machinename + " is not an allowed host ");
                }
                this.errMsg = this.nfRes.getString("ash.13", new Object[]{this.machinename});
                this.doLog(this.nfRes.getString("ashLog.1", new Object[]{this.errMsg, this.userName}));
                responseBuffer.append("ERROR: " + this.errMsg).append('\n');
                return;
            }
        }
        catch (NetFileException nfe) {
            if (nfe.getErrorCode() == 11) {
                this.errMsg = this.nfRes.getString("ash.1", new Object[]{this.machinename});
                responseBuffer.append("ERROR: " + this.errMsg).append('\n');
            } else {
                this.errMsg = this.nfRes.getString("ash.12", new Object[]{this.machinename});
                responseBuffer.append("ERROR: " + this.errMsg).append('\n');
            }
            this.doLog(this.nfRes.getString("ashLog.1", new Object[]{this.errMsg, this.userName}));
            this.debug.error(nfe.getMessage());
            return;
        }
        try {
            if (this.isHostAlreadyAdded((ArrayList)nfReqData.get("UserAddedHosts"))) {
                if (this.debug.messageEnabled()) {
                    this.debug.message(this.machinename + " has already been added ");
                }
                this.errMsg = this.nfRes.getString("ash.6", new Object[]{this.machinename});
                this.doLog(this.nfRes.getString("ashLog.1", new Object[]{this.errMsg, this.userName}));
                responseBuffer.append("ERROR: " + this.errMsg).append('\n');
                return;
            }
        }
        catch (NetFileException nfe) {
            this.errMsg = this.nfRes.getString("ash.7", new Object[]{this.machinename});
            this.doLog(this.nfRes.getString("ashLog.1", new Object[]{this.errMsg, this.userName}));
            this.debug.error(nfe.getMessage());
            responseBuffer.append("ERROR: " + this.errMsg).append('\n');
            return;
        }
        CheckPort chkPort = new CheckPort();
        try {
            if (this.machinetyp.equalsIgnoreCase("AUTODETECT")) {
                this.type = this.determineHostType(chkPort);
            } else if (this.machinetyp.equalsIgnoreCase("NFS")) {
                if (this.isNFSHost(chkPort)) {
                    this.type = "?NFS";
                }
            } else if (this.machinetyp.equalsIgnoreCase("WIN")) {
                if (this.isWinHost(chkPort)) {
                    this.type = '?' + this.wrnt[0] + '\n' + this.wrnt[1];
                }
            } else if (this.machinetyp.equalsIgnoreCase("FTP")) {
                if (this.isFTPHost(chkPort)) {
                    this.type = "?FTP";
                }
            } else if (this.machinetyp.equalsIgnoreCase("NETWARE") && this.isNetwareFTPHost(chkPort)) {
                this.type = "?NETWARE";
            }
        }
        catch (NetFileException nfe) {
            if (nfe.getMessage() != null) {
                if (nfe.getErrorCode() == 2) {
                    this.errMsg = this.nfRes.getString("ash.8", new Object[]{this.machdomain});
                    this.doLog(this.nfRes.getString("ashLog.1", new Object[]{this.errMsg, this.userName}));
                    responseBuffer.append("ERROR: " + this.errMsg).append('\n');
                } else if (nfe.getErrorCode() == 4) {
                    this.errMsg = this.nfRes.getString("ash.11", new Object[]{this.machinename});
                    this.doLog(this.nfRes.getString("ashLog.1", new Object[]{this.errMsg, this.userName}));
                    responseBuffer.append("ERROR: " + this.errMsg).append('\n');
                } else if (nfe.getErrorCode() == 9) {
                    this.errMsg = this.nfRes.getString("ash.14", new Object[]{this.machinename, this.machdomain});
                    this.doLog(this.nfRes.getString("ashLog.1", new Object[]{this.errMsg, this.userName}));
                    responseBuffer.append("ERROR: " + this.errMsg).append('\n');
                } else {
                    this.errMsg = this.nfRes.getString("ash.9", new Object[]{this.machinename});
                    this.doLog(this.nfRes.getString("ashLog.1", new Object[]{this.errMsg, this.userName}));
                    responseBuffer.append("ERROR: " + this.errMsg).append('\n');
                }
            } else {
                this.errMsg = this.nfRes.getString("ash.9", new Object[]{this.machinename});
                this.doLog(this.nfRes.getString("ashLog.1", new Object[]{this.errMsg, this.userName}));
                responseBuffer.append("ERROR: " + this.errMsg).append('\n');
            }
            this.debug.error(nfe.getMessage());
            return;
        }
        finally {
            chkPort = null;
        }
        if (this.type == null || this.type.trim().length() == 0) {
            this.errMsg = this.nfRes.getString("ash.10", new Object[]{this.machinename});
            this.doLog(this.nfRes.getString("ashLog.1", new Object[]{this.errMsg, this.userName}));
            responseBuffer.append("ERROR: " + this.errMsg).append('\n');
            return;
        }
        this.doLog(this.nfRes.getString("ashLog.2", new Object[]{this.machinename, this.type, this.userName}));
        responseBuffer.append(this.type).append('\n');
    }

    void detemineHostInetAddress() throws UnknownHostException {
        try {
            if (this.machinename == null || this.machinename.trim().length() == 0) {
                throw new UnknownHostException("null");
            }
            this.machhost = InetAddress.getByName(this.machinename);
            this.machpack = this.machhost.toString();
        }
        catch (UnknownHostException ue) {
            this.debug.error("Unknown host", (Throwable)ue);
            throw ue;
        }
    }

    boolean isLocalHost(InetAddress hostname) throws NetFileException {
        Object[] rphost_ip = null;
        rphost_ip = this.getLocalHostAddrs();
        int machip = this.machpack.indexOf("/", 0);
        String newip = this.machpack.substring(machip + 1);
        if (rphost_ip == null || rphost_ip.length < 1) {
            throw new NetFileException();
        }
        for (int k = 0; k < rphost_ip.length; ++k) {
            if (!((String)rphost_ip[k]).trim().equals(newip.trim())) continue;
            return true;
        }
        return false;
    }

    boolean isAllowedHost(ArrayList allowedHosts, ArrayList deniedHosts, String hostName) throws NetFileException {
        String szHostName;
        String szFQHostName;
        if (this.nfDenyProc == null) {
            this.nfDenyProc = new NetFileHostDenialProcessor();
        }
        if ((szFQHostName = this.nfDenyProc.getFQHostName(szHostName = hostName, this.szDefaultDomain)) == null) {
            throw new NetFileException(11, "");
        }
        InetAddress[] hostAddresses = null;
        try {
            hostAddresses = InetAddress.getAllByName(szFQHostName);
        }
        catch (UnknownHostException uhe) {
            try {
                szFQHostName = szHostName;
                hostAddresses = InetAddress.getAllByName(szFQHostName);
            }
            catch (UnknownHostException uhe1) {
                throw new NetFileException(11, "");
            }
        }
        try {
            return this.nfDenyProc.isHostAllowed(allowedHosts, deniedHosts, szFQHostName, hostAddresses, true);
        }
        catch (Exception e) {
            this.debug.error("Exception in determining if " + hostAddresses.toString() + " is allowed", (Throwable)e);
            return false;
        }
    }

    boolean isDeniedHost(ArrayList aList) throws NetFileException {
        InetAddress[] ia_denied_hosts;
        if (this.nfDenyProc == null) {
            this.nfDenyProc = new NetFileHostDenialProcessor();
        }
        if ((ia_denied_hosts = this.nfDenyProc.getDeniedHostsAddresses(aList)) == null || ia_denied_hosts.length < 1) {
            return false;
        }
        try {
            if (this.nfDenyProc.isHostDenied(this.machinename, ia_denied_hosts)) {
                if (this.debug.messageEnabled()) {
                    this.debug.message(this.machinename + " is a denied host ");
                }
                return true;
            }
        }
        catch (Exception e) {
            this.debug.error("Exception in finding denied host for " + this.machinename, (Throwable)e);
            throw new NetFileException();
        }
        return false;
    }

    boolean isHostAlreadyAdded(ArrayList alist) throws NetFileException {
        InetAddress[] ia_names = null;
        try {
            if (alist == null || alist.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            ia_names = this.nfDenyProc.getDeniedHostsAddresses(alist);
            for (int i = 0; i < ia_names.length; ++i) {
                if (!ia_names[i].equals(this.machhost)) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            this.debug.error("Exception in getting verifying if " + this.machinename + " is an already added host", (Throwable)e);
            throw new NetFileException();
        }
        finally {
            ia_names = null;
        }
        return false;
    }

    String determineHostType(CheckPort chkPort) throws NetFileException {
        String hostDetectOrder = this.nfAttrs.getString("sunPortalNetFileHostDetectOrder", "");
        StringTokenizer stok = new StringTokenizer(hostDetectOrder, "\n");
        String hostType = "";
        String detectedType = "";
        while (stok.hasMoreTokens()) {
            hostType = stok.nextToken();
            detectedType = this.determineHostType(chkPort, hostType);
            if (detectedType.equals("")) continue;
            return detectedType;
        }
        return "";
    }

    String determineHostType(CheckPort chkPort, String type) throws NetFileException {
        if (type.equalsIgnoreCase("WIN")) {
            if (this.isWinHost(chkPort)) {
                return '?' + this.wrnt[0] + '\n' + this.wrnt[1];
            }
        } else if (type.equalsIgnoreCase("FTP")) {
            if (this.isFTPHost(chkPort)) {
                if (this.isNetwareFTPHost(chkPort)) {
                    return "?NETWARE";
                }
                return "?FTP";
            }
        } else if (type.equalsIgnoreCase("NFS")) {
            if (this.isNFSHost(chkPort)) {
                return "?NFS";
            }
        } else if (type.equalsIgnoreCase("NETWARE") && this.isNetwareFTPHost(chkPort)) {
            return "?NETWARE";
        }
        return "";
    }

    boolean isWinHost(CheckPort chkPort) throws NetFileException {
        int winstat = chkPort.checkTcpPort(this.machinename, 139);
        if (winstat == 1) {
            XFileInterface winFileInterface = null;
            try {
                winFileInterface = XFileFactory.getInstance().newXFileInstance(this.logMgr, this.szCharSet, this.ssoToken);
            }
            catch (NetFileException nfe) {
                this.debug.error("Error in determining if host is Win type", (Throwable)nfe);
                if (nfe.getErrorCode() == 5) {
                    nfe.setErrorCode(4);
                }
                throw nfe;
            }
            try {
                this.wrnt = winFileInterface.verifyHostType(this.machdomain, this.machinename, this.userName, this.password);
            }
            catch (NetFileException nfe) {
                throw nfe;
            }
            catch (Exception e) {
                throw new NetFileException();
            }
            this.debug.message(this.machinename + " is of type " + this.wrnt[0]);
            if (this.wrnt == null || this.wrnt.length < 1) {
                throw new NetFileException();
            }
            return true;
        }
        if (winstat == -1) {
            throw new NetFileException();
        }
        return false;
    }

    boolean isFTPHost(CheckPort chkPort) throws NetFileException {
        int ftpstat = chkPort.checkTcpPort(this.machinename, 21);
        if (ftpstat == 1) {
            return true;
        }
        if (ftpstat == -1) {
            throw new NetFileException();
        }
        return false;
    }

    boolean isNFSHost(CheckPort chkPort) throws NetFileException {
        int nfsstat = chkPort.checkTcpPort(this.machinename, 2049);
        if (nfsstat == 1) {
            return true;
        }
        if (nfsstat == -1) {
            throw new NetFileException();
        }
        return false;
    }

    boolean isNetwareFTPHost(CheckPort chkPort) throws NetFileException {
        int ftpstat = chkPort.checkTcpPort(this.machinename, 21);
        if (ftpstat == 1) {
            NetWareFile nff = new NetWareFile(this.logMgr, this.szCharSet);
            boolean isNetWare = nff.getFTPType(this.machinename);
            return isNetWare;
        }
        if (ftpstat == -1) {
            return false;
        }
        return false;
    }

    Object[] getLocalHostAddrs() {
        String hostip;
        int j;
        boolean isWin = System.getProperty("os.name").toLowerCase().indexOf("window") != -1;
        boolean isLinux = System.getProperty("os.name").toLowerCase().indexOf("linux") != -1;
        ArrayList<String> rpHostIP = new ArrayList<String>();
        String configparam = "";
        try {
            int c;
            Runtime rt = Runtime.getRuntime();
            StringBuffer buftxt = new StringBuffer(80);
            String[] progarr = new String[2];
            if (isWin) {
                progarr[0] = "ipconfig";
                progarr[1] = "-all";
            } else {
                progarr[0] = "/sbin/ifconfig";
                progarr[1] = "-a";
            }
            Process shellconn = rt.exec(progarr);
            InputStream shellout = shellconn.getInputStream();
            while ((c = shellout.read()) > -1) {
                char chtxt = (char)c;
                buftxt.append(chtxt);
            }
            rt = null;
            shellout.close();
            shellout = null;
            shellconn.destroy();
            shellconn = null;
            configparam = buftxt.toString();
        }
        catch (IOException ex) {
            this.debug.error("IOException in getLocalHostAddrs: ", (Throwable)ex);
            rpHostIP.add("Failed Execution: " + ex);
            Object rt = null;
            return rpHostIP.toArray();
        }
        if (configparam.equals("")) {
            this.debug.message("Cannot get local machine hostname.");
            rpHostIP.add("Cannot get local machine hostname.");
            return rpHostIP.toArray();
        }
        StringTokenizer pars = new StringTokenizer(configparam, "\n");
        int parscnt = pars.countTokens();
        if (isWin) {
            int ipaddrindx = 0;
            int icolonindx = 0;
            for (j = 0; j < parscnt; ++j) {
                hostip = pars.nextToken();
                ipaddrindx = hostip.indexOf("IP Address", 0);
                icolonindx = hostip.indexOf(":", 0);
                if (ipaddrindx < 0 || icolonindx < 0) continue;
                rpHostIP.add(hostip.substring(icolonindx + 2).trim());
            }
            rpHostIP.add("127.0.0.1");
        } else {
            int inetindx = 0;
            int inetmaskindx = 0;
            for (j = 0; j < parscnt; ++j) {
                hostip = pars.nextToken();
                if (isLinux) {
                    inetindx = hostip.indexOf("inet addr:", 0);
                    inetmaskindx = hostip.indexOf(" ", inetindx + 10);
                    if (inetindx < 0 || inetmaskindx < 0) continue;
                    rpHostIP.add(hostip.substring(inetindx + 10, inetmaskindx));
                    continue;
                }
                inetindx = hostip.indexOf("inet", 0);
                inetmaskindx = hostip.indexOf("netmask", 0);
                if (inetindx < 0 || inetmaskindx < 0) continue;
                rpHostIP.add(hostip.substring(inetindx + 5, inetmaskindx));
            }
        }
        return rpHostIP.toArray();
    }

    private void loadPreferences() {
        Map[] prefs = this.nfContext.getPreferences();
        this.nfAttrs = new NetFileAttributeExtractor(prefs[0]);
    }

    private String getWinsIPAddress() {
        return this.nfAttrs.getString("sunPortalNetFileWINSServer", "");
    }

    private String getDefaultDomain() {
        return this.nfAttrs.getString("sunPortalNetFileDefaultDomain", "");
    }

    private void doLog(String msg) {
        if (this.logMgr == null) {
            return;
        }
        this.logMgr.doLog(msg);
    }
}

