/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.sun.portal.cli.cert.JSSUtil;
import com.sun.portal.cli.cert.Password;
import com.sun.portal.cli.cert.SRADecoderException;
import com.sun.portal.rproxy.cert.CertAdminPasswordCallback;
import com.sun.portal.util.GWDebug;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.util.PasswordCallback;

public class GWNSSInit {
    public static String nickname = "server-cert";
    public static final int[] cipherSuites128BitSSL2 = new int[]{65287, 65283, 65281};
    public static final int[] cipherSuites128BitSSL3 = new int[]{10, 4, 5, 30, 65279};
    public static final int[] cipherSuites40BitSSL2 = new int[]{65284, 65282};
    public static final int[] cipherSuites40BitSSL3 = new int[]{3, 6};
    public static final int[] cipherSuitesOthersSSL2 = new int[]{65286};
    public static final int[] cipherSuitesOthersSSL3 = new int[]{9, 29, 65278};
    public static final int[] cipherSuitesSSL3Null = new int[]{1, 28};
    public static final int[] cipherSuites128BitTLS = new int[0];
    public static final int[] cipherSuitesOthersTLS = new int[]{98, 100};
    private static final int[] cipherSuitesNotSupported = new int[]{102};

    public static void enableAllCiphers() {
        GWNSSInit.enableCipher(cipherSuites40BitSSL2);
        GWNSSInit.enableCipher(cipherSuites40BitSSL3);
        GWNSSInit.enableCipher(cipherSuitesOthersSSL2);
        GWNSSInit.enableCipher(cipherSuitesOthersSSL3);
        GWNSSInit.enableCipher(cipherSuites128BitSSL2);
        GWNSSInit.enableCipher(cipherSuites128BitSSL3);
        GWNSSInit.enableCipher(cipherSuitesOthersTLS);
        GWNSSInit.enableCipher(cipherSuites128BitTLS);
        GWNSSInit.enableCipher(cipherSuitesSSL3Null);
    }

    public static void disableAllCiphers() {
        GWNSSInit.disableCipher(cipherSuites40BitSSL2);
        GWNSSInit.disableCipher(cipherSuites40BitSSL3);
        GWNSSInit.disableCipher(cipherSuitesOthersSSL2);
        GWNSSInit.disableCipher(cipherSuitesOthersSSL3);
        GWNSSInit.disableCipher(cipherSuites128BitSSL2);
        GWNSSInit.disableCipher(cipherSuites128BitSSL3);
        GWNSSInit.disableCipher(cipherSuitesOthersTLS);
        GWNSSInit.disableCipher(cipherSuites128BitTLS);
        GWNSSInit.disableCipher(cipherSuitesSSL3Null);
    }

    public static void enableCipher(int[] cipherSuites) {
        GWNSSInit.setCipherState(cipherSuites, true);
    }

    public static void disableCipher(int[] cipherSuites) {
        GWNSSInit.setCipherState(cipherSuites, false);
    }

    private static void setCipherState(int[] cipherSuites, boolean state) {
        for (int j = 0; j < cipherSuites.length; ++j) {
            SSLSocket.setCipherPreference((int)cipherSuites[j], (boolean)state);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static boolean initialize() {
        String jssPassword;
        BufferedReader br;
        InputStreamReader isr;
        FileInputStream fis;
        String certdbDir;
        block20: {
            certdbDir = System.getProperty("gateway.keybase", System.getProperty("SRAP_CONFIG_DIR", "/etc/opt/SUNWps"));
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("GWNSSInit: certdbDir = " + certdbDir);
            }
            try {
                JSSUtil.setDefaultDecoder((String)certdbDir);
            }
            catch (SRADecoderException ex) {
                GWDebug.debug.error("GWNSSInit: Unable to initialize the password encryption module : " + ex.getMessage());
            }
            String nicknamefile = System.getProperty("gateway.nickname", System.getProperty("SRAP_CONFIG_DIR", "/etc/opt/SUNWps") + File.separatorChar + "cert" + File.separatorChar + ".nickname");
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("GWNSSInit: nicknamefile = " + nicknamefile);
            }
            if (nicknamefile != null) {
                try {
                    fis = new FileInputStream(nicknamefile);
                    isr = new InputStreamReader(fis);
                    br = new BufferedReader(isr);
                    nickname = br.readLine();
                }
                catch (Exception ex) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("GWNSSInit: Unable to read jss nickname from file " + nicknamefile);
                    }
                    break block20;
                }
            }
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("GWNSSInit: Unable to get nickname file name");
            }
        }
        String pwfile = System.getProperty("gateway.pass", System.getProperty("SRAP_CONFIG_DIR", "/etc/opt/SUNWps") + File.separatorChar + "cert" + File.separatorChar + ".jsspass");
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("GWNSSInit: pwfile = " + pwfile);
        }
        if (pwfile == null) {
            if (!GWDebug.debug.errorEnabled()) return false;
            GWDebug.debug.error("GWNSSInit: Unable to get password file name");
            return false;
        }
        try {
            fis = new FileInputStream(pwfile);
            isr = new InputStreamReader(fis);
            br = new BufferedReader(isr);
            jssPassword = br.readLine();
            Password pass = JSSUtil.decryptPassword((String)jssPassword);
            jssPassword = pass.getPassword();
            if (pass.isEncrypted() && GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("GWNSSInit: Found encrypted password");
            }
        }
        catch (Exception ex) {
            if (!GWDebug.debug.errorEnabled()) return false;
            GWDebug.debug.error("GWNSSInit: Unable to read jss password from file " + pwfile);
            return false;
        }
        try {
            CryptoManager.InitializationValues vals = new CryptoManager.InitializationValues(certdbDir);
            CryptoManager.initialize((CryptoManager.InitializationValues)vals);
            CryptoManager.getInstance().setPasswordCallback((PasswordCallback)new CertAdminPasswordCallback(jssPassword));
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("GWNSSInit: NSSInit initialization done successfully");
            }
        }
        catch (KeyDatabaseException kdbe) {
            if (!GWDebug.debug.errorEnabled()) return false;
            GWDebug.debug.error("GWNSSInit: Couldn't open the key database." + (Object)((Object)kdbe));
            return false;
        }
        catch (CertDatabaseException cdbe) {
            if (!GWDebug.debug.errorEnabled()) return false;
            GWDebug.debug.error("GWNSSInit: Couldn't open the certificate database." + (Object)((Object)cdbe));
            return false;
        }
        catch (AlreadyInitializedException aie) {
            if (!GWDebug.debug.warningEnabled()) return true;
            GWDebug.debug.warning("GWNSSInit: CryptoManager already initialized." + (Object)((Object)aie));
            return true;
        }
        catch (Exception e) {
            if (!GWDebug.debug.errorEnabled()) return false;
            GWDebug.debug.error("GWNSSInit: Exception occurred: " + e.getMessage());
            return false;
        }
        GWNSSInit.disableCipher(cipherSuitesNotSupported);
        GWNSSInit.enableAllCiphers();
        return true;
    }
}

