/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriter.util.http;

import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.xml.Tag;
import com.sun.portal.rewriter.util.xml.TagParser;
import com.sun.portal.rproxy.rewriter.util.http.CharsetDetector;
import com.sun.portal.rproxy.rewriter.util.http.ContentInfo;
import com.sun.portal.rproxy.rewriter.util.http.HTTPData;
import java.io.IOException;

public final class MIMEAndEncodingParser {
    private static final String CONTENT_TYPE_PATTERN = "Content-type:";
    private static final String CONTENT_PATTERN = "Content";
    private static final String CHARSET_PATTERN = "charset";
    private static final String CHARSET_EQUALS_PATTERN = "charset=";
    private static boolean charsetDetectionEnabled = false;

    private static String parseMIME(String aContentType, String aContentTypeLowerCase) {
        int i = aContentTypeLowerCase.indexOf(59);
        if (i == -1) {
            return StringHelper.trimQuotes((String)aContentType);
        }
        return StringHelper.trimQuotes((String)aContentType.substring(0, i));
    }

    private static final String parseEncoding(String aContentType, String aContentTypeLowerCase) {
        String lEncoding = null;
        int start = aContentTypeLowerCase.indexOf(CHARSET_EQUALS_PATTERN);
        if (start != -1) {
            int end = aContentTypeLowerCase.indexOf(59, start);
            if (end == -1) {
                end = aContentTypeLowerCase.length();
            }
            if (end - start > CHARSET_EQUALS_PATTERN.length()) {
                lEncoding = aContentType.substring(start + CHARSET_EQUALS_PATTERN.length(), end);
            }
        }
        return MIMEAndEncodingParser.validateEncoding(lEncoding);
    }

    private static String validateEncoding(String aPrabableEncoding) {
        if (aPrabableEncoding == null) {
            return null;
        }
        if (aPrabableEncoding.length() > 0) {
            char ch;
            aPrabableEncoding = StringHelper.trimQuotes((String)aPrabableEncoding);
            int endCE = -1;
            while (++endCE < aPrabableEncoding.length() && (Character.isLetterOrDigit(ch = aPrabableEncoding.charAt(endCE)) || ch == '-' || ch == '_')) {
            }
            if (endCE > 0 && endCE <= aPrabableEncoding.length()) {
                return aPrabableEncoding.substring(0, endCE);
            }
        }
        return null;
    }

    private static void parseMIMEAndEncoding(ContentInfo aContentTypeInfo, String aContentType) {
        String lContentType = StringHelper.trimQuotes((String)aContentType);
        String lContentTypeLowerCase = lContentType.toLowerCase();
        aContentTypeInfo.setMIME(MIMEAndEncodingParser.parseMIME(lContentType, lContentTypeLowerCase));
        aContentTypeInfo.setEncoding(MIMEAndEncodingParser.parseEncoding(lContentType, lContentTypeLowerCase));
    }

    public static final ContentInfo parse(HTTPData aHTTPData) throws IOException {
        int bCharsetStartIndex;
        int bMetaTagEndIndex;
        int bMetaTagStartIndex;
        MIMEAndEncodingParser.parseHeadder(aHTTPData);
        if (!MIMEAndEncodingParser.isNeeds2ScanBody(aHTTPData)) {
            return aHTTPData.getContentInfo();
        }
        String lContent = aHTTPData.getRawEncodedString();
        String lContentLowerCase = aHTTPData.getRawEncodedStringLowerCase();
        int cursorIndex = 0;
        while ((bMetaTagStartIndex = lContentLowerCase.indexOf("<meta", cursorIndex)) != -1 && (bMetaTagEndIndex = lContentLowerCase.indexOf(">", bMetaTagStartIndex)) != -1 && (bCharsetStartIndex = lContentLowerCase.indexOf(CHARSET_EQUALS_PATTERN, bMetaTagStartIndex)) != -1) {
            if (bMetaTagEndIndex < bCharsetStartIndex) {
                cursorIndex = bMetaTagEndIndex;
                continue;
            }
            String bMetaTag = lContent.substring(bMetaTagStartIndex, bMetaTagEndIndex - 1);
            Tag bTag = TagParser.parse((String)bMetaTag);
            String bContentValue = bTag.get(CONTENT_PATTERN);
            MIMEAndEncodingParser.parseMIMEAndEncoding(aHTTPData.getContentInfo(), bContentValue);
            if (!aHTTPData.getContentInfo().isInvalidEncoding()) break;
            aHTTPData.getContentInfo().setEncoding(MIMEAndEncodingParser.validateEncoding(bTag.get(CHARSET_PATTERN)));
            break;
        }
        if (aHTTPData.getContentInfo().isInvalidEncoding() && charsetDetectionEnabled) {
            CharsetDetector cdet = new CharsetDetector();
            String aEncoding = cdet.detectCharset(aHTTPData);
            aHTTPData.getContentInfo().setEncoding(aEncoding);
        }
        return aHTTPData.getContentInfo();
    }

    public static void parseHeadder(HTTPData aHTTPData) {
        String headder = aHTTPData.getContentType();
        if (headder != null && headder.length() > 0) {
            int index = headder.indexOf(CONTENT_TYPE_PATTERN);
            String bContentType = index == -1 ? headder : headder.substring(index + CONTENT_TYPE_PATTERN.length());
            MIMEAndEncodingParser.parseMIMEAndEncoding(aHTTPData.getContentInfo(), bContentType);
        }
    }

    private static boolean isNeeds2ScanBody(HTTPData aHTTPData) throws IOException {
        ContentInfo lContentInfo = aHTTPData.getContentInfo();
        if (lContentInfo.isInvalidMIME() || lContentInfo.isInvalidEncoding() && (lContentInfo.getMIME().equalsIgnoreCase("text/html") || lContentInfo.getMIME().equalsIgnoreCase("text/htm"))) {
            return aHTTPData.getContentBytes() != null && aHTTPData.getContentBytes().length != 0;
        }
        return false;
    }

    static {
        try {
            Class.forName("org.mozilla.intl.chardet.nsDetector");
            charsetDetectionEnabled = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

