/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.rproxy.connectionhandler.HTTPRequest;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.rproxy.connectionhandler.Session;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.ServiceIdentifier;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;

public class HTTPSession
extends Session {
    private static final int MAXREQHEADSIZE = 2048;
    private BufferedInputStream in;

    public HTTPSession(Socket s) {
        block2: {
            super(s);
            this.in = null;
            try {
                this.in = new BufferedInputStream(this._theSocket.getInputStream());
            }
            catch (IOException ex) {
                if (!GWDebug.debug.errorEnabled()) break block2;
                GWDebug.debug.error("Unable to get socket's Inputstream !", ex);
            }
        }
    }

    public HTTPSession(Socket s, String str) {
        super(s, str);
        this.in = null;
        try {
            this.in = new BufferedInputStream(this._theSocket.getInputStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public HTTPSession(Socket s, String str, String protocol, int port) {
        this(s, str);
        this._gwprotocol = protocol;
        doingPDC = srapGateway_certificateEnabledList_lc.contains(rphost.toLowerCase()) && ServiceIdentifier.isGateway() && this._gwprotocol.equals("https");
        this.port = port;
        this._gwport = Integer.toString(port);
    }

    public Request getRequest() {
        HTTPRequest req;
        block23: {
            req = null;
            try {
                this.in.mark(2048);
                boolean keepGoing = true;
                StringBuffer sb = new StringBuffer();
                req = new HTTPRequest(this._gwprotocol, this.port);
                int totalRead = 0;
                while (keepGoing) {
                    int b = this.in.read();
                    if (b == -1) {
                        keepGoing = false;
                        throw new EOFException();
                    }
                    ++totalRead;
                    sb.append((char)b);
                    if (sb.length() <= 1 || sb.charAt(sb.length() - 2) != '\r' || sb.charAt(sb.length() - 1) != '\n') continue;
                    req.addHeaderLine(sb.toString());
                    keepGoing = !req.isHeaderComplete();
                    sb.setLength(0);
                }
                _numBytesRead += totalRead;
                req.addSize(totalRead);
                req.setContentStream(this.in);
                boolean keepAlivePresent = false;
                if (processKeepAliveConnections) {
                    String keepAliveHeader = req.getRequestHeader("Connection");
                    if (keepAliveHeader != null) {
                        if (!(keepAliveHeader = keepAliveHeader.substring(keepAliveHeader.indexOf(58) + 1).trim().toLowerCase()).equals("close")) {
                            keepAlivePresent = true;
                        }
                    } else if (this.this_req > 0) {
                        keepAlivePresent = true;
                    }
                }
                if (!processKeepAliveConnections || !keepAlivePresent && req.getHTTPVersion().toUpperCase().compareTo("HTTP/1.1") < 0) {
                    this._moreElements = false;
                }
            }
            catch (EOFException ex) {
                block22: {
                    if (!this.thisreqKeepAlive) {
                        this._moreElements = false;
                        if (GWDebug.debug.warningEnabled()) {
                            GWDebug.debug.warning("HTTPSession[" + this._theSocket + "]: EOF when reading request");
                        }
                    } else {
                        try {
                            this._theSocket.setSoTimeout(this.readTimeout);
                            this.in = new BufferedInputStream(this._theSocket.getInputStream());
                        }
                        catch (IOException ioex) {
                            if (!GWDebug.debug.errorEnabled()) break block22;
                            GWDebug.debug.error("EOFException in HTTPSession while reading request header", ioex);
                        }
                    }
                }
                req = null;
            }
            catch (InterruptedIOException ex) {
                this._moreElements = false;
                if (GWDebug.debug.warningEnabled()) {
                    GWDebug.debug.warning("HTTPSession[" + this._theSocket + "]: Interrupted when reading request");
                }
                req = null;
            }
            catch (IOException ex1) {
                try {
                    this.in.reset();
                    if (GWDebug.debug.warningEnabled()) {
                        GWDebug.debug.warning("HTTPSession[" + this._theSocket + "]: IOException when reading request");
                    }
                    req = null;
                }
                catch (Exception exception) {}
            }
            catch (Throwable t) {
                if (!GWDebug.debug.messageEnabled()) break block23;
                GWDebug.debug.message("Error in HTTPSession::getRequest(): ", t);
            }
        }
        return req;
    }
}

