/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.netlet.econnection.ReaderWriter;
import com.sun.portal.netlet.econnection.ReaderWriterDecrypt;
import com.sun.portal.netlet.econnection.ReaderWriterEncrypt;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import com.sun.portal.netlet.eproxy.SConn;
import com.sun.portal.netlet.eproxy.SessionAuthenticator;
import com.sun.portal.netlet.eproxy.SessionRequest;
import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.configservlet.client.NetletProfile;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWThreadPool;
import com.sun.portal.util.NetletLogMgr;
import java.net.Socket;

public class RWGroupCrypt
extends ReaderWriterLock {
    public boolean done;
    private int srcPort;
    private String destPort;
    private String destHost;
    private Socket fromClient;
    private Socket toServer;
    private ReaderWriterDecrypt src_to_dst;
    private ReaderWriterEncrypt dst_to_src;
    private SessionAuthenticator sessionAuth;
    private SessionRequest sessionReq;
    private Integer netletLogId;
    private long startTime;
    private boolean stopLogged;

    public RWGroupCrypt(Socket in, int sport, String dport, String dhost, SessionAuthenticator sa, SessionRequest rq) {
        block14: {
            this.done = false;
            this.stopLogged = false;
            this.fromClient = in;
            this.srcPort = sport;
            this.destPort = new String(dport);
            this.destHost = new String(dhost);
            this.sessionAuth = sa;
            this.sessionReq = rq;
            this.toServer = SConn.connect(this.destPort, this.destHost);
            if (this.toServer == null) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("RWGroupCrypt: unable to make server connection!");
                }
                this.cleanup();
                return;
            }
            try {
                this.toServer.setKeepAlive(true);
                this.fromClient.setKeepAlive(true);
            }
            catch (Exception ex) {
                GWDebug.debug.error("RWGroupCrypt: failed to set KeepAlive for socket", ex);
            }
            if (NetletLogMgr.loggingEnabled) {
                try {
                    this.netletLogId = new Integer(NetletLogMgr.getLogId());
                    NetletLogMgr.write("Netlet", GWLocale.getPFString("en1", new Object[]{this.netletLogId, new String(NetletLogMgr.getUserId(this.sessionReq.getSessionID())), "START", this.fromClient.getInetAddress().toString(), new Integer(this.srcPort), this.toServer.getInetAddress().toString(), new Integer(this.toServer.getPort())}));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.getNetletKeepAliveInterval(rq) > 0) {
                try {
                    this.toServer.setSoTimeout(this.getNetletKeepAliveInterval(rq) * 60000);
                }
                catch (Exception se) {
                    System.out.println("Unable to set socket time out.." + se);
                }
            }
            try {
                this.src_to_dst = new ReaderWriterDecrypt(this, this.fromClient.getInputStream(), this.toServer.getOutputStream());
                this.dst_to_src = new ReaderWriterEncrypt(this, this.toServer.getInputStream(), this.fromClient.getOutputStream(), this.getNetletKeepAliveInterval(rq));
            }
            catch (Exception ex) {
                GWDebug.debug.error("RWGroupCrypt: Unable to create reader writers.", ex);
            }
            try {
                GWThreadPool.run(this.src_to_dst);
                GWThreadPool.run(this.dst_to_src);
            }
            catch (InterruptedException e) {
                if (!GWDebug.debug.errorEnabled()) break block14;
                GWDebug.debug.error("Could not start ReaderWriterClear tasks", e);
            }
        }
        this.startTime = System.currentTimeMillis();
    }

    public synchronized void notifyFinished(ReaderWriter obj) {
        if (!this.stopLogged && NetletLogMgr.loggingEnabled) {
            try {
                this.netletLogId = new Integer(NetletLogMgr.getLogId());
                NetletLogMgr.write("Netlet", GWLocale.getPFString("en1", new Object[]{this.netletLogId, new String(NetletLogMgr.getUserId(this.sessionReq.getSessionID())), new String("STOP"), this.fromClient.getInetAddress().toString(), new Integer(this.srcPort), this.toServer.getInetAddress().toString(), new Integer(this.toServer.getPort())}));
                this.stopLogged = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (obj == this.src_to_dst) {
            if (this.dst_to_src != null) {
                this.dst_to_src.stop();
            }
        } else if (obj == this.dst_to_src && this.src_to_dst != null) {
            this.src_to_dst.stop();
        }
        this.cleanup();
    }

    public synchronized void stopAll() {
        if (!this.done) {
            if (this.dst_to_src != null) {
                this.dst_to_src.stop();
            }
            if (this.src_to_dst != null) {
                this.src_to_dst.stop();
            }
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        try {
            if (this.fromClient != null) {
                try {
                    this.fromClient.close();
                    if (PerfContextObject.ENABLE_PERF) {
                        SocketCount.decrementPlainSockets();
                    }
                }
                catch (Exception e) {
                }
                finally {
                    this.fromClient = null;
                }
            }
            if (this.toServer != null) {
                try {
                    this.toServer.close();
                    if (PerfContextObject.ENABLE_PERF) {
                        SocketCount.decrementPlainSockets();
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    this.toServer = null;
                }
            }
            Object var5_5 = null;
            this.src_to_dst = null;
            this.dst_to_src = null;
            this.done = true;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.src_to_dst = null;
            this.dst_to_src = null;
            this.done = true;
            throw throwable;
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public long getLastActivityTime() {
        if (this.src_to_dst.getLastActivityTime() > this.dst_to_src.getLastActivityTime()) {
            return this.src_to_dst.getLastActivityTime();
        }
        return this.dst_to_src.getLastActivityTime();
    }

    private int getNetletKeepAliveInterval(SessionRequest rq) {
        try {
            String sid = rq.getSessionID();
            NetletProfile profile = new NetletProfile(sid);
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("RWGroupCrypt: Netlet keep alive interval -> " + NetletProfile.getInt("KeepAliveInterval", 0));
            }
            return NetletProfile.getInt("KeepAliveInterval", 0);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getAppletSrcPort() {
        return this.srcPort;
    }
}

