/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.mail;

import com.sun.ssoadapter.config.Configuration;
import com.sun.ssoadapter.config.ConfigurationFactory;
import java.util.Vector;
import javax.mail.Flags;
import javax.mail.search.AndTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.HeaderTerm;
import javax.mail.search.NotTerm;
import javax.mail.search.OrTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SubjectTerm;
import javax.servlet.http.HttpServletRequest;

public class ViewBean {
    private String name = null;
    private int index = -1;
    private String[] ruleNames = null;
    private boolean applyAll = false;
    private SearchTerm searchRules = null;

    protected ViewBean(String name, int idx) {
        this.name = name;
        this.index = idx;
    }

    ViewBean(Configuration view, ConfigurationFactory rules, HttpServletRequest request, int idx) throws Exception {
        this.name = view.getConfigurationName();
        this.index = idx;
        Boolean applyAll = new Boolean(view.getProperty("applyAll"));
        this.applyAll = applyAll;
        this.ruleNames = view.getPropertyArray("ruleName");
        this.searchRules = this.parseRules(rules, request);
    }

    ViewBean(SearchTerm term) throws Exception {
        this.searchRules = term;
    }

    public ViewBean() {
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public SearchTerm getRules() {
        return this.searchRules;
    }

    private SearchTerm parseRules(ConfigurationFactory allRules, HttpServletRequest request) throws Exception {
        Vector<SearchTerm> terms = new Vector<SearchTerm>();
        Configuration conf = null;
        for (int i = 0; i < this.ruleNames.length; ++i) {
            String ruleName = this.ruleNames[i];
            conf = allRules.readConfiguration(ruleName, false, request);
            String target = conf.getProperty("target");
            String operator = conf.getProperty("op");
            String string = conf.getProperty("ruleValue");
            terms.add(this.MakeRule(target.toLowerCase(), operator, string));
        }
        Object finalTerm = (SearchTerm)terms.firstElement();
        if (terms.size() > 1) {
            SearchTerm[] t = new SearchTerm[terms.size()];
            terms.toArray(t);
            finalTerm = this.applyAll ? new AndTerm(t) : new OrTerm(t);
        }
        Flags flags = new Flags(Flags.Flag.DELETED);
        return new AndTerm(finalTerm, (SearchTerm)new FlagTerm(flags, false));
    }

    private SearchTerm MakeRule(String target, String operator, String value) {
        SubjectTerm term = null;
        if (target.equals("subject")) {
            term = new SubjectTerm(value);
        } else if (target.equals("sender")) {
            term = new HeaderTerm("From", value);
        } else if (target.equals("date")) {
            term = new HeaderTerm("Date", value);
        } else if (target.equals("priority")) {
            term = new HeaderTerm("Priority", value);
        } else if (target.equals("to")) {
            term = new HeaderTerm("To", value);
        } else if (target.equals("cc")) {
            term = new HeaderTerm("Cc", value);
        } else if (target.equals("flag")) {
            boolean flag = false;
            if (operator.equals("is")) {
                flag = true;
            }
            Flags flags = new Flags(Flags.Flag.DELETED);
            if (value.equals("read")) {
                flags = new Flags(Flags.Flag.SEEN);
            } else if (value.equals("recent")) {
                flags = new Flags(Flags.Flag.RECENT);
            }
            return new FlagTerm(flags, flag);
        }
        if (operator.equals("contains")) {
            return term;
        }
        return new NotTerm((SearchTerm)term);
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("ViewBean[name=\"");
        strbuf.append(this.name);
        strbuf.append("\", index=\"" + this.index);
        strbuf.append("\", applyAll=\"");
        strbuf.append(this.applyAll);
        strbuf.append("\", ruleNames=[");
        for (int i = 0; i < this.ruleNames.length; ++i) {
            if (i > 0) {
                strbuf.append(",");
            }
            strbuf.append(this.ruleNames[i]);
        }
        strbuf.append("]]");
        return strbuf.toString();
    }
}

