/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.servlet;

import com.iplanet.am.util.AMClientDetector;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.netlet.econnection.Base64;
import com.sun.portal.netlet.servlet.Rules;
import com.sun.portal.netlet.util.NetletConstants;
import com.sun.portal.netlet.util.UrlDecoder;
import com.sun.portal.netlet.util.UserAttributes;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NetletConfig
extends HttpServlet
implements SSOTokenListener,
NetletConstants {
    private static final String sccsID = "@(#)NetletConfig.java\t1.37 01/07/16 Sun Microsystems, Inc.";
    private Debug debug = null;
    private String serverName = null;
    private String serverPort = null;
    private String serverProtocol = null;
    private String serverDomain = null;
    private boolean logCreated = false;
    private Hashtable sessionHash = new Hashtable();
    private Hashtable clientPorts = new Hashtable();
    private final int STATUS_LOADING = 1;
    private final int STATUS_LOADED = 2;
    private final int STATUS_NOT_LOADED = 3;
    private final int STATUS_UNLOADED = 4;
    private SecureRandom sRandom = null;

    public NetletConfig() {
        this.debug = Debug.getInstance((String)"srapNetlet");
        try {
            this.sRandom = SecureRandom.getInstance("SHA1PRNG");
            byte[] seed = this.sRandom.generateSeed(32);
            this.sRandom.setSeed(seed);
        }
        catch (NoSuchAlgorithmException ne) {
            this.sRandom = new SecureRandom();
        }
    }

    private String getCommand(HttpServletRequest req) {
        String command = req.getParameter("func");
        try {
            String queryString = req.getQueryString();
            int funcStartIndex = queryString.indexOf("func=");
            if (funcStartIndex == -1) {
                return UrlDecoder.decode(command);
            }
            int funcEndIndex = (queryString = queryString.substring(funcStartIndex + 5)).indexOf("&");
            queryString = funcEndIndex == -1 ? queryString : queryString.substring(0, funcEndIndex);
            return UrlDecoder.decode(queryString);
        }
        catch (Exception ex) {
            this.debug.error("NetletConfig: Exception in getting the command -> " + ex);
            return UrlDecoder.decode(command);
        }
    }

    private boolean isNetletAvailable(NetletUser user) {
        String token;
        HttpServletRequest req = user.getReq();
        HttpServletResponse res = user.getRes();
        String psNetletHeader = req.getHeader("PS-Netlet");
        if (psNetletHeader == null) {
            this.debug.error("Netlet can not be accessed in open portal mode.");
            this.redirectToPage(res, "noGateway", null, user.getLocale(), user.getHTMLcharsetname());
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(psNetletHeader, ";");
        if (tokenizer.hasMoreTokens() && !"enabled=true".equals(token = tokenizer.nextToken().trim())) {
            this.debug.error("Gateway does not allow Netlet connections.");
            this.redirectToPage(res, "netletDisabled", null, user.getLocale(), user.getHTMLcharsetname());
            return false;
        }
        return true;
    }

    private void doGetPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException, FileNotFoundException {
        String command;
        if (this.serverName == null || this.serverPort == null || this.serverProtocol == null) {
            this.serverName = req.getServerName();
            if (this.serverName != null && this.serverName.trim().length() != 0 && this.serverName.indexOf(".") != -1) {
                this.serverDomain = this.serverName.substring(this.serverName.indexOf(".") + 1);
            }
            this.serverProtocol = req.getScheme();
            int sPort = req.getServerPort();
            this.serverPort = "" + sPort;
        }
        if ((command = this.getCommand(req)) == null || command.trim().length() == 0) {
            this.debug.error("Error no function specified");
            return;
        }
        NetletUser nu = null;
        String sid = null;
        try {
            nu = new NetletUser(req);
            nu.setRes(res);
            sid = new String(nu.getSSOTokenID().toString());
            if (!SSOTokenManager.getInstance().isValidToken(nu.getSSOToken())) {
                this.debug.error("Invalid SSOToken");
                this.redirectToPage(res, "invalidsession", null, null, null);
                return;
            }
            if (!this.isNetletAvailable(nu)) {
                return;
            }
            if (!nu.isAllowed()) {
                this.redirectToPage(res, "noprivilege", null, nu.getLocale(), nu.getHTMLcharsetname());
                return;
            }
            if (this.debug.messageEnabled()) {
                this.debug.message("Command -> " + command);
            }
            if (command.equals("makepage") || command.equals("load")) {
                if (this.getStatus(sid) == 2) {
                    this.debug.message("Netlet already loaded for " + nu.getClientID());
                    res.setStatus(204);
                    return;
                }
                this.setStatus(sid, 1);
                this.makeNetletPage(nu);
            } else if (command.equals("makeNetletFrame")) {
                nu.getUserAttributes();
                this.printRules(nu);
                this.makeNetletFrame(nu);
            } else if (command.equals("makeInfoFrame")) {
                this.makeInfoFrame(nu);
            } else if (command.equals("makeDetectFrame")) {
                this.makeDetectNetletFrame(nu);
            } else if (command.equals("setLoaded")) {
                this.setStatus(sid, 2);
                res.setStatus(200);
                this.readClientPorts(nu);
            } else if (command.equals("setLoading")) {
                this.setStatus(sid, 1);
                res.setStatus(200);
            } else if (command.equals("isLoaded")) {
                if (this.getStatus(sid) == 2 || this.getStatus(sid) == 1) {
                    res.setStatus(200);
                } else {
                    res.setStatus(204);
                }
            } else if (command.equals("unload")) {
                this.setStatus(sid, 4);
                res.sendRedirect(nu.getDefaultRedirectURL());
                this.removeClientPort(nu.getSSOTokenID().toString());
            } else if (command.equals("loadResources")) {
                this.setStatus(sid, 1);
                this.outputResources(nu);
            } else if (command.equals("parsePacFile")) {
                this.parsePacFile(nu);
            } else if (command.equals("storeProxySettings")) {
                this.storeProxySettings(nu);
            } else if (command.equals("doReauth")) {
                this.doReauth(nu);
            } else {
                if (this.getStatus(sid) == 4) {
                    this.makeErrorMsg(nu, "nc2");
                    return;
                }
                if (this.getStatus(sid) != 2) {
                    this.makeLoadingPage(nu, req);
                    return;
                }
                nu.getUserAttributes();
                this.printRules(nu);
                if (!this.openDynamic(nu, command)) {
                    this.debug.error("Error processsing dynamic rule for " + command);
                }
            }
        }
        catch (SSOException ssoe) {
            this.debug.error("Error in NetletConfig - doGetPost() ", (Throwable)ssoe);
            this.redirectToPage(res, "invalidsession", null, null, null);
            return;
        }
        catch (MissingResourceException ex) {
            this.debug.error("Error in NetletConfig - doGetPost() ", (Throwable)ex);
            return;
        }
    }

    private void addClientPort(String sessId, Hashtable cps) {
        this.clientPorts.put(sessId, cps);
    }

    private void removeClientPort(String sessId) {
        this.clientPorts.remove(sessId);
    }

    private void readClientPorts(NetletUser nu) {
        HttpServletRequest req = nu.getReq();
        String cps = req.getParameter("clientPorts");
        String contentType = req.getContentType();
        if (contentType != null && contentType.indexOf("multipart/form-data") != -1) {
            cps = this.extractParameter(req, "clientPorts");
        }
        this.addClientPort(nu.getSSOTokenID().toString(), this.unformatClientPorts(cps));
        this.debug.message("Client ports for " + nu.getClientID() + " : " + this.clientPorts);
    }

    private Hashtable unformatClientPorts(String str) {
        Hashtable clientPorts = new Hashtable();
        StringTokenizer rules = new StringTokenizer(str, "|");
        while (rules.hasMoreTokens()) {
            String rule = rules.nextToken().trim();
            Vector<String> v = new Vector<String>();
            StringTokenizer nameAndPorts = new StringTokenizer(rule, "->");
            String ruleName = nameAndPorts.nextToken().trim();
            String portList = nameAndPorts.nextToken().trim();
            StringTokenizer ports = new StringTokenizer(portList, ",");
            while (ports.hasMoreTokens()) {
                String port = ports.nextToken();
                v.addElement(port);
            }
            clientPorts.put(ruleName, v);
        }
        return clientPorts;
    }

    private String getClientPort(String sessId, String ruleName, String clientPortInRule) {
        String clientPort = null;
        Hashtable nameAndPort = (Hashtable)this.clientPorts.get(sessId);
        Vector ports = (Vector)nameAndPort.get(ruleName);
        Enumeration enumeration = ports.elements();
        while (enumeration.hasMoreElements()) {
            String elem = (String)enumeration.nextElement();
            StringTokenizer st = new StringTokenizer(elem, ":");
            String cPort = null;
            if (!st.hasMoreElements() || !(cPort = (String)st.nextElement()).equals(clientPortInRule) || !st.hasMoreElements()) continue;
            clientPort = (String)st.nextElement();
            break;
        }
        this.debug.message("Rule name -> " + ruleName + ", Administrator configured client port -> " + clientPortInRule + ", Actual client port -> " + clientPort);
        return clientPort;
    }

    private void addLoopbackRule(NetletUser u) {
        Rules lb = new Rules();
        lb.name = "loopback";
        lb.url = "";
        lb.lport = new Vector();
        lb.lport.add(new String("" + u.getDefaultLBPort()));
        lb.dport = new Vector();
        lb.dport.add(this.serverPort);
        lb.dhost = new Vector();
        lb.dhost.add(this.serverName);
        u.addRule(lb);
    }

    void makeLoadingPage(NetletUser user, HttpServletRequest req) throws IOException {
        HttpServletResponse res = user.getRes();
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), user.getHTMLcharsetname())));
        res.setContentType("text/html; charset=" + user.getHTMLcharsetname());
        res.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        res.setHeader("Pragma", "no-cache");
        StringBuffer url = new StringBuffer();
        url.append(this.getDynamicUrl() + req.getServletPath()).append("?").append(req.getQueryString());
        StringBuffer outBuf = new StringBuffer();
        outBuf.append("<html>\n");
        outBuf.append("<head>\n");
        outBuf.append("<script language=javascript>\n");
        outBuf.append("\tfunction doRedirect() {\n");
        outBuf.append("\t\twindow.location='" + url.toString() + "';\n");
        outBuf.append("\t}\n");
        outBuf.append("</script>\n");
        if (user.terminateAtLogout()) {
            outBuf.append(user.getBundle().getString("addToDetachedWindows"));
            outBuf.append("\n");
        }
        outBuf.append("<title>");
        outBuf.append(user.getBundle().getString("ntitle2"));
        outBuf.append("</title></head>\n");
        outBuf.append("<BODY TEXT=\"" + user.getBundle().getString("ntxcolor") + "\" BGCOLOR=\"" + user.getBundle().getString("nbgcolor") + "\"");
        if (user.terminateAtLogout()) {
            outBuf.append(" onLoad=addToDetachedWindows()");
        }
        outBuf.append(">\n");
        outBuf.append("<p>" + user.getBundle().getString("nc3") + "\n");
        outBuf.append("<form>\n");
        outBuf.append("<input type=button name=continue value='" + user.getBundle().getString("contButton") + "'" + " onClick='doRedirect()'" + ">\n");
        outBuf.append("</form>\n");
        outBuf.append("</body></html>\n");
        out.print(outBuf.toString());
        out.close();
    }

    void makeErrorMsg(NetletUser user, String key) throws IOException {
        HttpServletResponse res = user.getRes();
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), user.getHTMLcharsetname())));
        res.setContentType("text/html; charset=" + user.getHTMLcharsetname());
        res.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        res.setHeader("Pragma", "no-cache");
        out.print("<html>\n");
        out.print("<head><title>");
        out.print(user.getBundle().getString("ntitle"));
        if (user.terminateAtLogout()) {
            out.print(user.getBundle().getString("addToDetachedWindows"));
            out.print("\n");
        }
        out.print("</title></head>\n");
        out.print("<BODY TEXT=\"" + user.getBundle().getString("ntxcolor") + "\" BGCOLOR=\"" + user.getBundle().getString("nbgcolor") + "\"");
        if (user.terminateAtLogout()) {
            out.print(" onLoad=addToDetachedWindows()");
        }
        out.print(">\n");
        out.print("<p>" + user.getBundle().getString(key) + "</body></html>\n");
        out.close();
    }

    void makeNetletPage(NetletUser user) throws ServletException, IOException {
        StringBuffer outBuffer = new StringBuffer();
        HttpServletResponse res = user.getRes();
        String url = user.getReq().getServletPath();
        url = this.getDynamicUrl() + url;
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), user.getHTMLcharsetname())));
        res.setContentType("text/html; charset=" + user.getHTMLcharsetname());
        res.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        res.setHeader("Pragma", "no-cache");
        outBuffer.append("<html>\n");
        outBuffer.append("<head><title>");
        outBuffer.append(user.getBundle().getString("ntitle"));
        outBuffer.append("</title></head>\n");
        Object[] values = new Object[]{"info", url + "?func=makeInfoFrame", "netlet", url + "?func=makeDetectFrame"};
        String frameset = user.getBundle().getString("frameset");
        MessageFormat format = new MessageFormat("");
        format.applyPattern(frameset);
        outBuffer.append(format.format(values).toString());
        outBuffer.append("</html>\n");
        out.print(outBuffer.toString());
        out.close();
    }

    void makeNetletFrame(NetletUser user) throws ServletException, IOException {
        StringBuffer outBuffer = new StringBuffer();
        HttpServletResponse res = user.getRes();
        HttpServletRequest req = user.getReq();
        String encryptionType = user.getEncryptionType();
        this.debug.message("Netlet encryption type -> " + encryptionType);
        boolean isNetletSSL = false;
        if ("SSL".equals(encryptionType)) {
            isNetletSSL = true;
        }
        boolean sendJSSEJar = false;
        String JSSEQueryString = req.getParameter("JSSE");
        if (JSSEQueryString == null) {
            sendJSSEJar = false;
        } else {
            sendJSSEJar = true;
            isNetletSSL = false;
        }
        boolean isPDCEnabled = false;
        String PDCHeader = req.getHeader("PS-GW-PDC");
        if (PDCHeader != null) {
            isPDCEnabled = Boolean.getBoolean(PDCHeader);
        }
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), user.getHTMLcharsetname())));
        res.setContentType("text/html; charset=" + user.getHTMLcharsetname());
        res.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        res.setHeader("Pragma", "no-cache");
        outBuffer.append("<html>\n");
        outBuffer.append("<head><title>");
        outBuffer.append(user.getBundle().getString("ntitle"));
        outBuffer.append("</title></head>\n");
        outBuffer.append("\t<script language=javascript>\n");
        outBuffer.append("\t\tvar needToSleep = true;\n");
        outBuffer.append("\t</script>\n");
        outBuffer.append("</head>\n");
        outBuffer.append("<BODY TEXT=\"").append(user.getBundle().getString("ntxcolor"));
        outBuffer.append("\" BGCOLOR=\"").append(user.getBundle().getString("nbgcolor")).append("\">\n");
        if (isNetletSSL) {
            outBuffer.append("<p><applet name=\"netapp\" codebase=\"").append(this.getStaticUrl()).append("/netlet\" archive=\"netlet.jar, kssl.jar\" code=\"SServer.class\" width=1 height=1 MAYSCRIPT>\n");
        } else if (sendJSSEJar) {
            outBuffer.append("<p><applet name=\"netapp\" codebase=\"").append(this.getStaticUrl()).append("/netlet\" archive=\"netlet.jar, netletjsse.jar\" code=\"SServer.class\" width=1 height=1 MAYSCRIPT>\n");
        } else {
            outBuffer.append("<p><applet name=\"netapp\" codebase=\"").append(this.getStaticUrl()).append("/netlet\" archive=\"netlet.jar\" code=\"SServer.class\" width=1 height=1 MAYSCRIPT>\n");
        }
        if (isNetletSSL) {
            outBuffer.append("<param name=\"cabbase\" value=\"netlet.cab, kssl.cab\">\n");
        } else if (sendJSSEJar) {
            outBuffer.append("<param name=\"cabbase\" value=\"netlet.cab, netletjsse.cab\">\n");
        } else {
            outBuffer.append("<param name=\"cabbase\" value=\"netlet.cab\">\n");
        }
        outBuffer.append("<param name=\"cookiename\" value=\"" + SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro") + "\">\n");
        outBuffer.append("<param name=\"configURL\" value=\"").append(this.getDynamicUrl()).append("/NetletConfig\">\n");
        outBuffer.append("<param name=\"resourcesURL\" value=\"").append(this.getDynamicUrl()).append("/NetletConfig?func=loadResources\">\n");
        outBuffer.append("<param name=\"gwURL\" value=\"").append(req.getHeader("ps-gw-url")).append("\">\n");
        outBuffer.append("<param name=\"clientBindIP\" value=\"").append(user.getClientBindIP()).append("\">\n");
        int count = 0;
        this.addLoopbackRule(user);
        Enumeration e = user.getRules();
        while (e.hasMoreElements()) {
            Rules r = (Rules)e.nextElement();
            if (!user.inPrivilegeList("sunPortalNetletDenyRules", r.name, false, false) && user.inPrivilegeList("sunPortalNetletAccessRules", r.name, false, false)) {
                for (int i = 0; i < r.lport.size(); ++i) {
                    outBuffer.append("<param name=ruleName_" + count + " value=" + r.name + ">\n");
                    outBuffer.append("<param name=listenPort_" + count + " value=" + (String)r.lport.elementAt(i) + ">\n");
                    outBuffer.append("<param name=serverPort_" + count + " value=" + (String)r.dport.elementAt(i) + ">\n");
                    outBuffer.append("<param name=serverHost_" + count + " value=" + (String)r.dhost.elementAt(i) + ">\n");
                    outBuffer.append("<param name=cipher_" + count + " value=" + user.getAlgorithm(r) + ">\n");
                    ++count;
                }
                continue;
            }
            if (!this.debug.messageEnabled()) continue;
            this.debug.message("Access Denied For Client ID: " + user.getClientID() + " and Rule: " + r.name);
        }
        outBuffer.append("<param name=sessionId value=" + user.getSSOTokenID().toString() + ">\n");
        outBuffer.append("<param name=encryptionType value=" + encryptionType + ">\n");
        outBuffer.append("<param name=numParms value=" + count + ">\n");
        outBuffer.append("<param name=doPortWarning value=" + user.getPortWarn() + ">\n");
        outBuffer.append("<param name=doReauth value=" + user.getReauth() + ">\n");
        outBuffer.append("<param name=showPortWarnCheckbox value=" + user.getPortWarnCheckbox() + ">\n");
        outBuffer.append("<param name=defaultCipher value=" + user.getDefaultCipher() + ">\n");
        outBuffer.append("<param name=proxytype value=" + user.getNetletUserAttributes().getString("sunPortalNetletProxyType", "") + ">\n");
        outBuffer.append("<param name=proxyhost value=" + user.getNetletUserAttributes().getString("sunPortalNetletProxyHost", "") + ">\n");
        outBuffer.append("<param name=proxyport value=" + user.getNetletUserAttributes().getString("sunPortalNetletProxyPort", "") + ">\n");
        outBuffer.append("<param name=proxyoverride value=" + user.getNetletUserAttributes().getString("sunPortalNetletProxyOverride", "") + ">\n");
        if (sendJSSEJar) {
            outBuffer.append("<param name=isJSSEEnabled value=true>\n");
        }
        if (isPDCEnabled) {
            outBuffer.append("<param name=isPDCEnabled value=true>\n");
        }
        outBuffer.append("</applet>\n");
        outBuffer.append("</body>\n");
        outBuffer.append("</html>\n");
        out.print(outBuffer.toString());
        out.close();
    }

    void makeInfoFrame(NetletUser user) throws ServletException, IOException {
        StringBuffer outBuffer = new StringBuffer();
        HttpServletResponse res = user.getRes();
        HttpServletRequest req = user.getReq();
        String stat = req.getParameter("stat");
        if (stat == null || stat.equals("")) {
            stat = "nc4";
        }
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), user.getHTMLcharsetname())));
        res.setContentType("text/html; charset=" + user.getHTMLcharsetname());
        res.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        res.setHeader("Pragma", "no-cache");
        outBuffer.append("<html>\n");
        outBuffer.append("<head>\n");
        outBuffer.append(user.getBundle().getString("showClientPorts")).append("\n");
        if (user.terminateAtLogout()) {
            outBuffer.append(user.getBundle().getString("closeNetletWindow"));
            outBuffer.append("\n");
        }
        outBuffer.append("</head>\n");
        outBuffer.append("<BODY TEXT=\"").append(user.getBundle().getString("ntxcolor")).append("\"");
        if (user.terminateAtLogout()) {
            outBuffer.append(" onLoad=\"").append(user.getBundle().getString("addNetletWindow")).append("\"").append(" onUnload=\"").append(user.getBundle().getString("removeNetletWindow")).append("\"");
        }
        outBuffer.append(" BGCOLOR=\"").append(user.getBundle().getString("nbgcolor")).append("\">\n");
        outBuffer.append("<p>").append(user.getBundle().getString(stat));
        outBuffer.append("</body>\n");
        outBuffer.append("</html>\n");
        out.print(outBuffer.toString());
        out.close();
    }

    void makeDetectNetletFrame(NetletUser user) throws ServletException, IOException {
        StringBuffer outBuffer = new StringBuffer();
        HttpServletResponse res = user.getRes();
        HttpServletRequest req = user.getReq();
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), user.getHTMLcharsetname())));
        res.setContentType("text/html; charset=" + user.getHTMLcharsetname());
        res.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        res.setHeader("Pragma", "no-cache");
        outBuffer.append("<html>\n");
        outBuffer.append("<head>\n");
        outBuffer.append("\n</head>\n");
        outBuffer.append("<BODY TEXT=\"").append(user.getBundle().getString("ntxcolor"));
        outBuffer.append("\" BGCOLOR=\"").append(user.getBundle().getString("nbgcolor")).append("\">\n");
        outBuffer.append("<applet name=\"netapp\" codebase=\"").append(this.getStaticUrl()).append("/netlet\" archive=\"netletdetect.jar\" code=\"NetletEnvDetect.class\" width=1 height=1>\n");
        outBuffer.append("<param name=\"configURL\" value=\"").append(this.getDynamicUrl()).append("/NetletConfig\">\n");
        outBuffer.append("<param name=\"gwURL\" value=\"").append(req.getHeader("ps-gw-url")).append("\">\n");
        outBuffer.append("</applet>");
        outBuffer.append("</body>\n");
        outBuffer.append("</html>\n");
        out.print(outBuffer.toString());
        out.close();
    }

    void outputResources(NetletUser user) throws ServletException, IOException {
        HttpServletResponse res = user.getRes();
        PrintWriter out = res.getWriter();
        res.setContentType("text/plain");
        Enumeration<String> e = user.getAppletBundle().getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String value = user.getAppletBundle().getString(key);
            out.println(key + "=" + NetletConfig.encodeJavaString(value));
        }
        out.close();
    }

    public static String encodeJavaString(String s) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            int c = s.charAt(i);
            int ic = c;
            if (ic >= 32 && ic <= 127) {
                buf.append((char)c);
                continue;
            }
            buf.append("\\u");
            for (int j = 4; j > 0; --j) {
                buf.append(Character.forDigit((ic & 0xF000) >> 12, 16));
                ic <<= 4;
            }
        }
        return buf.toString();
    }

    private boolean isIPAddress(String hostName) {
        StringTokenizer st = new StringTokenizer(hostName, ".");
        int count = 0;
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            try {
                int intVal = Integer.parseInt(str);
                if (intVal > 255) {
                    return false;
                }
            }
            catch (NumberFormatException ex) {
                return false;
            }
            ++count;
        }
        return count == 4;
    }

    public boolean isValidHost(String hostName) {
        InetAddress inetaddr = null;
        try {
            inetaddr = InetAddress.getByName(hostName);
        }
        catch (UnknownHostException uhe) {
            return false;
        }
        String resolvedHostName = inetaddr.getHostName();
        return !this.isIPAddress(hostName) || !hostName.equals(resolvedHostName);
    }

    private String getIPAddress(String hostName) {
        InetAddress inetaddr = null;
        try {
            inetaddr = InetAddress.getByName(hostName);
        }
        catch (UnknownHostException uhe) {
            this.debug.message("getIPAddress : UnknownHostException hostName " + hostName);
            return hostName;
        }
        return inetaddr.getHostAddress();
    }

    private String getHostName(String IPAddress) {
        InetAddress inetaddr = null;
        try {
            inetaddr = InetAddress.getByName(IPAddress);
        }
        catch (UnknownHostException uhe) {
            this.debug.message("getHostName : UnknownHostException IPAddress " + IPAddress);
            return IPAddress;
        }
        String hostName = inetaddr.getHostName();
        if (hostName.indexOf(".") == -1 && this.serverDomain != null) {
            hostName = hostName + ".";
            hostName = hostName + this.serverDomain;
        }
        return hostName;
    }

    private boolean containsString(String source, String target) {
        if (source == null || target == null) {
            return false;
        }
        int targetLen = target.length();
        int sourceLen = source.length();
        int i = 0;
        while (sourceLen - i >= targetLen) {
            String temp = source.substring(i, i + targetLen);
            if (target.equals(temp)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean openDynamic(NetletUser user, String type) throws IOException {
        String hostName;
        int i;
        this.debug.message("openDynamic " + type);
        Rules rule = user.getRule(type);
        if (rule == null) {
            this.debug.message("Error No rule for " + type);
            return false;
        }
        String url = null;
        String localIP = user.getClientBindIP();
        if (!rule.loopback) {
            url = rule.url;
        } else {
            String ruleURL;
            String loopbackport = this.getClientPort(user.getSSOTokenID().toString(), type, rule.clientLoopbackPort);
            if (loopbackport == null) {
                loopbackport = this.getClientPort(user.getSSOTokenID().toString(), "loopback", rule.clientLoopbackPort);
            }
            if ((ruleURL = rule.url).toLowerCase().startsWith("http")) {
                int colonIndex = ruleURL.indexOf(":");
                String appletProtocol = ruleURL.substring(0, colonIndex);
                int urlIndex = ruleURL.indexOf("/", colonIndex + 3);
                url = appletProtocol + "://" + localIP + ":" + loopbackport + ruleURL.substring(urlIndex, ruleURL.length());
            } else {
                url = this.serverProtocol + "://" + localIP + ":" + loopbackport + rule.url;
            }
        }
        int localHostIndex = url.toLowerCase().indexOf("localhost");
        if (localHostIndex >= 0) {
            url = url.substring(0, localHostIndex) + localIP + url.substring(localHostIndex + "localhost".length());
        }
        this.debug.message("Open dynamic port url " + url);
        HttpServletRequest req = user.getReq();
        HttpServletResponse res = user.getRes();
        String targetHost = req.getParameter("machine");
        targetHost = URLEncoder.encode(targetHost);
        if (targetHost == null || targetHost.equals("")) {
            this.debug.message("Error: no target host specified for " + type);
            return false;
        }
        if (user.inPrivilegeList("sunPortalNetletDenyRules", type, false, false)) {
            this.redirectToPage(user.getRes(), "noprivilege.rule", type, user.getLocale(), user.getHTMLcharsetname());
            return false;
        }
        if (!user.inPrivilegeList("sunPortalNetletAccessRules", type, false, false)) {
            this.redirectToPage(user.getRes(), "noprivilege.rule", type, user.getLocale(), user.getHTMLcharsetname());
            return false;
        }
        String tempTargetHost = new String(targetHost);
        StringTokenizer hostNames = new StringTokenizer(tempTargetHost, "+");
        Vector<String> newTargetHosts = new Vector<String>();
        while (hostNames.hasMoreTokens()) {
            String hostName2 = hostNames.nextToken();
            if (hostName2.indexOf(".") == -1 && this.serverDomain != null) {
                hostName2 = hostName2 + ".";
                hostName2 = hostName2 + this.serverDomain;
            }
            newTargetHosts.add(hostName2);
        }
        if (newTargetHosts.size() == 0) {
            this.redirectToPage(user.getRes(), "invalidhost", null, user.getLocale(), user.getHTMLcharsetname());
            return false;
        }
        for (i = 0; i < newTargetHosts.size(); ++i) {
            boolean inDeniedList;
            hostName = (String)newTargetHosts.get(i);
            boolean bl = inDeniedList = user.inPrivilegeList("sunPortalNetletDenyHosts", this.getHostName(hostName), true, true) || user.inPrivilegeList("sunPortalNetletDenyHosts", this.getIPAddress(hostName), true, true);
            if (!inDeniedList) continue;
            newTargetHosts.remove(hostName);
            --i;
        }
        if (newTargetHosts.size() == 0) {
            this.redirectToPage(user.getRes(), "noprivilege.host", targetHost.replace('+', ','), user.getLocale(), user.getHTMLcharsetname());
            return false;
        }
        for (i = 0; i < newTargetHosts.size(); ++i) {
            boolean inAllowedList;
            hostName = (String)newTargetHosts.get(i);
            boolean bl = inAllowedList = user.inPrivilegeList("sunPortalNetletAccessHosts", this.getHostName(hostName), true, true) || user.inPrivilegeList("AccessHosts", this.getIPAddress(hostName), true, true);
            if (inAllowedList) continue;
            newTargetHosts.remove(hostName);
            --i;
        }
        if (newTargetHosts.size() == 0) {
            this.redirectToPage(user.getRes(), "noprivilege.host", targetHost.replace('+', ','), user.getLocale(), user.getHTMLcharsetname());
            return false;
        }
        String localPort = "";
        String targetPort = "";
        StringBuffer newTargets = new StringBuffer();
        Iterator iter = newTargetHosts.iterator();
        if (iter.hasNext()) {
            newTargets.append((String)iter.next());
        }
        while (iter.hasNext()) {
            newTargets.append("+");
            newTargets.append((String)iter.next());
        }
        targetHost = newTargets.toString();
        this.debug.message("Server domain -> " + this.serverDomain + " Valid and allowed targets -> " + targetHost);
        for (int i2 = 0; i2 < rule.ruleCount; ++i2) {
            String targetHostInRule;
            targetPort = (String)rule.dport.elementAt(i2);
            String clientPortInRule = (String)rule.lport.elementAt(i2);
            localPort = this.getClientPort(user.getSSOTokenID().toString(), type, clientPortInRule);
            this.debug.message("Client port in rule -> " + clientPortInRule + " Actual client port ->" + localPort);
            if (localPort == null) {
                this.debug.error("NetletConfig: No clientport corresponding to " + targetPort);
                continue;
            }
            if (!localPort.equals(clientPortInRule) && this.containsString(url, clientPortInRule)) {
                String temp = url;
                url = temp.substring(0, temp.indexOf(clientPortInRule));
                url = url + localPort;
                url = url + temp.substring(temp.indexOf(clientPortInRule) + clientPortInRule.length());
                this.debug.message("URL -> " + url);
            }
            if (rule.loopback) {
                if (i2 == 0) {
                    url = url + "?";
                }
                url = url + "clientPort[\\'" + targetPort + "\\']=" + localPort;
                if (i2 + 1 < rule.ruleCount) {
                    url = url + "&";
                }
            }
            if (!(targetHostInRule = (String)rule.dhost.elementAt(i2)).equals("TARGET")) continue;
            try {
                user.getSSOToken().setProperty(localPort, targetHost + "^" + targetPort);
                continue;
            }
            catch (SSOException ex) {
                this.debug.error("Error setting session " + (Object)((Object)ex));
                return false;
            }
        }
        this.openPage(user, res, url);
        return true;
    }

    void openPage(NetletUser user, HttpServletResponse res, String url) throws IOException {
        StringBuffer outBuffer = new StringBuffer();
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), user.getHTMLcharsetname())));
        res.setContentType("text/html; charset=" + user.getHTMLcharsetname());
        outBuffer.append("<html>\n");
        if (user.terminateAtLogout()) {
            outBuffer.append(user.getBundle().getString("addToDetachedWindows"));
            outBuffer.append("\n");
        }
        if (url == null || url.equals("")) {
            outBuffer.append("<body onload=window.close()>\n");
        } else {
            outBuffer.append("<body onload=\"");
            if (user.terminateAtLogout()) {
                outBuffer.append("addToDetachedWindows(); ");
            }
            outBuffer.append("window.location.replace('" + url + "')\">\n");
        }
        outBuffer.append("</body></html>\n\n");
        out.print(outBuffer.toString());
        out.close();
    }

    void printRules(NetletUser u) {
        Enumeration e = u.getRules();
        while (e.hasMoreElements()) {
            Rules r = (Rules)e.nextElement();
            for (int i = 0; i < r.lport.size(); ++i) {
            }
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGetPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGetPost(req, res);
    }

    private synchronized int getStatus(String sid) {
        Integer status = (Integer)this.sessionHash.get(sid);
        if (status == null) {
            return 3;
        }
        return status;
    }

    private synchronized void removeSession(SSOTokenID sid) {
        this.sessionHash.remove(sid);
        this.removeClientPort(sid.toString());
    }

    private synchronized void setStatus(String sid, int state) {
        Integer status = this.sessionHash.put(sid, new Integer(state));
        if (status != null) {
            return;
        }
        try {
            SSOToken token = SSOTokenManager.getInstance().createSSOToken(sid.toString());
            token.addSSOTokenListener((SSOTokenListener)this);
        }
        catch (SSOException e) {
            e.printStackTrace();
        }
    }

    public void ssoTokenChanged(SSOTokenEvent se) {
        try {
            int type = se.getType();
            this.removeSession(se.getToken().getTokenID());
        }
        catch (SSOException sSOException) {
            // empty catch block
        }
    }

    void parsePacFile(NetletUser user) throws ServletException, IOException {
        HttpServletResponse res = user.getRes();
        PrintWriter out = res.getWriter();
        res.setContentType("text/plain");
        HttpServletRequest req = user.getReq();
        String result = "FAILED";
        try {
            String pacUrl = req.getParameter("PacFileUrl");
            String serverURL = req.getParameter("ServerURL");
            String pacFileBody = req.getParameter("PacFileBody");
            String clientIPAddr = req.getParameter("ClientIPAddr");
            Cookie[] cookieArr = req.getCookies();
            for (int i = 0; i < cookieArr.length; ++i) {
                Cookie cookie = cookieArr[i];
                if (!cookie.getName().equals("iPlanetUserId")) continue;
                String value = cookie.getValue();
                try {
                    clientIPAddr = value.substring(0, value.indexOf(":"));
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            Enumeration e = req.getHeaderNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
            }
            String contentType = req.getContentType();
            if (contentType != null && contentType.indexOf("multipart/form-data") != -1) {
                pacFileBody = this.extractParameter(req, "PacFileBody");
            }
            Vector<String> arguments = new Vector<String>();
            arguments.add(serverURL);
            String host = "localhost";
            int indDoubleSlash = serverURL.indexOf("//");
            if (indDoubleSlash > -1) {
                int ind1 = serverURL.indexOf("/", indDoubleSlash + 2);
                int ind2 = serverURL.indexOf(":", indDoubleSlash + 2);
                host = ind2 > -1 && ind2 < ind1 ? serverURL.substring(indDoubleSlash + 2, ind2) : serverURL.substring(indDoubleSlash + 2, ind1);
            }
            arguments.add(host);
            try {
                Runtime rt = Runtime.getRuntime();
                String javaHome = System.getProperty("java.home", "/usr/java1.2/jre");
                String command = javaHome + "/bin/java com.sun.portal.netlet.servlet.EvalPAC " + URLEncoder.encode(pacFileBody) + " " + arguments.elementAt(0) + " " + arguments.elementAt(1) + " " + clientIPAddr;
                Object obj = this.getServletContext().getAttribute("com.ibm.websphere.servlet.application.classpath");
                String ibmAppClassPath = obj == null ? null : obj.toString();
                String classPath = System.getProperty("java.class.path", ".");
                String[] env = new String[1];
                if (ibmAppClassPath != null && ibmAppClassPath.trim().length() != 0) {
                    classPath = ibmAppClassPath;
                }
                env[0] = new String("CLASSPATH=" + classPath);
                Process proc = rt.exec(command, env);
                DataInputStream in = new DataInputStream(proc.getInputStream());
                result = in.readLine();
                this.debug.message("Proxy from PAC file -> " + result);
            }
            catch (Exception ex) {
                this.debug.error("Exception in processing PAC file: ", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        out.println(result);
        out.close();
    }

    private String getSessionKey(byte[] rdata, SSOTokenID sid) {
        String sessionId = sid.toString();
        byte[] sidBytes = new byte[sessionId.length()];
        sidBytes = sessionId.getBytes();
        byte[] encodedKey = new byte[sidBytes.length + rdata.length];
        encodedKey[0] = rdata[1];
        encodedKey[1] = rdata[3];
        encodedKey[2] = sidBytes[3];
        encodedKey[3] = rdata[2];
        encodedKey[4] = sidBytes[1];
        encodedKey[5] = rdata[0];
        encodedKey[6] = sidBytes[2];
        encodedKey[7] = rdata[4];
        encodedKey[8] = rdata[14];
        encodedKey[9] = rdata[5];
        encodedKey[10] = rdata[6];
        encodedKey[11] = sidBytes[4];
        encodedKey[12] = rdata[8];
        encodedKey[13] = rdata[9];
        encodedKey[14] = rdata[10];
        encodedKey[15] = sidBytes[5];
        encodedKey[16] = rdata[12];
        encodedKey[17] = rdata[13];
        encodedKey[18] = sidBytes[6];
        encodedKey[19] = sidBytes[7];
        encodedKey[20] = rdata[11];
        encodedKey[21] = sidBytes[8];
        encodedKey[22] = sidBytes[9];
        encodedKey[23] = sidBytes[10];
        encodedKey[24] = rdata[15];
        encodedKey[25] = rdata[7];
        encodedKey[26] = rdata[18];
        encodedKey[27] = rdata[23];
        encodedKey[28] = rdata[21];
        encodedKey[29] = sidBytes[4];
        encodedKey[30] = rdata[26];
        encodedKey[31] = rdata[25];
        encodedKey[32] = rdata[22];
        encodedKey[33] = sidBytes[5];
        encodedKey[34] = rdata[20];
        encodedKey[35] = rdata[24];
        encodedKey[36] = sidBytes[6];
        encodedKey[37] = sidBytes[7];
        encodedKey[38] = rdata[16];
        encodedKey[39] = sidBytes[8];
        encodedKey[40] = rdata[19];
        encodedKey[41] = sidBytes[10];
        encodedKey[42] = rdata[17];
        encodedKey[43] = sidBytes[7];
        encodedKey[44] = rdata[28];
        encodedKey[45] = sidBytes[1];
        encodedKey[46] = sidBytes[0];
        encodedKey[47] = sidBytes[4];
        encodedKey[48] = rdata[31];
        encodedKey[49] = sidBytes[11];
        encodedKey[50] = rdata[27];
        encodedKey[51] = sidBytes[5];
        encodedKey[52] = sidBytes[8];
        encodedKey[53] = sidBytes[32];
        encodedKey[54] = sidBytes[6];
        encodedKey[55] = sidBytes[7];
        encodedKey[56] = sidBytes[24];
        encodedKey[57] = sidBytes[8];
        encodedKey[58] = rdata[30];
        encodedKey[59] = sidBytes[10];
        encodedKey[60] = sidBytes[12];
        encodedKey[61] = rdata[29];
        int j = 0;
        for (int i = 61; i < encodedKey.length; ++i) {
            if (j < sidBytes.length - 1) {
                encodedKey[i] = sidBytes[j++];
                continue;
            }
            j = 0;
            encodedKey[i] = sidBytes[0];
        }
        byte[] b64 = Base64.encode(encodedKey);
        return new String(b64);
    }

    public String getStaticUrl() {
        try {
            return this.getServletConfig().getServletContext().getInitParameter("staticContext");
        }
        catch (NullPointerException npe) {
            this.debug.error("Cannot find init parameter - staticContext");
            return new String("/ips-static");
        }
    }

    public String getDynamicUrl() {
        try {
            return this.getServletConfig().getServletContext().getInitParameter("dynamicContext");
        }
        catch (NullPointerException npe) {
            this.debug.error("Cannot find init parameter - dynamicContext");
            return new String("/ips");
        }
    }

    public void redirectToPage(HttpServletResponse res, String stat, String val, String loc, String charset) {
        StringBuffer outBuffer = new StringBuffer();
        try {
            if (charset != null && charset.trim().length() != 0) {
                res.setContentType("text/html; charset=" + charset);
            } else {
                res.setContentType("text/html");
            }
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), charset)));
            ResourceBundle bundle = null;
            if (loc == null || loc.trim().length() == 0) {
                loc = SystemProperties.get((String)"com.iplanet.am.locale", (String)"en_US");
                bundle = ResourceBundle.getBundle("srapNetletServlet", Locale.getLocale((String)loc));
            } else {
                bundle = ResourceBundle.getBundle("srapNetletServlet", Locale.getLocale((String)loc));
            }
            outBuffer.append("<html>\n");
            outBuffer.append("<BODY TEXT=\"").append(bundle.getString("ntxcolor"));
            outBuffer.append("\" BGCOLOR=\"").append(bundle.getString("nbgcolor")).append("\">\n");
            outBuffer.append("<p>").append(bundle.getString(stat));
            if (val != null && val.trim().length() != 0) {
                outBuffer.append(val);
            }
            outBuffer.append("</body>\n");
            outBuffer.append("</html>\n");
            out.print(outBuffer.toString());
            out.close();
        }
        catch (IOException ioe) {
            this.debug.error("Error redirecting to session invalid page." + ioe);
        }
    }

    public void storeProxySettings(NetletUser nu) {
        HttpServletRequest req = nu.getReq();
        UserAttributes attrs = nu.getNetletUserAttributes();
        try {
            attrs.setString("sunPortalNetletProxyType", req.getParameter("proxytype"));
            attrs.setString("sunPortalNetletProxyHost", req.getParameter("proxyhost"));
            attrs.setString("sunPortalNetletProxyPort", req.getParameter("proxyport"));
            attrs.setString("sunPortalNetletProxyOverride", req.getParameter("proxyoverride"));
        }
        catch (Exception e) {
            this.debug.error("Exception in setting attribute: " + e);
        }
        nu.setNetletUserAttributes(attrs);
        HttpServletResponse res = nu.getRes();
        try {
            PrintWriter out = res.getWriter();
            out.println("");
            out.close();
        }
        catch (IOException ioe) {
            this.debug.error("Exception in sending respose : " + ioe);
        }
    }

    public void doReauth(NetletUser nu) {
        HttpServletRequest req = nu.getReq();
        String password = req.getParameter("password");
        String contentType = req.getContentType();
        if (contentType != null && contentType.indexOf("multipart/form-data") != -1) {
            password = this.extractParameter(req, "password");
        }
        String result = this.verifyPassword(nu, password);
        this.writeResult(nu, result);
    }

    public String verifyPassword(NetletUser nu, String password) {
        if (password == null || password.trim().length() == 0) {
            return "FAILED";
        }
        UserAttributes attrs = nu.getNetletUserAttributes();
        String actualPassword = attrs.getString("sunPortalNetletPassword", "srap-netlet");
        return actualPassword.equals(password) ? "SUCCESS" : "FAILED";
    }

    public void writeResult(NetletUser nu, String result) {
        HttpServletResponse res = nu.getRes();
        try {
            PrintWriter out = res.getWriter();
            out.println(result);
            out.close();
        }
        catch (IOException ioe) {
            this.debug.error("Exception in sending respose : " + ioe);
        }
    }

    public String extractParameter(HttpServletRequest req, String paramName) {
        HashMap<String, String> reqList = new HashMap<String, String>();
        try {
            DataInputStream in = new DataInputStream((InputStream)req.getInputStream());
            int formDataLength = req.getContentLength();
            byte[] dataBytes = new byte[formDataLength];
            in.readFully(dataBytes);
            String file = new String(dataBytes, "ISO-8859-1");
            dataBytes = null;
            StringTokenizer strTok = new StringTokenizer(file, "&");
            while (strTok.hasMoreTokens()) {
                String token = strTok.nextToken();
                int ind = token.indexOf("=");
                if (ind <= -1) continue;
                String key = token.substring(0, ind);
                String value = token.substring(ind + 1);
                reqList.put(key, value);
            }
        }
        catch (IOException ioe) {
            return null;
        }
        return URLDecoder.decode(reqList.get(paramName).toString());
    }

    class NetletUser {
        private Hashtable netletRules = new Hashtable();
        private HttpServletRequest req = null;
        private HttpServletResponse res = null;
        private boolean portWarn = false;
        private String clientBindIP = "127.0.0.1";
        private boolean portwarnCheckbox = true;
        private boolean doReauth = false;
        private int defaultLoopbackPort = 8000;
        private String enc = null;
        private ResourceBundle bundle = null;
        private ResourceBundle appletBundle = null;
        private String HTMLcharsetname = null;
        private SSOToken ssoToken = null;
        private UserAttributes userAttrs = null;
        private Hashtable userCipherPreference = new Hashtable();
        private String defaultCipher = null;
        private boolean terminateAtLogout = true;

        private SSOToken createSSOToken(HttpServletRequest httpreq) {
            SSOToken token = null;
            String cookieName = SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro");
            Cookie[] cks = httpreq.getCookies();
            if (cks != null) {
                for (int i = 0; i < cks.length; ++i) {
                    String cName = cks[i].getName();
                    if (cName == null || !cName.equals(cookieName)) continue;
                    String sessID = cks[i].getValue();
                    try {
                        token = SSOTokenManager.getInstance().createSSOToken(sessID);
                    }
                    catch (SSOException ssoe) {
                        try {
                            token = SSOTokenManager.getInstance().createSSOToken(URLDecoder.decode(sessID));
                        }
                        catch (SSOException ssoe2) {}
                    }
                    break;
                }
            }
            return token;
        }

        public NetletUser(HttpServletRequest httpreq) throws SSOException {
            this.req = httpreq;
            this.ssoToken = this.createSSOToken(this.req);
            if (this.ssoToken == null) {
                throw new SSOException("NetletUser.java Can't get ssoToken");
            }
            this.userAttrs = new UserAttributes(this.ssoToken);
            this.terminateAtLogout = this.userAttrs.getBoolean("sunPortalNetletTerminateAtLogout", true);
            this.enc = this.userAttrs.getUserAttribute("preferredlocale", Locale.getDefaultLocale().toString());
            this.HTMLcharsetname = this.findHTMLCharset(this.req);
            NetletConfig.this.debug.message("Netlet using encoding : " + this.enc + "  charset : " + this.HTMLcharsetname);
            this.bundle = ResourceBundle.getBundle("srapNetletServlet", Locale.getLocale((String)this.enc));
            this.appletBundle = ResourceBundle.getBundle("srapNetletApplet", Locale.getLocale((String)this.enc));
            this.defaultCipher = this.userAttrs.getString("sunPortalNetletKSSLDefaultCipher", "KSSL_SSL3_RSA_WITH_RC4_128_MD5") + "|" + this.userAttrs.getString("sunPortalNetletJSSEDefaultCipher", "SSL_RSA_WITH_RC4_128_MD5");
            List userCipherList = this.userAttrs.getStringList("sunPortalNetletUserCipher");
            for (int x = 0; x < userCipherList.size(); ++x) {
                String userCipher = (String)userCipherList.get(x);
                int index = userCipher.indexOf("|");
                if (index == -1) continue;
                NetletConfig.this.debug.message("\nRule name -> " + userCipher.substring(0, index));
                NetletConfig.this.debug.message("Cipher -> " + userCipher.substring(index + 1));
                this.userCipherPreference.put(userCipher.substring(0, index), userCipher.substring(index + 1));
            }
        }

        public String findHTMLCharset(HttpServletRequest req) {
            String HTMLcharset = null;
            AMClientDetector amCD = new AMClientDetector();
            String clientType = amCD.getClientType(req);
            try {
                Client clientObj = Client.getInstance((String)clientType);
                HTMLcharset = clientObj.getCharset(Locale.getLocale((String)this.getLocale()));
            }
            catch (ClientException ce) {
                NetletConfig.this.debug.error("NetletConfig: ClientException in determining charset, reading charset from properties file.");
                try {
                    HTMLcharset = this.getBundle().getString("HTMLcharset");
                }
                catch (Exception mre) {
                    NetletConfig.this.debug.error("NetletConfig: Exception in reading HTMLcharset from properties file, using ISO-8859-1.");
                    HTMLcharset = "ISO-8859-1";
                }
            }
            return HTMLcharset;
        }

        public String getAlgorithm(Rules r) {
            String ruleName = r.name;
            if (ruleName == null || ruleName.trim().length() == 0) {
                return "SSL_RSA_WITH_RC4_128_MD5";
            }
            if (r.algorithms == null || r.algorithms.size() == 0) {
                return this.defaultCipher;
            }
            if (r.algorithms.size() == 1) {
                return (String)r.algorithms.get(0);
            }
            Object algo = this.userCipherPreference.get(ruleName);
            if (algo == null || algo.equals("null") || !r.algorithms.contains(algo)) {
                return (String)r.algorithms.get(0);
            }
            return algo.toString();
        }

        public String getDefaultCipher() {
            return this.defaultCipher;
        }

        public void getUserAttributes() throws SSOException {
            this.portWarn = this.userAttrs.getBoolean("sunPortalNetletPortWarn", true);
            this.doReauth = this.userAttrs.getBoolean("sunPortalNetletDoReauth", false);
            this.portwarnCheckbox = this.userAttrs.getBoolean("sunPortalNetletPortWarnCheckBox", true);
            this.defaultLoopbackPort = this.userAttrs.getInt("sunPortalNetletClientLoopbackPort", 8000);
            this.clientBindIP = this.userAttrs.getString("sunPortalNetletClientBindIP", "127.0.0.1");
            this.parseRules(new ArrayList(this.userAttrs.getStringList("sunPortalNetletRules")));
        }

        public boolean isAllowed() {
            return this.userAttrs == null ? false : this.userAttrs.isAllowed();
        }

        public String getDefaultRedirectURL() {
            String defaultRedirectURL = this.userAttrs.getUserAttribute("iplanet-am-auth-default-url");
            return defaultRedirectURL;
        }

        public int getDefaultLBPort() {
            return this.defaultLoopbackPort;
        }

        public boolean getPortWarn() {
            return this.portWarn;
        }

        public boolean terminateAtLogout() {
            return this.terminateAtLogout;
        }

        public String getClientBindIP() {
            return this.clientBindIP;
        }

        public boolean getPortWarnCheckbox() {
            return this.portwarnCheckbox;
        }

        public boolean getReauth() {
            return this.doReauth;
        }

        public void addRule(Rules r) {
            if (r == null) {
                return;
            }
            this.netletRules.put(r.name, r);
        }

        public Enumeration getRules() {
            return this.netletRules.elements();
        }

        public Rules getRule(String cmd) {
            return (Rules)this.netletRules.get(cmd);
        }

        private void parseRules(ArrayList cmds) {
            StringTokenizer algoTokens = null;
            String tmpStr = null;
            for (int x = 0; x < cmds.size(); ++x) {
                String rule = (String)cmds.get(x);
                boolean isExtend = rule.endsWith("EXTEND");
                if (isExtend) {
                    rule = rule.substring(0, rule.lastIndexOf("|"));
                }
                Rules r = new Rules();
                StringTokenizer st = new StringTokenizer(rule, "|");
                try {
                    while (st.hasMoreElements()) {
                        String tmp;
                        tmpStr = (String)st.nextElement();
                        algoTokens = new StringTokenizer(tmpStr, "^");
                        try {
                            r.name = algoTokens.nextElement().toString();
                            tmpStr = algoTokens.nextElement().toString();
                            if (tmpStr.startsWith("ALGO")) {
                                r.isAlgoUserConfigurable = true;
                                try {
                                    tmpStr = algoTokens.nextElement().toString();
                                }
                                catch (NoSuchElementException ne) {
                                    tmpStr = this.defaultCipher;
                                }
                            }
                            algoTokens = new StringTokenizer(tmpStr, "+");
                            while (algoTokens.hasMoreElements()) {
                                r.algorithms.add(algoTokens.nextElement());
                            }
                        }
                        catch (NoSuchElementException ne) {
                            r.name = tmpStr;
                            r.algorithms.add(this.defaultCipher);
                        }
                        r.url = (String)st.nextElement();
                        if (r.url.equalsIgnoreCase("null")) {
                            r.url = "";
                        }
                        if ((tmp = (String)st.nextElement()).equalsIgnoreCase("false")) {
                            r.loopback = false;
                        } else if (tmp.equalsIgnoreCase("true")) {
                            r.loopback = true;
                            r.clientLoopbackPort = new String("" + this.defaultLoopbackPort + "");
                            r.loopbackServer = NetletConfig.this.serverName;
                            r.serverLoopbackPort = NetletConfig.this.serverPort;
                        } else {
                            StringTokenizer st1 = new StringTokenizer(tmp, ":");
                            r.loopback = true;
                            r.clientLoopbackPort = (String)st1.nextElement();
                            r.loopbackServer = (String)st1.nextElement();
                            r.serverLoopbackPort = (String)st1.nextElement();
                            r.lport.add(r.clientLoopbackPort);
                            r.dhost.add(r.loopbackServer);
                            r.dport.add(r.serverLoopbackPort);
                            ++r.ruleCount;
                        }
                        while (st.hasMoreElements()) {
                            ++r.ruleCount;
                            r.lport.add(this.expandAttributes((String)st.nextElement()));
                            r.dhost.add(this.expandAttributes((String)st.nextElement()));
                            r.dport.add(this.expandAttributes((String)st.nextElement()));
                        }
                        r.isExtend = isExtend;
                    }
                }
                catch (NoSuchElementException ex) {
                    continue;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                this.addRule(r);
            }
        }

        private String expandAttributes(String val) {
            int i = val.indexOf(36);
            if (i == -1) {
                return val;
            }
            int state = 0;
            StringBuffer buf = new StringBuffer();
            StringBuffer attr = null;
            char[] cval = val.toCharArray();
            while (i < cval.length) {
                char c = cval[i++];
                switch (state) {
                    case 0: {
                        if (c == '$') {
                            state = 1;
                            break;
                        }
                        buf.append(c);
                        break;
                    }
                    case 1: {
                        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                            attr = new StringBuffer();
                            attr.append(c);
                            state = 2;
                            break;
                        }
                        if (c == '{') {
                            attr = new StringBuffer();
                            state = 3;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 2: {
                        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-') {
                            attr.append(c);
                            break;
                        }
                        buf.append(this.getAttr(attr.toString()));
                        buf.append(c);
                        state = 0;
                        break;
                    }
                    case 3: {
                        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-') {
                            attr.append(c);
                            break;
                        }
                        if (c == '}') {
                            buf.append(this.getAttr(attr.toString()));
                            state = 0;
                            break;
                        }
                        state = 0;
                    }
                }
            }
            switch (state) {
                case 1: {
                    break;
                }
                case 2: {
                    buf.append(this.getAttr(attr.toString()));
                    break;
                }
            }
            String rval = buf.toString();
            return rval;
        }

        private String getAttr(String aname) {
            return this.userAttrs.getUserAttribute(aname);
        }

        public void setReq(HttpServletRequest r) {
            this.req = r;
        }

        public HttpServletRequest getReq() {
            return this.req;
        }

        public void setRes(HttpServletResponse r) {
            this.res = r;
        }

        public HttpServletResponse getRes() {
            return this.res;
        }

        public String getLocale() {
            return this.enc;
        }

        public ResourceBundle getBundle() {
            return this.bundle;
        }

        public ResourceBundle getAppletBundle() {
            return this.appletBundle;
        }

        public String getHTMLcharsetname() {
            return this.HTMLcharsetname;
        }

        public SSOToken getSSOToken() {
            return this.ssoToken;
        }

        public SSOTokenID getSSOTokenID() {
            return this.ssoToken.getTokenID();
        }

        public UserAttributes getNetletUserAttributes() {
            return this.userAttrs;
        }

        public void setNetletUserAttributes(UserAttributes attrs) {
            this.userAttrs = attrs;
        }

        public String getClientHostName() throws SSOException {
            return this.ssoToken.getHostName();
        }

        public String getClientID() {
            if (this.ssoToken != null) {
                try {
                    String dn = this.ssoToken.getPrincipal().getName();
                    String clientId = dn.substring(dn.indexOf("=") + 1, dn.indexOf(","));
                    return clientId;
                }
                catch (Exception ex) {
                    NetletConfig.this.debug.error("NetletConfig: Unable to get client ID -> " + ex);
                }
            }
            return "";
        }

        public boolean inPrivilegeList(String privilege, String value, boolean ignoreCase, boolean isHost) {
            if (value == null) {
                return false;
            }
            boolean stringMatch = false;
            ArrayList privilegeList = new ArrayList(this.userAttrs.getStringList(privilege));
            if (privilegeList != null) {
                for (int i = 0; i < privilegeList.size(); ++i) {
                    String privilegeString = (String)privilegeList.get(i);
                    if (privilegeString.equals("*")) {
                        return true;
                    }
                    if (isHost && !NetletConfig.this.isIPAddress(privilegeString) && privilegeString.indexOf(".") == -1 && NetletConfig.this.serverDomain != null) {
                        privilegeString = privilegeString + ".";
                        privilegeString = privilegeString + NetletConfig.this.serverDomain;
                    }
                    stringMatch = ignoreCase ? this.wildcardMatch(value.toLowerCase(), privilegeString.toLowerCase()) : this.wildcardMatch(value, privilegeString);
                    if (NetletConfig.this.debug.messageEnabled()) {
                        NetletConfig.this.debug.message("NetletConfig.inPrivilegeList() :  privilege : " + privilege + " value : " + value + " privilegeString : " + privilegeString + " ignoreCase : " + ignoreCase + " isHost : " + isHost + " result : " + stringMatch);
                    }
                    if (!stringMatch) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean wildcardMatch(String str1, String str2) {
            int beginIndex1 = 0;
            int endIndex1 = 0;
            int beginIndex2 = 0;
            int endIndex2 = 0;
            int strlen1 = str1.length();
            int strlen2 = str2.length();
            String substr = null;
            if (str1 == null || str2 == null) {
                return false;
            }
            endIndex2 = str2.indexOf(42, beginIndex2);
            if (endIndex2 != -1) {
                substr = str2.substring(beginIndex2, endIndex2);
                if (endIndex2 > beginIndex2) {
                    if ((beginIndex1 = str1.indexOf(substr, beginIndex1)) == -1) {
                        return false;
                    }
                    if (beginIndex1 != beginIndex2) {
                        return false;
                    }
                }
                beginIndex1 += endIndex2 - beginIndex2;
                if (endIndex2 >= strlen2 - 1) {
                    return true;
                }
                beginIndex2 = endIndex2 + 1;
            } else {
                beginIndex1 = str1.indexOf(str2);
                if (beginIndex1 == -1) {
                    return false;
                }
                return strlen1 == strlen2;
            }
            while ((endIndex2 = str2.indexOf(42, beginIndex2)) != -1) {
                substr = str2.substring(beginIndex2, endIndex2);
                if (endIndex2 > beginIndex2 && (beginIndex1 = str1.indexOf(substr, beginIndex1)) == -1) {
                    return false;
                }
                beginIndex1 += endIndex2 - beginIndex2;
                if (endIndex2 >= strlen2 - 1) {
                    return true;
                }
                beginIndex2 = endIndex2 + 1;
            }
            substr = str2.substring(beginIndex2, strlen2);
            endIndex1 = str1.lastIndexOf(substr, strlen1 - 1);
            if (endIndex1 == -1) {
                return false;
            }
            if (beginIndex1 > endIndex1) {
                return false;
            }
            beginIndex1 = endIndex1;
            return strlen1 - beginIndex1 == strlen2 - beginIndex2;
        }

        public String getEncryptionType() {
            StringTokenizer tokenizer;
            HttpServletRequest req = this.getReq();
            String psNetletHeader = req.getHeader("PS-Netlet");
            if (psNetletHeader != null && (tokenizer = new StringTokenizer(psNetletHeader, ";")).countTokens() == 2) {
                String token = tokenizer.nextToken();
                token = tokenizer.nextToken().trim();
                if ("encryption=ssl".equals(token)) {
                    return "SSL";
                }
            }
            return "PLAIN";
        }
    }
}

