/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.econnection;

import com.sun.portal.netlet.econnection.MessageConstants;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;

public abstract class HeaderMsg
implements MessageConstants {
    protected byte version;
    protected short opCode;
    protected int msgLen;
    protected int seq = 0;
    protected final int HEADER_LEN = 11;
    protected final int MAX_MSG_LEN = 100000;

    public HeaderMsg() {
    }

    public HeaderMsg(byte vers, short op) {
        this.version = vers;
        this.opCode = op;
    }

    public int readHeader(DataInputStream in) {
        this.msgLen = 0;
        try {
            int tmp_seq;
            do {
                this.version = in.readByte();
                this.opCode = in.readShort();
                tmp_seq = in.readInt();
                this.msgLen = in.readInt();
            } while (this.opCode == 4);
            if (tmp_seq != this.seq) {
                System.out.println("Netlet HeaderMsg: Unexpected sequence number");
                return -1;
            }
            ++this.seq;
        }
        catch (EOFException e) {
            return -1;
        }
        catch (SocketException e) {
            return -1;
        }
        catch (IOException e) {
            System.out.println("HeaderMsg: readHeader IOException:" + e);
            return -1;
        }
        return 0;
    }

    public void writeHeaderToByteArray(ByteArrayOutputStream b) {
        DataOutputStream b_out = new DataOutputStream(b);
        try {
            b_out.writeByte(this.version);
            b_out.writeShort(this.opCode);
            b_out.writeInt(this.seq);
            b_out.writeInt(this.msgLen);
            ++this.seq;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public abstract int readMsg(DataInputStream var1);

    public abstract int writeMsg(DataOutputStream var1);

    public byte getVersion() {
        return this.version;
    }

    public void setVersion(int v) {
        this.version = (byte)v;
    }

    public short getOpCode() {
        return this.opCode;
    }

    public void setOpCode(short oc) {
        this.opCode = oc;
    }

    public int getMsgLen() {
        return this.msgLen;
    }

    public void setMsgLen(int ml) {
        this.msgLen = ml;
    }
}

