/*
 * Decompiled with CFR 0.152.
 */
package com.sun.addressbook.ldap;

import com.sun.addressbook.ABDebug;
import com.sun.addressbook.ABSession;
import com.sun.addressbook.ABStore;
import com.sun.addressbook.ABStoreException;
import com.sun.addressbook.AddressBook;
import com.sun.addressbook.MissingPropertiesException;
import com.sun.addressbook.OperationNotSupportedException;
import com.sun.addressbook.ldap.LdapAddressBook;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPRebind;
import netscape.ldap.LDAPRebindAuth;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.ConnectionPool;

public class LdapABStore
extends ABStore {
    private static Hashtable connPoolTable = new Hashtable();
    private static long lastPabTimeStamp = 0L;
    private String ldapServer = null;
    private int ldapPort = -1;
    private String ldapPortStr = null;
    private String authId = null;
    private String authPw = null;
    private String dirSearchBase = null;
    private String fullPabSearchBase = null;
    private String pabSearchBase = null;
    private String user = null;
    private String domain = null;
    private int min = 5;
    private int max = 20;
    private int ldapTimeout = 10000;
    private String pabLang = "en";

    protected String getFullPabSearchBase() {
        return this.fullPabSearchBase;
    }

    protected String getPabLang() {
        return this.pabLang;
    }

    public void init(ABSession session) throws MissingPropertiesException, ABStoreException {
        this.session = session;
        this.ldapServer = session.getProperty("ab.host");
        if (this.ldapServer == null) {
            throw new MissingPropertiesException("Failed to setup the LdapABStore: Property ab.host missing");
        }
        this.ldapPortStr = session.getProperty("ab.port");
        if (this.ldapPortStr == null) {
            throw new MissingPropertiesException("Failed to setup the LdapABStore: Property ab.port missing");
        }
        try {
            this.ldapPort = Integer.parseInt(this.ldapPortStr);
        }
        catch (Exception e) {
            throw new MissingPropertiesException("Failed to setup the LdapABStore: Property ab.port should be an integer");
        }
        this.authId = session.getProperty("ab.ldap.authId");
        if (this.authId == null) {
            throw new MissingPropertiesException("Failed to setup the LdapABStore: Property ab.ldap.authId missing");
        }
        this.authPw = session.getProperty("ab.ldap.authPw");
        if (this.authPw == null) {
            throw new MissingPropertiesException("Failed to setup the LdapABStore: Property ab.ldap.authPw missing");
        }
        this.dirSearchBase = session.getProperty("ab.ldap.dirSearchBase");
        if (this.dirSearchBase == null) {
            throw new MissingPropertiesException("Failed to setup the LdapABStore: Property ab.ldap.dirSearchBase missing");
        }
        this.pabSearchBase = session.getProperty("ab.ldap.pabSearchBase");
        if (this.pabSearchBase == null) {
            throw new MissingPropertiesException("Failed to setup the LdapABStore: Property ab.ldap.pabSearchBase missing");
        }
        this.user = session.getProperty("ab.userName");
        if (this.user == null) {
            throw new MissingPropertiesException("Failed to setup the LdapABStore: Property ab.userName missing");
        }
        this.pabLang = session.getProperty("ab.ldap.lang");
        if (this.pabLang == null) {
            ABDebug.logWarning("Missing/Incorrect property ab.ldap.lang. Setting default");
            this.pabLang = "en";
        }
        this.domain = session.getProperty("ab.domain");
        if (this.domain == null) {
            ABDebug.logWarning("Missing/Incorrect property ab.domain. Assuming default domain");
            this.domain = "";
        }
        try {
            this.min = Integer.parseInt(session.getProperty("ab.ldap.connPoolMin"));
        }
        catch (Exception e) {
            ABDebug.logWarning("Missing/Incorrect value ab.ldap.connPoolMin.Setting default");
            this.min = 5;
        }
        try {
            this.max = Integer.parseInt(session.getProperty("ab.ldap.connPoolMax"));
        }
        catch (Exception e) {
            ABDebug.logWarning("Missing/Incorrect value ab.ldap.connPoolMax.Setting default");
            this.max = 20;
        }
        try {
            this.ldapTimeout = Integer.parseInt(session.getProperty("ab.ldap.timeout"));
        }
        catch (Exception e) {
            ABDebug.logWarning("Missing/Incorrect value ab.ldap.timeout.Setting default");
            this.ldapTimeout = 10000;
        }
    }

    public void connect() throws ABStoreException {
        LDAPConnection ld = null;
        if (connPoolTable.get(this.ldapServer) == null) {
            ConnectionPool cp = null;
            try {
                ld = this.makeConnection(this.ldapServer, this.ldapPort, this.authId, this.authPw, this.ldapTimeout);
                cp = new ConnectionPool(this.min, this.max, ld);
                connPoolTable.put(this.ldapServer, cp);
            }
            catch (LDAPException ldapE) {
                ABDebug.logError("Could not create connection pool");
                throw new ABStoreException(ldapE.getMessage());
            }
        }
    }

    public void closePool() throws ABStoreException {
        ConnectionPool cp = (ConnectionPool)connPoolTable.get(this.ldapServer);
        cp.destroy();
        connPoolTable.remove(this.ldapServer);
    }

    public void disconnect() throws ABStoreException {
    }

    public boolean isConnected() throws ABStoreException {
        LDAPConnection ld = this.LDAPConnect();
        if (ld != null) {
            this.LDAPClose(ld);
            return true;
        }
        return false;
    }

    private String getPabSearchBase() throws ABStoreException {
        LDAPConnection ld = this.LDAPConnect();
        if (ld == null) {
            String msg = "LdapABStore.getPabSearchBase():failed to get ldapconnection from pool";
            ABDebug.logWarning(msg);
            throw new ABStoreException(msg);
        }
        String searchFilter = "";
        ABDebug.logMessage("LDAPABStore.getPabSearchBase(): domain=" + this.domain);
        searchFilter = this.domain.equals("") ? "uid=" + this.user : "(&(uid=" + this.user + ")(pabURI=*" + this.domain + "*))";
        LDAPSearchResults paburiSearchResults = null;
        String[] searchAttrPaburi = new String[]{"paburi"};
        String newSearchBase = null;
        ABDebug.logMessage("LDAPABStore.getPabSearchBase(): dirSearchBase=" + this.dirSearchBase);
        ABDebug.logMessage("LDAPABStore.getPabSearchBase(): scope=" + 2);
        ABDebug.logMessage("LDAPABStore.getPabSearchBase(): searchFilter=" + searchFilter);
        try {
            paburiSearchResults = ld.search(this.dirSearchBase, 2, searchFilter, searchAttrPaburi, false);
        }
        catch (LDAPException ldapE) {
            String msg = "LdapABStore.getPabSearchBase():  Cannot locate " + this.user + "'s ldap entry:  ";
            ABDebug.logWarning(msg);
        }
        if (paburiSearchResults != null) {
            try {
                LDAPEntry tmp = paburiSearchResults.next();
                Enumeration enumeration = tmp.getAttribute("paburi").getStringValues();
                String pabUri = (String)enumeration.nextElement();
                int idx = pabUri.indexOf("/ou=");
                newSearchBase = pabUri.substring(idx + 1);
                ABDebug.logMessage("LdapABStore.getPabSearchBase(): Pab search base = " + newSearchBase);
            }
            catch (Exception e) {
                ABDebug.logError("LdapABStore.getPabSearchBase(): Unable to find paburi for user=" + this.user);
                newSearchBase = null;
            }
        }
        this.LDAPClose(ld);
        return newSearchBase;
    }

    public String[] getAddressBooks() throws ABStoreException, OperationNotSupportedException {
        LDAPSearchResults abIdSearchResults = null;
        LDAPConnection ld = this.LDAPConnect();
        String searchFilter = null;
        ArrayList<String> abIDs = new ArrayList<String>();
        String newSearchBase = this.getPabSearchBase();
        if (newSearchBase != null) {
            this.fullPabSearchBase = newSearchBase;
            ABDebug.logMessage("LdapABStore.getAddressBooks(): Setting fullPabSearchBase to " + this.fullPabSearchBase);
            searchFilter = "objectclass=pab";
            String[] searchAttr = new String[]{"un"};
            try {
                abIdSearchResults = ld.search(this.fullPabSearchBase, 2, searchFilter, searchAttr, false);
            }
            catch (LDAPException ldapE) {
                ABDebug.logError("LdapABStore.getAddressBooks(): Unable to get address book for " + this.user);
                abIdSearchResults = null;
            }
            if (abIdSearchResults != null) {
                try {
                    while (abIdSearchResults.hasMoreElements()) {
                        LDAPEntry tmp = abIdSearchResults.next();
                        Enumeration enumeration = tmp.getAttribute("un").getStringValues();
                        abIDs.add((String)enumeration.nextElement());
                    }
                }
                catch (Exception e) {
                    String msg = "LdapABStore.getAddressBooks(): ERROR: Cannot find user address book at the location specified in paburi." + e;
                    ABDebug.logError(msg);
                    throw new ABStoreException(msg);
                }
            }
        } else {
            abIDs.add(this.createAB());
        }
        this.LDAPClose(ld);
        return abIDs.toArray(new String[abIDs.size()]);
    }

    protected String getDefaultAbID() throws ABStoreException {
        try {
            return this.getAddressBooks()[0];
        }
        catch (Exception e) {
            throw new ABStoreException(e.getMessage());
        }
    }

    public AddressBook openAddressBook(String abID) throws ABStoreException {
        ABDebug.logMessage("LdapABStore.openAddressBook() abID=" + abID);
        return new LdapAddressBook(this, abID);
    }

    public void closeAddressBook(AddressBook ab) throws ABStoreException {
        ab = null;
    }

    public String createAB() throws ABStoreException {
        LDAPEntry pabEntry;
        LDAPAttributeSet attrs;
        String[] objClass;
        String abID = null;
        LDAPConnection ld = this.LDAPConnect();
        LDAPSearchResults userDNSearchResults = null;
        String userDN = null;
        String[] searchAttrDN = new String[]{"dn"};
        String searchFilter = "uid=" + this.user;
        try {
            userDNSearchResults = ld.search(this.dirSearchBase, 2, searchFilter, searchAttrDN, false);
        }
        catch (LDAPException ldapE) {
            String msg = "LdapABStore.createAB():  Cannot locate " + this.user + "'s ldap entry in searchbase:  " + this.dirSearchBase;
            ABDebug.logWarning(msg);
            throw new ABStoreException("LdapABStore.createAB: Creation of address book failed: User doesnt exist in the directory");
        }
        String searchBaseFromUserDN = null;
        ABDebug.logMessage("LdapABStore.createAB():  user dn search results size = " + userDNSearchResults.getCount());
        if (userDNSearchResults != null) {
            try {
                LDAPEntry tmp = userDNSearchResults.next();
                ABDebug.logMessage("ldap entry = " + tmp);
                userDN = tmp.getDN();
                int idx = userDN.indexOf("ou=");
                searchBaseFromUserDN = userDN.substring(idx);
            }
            catch (Exception e) {
                String msg = "LdapABStore.createAB():  Cannot locate user = " + this.user + " in directory";
                ABDebug.logError(msg);
                throw new ABStoreException(msg);
            }
        }
        if (searchBaseFromUserDN == null) {
            throw new ABStoreException("LdapABStore.createAB():  Error in user's " + this.user + " entry in directory = ");
        }
        String searchBase = searchBaseFromUserDN + ", " + this.pabSearchBase;
        this.fullPabSearchBase = "ou=" + this.user + "," + searchBase;
        ABDebug.logMessage("search base = " + this.fullPabSearchBase);
        if (ld == null) {
            String msg = "LdapABStore.connect():  failed to get ldap connection from pool";
            ABDebug.logWarning(msg);
            return null;
        }
        String dn = null;
        try {
            objClass = new String[]{"top", "organizationalunit"};
            attrs = new LDAPAttributeSet();
            attrs.add(new LDAPAttribute("objectclass", objClass));
            attrs.add(new LDAPAttribute("ou", this.user));
            dn = this.fullPabSearchBase;
            pabEntry = new LDAPEntry(dn, attrs);
            ld.add(pabEntry);
        }
        catch (Exception e) {
            ABDebug.logWarning("LdapABStore.createAB(): Address book creation failed while creating dn = " + dn + ": " + e);
        }
        try {
            objClass = new String[]{"top", "pab"};
            attrs = new LDAPAttributeSet();
            abID = "AddressBook" + this.pabTimeStamp();
            attrs.add(new LDAPAttribute("objectclass", objClass));
            attrs.add(new LDAPAttribute("cn", "Address Book"));
            attrs.add(new LDAPAttribute("un", abID));
            dn = "un=" + abID + "," + this.fullPabSearchBase;
            pabEntry = new LDAPEntry(dn, attrs);
            ld.add(pabEntry);
        }
        catch (Exception e) {
            ABDebug.logWarning("LdapABStore.createAB():Address book creation failed while creating entry " + dn + ": " + e);
            abID = null;
        }
        try {
            dn = "uid=" + this.user + ", " + searchBaseFromUserDN;
            String pabURL = "ldap://" + this.ldapServer + ":" + this.ldapPortStr;
            String newpabUri = pabURL + "/" + this.fullPabSearchBase;
            LDAPModificationSet mods = new LDAPModificationSet();
            mods.add(2, new LDAPAttribute("paburi", newpabUri));
            ld.modify(dn, mods);
        }
        catch (Exception e) {
            ABDebug.logWarning("LdapABStore.createAB():Address book creation failed while adding paburi field to user " + this.user);
            abID = null;
        }
        this.LDAPClose(ld);
        return abID;
    }

    private LDAPRebind getRebind(final String authId, final String authPw) {
        return new LDAPRebind(){
            private String authDN = authId;
            private String authPwd = authPw;

            public LDAPRebindAuth getRebindAuthentication(String host, int port) {
                return new LDAPRebindAuth(this.authDN, this.authPwd);
            }
        };
    }

    private LDAPConnection makeConnection(String host, int port, String authId, String authPw, int timeout) throws LDAPException {
        LDAPConnection ld = new LDAPConnection();
        try {
            ld.setOption(4, (Object)new Integer(timeout));
            ld.connect(host, port, authId, authPw);
            LDAPRebind x_rebind = this.getRebind(authId, authPw);
            ld.setOption(8, (Object)new Boolean(true));
            ld.setOption(9, (Object)x_rebind);
            ABDebug.logMessage("LdapABStore.makeConnection():SET ldap referrals to TRUE ");
        }
        catch (Exception e) {
            String msg = "LdapABStore.makeConnection(): Error while creating connection: Invalid ldap host/port or admin credentials";
            ABDebug.logError(msg);
            throw new LDAPException(msg);
        }
        return ld;
    }

    LDAPConnection LDAPConnect() {
        ConnectionPool cp = (ConnectionPool)connPoolTable.get(this.ldapServer);
        if (cp == null) {
            return null;
        }
        LDAPConnection ld = cp.getConnection();
        return ld;
    }

    void LDAPClose(LDAPConnection ld) {
        ConnectionPool cp = (ConnectionPool)connPoolTable.get(this.ldapServer);
        if (cp != null) {
            cp.close(ld);
        }
    }

    private synchronized String pabTimeStamp() {
        long current = System.currentTimeMillis() / 1000L - 915170400L;
        lastPabTimeStamp = current > lastPabTimeStamp ? current : ++lastPabTimeStamp;
        return Long.toString(lastPabTimeStamp);
    }
}

