/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.cal.socs;

import com.sun.comclient.calendar.Attendee;
import com.sun.comclient.calendar.VAlarm;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.socs.SOCSEvent;
import com.sun.portal.wireless.taglibs.base.CollectionIterator;
import com.sun.portal.wireless.taglibs.base.Util;
import com.sun.portal.wireless.taglibs.cal.EventBean;
import com.sun.portal.wireless.taglibs.cal.socs.CalIdBean;
import com.sun.portal.wireless.taglibs.cal.socs.EmailReminderBean;
import com.sun.portal.wireless.taglibs.cal.socs.ReminderBean;
import java.util.StringTokenizer;
import java.util.Vector;

public class SOCSEventBean
extends EventBean {
    private SOCSEvent theEvent;
    private ReminderBean firstRemBean;

    public SOCSEventBean(SOCSEvent event) {
        super((VEvent)event);
        this.theEvent = event;
    }

    public VEvent getEvent() {
        return this.theEvent;
    }

    public boolean isCalIdTheOrganizer() throws Exception {
        String calId = this.theEvent.getCalID();
        if (!this.isNew()) {
            return this.theEvent.isCalIdTheOrganizer(calId);
        }
        return true;
    }

    public void setReply(String replyStatus) throws Exception {
        Attendee att = this.getCalIdAsAttendee();
        if (att != null) {
            att.setParticipantStatus(replyStatus);
        }
    }

    private Attendee getCalIdAsAttendee() {
        return this.theEvent.getAttendee(this.theEvent.getCalID());
    }

    public String getReply() throws Exception {
        Attendee att = this.getCalIdAsAttendee();
        if (att != null) {
            return att.getParticipantStatus();
        }
        return "";
    }

    public boolean isRecurrence() throws Exception {
        return this.theEvent.isRecurring();
    }

    public void setReminderBean(ReminderBean remBean) throws Exception {
        VAlarm[] alarms = this.theEvent.getAlarmComponents();
        try {
            if (alarms != null && alarms.length > 0) {
                Util.logMessage((String)"Removing Alarm ");
                this.theEvent.removeAlarmComponent(alarms[0]);
            }
            this.theEvent.addAlarmComponent(remBean.getAlarm());
        }
        catch (Exception e) {
            Util.logError((String)"** Setting failed for ReminderBean", (Throwable)e);
        }
    }

    public void setAttendees(String attListCalIds) throws Exception {
        StringTokenizer strTok = new StringTokenizer(attListCalIds, ",;");
        while (strTok.hasMoreTokens()) {
            String token = strTok.nextToken().trim();
            if (token.equals("")) continue;
            Attendee att = new Attendee("INDIVIDUAL", "REQ-PARTICIPANT", token);
            att.setRSVPRequired(true);
            this.component.addAttendee(att);
        }
    }

    public String getAttendees() throws Exception {
        if (this.component.getAttendees() != null) {
            Attendee[] attArr = this.component.getAttendees();
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < attArr.length; ++i) {
                Attendee att = attArr[i];
                result.append(att.getValue());
                if (i == attArr.length - 1) continue;
                result.append(",");
            }
            return result.toString();
        }
        return new String();
    }

    public boolean isAttendeesEmpty() {
        boolean result = true;
        try {
            result = !this.component.hasAttendee();
        }
        catch (Exception ex) {
            Util.logError((String)"failed in hasAttendee ", (Throwable)ex);
        }
        return result;
    }

    public CollectionIterator getAttendeesIterator() throws Exception {
        Vector<CalIdBean> result = new Vector<CalIdBean>();
        Attendee[] attArr = this.component.getAttendees();
        if (attArr != null) {
            for (int i = 0; i < attArr.length; ++i) {
                Attendee att = attArr[i];
                if (att == null) continue;
                result.add(new CalIdBean(att.getValue()));
            }
        }
        return new CollectionIterator(result);
    }

    public void setRemovedAttendee(String remove) throws Exception {
        StringTokenizer strTok = new StringTokenizer(remove, ",;");
        while (strTok.hasMoreTokens()) {
            Attendee[] attArr;
            String token = strTok.nextToken().trim();
            if (token.equals("") || (attArr = this.component.getAttendees()) == null) continue;
            for (int i = 0; i < attArr.length; ++i) {
                if (!attArr[i].getValue().equals(token)) continue;
                this.component.removeAttendee(attArr[i]);
            }
        }
    }

    public VAlarm getFirstAlarm() throws Exception {
        VAlarm firstAlarm = null;
        VAlarm[] alarms = this.theEvent.getAlarmComponents();
        if (alarms != null && alarms.length > 0) {
            firstAlarm = alarms[0];
        } else {
            firstAlarm = this.theEvent.createAlarm();
            this.theEvent.addAlarmComponent(firstAlarm);
        }
        if (firstAlarm == null) {
            throw new Exception("No alrams set or able to create");
        }
        return firstAlarm;
    }

    public ReminderBean getReminderBean() throws Exception {
        if (this.firstRemBean == null) {
            try {
                this.firstRemBean = this.toReminderBean(this.getFirstAlarm());
            }
            catch (Exception ex) {
                Util.logError((String)"getReminderBean", (Throwable)ex);
                throw ex;
            }
        }
        return this.firstRemBean;
    }

    protected ReminderBean toReminderBean(VAlarm alarm) {
        return new EmailReminderBean(alarm);
    }
}

