/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.deployment;

import com.sun.portal.desktop.deployment.ExtractOp;
import com.sun.portal.desktop.deployment.Par;
import com.sun.portal.desktop.deployment.ParEntryDomPPF;
import com.sun.portal.desktop.deployment.ParFileException;
import com.sun.portal.desktop.deployment.ParManifest;
import com.sun.portal.desktop.deployment.ParOutputStream;
import com.sun.portal.desktop.deployment.ProviderPackageFile;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import org.w3c.dom.Document;

public class ParFileBuilder {
    private HashMap m_FileLists = new HashMap();
    private ParManifest m_Man = null;
    private boolean m_DefaultManifest = true;
    private String m_CRoot;
    private String m_DPRoot;
    private String m_PBFRoot;
    private String m_SRoot;
    private boolean m_Verbose;
    private PrintStream m_Out;

    public ParFileBuilder(boolean verbose, PrintStream out) {
        this.m_Verbose = verbose;
        this.m_Out = out;
    }

    public ParFileBuilder(boolean verbose, PrintStream out, String classroot, String dproot, String pbfileroot, String statroot) {
        this(verbose, out);
        this.m_DefaultManifest = false;
        this.m_CRoot = classroot;
        this.m_DPRoot = dproot;
        this.m_PBFRoot = pbfileroot;
        this.m_SRoot = statroot;
    }

    public void clear() {
        this.m_FileLists.clear();
        this.m_Man = null;
    }

    public void addDPEntry(Document doc, Vector files, ExtractOp op) throws ParFileException {
        this.assureManifest();
        Vector fc = (Vector)files.clone();
        String name = Par.findDPEntryName(doc);
        Vector vold = (Vector)this.m_FileLists.get(name);
        if (vold != null) {
            int len = vold.size() - 1;
            for (int i = 0; i < len; ++i) {
                fc.add(vold.elementAt(i));
            }
        }
        if (this.m_Verbose) {
            Object[] tok = new Object[]{name};
            this.m_Out.println(Par.getLocalizedString("msgAddManifestEntry", tok));
        }
        if (vold == null) {
            this.m_Man.addDPEntry(name);
        }
        for (int i = 0; i < fc.size(); ++i) {
            ProviderPackageFile ppf = (ProviderPackageFile)fc.elementAt(i);
            ppf.addManifestInclusion(this.m_Man, name);
        }
        if (op != null) {
            this.m_Man.addDPEntryAutoExtract(name, op);
            if (this.m_Verbose) {
                this.m_Out.println("\tAutoextract - " + op.toArg());
            }
        }
        fc.add(new ParEntryDomPPF(doc, name));
        this.m_FileLists.put(name, fc);
    }

    public void addDPEntry(Document doc, Vector files) throws ParFileException {
        this.addDPEntry(doc, files, null);
    }

    public void makeParFile(String path) throws ParFileException {
        if (this.m_Man == null) {
            throw new ParFileException("errorEmptyPar");
        }
        if (this.m_Verbose) {
            Object[] tok = new Object[]{path};
            this.m_Out.println(Par.getLocalizedString("msgStreamingTo", tok));
        }
        try {
            ParOutputStream pos = new ParOutputStream(path, this.m_Man);
            Vector ev = this.m_Man.getDPEntryList();
            for (int i = 0; i < ev.size(); ++i) {
                String name = (String)ev.elementAt(i);
                this.streamEntry(pos, name);
            }
            pos.close();
        }
        catch (Exception ex) {
            throw new ParFileException("errorParStream", ex);
        }
        this.clear();
    }

    private void streamEntry(ParOutputStream pos, String name) throws ParFileException {
        Vector files = (Vector)this.m_FileLists.get(name);
        byte[] buf = new byte[4000];
        HashMap<String, String> namecheck = new HashMap<String, String>();
        try {
            for (int i = 0; i < files.size(); ++i) {
                int len;
                ProviderPackageFile ppf = (ProviderPackageFile)files.elementAt(i);
                ZipEntry ze = ppf.getZipEntry(this.m_Man);
                String nm = ze.getName();
                if (namecheck.get(nm) != null) continue;
                namecheck.put(nm, nm);
                if (this.m_Verbose) {
                    Object[] tok = new Object[]{nm};
                    this.m_Out.println(Par.getLocalizedString("msgArchiving", tok));
                }
                pos.putNextEntry(ze);
                InputStream is = ppf.getStream();
                while ((len = is.read(buf)) > 0) {
                    pos.write(buf, 0, len);
                }
                is.close();
            }
        }
        catch (Exception ex) {
            throw new ParFileException("errorParStream", ex);
        }
    }

    private void assureManifest() {
        if (this.m_Man != null) {
            return;
        }
        if (this.m_DefaultManifest) {
            this.m_Man = new ParManifest();
            return;
        }
        this.m_Man = new ParManifest(this.m_CRoot, this.m_DPRoot, this.m_PBFRoot, this.m_SRoot);
    }
}

