/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.ab;

import com.sun.addressbook.ABFilter;
import com.sun.addressbook.ABSearchTerm;
import com.sun.addressbook.ABStore;
import com.sun.addressbook.ABStoreException;
import com.sun.addressbook.AddressBook;
import com.sun.addressbook.Element;
import com.sun.addressbook.Entry;
import com.sun.addressbook.Group;
import com.sun.portal.wireless.taglibs.ab.ABContext;
import com.sun.portal.wireless.taglibs.base.Util;
import com.sun.ssoadapter.SSOAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;

public class ContactDB {
    private static final String instanceName = "ab-taglib";
    private static final String thisClass = "com.sun.portal.wireless.taglibs.ab.ContactDB";
    private SSOAdapter ssoAdapter = null;
    private ABStore abStore = null;
    private AddressBook ab = null;
    private static int NOT = 0;
    private static int AND = 1;
    private static int OR = 2;
    private static final String[] operators = new String[]{"NOT", "AND", "OR"};

    public ContactDB(SSOAdapter ssoAdapter, HttpServletRequest req, ABContext ctx) throws JspException {
        try {
            this.abStore = (ABStore)ssoAdapter.getConnection();
            this.ab = this.abStore.openAddressBook();
        }
        catch (Exception e) {
            throw new JspException("com.sun.portal.wireless.taglibs.ab.ContactDB::getSSOAdapter() failed. " + e);
        }
    }

    public SSOAdapter getSSOAdapter() {
        return this.ssoAdapter;
    }

    public ABStore getABStore() {
        return this.abStore;
    }

    public AddressBook getAddressBook() {
        return this.ab;
    }

    public void refreshAB() {
        try {
            this.abStore.disconnect();
            this.abStore.init(this.abStore.getSession());
            this.abStore.connect();
            this.ab = this.abStore.openAddressBook();
        }
        catch (Exception e) {
            Util.logWarning((String)("com.sun.portal.wireless.taglibs.ab.ContactDB::refreshAB() failed." + e));
        }
    }

    public ABFilter getABFilter() {
        return new ABFilter();
    }

    public boolean addElementToABook(Element element) {
        boolean success = true;
        try {
            this.getAddressBook().add(element);
        }
        catch (Exception abe) {
            success = false;
        }
        return success;
    }

    public boolean deleteElementFromABook(Element element) {
        boolean success = true;
        try {
            this.getAddressBook().delete(element);
        }
        catch (Exception abe) {
            success = false;
        }
        return success;
    }

    public boolean modifyElementFromABook(Element oldElement, Element newElement) {
        boolean success = true;
        try {
            this.getAddressBook().modify(oldElement, newElement);
        }
        catch (Exception abe) {
            Util.logError((String)"ContactDB: Modify Failed: ", (Throwable)abe);
            success = false;
        }
        return success;
    }

    public List listABook(String sortBy, String sortDir) throws JspException {
        String anyStr = "*";
        boolean exact = true;
        return this.searchABook(null, null, anyStr, sortBy, sortDir, exact);
    }

    public List searchABook(Entry searchEntry, Group group, String anyStr, String sortBy, String sortDir, boolean exact) throws JspException {
        ABSearchTerm term = null;
        AddressBook ab = this.getAddressBook();
        if (anyStr != null) {
            term = ab.newABSearchTerm("any", anyStr, exact);
        } else {
            ArrayList<ABSearchTerm> terms = new ArrayList<ABSearchTerm>();
            String searchFn = searchEntry.getFn();
            String searchLn = searchEntry.getLn();
            String searchEm = searchEntry.getEm();
            String searchBp = searchEntry.getBp();
            String searchHp = searchEntry.getHp();
            String searchMp = searchEntry.getMp();
            String searchFp = searchEntry.getFp();
            String searchPp = searchEntry.getPp();
            String searchCn = searchEntry.getCn();
            if (searchFn != null) {
                terms.add(ab.newABSearchTerm("fn", searchFn, exact));
            }
            if (searchLn != null) {
                terms.add(ab.newABSearchTerm("ln", searchLn, exact));
            }
            if (searchCn != null) {
                terms.add(ab.newABSearchTerm("cn", searchCn, exact));
            }
            if (searchEm != null) {
                terms.add(ab.newABSearchTerm("em", searchEm, exact));
            }
            if (searchBp != null) {
                terms.add(ab.newABSearchTerm("bp", searchBp, exact));
            }
            if (searchHp != null) {
                terms.add(ab.newABSearchTerm("hp", searchHp, exact));
            }
            if (searchMp != null) {
                terms.add(ab.newABSearchTerm("mp", searchMp, exact));
            }
            if (searchFp != null) {
                terms.add(ab.newABSearchTerm("fp", searchFp, exact));
            }
            if (searchPp != null) {
                terms.add(ab.newABSearchTerm("pp", searchPp, exact));
            }
            try {
                if (terms.size() == 1) {
                    term = (ABSearchTerm)terms.get(0);
                } else {
                    ABSearchTerm[] arrayTerms = terms.toArray(new ABSearchTerm[terms.size()]);
                    term = ab.newABSearchTerm(arrayTerms, 2);
                }
            }
            catch (Exception abse) {
                throw new JspException("com.sun.portal.wireless.taglibs.ab.ContactDB:: appendSearchTerm Failed. " + abse);
            }
        }
        Element[] elements = null;
        ABFilter filter = new ABFilter();
        if (group != null) {
            filter.setGroup(group);
        }
        if (sortBy != null) {
            filter.setSortBy(sortBy);
        }
        if (sortDir != null) {
            if (sortDir.equalsIgnoreCase("dsc")) {
                filter.setSortOrder(2);
            } else {
                filter.setSortOrder(1);
            }
        }
        if (searchEntry.getElementType() == 1 || searchEntry.getElementType() == -1) {
            filter.setElementType(1);
        } else {
            filter.setElementType(searchEntry.getElementType());
        }
        try {
            filter.setSearchTerm(term);
            elements = ab.fetch(filter);
        }
        catch (Exception e) {
            throw new JspException("com.sun.portal.wireless.taglibs.ab.ContactDB:: Search Failed. " + e);
        }
        ArrayList<Element> list = new ArrayList<Element>();
        if (elements != null && elements.length > 0) {
            for (int i = 0; i < elements.length; ++i) {
                list.add(elements[i]);
            }
        }
        return list;
    }

    public List getContacts(Group group, List list) throws JspException {
        ABFilter filter = new ABFilter();
        ABSearchTerm term = null;
        AddressBook ab = this.getAddressBook();
        term = ab.newABSearchTerm("any", "*", true);
        Element[] elements = null;
        if (group != null) {
            filter.setGroup(group);
        }
        filter.setElementType(3);
        try {
            filter.setSearchTerm(term);
            elements = ab.fetch(filter);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JspException("com.sun.portal.wireless.taglibs.ab.ContactDB:: Search Failed. " + e);
        }
        if (elements != null && elements.length > 0) {
            for (int i = 0; i < elements.length; ++i) {
                if (elements[i].getElementType() == 2) {
                    this.getContacts((Group)elements[i], list);
                    continue;
                }
                boolean found = false;
                for (int j = 0; j < list.size(); ++j) {
                    Element e = (Element)list.get(j);
                    if (!e.getUn().equals(elements[i].getUn())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                Entry e = (Entry)elements[i];
                list.add(e);
            }
        }
        return list;
    }

    public boolean addElementToGroup(Element element, Group group) {
        boolean success = true;
        try {
            this.getAddressBook().addGroupMember(element, group);
        }
        catch (Exception abe) {
            success = false;
        }
        return success;
    }

    public boolean deleteElementFromGroup(Element element, Group group) {
        boolean success = true;
        try {
            this.getAddressBook().deleteGroupMember(element, group);
        }
        catch (Exception abe) {
            success = false;
        }
        return success;
    }

    public void release() {
        try {
            this.abStore.disconnect();
        }
        catch (ABStoreException e) {
            Util.logError((String)"Disconnect Failed: ", (Throwable)e);
        }
    }
}

