/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.mail;

import com.iplanet.sso.SSOToken;
import com.sun.portal.providers.ProviderEditUtility;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.mail.MailApplicationHelper;
import com.sun.portal.providers.mail.MailProvider;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterDebug;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.UIDFolder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UWCMailHelper
implements MailApplicationHelper {
    protected String appName = "";
    public MailProvider provider = null;
    public SSOAdapter ssoAdapter = null;
    public Properties adapterProperties = null;
    public String charset = null;
    private long lastCheckTime = 0L;
    private long checkInterval;
    protected String containerName = "";
    protected String clientAppURL = null;

    public void init(MailProvider provider, SSOAdapter ssoAdapter) throws Exception {
        this.provider = provider;
        this.ssoAdapter = ssoAdapter;
        if (ssoAdapter != null) {
            this.adapterProperties = ssoAdapter.getProperties();
        }
        this.checkInterval = Integer.parseInt(this.adapterProperties.getProperty("checkInterval", "5000"));
        SSOToken token = ssoAdapter.getSSOToken();
        this.charset = token.getProperty("CharSet");
        SSOAdapterDebug.logMessage((String)("UWCMailHelper.init(): charset=" + this.charset));
    }

    public String getStartURL(MailProvider provider, HttpServletRequest request) {
        StringBuffer clientURL = new StringBuffer();
        String mailURL = "?argv=laurel=on";
        String host = this.adapterProperties.getProperty("host");
        String port = this.adapterProperties.getProperty("clientPort", "80");
        String protocol = this.adapterProperties.getProperty("clientProtocol", "http");
        clientURL.append(protocol + "://" + host + ":" + port);
        clientURL.append(mailURL);
        this.clientAppURL = clientURL.toString();
        SSOAdapterDebug.logMessage((String)("UWCMailHelper.getStartURL() clientURL=" + clientURL.toString()));
        return clientURL.toString();
    }

    public StringBuffer getAppPrefsEdit(MailProvider mprov, HttpServletRequest req, HttpServletResponse res) {
        StringBuffer content = new StringBuffer();
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        ProviderContext pc = mprov.getProviderContext();
        Map dpEditMap = null;
        String fontTag = "";
        try {
            List pflist = pc.getClientAndLocalePropertiesFilters();
            dpEditMap = pc.getCollectionProperty(mprov.getName(), "dpEditAttributes", pflist);
            fontTag = pc.getStringProperty(mprov.getName(), "fontFace1", "Sans-serif");
            tagTable.put("iwtDesktop-fontFace1", fontTag);
            tagTable.put("isAppHandler", this.getName());
        }
        catch (ProviderContextException pce) {
            pc.debugError((Object)"Exception thrown retrieving values from the display profile\n", (Throwable)pce);
        }
        if (dpEditMap != null) {
            try {
                ProviderEditUtility.setDefaultPresentation((String)this.provider.getName(), (ProviderContext)this.provider.getProviderContext(), tagTable);
                content.append(pc.getTemplate(this.provider.getName(), "edit-start.template", tagTable));
            }
            catch (ProviderContextException pce) {
                pc.debugError((Object)"Exception thrown retrieving values from the display profile\n", (Throwable)pce);
            }
            Set entries = dpEditMap.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                StringTokenizer tok = new StringTokenizer(value, "|");
                while (tok.hasMoreElements()) {
                    String type = tok.nextToken();
                    String header = tok.nextToken();
                    content.append(ProviderEditUtility.createEditContent((String)type, (String)header, (String)key, (String)mprov.getName(), (ProviderContext)pc, (boolean)true));
                }
            }
            try {
                ProviderEditUtility.setDefaultPresentation((String)this.provider.getName(), (ProviderContext)this.provider.getProviderContext(), tagTable);
                content.append(pc.getTemplate(this.provider.getName(), "edit-end.template", tagTable));
            }
            catch (ProviderContextException pce) {
                pc.debugError((Object)"Exception thrown retrieving values from the display profile\n", (Throwable)pce);
            }
        }
        return content;
    }

    public URL processAppPrefsEdit(MailProvider mprov, HttpServletRequest request, HttpServletResponse res) throws ProviderException {
        URL url = null;
        Object props = null;
        Map dpEditMap = null;
        ProviderContext pc = mprov.getProviderContext();
        StringBuffer returnURL = new StringBuffer();
        List pflist = null;
        try {
            url = this.getAppHelperProcessURL(request, mprov);
            pflist = pc.getClientAndLocalePropertiesFilters();
            dpEditMap = pc.getCollectionProperty(mprov.getName(), "dpEditAttributes", pflist);
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("UWCMailHelper.processAppPrefsEdit():\n", (Throwable)pce);
        }
        if (dpEditMap != null) {
            Set entries = dpEditMap.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                StringTokenizer tok = new StringTokenizer(value, "|");
                String type = tok.nextToken();
                try {
                    pc.debugMessage((Object)("UWCMailHelper.processAppPrefsEdit(): key=" + key));
                    if (type.equals("string") || type.equals("select") || type.equals("password")) {
                        String reqString = ProviderEditUtility.getRequestParameter((String)key, (HttpServletRequest)request);
                        if (reqString.equals("")) continue;
                        if (pc.existsStringProperty(mprov.getName(), key, pflist)) {
                            pc.setStringProperty(mprov.getName(), key, reqString, pflist);
                            pc.debugMessage((Object)("UWCMailHelper.processAppPrefsEdit(): reqString(filtered)=" + reqString));
                            continue;
                        }
                        if (pc.existsStringProperty(mprov.getName(), key)) {
                            pc.setStringProperty(mprov.getName(), key, reqString);
                            pc.debugMessage((Object)("UWCMailHelper.processAppPrefsEdit(): reqString=" + reqString));
                            continue;
                        }
                        pc.debugWarning((Object)("UWCMailHelper.processAppPrefsEdit(): Unable to save key=" + key));
                        continue;
                    }
                    if (type.equals("int")) {
                        String reqNumber = ProviderEditUtility.getRequestParameter((String)key, (HttpServletRequest)request);
                        int parsedInt = 0;
                        try {
                            parsedInt = Integer.parseInt(reqNumber);
                        }
                        catch (NumberFormatException nfe) {
                            parsedInt = 0;
                            pc.debugWarning((Object)("UWCMailHelper.processAppPrefsEdit(): key=" + key + " is not an integer, setting value to 0"));
                        }
                        if (reqNumber.equals("")) continue;
                        if (pc.existsIntegerProperty(mprov.getName(), key, pflist)) {
                            pc.setIntegerProperty(mprov.getName(), key, parsedInt, pflist);
                            continue;
                        }
                        if (pc.existsIntegerProperty(mprov.getName(), key)) {
                            pc.setIntegerProperty(mprov.getName(), key, parsedInt);
                            continue;
                        }
                        pc.debugWarning((Object)("UWCMailHelper.processAppPrefsEdit(): Unable to save key=" + key));
                        continue;
                    }
                    if (!type.equals("check")) continue;
                    String reqBool = ProviderEditUtility.getRequestParameter((String)key, (HttpServletRequest)request);
                    Boolean bool = null;
                    bool = reqBool.equals("") ? new Boolean("false") : new Boolean("true");
                    if (pc.existsBooleanProperty(mprov.getName(), key, pflist)) {
                        pc.setBooleanProperty(mprov.getName(), key, bool.booleanValue(), pflist);
                        continue;
                    }
                    if (pc.existsBooleanProperty(mprov.getName(), key)) {
                        pc.setBooleanProperty(mprov.getName(), key, bool.booleanValue());
                        continue;
                    }
                    pc.debugWarning((Object)("UWCMailHelper.processAppPrefsEdit(): Unable to save key=" + key));
                }
                catch (ProviderContextException pce) {
                    throw new ProviderException("UWCMailHelper.processAppPrefsEdit():\n", (Throwable)pce);
                }
            }
        }
        pc.debugMessage((Object)("UWCMailHelper::processAppPrefsEdit:  Return url = " + url.toString()));
        return url;
    }

    public String getMessageURL(MailProvider provider, HttpServletRequest request, Message message) throws Exception {
        StringBuffer clientURL = new StringBuffer();
        Folder folder = message.getFolder();
        if (this.clientAppURL != null) {
            clientURL.append(this.clientAppURL);
        } else {
            this.clientAppURL = this.getStartURL(provider, request);
            clientURL.append(this.clientAppURL);
        }
        clientURL.append("&argv=mbox=");
        clientURL.append(this.encode(message.getFolder().getFullName()));
        clientURL.append("&argv=msg=");
        clientURL.append(((UIDFolder)folder).getUID(message));
        return clientURL.toString();
    }

    public String getAppHelperEditLink(HttpServletRequest req, ProviderContext pc) {
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        StringBuffer link = new StringBuffer();
        try {
            link.append(pc.getDesktopURL(req));
        }
        catch (Exception e) {
            return "";
        }
        link.append("?action=edit&provider=");
        link.append(ProviderEditUtility.getRequestParameter((String)"provider", (HttpServletRequest)req));
        link.append("&targetprovider=" + this.provider.getName());
        link.append("&containerName=");
        link.append(ProviderEditUtility.getRequestParameter((String)"containerName", (HttpServletRequest)req));
        link.append("&appPref=" + this.getName());
        tagTable.put("editLink", link.toString());
        String content = null;
        try {
            String fontTag = pc.getStringProperty(this.provider.getName(), "fontFace1", "Sans-serif");
            tagTable.put("iwtDesktop-fontFace1", fontTag);
            ProviderEditUtility.setDefaultPresentation((String)this.provider.getName(), (ProviderContext)this.provider.getProviderContext(), tagTable);
            content = pc.getTemplate(this.provider.getName(), "edit-link.template", tagTable).toString();
            pc.debugMessage((Object)("content = \n" + content.toString()));
        }
        catch (Exception e) {
            pc.debugError((Object)"unable to create hyperlink\n", (Throwable)e);
            content = "";
        }
        pc.debugMessage((Object)("LDAPABApplicationHelper: returned value is" + content.toString()));
        return content;
    }

    protected URL getAppHelperProcessURL(HttpServletRequest req, MailProvider prov) {
        ProviderContext pc = prov.getProviderContext();
        StringBuffer link = new StringBuffer();
        URL returnURL = null;
        try {
            link.append(pc.getDesktopURL(req));
        }
        catch (Exception e) {
            return null;
        }
        String provider = prov.editContainer;
        String targetProvider = prov.targetProvider;
        String containerName = prov.containerName;
        pc.debugMessage((Object)("UWCMailHelper.getAppHelperProcessURL():     provider=" + provider + "\n                                                    targetProvider=" + targetProvider + "\n                                                    containerName=" + containerName));
        if (this.isEmpty(provider) || this.isEmpty(targetProvider) || this.isEmpty(containerName)) {
            pc.debugWarning((Object)"getAppHelperProcessURL():  Missing returnURL parameter and attempting to generate default desktop URL\n");
            try {
                returnURL = new URL(link.toString());
            }
            catch (Exception e) {
                pc.debugWarning((Object)"getAppHelperProcessURL():  Unable to generate default desktop URL\n", (Throwable)e);
                return null;
            }
        }
        link.append("?action=edit&provider=" + provider);
        link.append("&targetprovider=" + targetProvider);
        link.append("&containerName=" + containerName);
        try {
            returnURL = new URL(link.toString());
            pc.debugMessage((Object)("UWCMailHelper:getAppHelperProcessURL():  returnURL =" + returnURL));
        }
        catch (Exception e) {
            pc.debugError((Object)"Unable to create returnURL", (Throwable)e);
            return null;
        }
        return returnURL;
    }

    protected boolean isEmpty(String line) {
        return line == null || line.length() > 0;
    }

    public String encode(String enc) {
        String result = "";
        try {
            result = URLEncoder.encode(enc, this.charset);
        }
        catch (UnsupportedEncodingException uee) {
            SSOAdapterDebug.logWarning((String)"UWCMailHelper.encode():  Exception thrown encoding string. Returning unencoded string.", (Throwable)uee);
            return enc;
        }
        return result;
    }

    public void setName(String name) {
        this.appName = name;
    }

    public String getName() {
        return this.appName;
    }
}

