/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.mail;

import com.sun.portal.providers.ProfileProviderAdapter;
import com.sun.portal.providers.ProviderAdapter;
import com.sun.portal.providers.ProviderEditUtility;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.mail.MailApplicationHelper;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterException;
import com.sun.ssoadapter.SSOAdapterFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;
import javax.mail.search.AndTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MailProvider
extends ProfileProviderAdapter {
    private boolean genericHTML = true;
    private HttpServletRequest req = null;
    private ResourceBundle bundle = null;
    protected HashMap appHandlers = null;
    private Store store = null;
    protected SSOAdapterFactory adapterFactory = null;
    protected String editContainer = "";
    protected String targetProvider = "";
    protected String containerName = "";
    protected boolean isSSOConfigFound = true;
    protected List pflist = null;
    protected Boolean isPresentable = null;
    Hashtable mailValuePairs = new Hashtable();
    private static final int PREDEFINED_REPLIES_LENGTH = 9;
    static final Comparator DATE_ORDER = new Comparator(){

        public int compare(Object o1, Object o2) {
            try {
                Message m1 = (Message)o1;
                Message m2 = (Message)o2;
                Date d1 = m1.getReceivedDate();
                Date d2 = m2.getReceivedDate();
                return d1.compareTo(d2);
            }
            catch (MessagingException e) {
                return 0;
            }
        }
    };
    static final SearchTerm nonDeletedSearch = new FlagTerm(new Flags(Flags.Flag.DELETED), false);
    static final SearchTerm unReadSearch = new AndTerm(new SearchTerm[]{new FlagTerm(new Flags(Flags.Flag.SEEN), false), nonDeletedSearch});

    public void init(String n, HttpServletRequest request) throws ProviderException {
        super.init(n, request);
        try {
            this.pflist = this.getProviderContext().getClientAndLocalePropertiesFilters();
        }
        catch (ProviderContextException pce) {
            this.getProviderContext().debugWarning((Object)"MailProvider.init():  Unable to retrieve DP filters");
        }
        this.req = request;
        this.appHandlers = new HashMap();
        this.bundle = this.getResourceBundle();
        this.adapterFactory = SSOAdapterFactory.getInstance();
        try {
            SSOAdapter ssoAdapter = this.adapterFactory.getSSOAdapter(this.getBestStringProperty("ssoAdapter", this.pflist), request, this.getProviderContext().getLocale(), this.getProviderContext().getUserID(), this.getName());
        }
        catch (SSOAdapterException ssoe) {
            this.isSSOConfigFound = false;
            this.getProviderContext().debugWarning((Object)(this.getName() + " not presentable, ssoAdapter not found: " + ssoe.getMessage()));
        }
        if (!this.getProviderContext().isAuthless(request)) {
            this.isPresentable = this.isPresentable(request) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public StringBuffer getContent(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        StringBuffer content = new StringBuffer();
        Hashtable<String, CharSequence> contentTags = new Hashtable<String, CharSequence>();
        contentTags.put("iwtDesktop-fontFace1", this.getBestStringProperty("fontFace1", "Sans-serif", this.pflist));
        SSOAdapter ssoAdapter = null;
        try {
            ssoAdapter = this.adapterFactory.getSSOAdapter(this.getBestStringProperty("ssoAdapter", this.pflist), request, this.getProviderContext().getLocale(), this.getProviderContext().getUserID(), this.getName());
            this.store = (Store)ssoAdapter.getConnection();
            ProviderEditUtility.setDefaultPresentation((String)this.getName(), (ProviderContext)this.getProviderContext(), contentTags);
        }
        catch (SSOAdapterException ssoe) {
            this.getProviderContext().debugMessage((Object)"MailProvider.getContent(): Failed to get SSOAdapter. ", (Throwable)ssoe);
            String errMsg = this.bundle.getString("MailProvider-ssoerror");
            StringBuffer summary = this.getErrorContent(errMsg);
            contentTags.put("mail-display-summary", summary);
            return this.getTemplate("display.template", contentTags);
        }
        catch (Exception e) {
            this.getProviderContext().debugMessage((Object)"MailProvider.getContent(): Failed to get connection. ");
            String errMsg = this.bundle.getString("MailProvider-loginerr");
            StringBuffer summary = this.getErrorContent(errMsg);
            contentTags.put("mail-display-summary", summary);
            return this.getTemplate("display.template", contentTags);
        }
        if (ssoAdapter != null && this.store != null) {
            String eprc;
            Folder inbox = null;
            Message[] nonDeletedMessages = null;
            Message[] unReadMessages = null;
            try {
                inbox = this.store.getFolder("INBOX");
                inbox.open(1);
                nonDeletedMessages = inbox.search(nonDeletedSearch);
                unReadMessages = inbox.search(unReadSearch, nonDeletedMessages);
            }
            catch (Exception e) {
                this.getProviderContext().debugMessage((Object)"MailProvider.getContent(): Failed to get connection. ");
                String errMsg = this.bundle.getString("MailProvider-loginerr");
                StringBuffer summary = this.getErrorContent(errMsg);
                contentTags.put("mail-display-summary", summary);
                return this.getTemplate("display.template", contentTags);
            }
            String applicationURL = "";
            MailApplicationHelper appHelper = null;
            String appHelperClass = "";
            appHelperClass = this.getBestStringProperty("applicationHelperURL", this.pflist);
            if (appHelperClass != null) {
                appHelper = this.getMailAppHelper(ssoAdapter, appHelperClass, true);
                applicationURL = appHelper != null ? this.getApplicationStartURL(appHelper, request) : null;
                if (applicationURL != null) {
                    contentTags.put("mail-display-clientURL", this.getClientURLContent(applicationURL));
                } else {
                    contentTags.put("mail-display-clientURL", "");
                    this.getProviderContext().debugWarning((Object)"applicationURL is null");
                }
            } else {
                contentTags.put("mail-display-clientURL", "");
            }
            if (inbox != null && nonDeletedMessages != null) {
                contentTags.put("mail-display-summary", this.getSummaryContent(nonDeletedMessages, unReadMessages));
                boolean displayHeaders = this.getBestBooleanProperty("displayHeaders", true, this.pflist);
                StringBuffer headers = new StringBuffer();
                if (displayHeaders) {
                    try {
                        headers = this.getHeadersContent(appHelper, request, inbox, nonDeletedMessages, unReadMessages);
                    }
                    catch (MessagingException e) {
                        String msg = this.bundle.getString("MailProvider-hdrerr");
                        if (this.getProviderContext().isDebugMessageEnabled()) {
                            this.getProviderContext().debugMessage((Object)"MailProvider.getContent(): retrieving headers", (Throwable)e);
                        }
                        headers = this.getErrorContent(msg);
                    }
                }
                contentTags.put("mail-display-headers", headers);
            }
            content.append(this.getTemplate("display.template", contentTags));
            Properties props = ssoAdapter.getProperties();
            if (props != null && (eprc = props.getProperty("enablePerRequestConnection", "true")) != null && eprc.equals("true")) {
                ssoAdapter.closeConnection();
            }
        } else {
            if (ssoAdapter != null && ssoAdapter.getName().endsWith("_" + this.getName())) {
                return this.getErrorContent(this.bundle.getString("MailProvider-loginerr"));
            }
            return this.getErrorContent(this.bundle.getString("MailProvider-noConfig"));
        }
        return content;
    }

    public StringBuffer getEdit(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        StringBuffer content = new StringBuffer();
        SSOAdapter ssoAdapter = null;
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        this.editContainer = request.getParameter("provider");
        this.targetProvider = request.getParameter("targetprovider");
        this.containerName = request.getParameter("containerName");
        this.getProviderContext().debugMessage((Object)("Mail.getEdit():     editContainer=" + this.editContainer + "\n                        targetProvider=" + this.targetProvider + "\n                        containerName=" + this.containerName));
        try {
            ssoAdapter = this.adapterFactory.getSSOAdapter(this.getBestStringProperty("ssoAdapter", this.pflist), request, this.getProviderContext().getLocale(), this.getProviderContext().getUserID(), this.getName());
            ProviderEditUtility.setDefaultPresentation((String)this.getName(), (ProviderContext)this.getProviderContext(), tagTable);
        }
        catch (Exception e) {
            this.getProviderContext().debugMessage((Object)"MailProvider.processEdit(): No SSO Adapter Found for user", (Throwable)e);
        }
        String appPref = ProviderEditUtility.getRequestParameter((String)"appPref", (HttpServletRequest)request);
        if (!appPref.equals("")) {
            MailApplicationHelper mah = this.getMailAppHelper(ssoAdapter, appPref, false);
            content = mah.getAppPrefsEdit(this, request, response);
        } else {
            String fontTag = this.getBestStringProperty("fontFace1", "Sans-serif", this.pflist);
            tagTable.put("iwtDesktop-fontFace1", fontTag);
            content.append(this.getTemplate("edit-start.template", tagTable));
            ProviderEditUtility.editContainer = this.editContainer;
            ProviderEditUtility.container = this.containerName;
            try {
                content.append(ProviderEditUtility.getSSOAdapterPrefs((ProviderAdapter)this, (SSOAdapter)ssoAdapter));
            }
            catch (Exception e) {
                this.getProviderContext().debugWarning((Object)"MailProvider.processEdit(): Failed to get SSOAdapter attributes ", (Throwable)e);
            }
            content.append(this.getTemplate("edit-end.template", tagTable));
            MailApplicationHelper mah = null;
            Map appHelperClasses = this.getAppHandlerMap();
            if (appHelperClasses == null) {
                this.getProviderContext().debugError((Object)"Application Helper map is null");
            } else {
                Iterator iter = appHelperClasses.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry appClass = iter.next();
                    String appHelperClass = (String)appClass.getValue();
                    mah = this.getMailAppHelper(ssoAdapter, appHelperClass, true);
                    String link = "";
                    if (mah == null) {
                        this.getProviderContext().debugWarning((Object)"MailApplicationHelper is null");
                    } else {
                        link = mah.getAppHelperEditLink(request, this.getProviderContext());
                    }
                    if (link != null || !link.equals("")) {
                        content.append(link);
                        continue;
                    }
                    this.getProviderContext().debugWarning((Object)"MailProvider.getEdit():  returned a null or empty string");
                }
            }
        }
        return content;
    }

    public URL processEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        URL returnURL;
        block9: {
            SSOAdapter ssoAdapter = null;
            returnURL = null;
            try {
                ssoAdapter = this.adapterFactory.getSSOAdapter(this.getBestStringProperty("ssoAdapter", this.pflist), req, this.getProviderContext().getLocale(), this.getProviderContext().getUserID(), this.getName());
            }
            catch (SSOAdapterException ssoe) {
                this.getProviderContext().debugMessage((Object)"MailProvider.processEdit(): No SSO Adapter Found for user", (Throwable)ssoe);
            }
            String appPref = ProviderEditUtility.getRequestParameter((String)"appPref", (HttpServletRequest)req);
            this.getProviderContext().debugMessage((Object)("MailProvider.processEdit(): editContainer=" + this.editContainer + "\n                            targetProvider=" + this.targetProvider + "\n                            containerName=" + this.containerName + "\n                            appPref=" + appPref));
            MailApplicationHelper mah = null;
            if (!appPref.equals("")) {
                mah = this.getMailAppHelper(ssoAdapter, appPref, false);
                if (mah == null) {
                    this.getProviderContext().debugError((Object)"MailApplicationHandler is null");
                    returnURL = null;
                } else {
                    returnURL = mah.processAppPrefsEdit(this, req, res);
                    this.getProviderContext().debugMessage((Object)("returnURL = " + returnURL));
                }
            } else {
                SSOAdapter newAdapter = null;
                try {
                    newAdapter = ProviderEditUtility.setSSOAdapterPrefs((ProviderAdapter)this, (SSOAdapter)ssoAdapter, (SSOAdapterFactory)this.adapterFactory, (HttpServletRequest)req);
                    returnURL = ProviderEditUtility.getErrorURL();
                    if (returnURL == null && newAdapter != null) {
                        this.getProviderContext().debugMessage((Object)"MailProvider::processEdit():  Resetting the app helpers ssoAdapter");
                        appPref = this.getBestStringProperty("applicationHelperURL", this.pflist);
                        mah = this.getMailAppHelper(ssoAdapter, appPref, false);
                        mah.init(this, newAdapter);
                    }
                }
                catch (Exception e) {
                    this.getProviderContext().debugError((Object)"Unable to save the users SSOAdapter preferences", (Throwable)e);
                    returnURL = ProviderEditUtility.getErrorURL();
                    if (returnURL == null) break block9;
                    this.getProviderContext().debugWarning((Object)("returnURL =" + returnURL.toString()));
                }
            }
        }
        return returnURL;
    }

    protected Map getAppHandlerMap() {
        Map appHelperClasses = null;
        appHelperClasses = this.getBestCollectionProperty("applicationHelperEdit", this.pflist);
        return appHelperClasses;
    }

    private MailApplicationHelper getMailAppHelper(SSOAdapter ssoAdapter, String applicationHelperName, boolean safe) {
        MailApplicationHelper abApplicationHelper = null;
        if (ssoAdapter == null) {
            this.getProviderContext().debugError((Object)"MailProvider.getMailAppHandler(): ssoAdapter is null");
            return null;
        }
        if (this.getProviderContext().isDebugMessageEnabled()) {
            this.getProviderContext().debugMessage((Object)"MailProvider.getMailAppHandler(): ssoAdapter is not null");
        }
        if (applicationHelperName == null) {
            this.getProviderContext().debugError((Object)"MailProvider.getMailAppHandler(): applicationHelperName is null");
            return null;
        }
        if (this.getProviderContext().isDebugMessageEnabled()) {
            this.getProviderContext().debugMessage((Object)("MailProvider.getMailAppHandler(): applicationHelperName is " + applicationHelperName));
        }
        boolean validClass = safe;
        this.getProviderContext().debugMessage((Object)("MailProvider.getMailAppHandler(): validClass ==" + validClass));
        if (!safe) {
            Map validAppHelpers = this.getAppHandlerMap();
            validClass = validAppHelpers != null ? validAppHelpers.containsKey(applicationHelperName) : false;
        }
        if (this.getProviderContext().isDebugMessageEnabled()) {
            Set keys = this.appHandlers.keySet();
            Iterator iter = keys.iterator();
            this.getProviderContext().debugMessage((Object)"MailProvider.getMailAppHandler(): appHandlers keys include:");
            while (iter.hasNext()) {
                this.getProviderContext().debugMessage((Object)("MailProvider.getMailAppHandler(): validAppHelper key = " + (String)iter.next()));
            }
        }
        boolean appHandlerCached = ProviderEditUtility.isAppHandlerSet((HashMap)this.appHandlers, (String)applicationHelperName);
        this.getProviderContext().debugMessage((Object)("MailProvider.getMailAppHandler(): appHandlerCached=" + appHandlerCached));
        if (appHandlerCached) {
            this.getProviderContext().debugMessage((Object)("MailProvider.getMailAppHandler(): App Handler " + applicationHelperName + " is being retrieved."));
            abApplicationHelper = (MailApplicationHelper)this.appHandlers.get(applicationHelperName);
            return abApplicationHelper;
        }
        if (validClass) {
            this.getProviderContext().debugMessage((Object)("MailProvider.getMailAppHandler(): App Handler " + applicationHelperName + " is not cached."));
            try {
                Class<?> applicationHelperClass = Class.forName(applicationHelperName);
                Class[] argConst = new Class[]{};
                Constructor<?> applicationHelperConst = applicationHelperClass.getConstructor(argConst);
                Object[] argConstObj = new Object[]{};
                abApplicationHelper = (MailApplicationHelper)applicationHelperConst.newInstance(argConstObj);
            }
            catch (ClassNotFoundException cnfe) {
                this.getProviderContext().debugError((Object)"MailProvider.getMailAppHelper(): ", (Throwable)cnfe);
            }
            catch (NoSuchMethodException nsme) {
                this.getProviderContext().debugError((Object)"MailProvider.getMailAppHelper(): ", (Throwable)nsme);
            }
            catch (InstantiationException ine) {
                this.getProviderContext().debugError((Object)"MailProvider.getMailAppHelper(): ", (Throwable)ine);
            }
            catch (IllegalAccessException iae) {
                this.getProviderContext().debugError((Object)"MailProvider.getMailAppHelper(): ", (Throwable)iae);
            }
            catch (InvocationTargetException ite) {
                this.getProviderContext().debugError((Object)"MailProvider.getMailAppHelper(): ", (Throwable)ite);
            }
            try {
                abApplicationHelper.init(this, ssoAdapter);
            }
            catch (Exception e) {
                this.getProviderContext().debugWarning((Object)("MailProvider:getMailAppHelper(): Unable to call init() for " + applicationHelperName), (Throwable)e);
                return null;
            }
            if (abApplicationHelper != null) {
                this.getProviderContext().debugMessage((Object)("MailProvider:getMailAppHelper:  Saving app helper " + applicationHelperName + " to the internal map"));
                this.appHandlers.put(applicationHelperName, abApplicationHelper);
                abApplicationHelper.setName(applicationHelperName);
                return abApplicationHelper;
            }
            return null;
        }
        return null;
    }

    protected String getApplicationStartURL(MailApplicationHelper mailApplicationHelper, HttpServletRequest request) {
        String applicationURLString = null;
        if (mailApplicationHelper != null) {
            applicationURLString = mailApplicationHelper.getStartURL(this, request);
        }
        return applicationURLString;
    }

    private StringBuffer getHeadersContent(MailApplicationHelper appHelper, HttpServletRequest request, Folder inbox, Message[] nonDeletedMessages, Message[] unReadMessages) throws ProviderException, MessagingException {
        Hashtable<String, CharSequence> tags = new Hashtable<String, CharSequence>();
        StringBuffer content = null;
        String sso_uri = null;
        try {
            ProviderEditUtility.setDefaultPresentation((String)this.getName(), (ProviderContext)this.getProviderContext(), tags);
        }
        catch (ProviderContextException pce) {
            this.getProviderContext().debugError((Object)"MailProvider.getHeadersContent(): Exception thrown:\n", (Throwable)pce);
        }
        Locale userLocale = this.getProviderContext().getLocale();
        String userTZ = this.getStringAttribute("preferredtimezone");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, userLocale);
        if (userTZ == null || userTZ.length() == 0) {
            userTZ = TimeZone.getDefault().getID();
        }
        TimeZone userTimeZone = TimeZone.getTimeZone(userTZ);
        dateFormat.setTimeZone(userTimeZone);
        tags.put("mail-display-headers-subject", this.bundle.getString("MailProvider-subj"));
        tags.put("mail-display-headers-from", this.bundle.getString("MailProvider-from"));
        tags.put("mail-display-headers-date", this.bundle.getString("MailProvider-date"));
        tags.put("mail-display-headers-status", this.bundle.getString("MailProvider-stat"));
        tags.put("iwtDesktop-fontFace1", this.getBestStringProperty("fontFace1", "Sans-serif", this.pflist));
        int max = this.getBestIntegerProperty("numberHeaders", 0, this.pflist);
        if (max > 30) {
            max = 30;
        }
        if (nonDeletedMessages.length == 0 || max == 0) {
            return new StringBuffer();
        }
        LinkedList<Message> messageSubSetList = new LinkedList<Message>();
        int startIndex = 0;
        int endIndex = nonDeletedMessages.length;
        if (endIndex > max) {
            startIndex = endIndex - max;
        }
        for (int i = startIndex; i < endIndex; ++i) {
            messageSubSetList.add(nonDeletedMessages[i]);
        }
        Collections.sort(messageSubSetList, DATE_ORDER);
        Object[] sortedMsgs = messageSubSetList.toArray();
        if (sortedMsgs.length == 0) {
            String errmsg = this.bundle.getString("MailProvider-nomsgerr");
            return this.getErrorContent(errmsg);
        }
        if (this.getProviderContext().isDebugMessageEnabled()) {
            this.getProviderContext().debugMessage((Object)("MailProvider.getHeaders() non-deleted/sorted: " + sortedMsgs.length));
        }
        Date date = null;
        int displayed = max;
        int count = 0;
        boolean top = this.getBestStringProperty("sortOrder", "top", this.pflist).equalsIgnoreCase("top");
        count = top ? sortedMsgs.length - 1 : (max > sortedMsgs.length ? 0 : sortedMsgs.length - max);
        String read = this.bundle.getString("MailProvider-read");
        String unread = this.bundle.getString("MailProvider-unread");
        String cbgc = this.bundle.getString("MailProvider-cbgc");
        StringBuffer messageList = new StringBuffer();
        while (displayed > 0) {
            Message msg = (Message)sortedMsgs[count];
            if (msg == null) continue;
            Hashtable<String, String> msgTags = new Hashtable<String, String>();
            try {
                ProviderEditUtility.setDefaultPresentation((String)this.getName(), (ProviderContext)this.getProviderContext(), msgTags);
            }
            catch (ProviderContextException pce) {
                this.getProviderContext().debugError((Object)"MailProvider.getHeadersContent(): Exception thrown:\n", (Throwable)pce);
            }
            msgTags.put("mail-display-headers-message-cbgc", cbgc);
            msgTags.put("iwtDesktop-fontFace1", this.getBestStringProperty("fontFace1", "Sans-serif", this.pflist));
            String subject = this.decodeWords(msg.getSubject());
            subject = subject != null && subject.length() != 0 ? this.mungeAddress(subject) : this.bundle.getString("MailProvider-nosubject");
            try {
                sso_uri = appHelper.getMessageURL(this, request, msg);
            }
            catch (Exception e) {
                sso_uri = null;
            }
            if (sso_uri != null && sso_uri.length() != 0) {
                Hashtable<String, String> linkTags = new Hashtable<String, String>();
                try {
                    ProviderEditUtility.setDefaultPresentation((String)this.getName(), (ProviderContext)this.getProviderContext(), linkTags);
                }
                catch (ProviderContextException pce) {
                    this.getProviderContext().debugError((Object)"MailProvider.getHeadersContent(): Exception thrown:\n", (Throwable)pce);
                }
                linkTags.put("link", sso_uri);
                linkTags.put("name", subject);
                try {
                    subject = this.getTemplate("url.template", linkTags).toString();
                }
                catch (ProviderException pe) {
                    this.getProviderContext().debugMessage((Object)"MailProvider.getHeadersContent() could not find url.template. ", (Throwable)pe);
                }
            } else {
                sso_uri = "";
            }
            msgTags.put("mail-display-headers-message-clientURL", sso_uri);
            msgTags.put("mail-display-headers-message-subject", subject);
            Address[] addrArray = msg.getFrom();
            String address = addrArray != null && addrArray.length > 0 ? addrArray[0].toString() : "";
            String name = address;
            try {
                if (address != null && address.length() != 0) {
                    InternetAddress ia = new InternetAddress(address);
                    address = ia.getAddress();
                    name = ia.getPersonal();
                    if ((name == null || name.length() == 0) && address != null && address.length() != 0) {
                        name = this.mungeAddress(address);
                    }
                }
            }
            catch (AddressException e) {
                // empty catch block
            }
            msgTags.put("mail-display-headers-message-mailto", address);
            msgTags.put("mail-display-headers-message-name", name);
            date = msg.getReceivedDate();
            if (date == null) {
                msgTags.put("mail-display-headers-message-date", "-");
            } else {
                msgTags.put("mail-display-headers-message-date", dateFormat.format(date));
            }
            String mstat = unread;
            if (msg.getFlags().contains(Flags.Flag.SEEN)) {
                mstat = read;
            }
            msgTags.put("mail-display-headers-message-status", mstat);
            StringBuffer msgContent = this.getTemplate("display-headers-message.template", msgTags);
            messageList.append(msgContent);
            count = top ? --count : ++count;
            if (count < 0 || count >= sortedMsgs.length) break;
            --displayed;
        }
        tags.put("mail-display-headers-messageList", messageList);
        content = this.getTemplate("display-headers.template", tags);
        return content;
    }

    private String mungeAddress(String addr) {
        if (addr == null) {
            return null;
        }
        try {
            return this.getProviderContext().escape(addr);
        }
        catch (ProviderContextException e) {
            this.getProviderContext().debugError((Object)(this.getName() + ".escapeContent():"), (Throwable)e);
            return addr;
        }
    }

    private StringBuffer getClientURLContent(String sso_uri) throws ProviderException {
        Hashtable<String, String> clientURLTags = new Hashtable<String, String>();
        if (sso_uri != null && sso_uri.length() != 0) {
            clientURLTags.put("mail-display-clientURL-uri", sso_uri);
        } else {
            clientURLTags.put("mail-display-clientURL-uri", "");
        }
        StringBuffer clientURL = new StringBuffer();
        try {
            ProviderEditUtility.setDefaultPresentation((String)this.getName(), (ProviderContext)this.getProviderContext(), clientURLTags);
            clientURL = this.getTemplate("display-clientURL.template", clientURLTags);
        }
        catch (ProviderContextException pce) {
            this.getProviderContext().debugError((Object)"MailProvider.getClientURLContent(): Exception thrown: \n ", (Throwable)pce);
        }
        return clientURL;
    }

    private StringBuffer getErrorContent(String msg) throws ProviderException {
        Hashtable<String, String> errorTags = new Hashtable<String, String>();
        errorTags.put("mail-display-error", msg);
        try {
            ProviderEditUtility.setDefaultPresentation((String)this.getName(), (ProviderContext)this.getProviderContext(), errorTags);
        }
        catch (ProviderContextException pce) {
            this.getProviderContext().debugError((Object)"MailProvider.getErrorContent(): Exception thrown: \n ", (Throwable)pce);
        }
        StringBuffer error = this.getTemplate("display-error.template", errorTags);
        return error;
    }

    private StringBuffer getSummaryContent(Message[] nonDeletedMessages, Message[] unReadMessages) throws ProviderException {
        int unread = unReadMessages.length;
        int total = nonDeletedMessages.length;
        StringBuffer summary = null;
        Hashtable<String, String> summaryTags = new Hashtable<String, String>();
        summaryTags.put("mail-display-summary-unread", Integer.toString(unread));
        summaryTags.put("mail-display-summary-total", Integer.toString(total));
        summaryTags.put("iwtDesktop-fontFace1", this.getBestStringProperty("fontFace1", "Sans-serif", this.pflist));
        try {
            ProviderEditUtility.setDefaultPresentation((String)this.getName(), (ProviderContext)this.getProviderContext(), summaryTags);
            summary = this.getTemplate("display-summary.template", summaryTags);
        }
        catch (ProviderContextException pce) {
            this.getProviderContext().debugError((Object)"MailProvider.getSummaryContent(): Exception thrown: \n ", (Throwable)pce);
        }
        return summary;
    }

    public boolean isPresentable(HttpServletRequest request) {
        boolean ip = false;
        try {
            this.getTemplate("display.template");
        }
        catch (ProviderException pe) {
            this.getProviderContext().debugError((Object)(this.getName() + " Not presentable 'display.template' not found."));
            return false;
        }
        if (this.isPresentable != null) {
            ip = this.isPresentable;
            return ip && this.isSSOConfigFound;
        }
        return this.isSSOConfigFound;
    }

    private String decodeWords(String t) {
        int i = 0;
        int j = 0;
        StringBuffer str = new StringBuffer();
        try {
            while ((i = t.indexOf("=?", j)) >= 0) {
                str.append(t.substring(0, i));
                t = MimeUtility.decodeText((String)t.substring(i, t.length()));
                j = 1;
            }
            str.append(t);
            return str.toString();
        }
        catch (Exception e) {
            return t;
        }
    }

    public String getBestStringProperty(String key, String def, List pflist) {
        ProviderContext pc = this.getProviderContext();
        try {
            if (key != null) {
                if (pc.existsStringProperty(this.getName(), key, pflist)) {
                    return pc.getStringProperty(this.getName(), key, pflist);
                }
                if (pc.existsStringProperty(this.getName(), key)) {
                    return pc.getStringProperty(this.getName(), key);
                }
            }
            return def;
        }
        catch (ProviderContextException pce) {
            pc.debugWarning((Object)("MailProvider.getBestStringProperty(): Unable to get " + key));
            return def;
        }
    }

    public String getBestStringProperty(String key, List pflist) {
        return this.getBestStringProperty(key, "", pflist);
    }

    public int getBestIntegerProperty(String key, int def, List pflist) {
        ProviderContext pc = this.getProviderContext();
        try {
            if (key != null) {
                if (pc.existsIntegerProperty(this.getName(), key, pflist)) {
                    return pc.getIntegerProperty(this.getName(), key, pflist);
                }
                if (pc.existsIntegerProperty(this.getName(), key)) {
                    return pc.getIntegerProperty(this.getName(), key);
                }
            }
            return def;
        }
        catch (ProviderContextException pce) {
            pc.debugWarning((Object)("MailProvider.getBestIntegerProperty(): Unable to get " + key));
            return def;
        }
    }

    public int getBestIntegerProperty(String key, List pflist) {
        return this.getBestIntegerProperty(key, 0, pflist);
    }

    public Map getBestCollectionProperty(String key, Map def, List pflist) {
        ProviderContext pc = this.getProviderContext();
        try {
            if (key != null) {
                if (pc.existsCollectionProperty(this.getName(), key, pflist)) {
                    return pc.getCollectionProperty(this.getName(), key, pflist);
                }
                if (pc.existsCollectionProperty(this.getName(), key)) {
                    return pc.getCollectionProperty(this.getName(), key);
                }
            }
            return def;
        }
        catch (ProviderContextException pce) {
            pc.debugWarning((Object)("MailProvider.getBestCollectionProperty(): Unable to get " + key));
            return def;
        }
    }

    public Map getBestCollectionProperty(String key, List pflist) {
        return this.getBestCollectionProperty(key, null, pflist);
    }

    public boolean getBestBooleanProperty(String key, boolean def, List pflist) {
        ProviderContext pc = this.getProviderContext();
        try {
            if (key != null) {
                if (pc.existsBooleanProperty(this.getName(), key, pflist)) {
                    return pc.getBooleanProperty(this.getName(), key, pflist);
                }
                if (pc.existsBooleanProperty(this.getName(), key)) {
                    return pc.getBooleanProperty(this.getName(), key);
                }
            }
            return def;
        }
        catch (ProviderContextException pce) {
            pc.debugWarning((Object)("MailProvider.getBestStringProperty(): Unable to get " + key));
            return def;
        }
    }

    public boolean getBestBooleanProperty(String key, List pflist) {
        return this.getBestBooleanProperty(key, false, pflist);
    }
}

