/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.sun.identity.authentication.AuthContext;
import com.sun.portal.cli.cert.JSSUtil;
import com.sun.portal.cli.cert.SRADecoderException;
import com.sun.portal.util.ApplicationLoginHostChooser;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.SystemProperties;
import java.net.URL;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;

public class ApplicationLogin {
    static String login(String appName) {
        block17: {
            AuthContext authContext = null;
            try {
                String defOrg = com.iplanet.am.util.SystemProperties.get((String)"com.iplanet.am.defaultOrg");
                URL platformUrl = ApplicationLoginHostChooser.getAlivePlatFormServerURL();
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("platformUrl : " + platformUrl);
                    GWDebug.debug.message("ApplicationLogin.login : defOrg : " + defOrg);
                }
                if (platformUrl == null) {
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("Using AuthContext(org) constructor.");
                    }
                    authContext = new AuthContext(defOrg);
                } else {
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("Using AuthContext(org , url) constructor.");
                    }
                    authContext = new AuthContext(defOrg, platformUrl);
                }
                AuthContext.IndexType index = AuthContext.IndexType.SERVICE;
                authContext.login(index, "srapGatewayAccessService".toLowerCase());
                Callback[] callback = null;
                while (authContext.hasMoreRequirements()) {
                    callback = authContext.getRequirements();
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("ApplicationLogin.login : callback : " + callback);
                    }
                    if (callback == null) continue;
                    ApplicationLogin.processCallBack(callback);
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("ApplicationLogin.login : process over , submitting ...");
                    }
                    authContext.submitRequirements(callback);
                    if (!GWDebug.debug.messageEnabled()) continue;
                    GWDebug.debug.message("ApplicationLogin.login : submitted. authContext.hasMoreRequirements() : " + authContext.hasMoreRequirements());
                }
            }
            catch (LoginException ex) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("LoginException while creating Application session", ex);
                }
                return null;
            }
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("ApplicationLogin.login : authContext : " + authContext);
            }
            try {
                if (authContext.getStatus() == AuthContext.Status.SUCCESS) {
                    String appSess = authContext.getSSOToken().getTokenID().toString();
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("ApplicationLogin.login : appSess : " + appSess);
                    }
                    return appSess;
                }
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.message("ApplicationLogin.login : getStatus() returned  : " + authContext.getStatus());
                }
            }
            catch (Exception ex) {
                if (!GWDebug.debug.errorEnabled()) break block17;
                GWDebug.debug.error("Exception while obtaining App session from authContext", ex);
            }
        }
        return null;
    }

    private static void processCallBack(Callback[] callback) {
        for (int count = 0; count < callback.length; ++count) {
            if (callback[count] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callback[count];
                String userName = SystemProperties.get("gateway.logging.user.id", "amService-srapGateway");
                nc.setName(userName);
                continue;
            }
            if (!(callback[count] instanceof PasswordCallback)) continue;
            PasswordCallback pc = (PasswordCallback)callback[count];
            String password = SystemProperties.get("gateway.logging.password", "TEST");
            try {
                password = JSSUtil.decryptPassword((String)password).getPassword();
            }
            catch (SRADecoderException syEx) {
                // empty catch block
            }
            char[] chars = new char[password.length()];
            password.getChars(0, chars.length, chars, 0);
            pc.setPassword(chars);
        }
    }
}

