/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.https;

import com.sun.portal.rproxy.https.JSSDebug;
import com.sun.portal.rproxy.https.JSSThreadPool;
import com.sun.portal.rproxy.https.RWGroupJSSProxy;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.StringTokenizer;
import sun.net.www.protocol.http.HttpURLConnection;

public class JSSProxyRunnable
implements Runnable {
    public static HashMap connectHashMap = new HashMap();
    private ServerSocket sconnection = null;

    JSSProxyRunnable(ServerSocket ss) {
        this.sconnection = ss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean go = true;
        while (go) {
            try {
                Socket inconnection;
                try {
                    inconnection = this.sconnection.accept();
                }
                catch (IOException e) {
                    JSSDebug.debug.error("JSSProxyRunnable: Unable to accept new connection." + e);
                    if (this.sconnection != null) {
                        try {
                            this.sconnection.close();
                        }
                        catch (IOException ee) {
                            JSSDebug.debug.message("JSSProxyRunnable: Unable to close server socket." + e);
                        }
                        finally {
                            this.sconnection = null;
                        }
                    }
                    go = false;
                    continue;
                }
                try {
                    inconnection.setTcpNoDelay(true);
                }
                catch (SocketException e) {
                    JSSDebug.debug.error("JSSProxyRunnable: Unable to  TcpNoDelay." + e);
                    if (inconnection == null) continue;
                    try {
                        inconnection.close();
                    }
                    catch (IOException ee) {}
                    continue;
                    finally {
                        inconnection = null;
                        continue;
                    }
                }
                JSSProxySessionRunnable p = new JSSProxySessionRunnable(inconnection);
                try {
                    JSSThreadPool.run(p);
                }
                catch (InterruptedException e) {
                    JSSDebug.debug.error("JSSProxyRunnable: Unable to run new JSSProxySession", e);
                    if (inconnection == null) continue;
                    try {
                        inconnection.close();
                    }
                    catch (IOException ee) {}
                    continue;
                    finally {
                        inconnection = null;
                        p = null;
                    }
                }
            }
            catch (Throwable t) {
                JSSDebug.debug.error("JSSProxyRunnable: Uncaught exception:", t);
            }
        }
    }

    private class JSSProxySessionRunnable
    implements Runnable {
        private Socket inconnection = null;
        private Socket toProxySocket = null;

        JSSProxySessionRunnable(Socket socket) {
            this.inconnection = socket;
        }

        public void run() {
            String replyStr;
            int port;
            Integer remotePort = new Integer(this.inconnection.getPort());
            byte[] prebuffer = new byte[1];
            try {
                DataInputStream inFrom = new DataInputStream(this.inconnection.getInputStream());
                inFrom.readFully(prebuffer, 0, 1);
            }
            catch (IOException e) {
                JSSDebug.debug.error("JSSProxySessionRunnable: Unable to open input stream on " + this.inconnection, e);
                connectHashMap.remove(remotePort);
                this.closeSockets();
                return;
            }
            String info = (String)connectHashMap.remove(remotePort);
            StringTokenizer st = new StringTokenizer(info);
            String host = st.nextToken();
            try {
                port = Integer.parseInt(st.nextToken());
            }
            catch (Exception ex) {
                port = 8080;
            }
            try {
                this.toProxySocket = new Socket(host, port);
                this.toProxySocket.setTcpNoDelay(true);
            }
            catch (Exception ex) {
                this.toProxySocket = null;
                JSSDebug.debug.message("JSSProxySessionRunnable: Unable to connect to " + host + ":" + port + ". " + ex);
            }
            if (this.toProxySocket == null) {
                this.closeSockets();
                return;
            }
            String desthost = st.nextToken();
            String destport = st.nextToken();
            OutputStream out = null;
            InputStream in = null;
            byte[] reply = new byte[200];
            int replyLen = 0;
            int newlinesSeen = 0;
            boolean headerDone = false;
            try {
                byte[] b;
                out = this.toProxySocket.getOutputStream();
                String msg = "CONNECT " + desthost + ":" + destport + " HTTP/1.0\n" + "User-Agent: " + HttpURLConnection.userAgent + "\r\n\r\n";
                JSSDebug.debug.message(msg);
                try {
                    b = msg.getBytes("ASCII7");
                }
                catch (UnsupportedEncodingException ignored) {
                    b = msg.getBytes();
                }
                out.write(b);
                out.flush();
                in = this.toProxySocket.getInputStream();
                boolean error = false;
                while (newlinesSeen < 2) {
                    int i = in.read();
                    if (i < 0) {
                        JSSDebug.debug.message("JSSProxySessionRunnable: Unexpected EOF from proxy");
                        this.closeSockets();
                        return;
                    }
                    if (i == 10) {
                        headerDone = true;
                        ++newlinesSeen;
                        continue;
                    }
                    if (i == 13) continue;
                    newlinesSeen = 0;
                    if (headerDone || replyLen >= reply.length) continue;
                    reply[replyLen++] = (byte)i;
                }
            }
            catch (IOException ioe) {
                JSSDebug.debug.message("JSSProxySessionRunnable: Unable to get OutputStream" + ioe);
                this.closeSockets();
                return;
            }
            try {
                replyStr = new String(reply, 0, replyLen, "ASCII7");
            }
            catch (UnsupportedEncodingException ignored) {
                replyStr = new String(reply, 0, replyLen);
            }
            if (!replyStr.startsWith("HTTP/1.0 200")) {
                JSSDebug.debug.message("JSSProxySessionRunnable: Unable to tunnel through ");
                this.closeSockets();
                return;
            }
            try {
                out.write(prebuffer);
                out.flush();
            }
            catch (IOException ioe) {
                JSSDebug.debug.message("JSSProxySessionRunnable: Unable to write prebuffer." + ioe);
                this.closeSockets();
                return;
            }
            new RWGroupJSSProxy(this.inconnection, this.toProxySocket);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void closeSockets() {
            if (this.inconnection != null) {
                try {
                    this.inconnection.close();
                }
                catch (Exception e1) {
                }
                finally {
                    this.inconnection = null;
                }
            }
            if (this.toProxySocket != null) {
                try {
                    this.toProxySocket.close();
                }
                catch (Exception exception) {
                }
                finally {
                    this.toProxySocket = null;
                }
            }
        }
    }
}

