/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.connectionhandler.CachedSSLSocketFactory;
import com.sun.portal.rproxy.connectionhandler.CachedSocket;
import com.sun.portal.rproxy.connectionhandler.JSSProxyRunnable;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.LogInfoContainer;
import com.sun.portal.util.ServerCertApprovalCallback;
import com.sun.portal.util.ServiceReachabilityInfo;
import com.sun.portal.util.SystemProperties;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLSocket;

class SConn {
    private static final String DEFAULT_SSL_PORT = "443";
    private static String rpSubdomain;
    private static String rpDomain;
    private static int gatewayNetletProxySocketTimeout;

    SConn() {
    }

    public static Socket connect(int p, String h) {
        Socket conn;
        block7: {
            conn = null;
            try {
                conn = new Socket(h, p);
                conn.setTcpNoDelay(true);
                if (PerfContextObject.ENABLE_PERF) {
                    SocketCount.incrementPlainSockets();
                }
            }
            catch (UnknownHostException e) {
                conn = null;
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Cannot open connection to " + h + ":" + p, e);
                }
            }
            catch (SocketException e) {
                conn = null;
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Cannot set tcpNoDelay on connection to " + h + ":" + p, e);
                }
            }
            catch (IOException e) {
                conn = null;
                if (!GWDebug.debug.errorEnabled()) break block7;
                GWDebug.debug.error("Cannot open connection to " + h + ":" + p, e);
            }
        }
        return conn;
    }

    public static Socket sslconnect(int p, String h) {
        SSLSocket sslSocket;
        block6: {
            sslSocket = null;
            ServerCertApprovalCallback serverCertApprovalCB = null;
            serverCertApprovalCB = ServerCertApprovalCallback.getInstance();
            try {
                sslSocket = new SSLSocket(InetAddress.getByName(h), p, null, 0, (SSLCertificateApprovalCallback)serverCertApprovalCB, null);
            }
            catch (Exception ex) {
                GWDebug.debug.error("Unable to create ssl Socket to Netlet proxy", ex);
                return null;
            }
            if (sslSocket == null) {
                if (GWDebug.debug.warningEnabled()) {
                    GWDebug.debug.warning("SConn: Null socket returned. Probably couldn't resolve host.");
                }
                return null;
            }
            try {
                sslSocket.setUseClientMode(true);
                sslSocket.enableSSL2(true);
                sslSocket.enableSSL3(true);
                sslSocket.forceHandshake();
                sslSocket.setSoLinger(false, 0);
                sslSocket.setSoTimeout(gatewayNetletProxySocketTimeout);
            }
            catch (Exception e) {
                if (!GWDebug.debug.errorEnabled()) break block6;
                GWDebug.debug.error("CachedSSLSocketFactory socket error", e);
            }
        }
        return sslSocket;
    }

    public static Socket connect(String p, String h) {
        Socket conn = null;
        StringTokenizer hosts = new StringTokenizer(h, "+");
        StringTokenizer portlist = new StringTokenizer(p, "-");
        int portlistLen = portlist.countTokens();
        if (hosts.countTokens() == portlistLen || portlistLen == 1) {
            while (hosts.hasMoreElements() && conn == null) {
                String strPorts = "";
                strPorts = portlistLen == 1 ? p : (String)portlist.nextElement();
                StringTokenizer ports = new StringTokenizer(strPorts, "+");
                String host = (String)hosts.nextElement();
                while (ports.hasMoreElements() && conn == null) {
                    String strPort = (String)ports.nextElement();
                    int port = -999;
                    try {
                        port = Integer.parseInt(strPort);
                    }
                    catch (NumberFormatException nfe) {
                        continue;
                    }
                    try {
                        conn = new Socket(host, port);
                        conn.setTcpNoDelay(true);
                        if (!PerfContextObject.ENABLE_PERF) continue;
                        SocketCount.incrementPlainSockets();
                    }
                    catch (UnknownHostException e) {
                        conn = null;
                        if (!GWDebug.debug.errorEnabled()) continue;
                        GWDebug.debug.error("Cannot open connection to " + host + ":" + port, e);
                    }
                    catch (SocketException e) {
                        conn = null;
                        if (!GWDebug.debug.errorEnabled()) continue;
                        GWDebug.debug.error("Cannot set tcpNoDelay on connection to " + host + ":" + port, e);
                    }
                    catch (IOException e) {
                        conn = null;
                        if (!GWDebug.debug.errorEnabled()) continue;
                        GWDebug.debug.error("Cannot open connection to " + host + ":" + port, e);
                    }
                }
            }
        } else {
            conn = null;
        }
        return conn;
    }

    public static Socket sslProxyConnect(String host, int port, String proxyHost, int proxyPort, int clientPort) {
        ServerSocket ss = null;
        CachedSocket s = null;
        Integer logId = null;
        Object tmp = GWLogManager.logIdMap.remove(new Integer(clientPort));
        if (tmp != null) {
            LogInfoContainer info = (LogInfoContainer)tmp;
            logId = info.getLogID();
        }
        int jssProxyPort = -1;
        try {
            ss = new ServerSocket(0, 50, InetAddress.getByName("127.0.0.1"));
            if (PerfContextObject.ENABLE_PERF) {
                SocketCount.incrementServerSockets();
            }
        }
        catch (IOException e) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("SConn: Unable to create server socket", e);
            }
            ss = null;
        }
        if (ss != null) {
            jssProxyPort = ss.getLocalPort();
            JSSProxyRunnable jssProxy = new JSSProxyRunnable(ss);
            Thread t = new Thread(jssProxy);
            t.start();
        }
        ServerCertApprovalCallback serverCertApprovalCB = new ServerCertApprovalCallback(host);
        s = CachedSSLSocketFactory.createSocket("127.0.0.1", jssProxyPort, "ssl", logId, serverCertApprovalCB);
        Integer localport = new Integer(s.getLocalPort());
        ServiceReachabilityInfo sInfo = new ServiceReachabilityInfo(host, port, proxyHost, proxyPort);
        JSSProxyRunnable.connectHashMap.put(localport, sInfo);
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("SConn: Connecting to " + proxyHost);
        }
        if (s == null) {
            if (GWDebug.debug.warningEnabled()) {
                GWDebug.debug.warning("SConn: Null socket returned. Probably couldn't resolve host.");
            }
            return null;
        }
        try {
            SConn.ForceSSLHandshake(host, s);
        }
        catch (IOException e) {
            s = null;
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("Cannot open connection to " + host + ":" + port, e);
            }
            return null;
        }
        return s.getSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ForceSSLHandshake(String host, CachedSocket s) throws IOException {
        String string = DEFAULT_SSL_PORT;
        synchronized (DEFAULT_SSL_PORT) {
            StringTokenizer st;
            int tokenCount;
            String h = host;
            String currentReqHost = h != null ? ((tokenCount = (st = new StringTokenizer(h, ".")).countTokens()) == 1 ? h + "." + rpSubdomain + rpDomain : (tokenCount == 2 ? h + rpDomain : h)) : null;
            try {
                s.getOutputStream().write(new byte[0]);
            }
            catch (IOException ex) {
                currentReqHost = null;
                throw ex;
            }
            currentReqHost = null;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    public static Socket proxyConnect(String host, int port, String proxyHost, int proxyPort) {
        Socket s;
        block15: {
            ServerSocket ss = null;
            s = null;
            int jssProxyPort = -1;
            try {
                ss = new ServerSocket(0, 50, InetAddress.getByName("127.0.0.1"));
                if (PerfContextObject.ENABLE_PERF) {
                    SocketCount.incrementServerSockets();
                }
            }
            catch (IOException e) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("SConn: Unable to create server socket", e);
                }
                ss = null;
            }
            if (ss != null) {
                jssProxyPort = ss.getLocalPort();
                JSSProxyRunnable jssProxy = new JSSProxyRunnable(ss);
                Thread t = new Thread(jssProxy);
                t.start();
            }
            try {
                s = new Socket("127.0.0.1", jssProxyPort);
                s.setTcpNoDelay(true);
                if (PerfContextObject.ENABLE_PERF) {
                    SocketCount.incrementPlainSockets();
                }
            }
            catch (UnknownHostException e) {
                s = null;
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Cannot open connection to " + host + ":" + port, e);
                }
            }
            catch (SocketException e) {
                s = null;
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Cannot set tcpNoDelay on connection to " + host + ":" + port, e);
                }
            }
            catch (IOException e) {
                s = null;
                if (!GWDebug.debug.errorEnabled()) break block15;
                GWDebug.debug.error("Cannot open connection to " + host + ":" + port, e);
            }
        }
        Integer localport = new Integer(s.getLocalPort());
        ServiceReachabilityInfo sInfo = new ServiceReachabilityInfo(host, port, proxyHost, proxyPort);
        JSSProxyRunnable.connectHashMap.put(localport, sInfo);
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("SConn: Connecting to " + proxyHost);
        }
        if (s == null) {
            if (GWDebug.debug.warningEnabled()) {
                GWDebug.debug.warning("SConn: Null socket returned. Probably couldn't resolve host.");
            }
            return null;
        }
        return s;
    }

    static {
        gatewayNetletProxySocketTimeout = 600000;
        String _host = SystemProperties.get("gateway.host", null);
        String rphost = "https://" + _host + "/";
        if (rphost != null) {
            int len = rphost.length();
            int index1 = rphost.indexOf(46);
            if (index1 != -1 && index1 + 1 < len) {
                int index2 = rphost.indexOf(46, index1 + 1);
                if (index2 == -1) {
                    rpSubdomain = rphost.substring(index1 + 1);
                } else {
                    rpSubdomain = rphost.substring(index1 + 1, index2);
                    rpDomain = rphost.substring(index2);
                }
            }
        }
        String gatewayNetletproxyTimeout = SystemProperties.get("gateway.netletproxy.socket.timeout", "600000");
        gatewayNetletProxySocketTimeout = Integer.parseInt(gatewayNetletproxyTimeout);
    }
}

