/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminConstants;
import com.sun.portal.cli.cert.CertAdminHelpText;
import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.CertAdminUtil;
import com.sun.portal.cli.cert.Command;
import com.sun.portal.cli.cert.JSSContext;
import com.sun.portal.cli.cert.JSSUtil;
import java.util.StringTokenizer;
import org.mozilla.jss.crypto.X509Certificate;

public class ModifyTrustAttributes
implements Command {
    private JSSContext cntx;

    public boolean execute(JSSContext cntx) {
        StringTokenizer st;
        this.cntx = cntx;
        CertAdminUtil.println(CertAdminHelpText.getTrustHelpText());
        String certnick = CertAdminUtil.question(CertAdminLocale.getPFString("q18", "Enter the name of the certificate ?"));
        if (certnick.trim().equals("")) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m30", "Certificate name entered is not valid!"));
            return false;
        }
        if (!JSSUtil.certExist(cntx, certnick)) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m31", "Specified certificate does not exist!"));
            return false;
        }
        String tmpattrib = "CT,CT,c";
        String attrib = CertAdminUtil.question(CertAdminLocale.getPFString("q19", "Enter the trust attribute you want the certificate to have [") + tmpattrib + CertAdminLocale.getPFString("q1", "]"));
        if (attrib.trim().equals("")) {
            attrib = tmpattrib;
        }
        if ((st = new StringTokenizer(attrib, ",")).countTokens() != 3) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m34", "Invalid trust attribute") + " " + attrib + " " + CertAdminLocale.getPFString("m35", "specified!"));
            return false;
        }
        CertAdminUtil.println(CertAdminConstants.newline);
        CertAdminUtil.println(CertAdminLocale.getPFString("m36", "specified!"));
        try {
            X509Certificate cert = JSSUtil.getCertByNickname(cntx, certnick);
            X509Certificate updatedCert = JSSUtil.changeCertificateTrust(cert, st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim());
            cntx.getCryptoManager().importCertToPerm(updatedCert, certnick);
        }
        catch (Exception ex) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m37", "Could not modify the trust attributes of the certificate!") + " " + certnick + " ");
            ex.printStackTrace();
            return false;
        }
        CertAdminUtil.println(CertAdminLocale.getPFString("m38", "Certificate trust attributes modified successfully "));
        return true;
    }
}

