/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminConstants;
import com.sun.portal.cli.cert.CertAdminHelpText;
import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.CertAdminPasswordCallback;
import com.sun.portal.cli.cert.CertAdminUtil;
import com.sun.portal.cli.cert.Command;
import com.sun.portal.cli.cert.JSSContext;
import com.sun.portal.cli.cert.JSSUtil;
import com.sun.portal.cli.cert.SystemProperties;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.util.ConsolePasswordCallback;
import org.mozilla.jss.util.NullPasswordCallback;
import org.mozilla.jss.util.PasswordCallback;

public class GenerateCSR
implements Command {
    public boolean execute(JSSContext cntx) {
        CertAdminUtil.println(CertAdminHelpText.getDNHelpText());
        String tmpfqdn = cntx.getHost();
        String fqdn = CertAdminUtil.question(CertAdminLocale.getPFString("q2", "What is the fully-qualified DNS name of this host? [") + tmpfqdn + CertAdminLocale.getPFString("q1", "]"));
        if (fqdn.equals("")) {
            fqdn = tmpfqdn;
        }
        String tmpo = "MyOrganization";
        String o = CertAdminUtil.question(CertAdminLocale.getPFString("q3", "What is the name of your organization (ex: Company)? [") + tmpo + CertAdminLocale.getPFString("q1", "]"));
        if (o.equals("")) {
            o = tmpo;
        }
        String tmpou = "MyOrganizationUnit";
        String ou = CertAdminUtil.question(CertAdminLocale.getPFString("q4", "What is the name of your organizational unit (ex: division)? [") + tmpou + CertAdminLocale.getPFString("q1", "]"));
        if (ou.equals("")) {
            ou = tmpou;
        }
        String tmpl = "MyLocality";
        String l = CertAdminUtil.question(CertAdminLocale.getPFString("q5", "What is the name of your City or Locality? [") + tmpl + CertAdminLocale.getPFString("q1", "]"));
        if (l.equals("")) {
            l = tmpl;
        }
        String tmps = "MyState";
        String s = CertAdminUtil.question(CertAdminLocale.getPFString("q6", "What is the name (no abbreviation please) of your State or Province? [") + tmps + CertAdminLocale.getPFString("q1", "]"));
        if (s.equals("")) {
            s = tmps;
        }
        String c = CertAdminUtil.question(CertAdminLocale.getPFString("q7", "What is the two-letter country code for this unit? []"));
        while (c.trim().length() != 2) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m19", "Email/Phone values should not be empty!"));
            c = CertAdminUtil.question(CertAdminLocale.getPFString("q7", "What is the two-letter country code for this unit? []"));
        }
        CertAdminUtil.println(CertAdminHelpText.getTokenHelpText());
        String token = CertAdminUtil.question(CertAdminLocale.getPFString("q8", "Enter the token name []"));
        CertAdminUtil.println(CertAdminHelpText.getCSRAdminHelpText());
        CertAdminUtil.println(CertAdminConstants.newline);
        String email = CertAdminUtil.question(CertAdminLocale.getPFString("q11", "What is the email address of the admin/webmaster for this server ?"));
        String phone = CertAdminUtil.question(CertAdminLocale.getPFString("q12", "What is the phone number of the admin/webmaster for this server ?"));
        while (email.trim().equals("") || phone.trim().equals("")) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m19", "Email/Phone values should not be empty!"));
            email = CertAdminUtil.question(CertAdminLocale.getPFString("q11", "What is the email address of the admin/webmaster for this server ?"));
            phone = CertAdminUtil.question(CertAdminLocale.getPFString("q12", "What is the phone number of the admin/webmaster for this server ?"));
        }
        CertAdminUtil.println(CertAdminConstants.newline);
        CertAdminUtil.println(CertAdminLocale.getPFString("m16", "You have entered the following values:"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m17", "Webmaster Email :") + email);
        CertAdminUtil.println(CertAdminLocale.getPFString("m18", "Webmaster Phone : ") + phone);
        CertAdminUtil.println(CertAdminConstants.newline);
        String ans = CertAdminUtil.question(CertAdminLocale.getPFString("q13", "Are these values correct (y/n) ? [n]"));
        while (!ans.equals("y")) {
            CertAdminUtil.println(CertAdminConstants.newline);
            email = CertAdminUtil.question(CertAdminLocale.getPFString("q11", "What is the email address of the admin/webmaster for this server ?"));
            phone = CertAdminUtil.question(CertAdminLocale.getPFString("q12", "What is the phone number of the admin/webmaster for this server ?"));
            while (email.trim().equals("") || phone.trim().equals("")) {
                CertAdminUtil.println(CertAdminLocale.getPFString("m19", "Email/Phone values should not be empty!"));
                email = CertAdminUtil.question(CertAdminLocale.getPFString("q11", "What is the email address of the admin/webmaster for this server ?"));
                phone = CertAdminUtil.question(CertAdminLocale.getPFString("q12", "What is the phone number of the admin/webmaster for this server ?"));
            }
            CertAdminUtil.println(CertAdminConstants.newline);
            CertAdminUtil.println(CertAdminLocale.getPFString("m16", "You have entered the following values:"));
            CertAdminUtil.println(CertAdminLocale.getPFString("m17", "Webmaster Email :") + email);
            CertAdminUtil.println(CertAdminLocale.getPFString("m18", "Webmaster Phone : ") + phone);
            CertAdminUtil.println(CertAdminConstants.newline);
            ans = CertAdminUtil.question(CertAdminLocale.getPFString("q13", "Are these values correct (y/n) ? [n]"));
        }
        try {
            String certWithSameDN;
            CertAdminPasswordCallback password;
            String passphrase = cntx.getPasswordContext().generatePassphrase(cntx);
            CryptoToken tok = null;
            if (token.trim().equals("")) {
                tok = cntx.getCryptoManager().getInternalKeyStorageToken();
                password = new CertAdminPasswordCallback(passphrase);
                if (!tok.passwordIsInitialized()) {
                    tok.initPassword((PasswordCallback)new NullPasswordCallback(), (PasswordCallback)password);
                }
            } else {
                tok = cntx.getCryptoManager().getTokenByName(token);
                password = new ConsolePasswordCallback();
                if (!tok.passwordIsInitialized()) {
                    tok.initPassword((PasswordCallback)new NullPasswordCallback(), (PasswordCallback)password);
                }
            }
            tok.login((PasswordCallback)password);
            String dn = "OU=" + ou + "," + "O=" + o + "," + "CN=" + fqdn + "," + "C=" + c + "," + "ST=" + s + "," + "L=" + l;
            Name issuer = new Name();
            if (!fqdn.equals("")) {
                issuer.addCommonName(fqdn);
            }
            if (!l.equals("")) {
                issuer.addLocalityName(l);
            }
            if (!s.equals("")) {
                issuer.addStateOrProvinceName(s);
            }
            issuer.addCountryName(c);
            if (!o.equals("")) {
                issuer.addOrganizationName(o);
            }
            if (!ou.equals("")) {
                issuer.addOrganizationalUnitName(ou);
            }
            if ((certWithSameDN = JSSUtil.getCertWithSubject(tok, issuer)) != null) {
                CertAdminUtil.println();
                CertAdminUtil.println(CertAdminLocale.getPFString("m63", "Certificate with the specified Subject DN already exist!"));
                CertAdminUtil.println(CertAdminLocale.getPFString("m64", "Certificate Nickname:") + " " + certWithSameDN);
                CertAdminUtil.println(CertAdminLocale.getPFString("m65", "Certificate Subject DN:") + " " + issuer.getRFC1485());
                CertAdminUtil.println(CertAdminLocale.getPFString("m66", "Retry deleting the certificate or change the Subject DN for the new certificate"));
                CertAdminUtil.question(CertAdminLocale.getPFString("m67", "Hit Return to continue!!"));
                CertAdminUtil.println(CertAdminConstants.newline);
                return false;
            }
            CertAdminUtil.println(CertAdminLocale.getPFString("m20", "Generating CSR..."));
            CertAdminUtil.println(CertAdminLocale.getPFString("m12", "Generating key.  This may take a few moments..."));
            CertAdminUtil.println(CertAdminConstants.newline);
            String blob = tok.generateCertRequest(dn, 1024, "rsa", (byte[])null, (byte[])null, (byte[])null);
            CertAdminUtil.println(CertAdminHelpText.getCSRHelpText());
            StringBuffer csr = new StringBuffer();
            csr.append("The CSR is also show below:");
            csr.append(CertAdminConstants.newline);
            csr.append(CertAdminConstants.newline);
            csr.append("Certificate request generated by Netscape certutil");
            csr.append(CertAdminConstants.newline);
            csr.append(CertAdminConstants.newline);
            csr.append("Phone: " + phone);
            csr.append(CertAdminConstants.newline);
            csr.append("Common Name: " + fqdn);
            csr.append(CertAdminConstants.newline);
            csr.append("Email: " + email);
            csr.append(CertAdminConstants.newline);
            csr.append("Organization: " + o);
            csr.append(CertAdminConstants.newline);
            csr.append("State: " + s);
            csr.append(CertAdminConstants.newline);
            csr.append("Country: " + c);
            csr.append(CertAdminConstants.newline);
            csr.append(CertAdminConstants.newline);
            csr.append(blob);
            CertAdminUtil.println(csr.toString());
            if (!CertAdminUtil.writeLine(csr.toString(), "csr." + SystemProperties.get("gateway.host") + "." + CertAdminUtil.getCurrentDateTime())) {
                CertAdminUtil.println(CertAdminLocale.getPFString("m21", "Could not write the csr to the file!"));
            }
        }
        catch (Exception ex) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m22", "Could not generate the csr!"));
            ex.printStackTrace();
            return false;
        }
        return true;
    }
}

