/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.portal.taglib;

import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.im.portal.provider.IMProvider;
import com.sun.im.portal.taglib.IMTaglibException;
import com.sun.im.portal.util.NetletRule;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationSession;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.tagext.TagSupport;

public class BaseIMTagSupport
extends TagSupport {
    private static final String VARIABLE_PREFIX = "$";
    private static final String SECURE_MODE = "secureMode";
    private static final String SECURE_DOWNLOAD_PORT = "secureDownloadPort";
    private static final String SECURE_PORT = "securePort";
    protected String mId = null;
    protected int mScope = 1;

    public void setId(String id) {
        if (id != null && id.length() > 0) {
            this.mId = id;
        }
    }

    public void setScope(String scope) {
        if (scope != null) {
            if (scope.equalsIgnoreCase("request")) {
                this.mScope = 2;
            } else if (scope.equalsIgnoreCase("session")) {
                this.mScope = 3;
            } else if (scope.equalsIgnoreCase("application")) {
                this.mScope = 4;
            }
        }
    }

    protected void processResult(Object result) throws IMTaglibException {
        if (this.mId != null) {
            if (result != null) {
                this.pageContext.setAttribute(this.mId, result, this.mScope);
            } else {
                this.pageContext.removeAttribute(this.mId, this.mScope);
            }
        } else {
            try {
                this.pageContext.getOut().print(result);
            }
            catch (IOException e) {
                throw new IMTaglibException(e);
            }
        }
    }

    protected boolean isContextVariable(String parameter) {
        if (parameter != null) {
            return parameter.startsWith(VARIABLE_PREFIX);
        }
        return false;
    }

    protected Object resolveParameter(String parameter) throws IMTaglibException {
        if (this.isContextVariable(parameter)) {
            String var = parameter.substring(VARIABLE_PREFIX.length());
            Object obj = this.pageContext.findAttribute(var);
            if (obj == null) {
                throw new IMTaglibException(3, var);
            }
            return obj;
        }
        return parameter;
    }

    protected String getVariable(String parameter) {
        if (this.isContextVariable(parameter)) {
            return parameter.substring(VARIABLE_PREFIX.length());
        }
        return parameter;
    }

    protected IMProvider getProvider() {
        return (IMProvider)((Object)this.pageContext.getAttribute("JSPProvider"));
    }

    protected CollaborationSession getCollaborationSession() throws IMTaglibException, CollaborationException {
        try {
            return this.getProvider().getCollaborationSession((HttpServletRequest)this.pageContext.getRequest());
        }
        catch (CollaborationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new IMTaglibException(e);
        }
    }

    public String getUsername() throws IMTaglibException {
        try {
            return this.getProvider().getUsername();
        }
        catch (Exception e) {
            throw new IMTaglibException(e);
        }
    }

    public String getToken() throws IMTaglibException {
        try {
            return this.getProvider().getToken((HttpServletRequest)this.pageContext.getRequest());
        }
        catch (Exception e) {
            throw new IMTaglibException(e);
        }
    }

    protected boolean getSecureMode() throws IMTaglibException {
        Object sm = this.pageContext.getAttribute(SECURE_MODE);
        if (sm != null) {
            return (Boolean)sm;
        }
        try {
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            String secure = request.getParameter("secure");
            if (secure != null && secure.equals("yes")) {
                this.pageContext.setAttribute(SECURE_MODE, (Object)Boolean.TRUE);
                return true;
            }
            String gateway_url = request.getHeader("x-ps-gw-url");
            if (gateway_url != null) {
                this.pageContext.setAttribute(SECURE_MODE, (Object)Boolean.TRUE);
                return true;
            }
            this.pageContext.setAttribute(SECURE_MODE, (Object)Boolean.FALSE);
            return false;
        }
        catch (Exception e) {
            throw new IMTaglibException(e);
        }
    }

    protected String getSecureDownloadPort() throws IMTaglibException {
        Object v = this.pageContext.getAttribute(SECURE_DOWNLOAD_PORT);
        if (v != null) {
            return (String)v;
        }
        this.getIMNetletRule();
        return (String)this.pageContext.getAttribute(SECURE_DOWNLOAD_PORT);
    }

    protected String getSecureIMPort() throws IMTaglibException {
        Object v = this.pageContext.getAttribute(SECURE_PORT);
        if (v != null) {
            return (String)v;
        }
        this.getIMNetletRule();
        return (String)this.pageContext.getAttribute(SECURE_PORT);
    }

    private void getIMNetletRule() throws IMTaglibException {
        try {
            String secureIMPort = "";
            String secureDownloadPort = "";
            SSOToken token = SSOTokenManager.getInstance().createSSOToken((HttpServletRequest)this.pageContext.getRequest());
            AMStoreConnection connection = new AMStoreConnection(token);
            AMUser user = connection.getUser(token.getPrincipal().getName());
            Set rules = user.getAttribute(NetletRule.NETLET_RULE);
            IMProvider p = this.getProvider();
            String ruleName = p.getStringProperty("netletRule");
            String rulePrefix = ruleName + "|";
            String strRule = "";
            boolean found = false;
            Iterator i = rules.iterator();
            while (i.hasNext()) {
                strRule = (String)i.next();
                if (!strRule.startsWith(rulePrefix)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new IMTaglibException("Undefined netletRule (" + ruleName + ") in channel " + p.getName());
            }
            StringTokenizer st = new StringTokenizer(strRule, "|");
            st.nextToken();
            st.nextToken();
            String downloadinfo = st.nextToken();
            if (downloadinfo.equals("true")) {
                secureDownloadPort = user.getStringAttribute(NetletRule.NETLET_DEFAULT_PORT);
            } else {
                StringTokenizer st1 = new StringTokenizer(downloadinfo, ":");
                secureDownloadPort = st1.nextToken();
            }
            String ruleinfo = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(ruleinfo, ":");
            secureIMPort = st2.nextToken();
            this.pageContext.setAttribute(SECURE_PORT, (Object)secureIMPort);
            this.pageContext.setAttribute(SECURE_DOWNLOAD_PORT, (Object)secureDownloadPort);
        }
        catch (Exception e) {
            throw new IMTaglibException(e);
        }
    }

    static boolean toBoolean(String name) {
        return name != null && name.toLowerCase().equals("true");
    }
}

