/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.config;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.security.DecryptAction;
import com.sun.identity.security.EncryptAction;
import com.sun.ssoadapter.config.ClientAwareUserContext;
import com.sun.ssoadapter.config.Configuration;
import com.sun.ssoadapter.config.ConfigurationConstants;
import com.sun.ssoadapter.config.ConfigurationDebug;
import com.sun.ssoadapter.config.ConfigurationException;
import com.sun.ssoadapter.config.PSClientAwareContextFactory;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;

public class ConfigurationFactory
implements ConfigurationConstants {
    public static final String DEFAULT_DESC_ATTR = "sunConfigurationTemplates";
    private static Hashtable factoryHashtable = new Hashtable(5);
    private Hashtable mergedConfigCache = new Hashtable(100);
    private Hashtable rawConfigCache = new Hashtable(100);
    private PSClientAwareContextFactory contextFactory = null;
    private String serviceName = null;
    private String rootAttributeName = null;
    private String descAttributeName = "sunConfigurationTemplates";
    private Map serviceMap = null;
    private static final String authlessSUID = "ssoadapter.authless.suid";

    private ConfigurationFactory(String serviceName, String rootAttributeName, String descAttributeName) throws Exception {
        this.serviceName = serviceName;
        this.rootAttributeName = rootAttributeName;
        this.descAttributeName = descAttributeName;
        this.serviceMap = new HashMap();
        this.serviceMap.put("serviceName", serviceName);
        try {
            this.contextFactory = PSClientAwareContextFactory.getInstance();
        }
        catch (Exception e) {
            ConfigurationDebug.logError(this.getClass().getName() + ":  constructor failed:  " + e);
            throw e;
        }
    }

    public static ConfigurationFactory getInstance(String serviceName, String rootAttributeName) {
        return ConfigurationFactory.getInstance(serviceName, rootAttributeName, DEFAULT_DESC_ATTR);
    }

    public static ConfigurationFactory getInstance(String serviceName, String rootAttributeName, String descAttributeName) {
        String hashKey = serviceName + rootAttributeName + descAttributeName;
        ConfigurationFactory configFactory = (ConfigurationFactory)factoryHashtable.get(hashKey);
        if (configFactory == null) {
            try {
                configFactory = new ConfigurationFactory(serviceName, rootAttributeName, descAttributeName);
            }
            catch (Exception e) {
                return null;
            }
            factoryHashtable.put(hashKey, configFactory);
        }
        return configFactory;
    }

    public Enumeration getConfigurationNames(HttpServletRequest request) {
        HashMapKeyEnumeration configNames = null;
        try {
            SSOTokenManager tokenManager = SSOTokenManager.getInstance();
            SSOToken token = tokenManager.createSSOToken(request);
            SSOTokenID tokenID = token.getTokenID();
            String tokenString = tokenID.toString();
            this.loadCache(request, token, tokenString);
            String hashKey = tokenString;
            TreeMap configHashMap = new TreeMap();
            HashMap tmpHashMap = (HashMap)this.rawConfigCache.get(hashKey);
            if (tmpHashMap != null) {
                configHashMap.putAll(tmpHashMap);
            }
            if ((tmpHashMap = (HashMap)this.mergedConfigCache.get(hashKey)) != null) {
                configHashMap.putAll(tmpHashMap);
            }
            configNames = new HashMapKeyEnumeration(configHashMap);
        }
        catch (Exception e) {
            ConfigurationDebug.logError(this.getClass().getName() + ".getConfigurationNames():  " + "failed:  " + e);
        }
        return configNames;
    }

    public Configuration computeMergedConfiguration(Configuration config, HttpServletRequest request) throws ConfigurationException {
        Object val;
        int i;
        Configuration configDescription;
        String configDescName = config.getConfigurationDescription();
        String configName = config.getConfigurationName();
        if (configDescName == null) {
            return config;
        }
        ConfigurationFactory descFactory = ConfigurationFactory.getInstance(this.serviceName, this.descAttributeName);
        try {
            configDescription = descFactory.readConfiguration(configDescName, false, request);
        }
        catch (Exception ee) {
            String msg = this.getClass().getName() + ".computeMergedConfiguration():  " + "problems reading configuration description, configDescName=" + configDescName;
            ConfigurationDebug.logError(msg);
            throw new ConfigurationException(msg);
        }
        if (configDescription == null) {
            String msg = this.getClass().getName() + ".computeMergedConfiguration():  " + "attempt to reference non-existent configuration description, configDescName=" + configDescName + " ignoring";
            ConfigurationDebug.logWarning(msg);
            return config;
        }
        String[] userDef = configDescription.getPropertyArray("merge");
        String[] defaultDef = configDescription.getPropertyArray("default");
        String[] encodedDef = configDescription.getPropertyArray("encoded");
        if (userDef == null && defaultDef == null) {
            return null;
        }
        Configuration mergedConfig = new Configuration();
        mergedConfig.setConfigurationName(configName);
        mergedConfig.setConfigurationDescription(configDescName);
        HashMap mergedHashMap = mergedConfig.getHashMap();
        if (defaultDef != null) {
            for (i = 0; i < defaultDef.length; ++i) {
                val = configDescription.getPropertyArray(defaultDef[i]);
                if (val == null) continue;
                mergedHashMap.put(defaultDef[i], val);
            }
        }
        if (userDef != null) {
            for (i = 0; i < userDef.length; ++i) {
                val = config.getPropertyArray(userDef[i]);
                if (val == null) continue;
                mergedHashMap.put(userDef[i], val);
            }
        }
        if (encodedDef != null) {
            for (i = 0; i < encodedDef.length; ++i) {
                val = mergedConfig.getProperty(encodedDef[i]);
                if (val == null) continue;
                mergedConfig.setProperty(encodedDef[i], (String)AccessController.doPrivileged(new DecryptAction((String)val)));
            }
        }
        return mergedConfig;
    }

    private void loadCache(HttpServletRequest request, SSOToken token, String tokenString) throws Exception {
        this.loadCache(request, token, tokenString, false, "");
    }

    private void loadCache(HttpServletRequest request, SSOToken token, String tokenString, boolean reload, String mergeConfigName) throws Exception {
        String tmpConfigName;
        String configString;
        String hashKey = tokenString;
        if (!(reload || this.rawConfigCache.get(hashKey) == null && this.mergedConfigCache.get(hashKey) == null)) {
            return;
        }
        HashMap<String, Configuration> rawConfigHashMap = new HashMap<String, Configuration>(10);
        HashMap<String, Configuration> mergedConfigHashMap = new HashMap<String, Configuration>(10);
        ClientAwareUserContext userContext = this.contextFactory.getClientAwareUserContext(request);
        Set configSet = userContext.getAttribute(this.serviceMap, this.rootAttributeName);
        Iterator configIter = configSet.iterator();
        while (configIter.hasNext()) {
            configString = (String)configIter.next();
            Configuration rawConfig = new Configuration(configString);
            tmpConfigName = rawConfig.getConfigurationName();
            if (tmpConfigName == null) {
                String msg = this.getClass().getName() + ".loadCache():  " + "configName not specified in entry from " + this.rootAttributeName;
                ConfigurationDebug.logError(msg);
                throw new ConfigurationException(msg);
            }
            rawConfigHashMap.put(tmpConfigName, rawConfig);
            String configDescName = rawConfig.getConfigurationDescription();
            if (configDescName == null || configDescName.length() == 0) continue;
            Configuration mergedConfig = this.computeMergedConfiguration(rawConfig, request);
            if (mergedConfig != null) {
                mergedConfigHashMap.put(tmpConfigName, mergedConfig);
                continue;
            }
            rawConfigHashMap.remove(tmpConfigName);
            String msg = this.getClass().getName() + ".loadCache():  " + "configuration called \"" + tmpConfigName + "\" cannot merge with configuration description \"" + configDescName + "\"";
            ConfigurationDebug.logWarning(msg);
        }
        configSet = userContext.getAttribute(this.serviceMap, this.descAttributeName);
        configIter = configSet.iterator();
        while (configIter.hasNext()) {
            configString = (String)configIter.next();
            Configuration tmpConfig = new Configuration(configString);
            if (tmpConfig.getProperty("merge") != null || tmpConfig.getProperty("default") != null) continue;
            tmpConfigName = tmpConfig.getConfigurationName();
            tmpConfig.setConfigurationDescription(tmpConfigName);
            HashMap tmpConfigHashMap = tmpConfig.getHashMap();
            tmpConfigHashMap.remove("merge");
            tmpConfigHashMap.remove("default");
            tmpConfigHashMap.remove("encoded");
            mergedConfigHashMap.put(tmpConfigName, tmpConfig);
        }
        this.mergedConfigCache.put(hashKey, mergedConfigHashMap);
        this.rawConfigCache.put(hashKey, rawConfigHashMap);
        HashtableReaper reaper = new HashtableReaper(hashKey, this.mergedConfigCache);
        if (token != null) {
            token.addSSOTokenListener((SSOTokenListener)reaper);
        }
        reaper = new HashtableReaper(hashKey, this.rawConfigCache);
        if (token != null) {
            token.addSSOTokenListener((SSOTokenListener)reaper);
        }
    }

    public Configuration readConfiguration(String configName, boolean useDesc, HttpServletRequest request) throws ConfigurationException {
        String tokenString;
        SSOToken token;
        Configuration finalConfig;
        block10: {
            finalConfig = null;
            SSOTokenManager tokenManager = null;
            token = null;
            SSOTokenID tokenID = null;
            tokenString = null;
            try {
                tokenManager = SSOTokenManager.getInstance();
                token = tokenManager.createSSOToken(request);
                tokenID = token.getTokenID();
                tokenString = tokenID.toString();
            }
            catch (SSOException ssoe) {
                tokenString = (String)request.getAttribute(authlessSUID);
                if (tokenString != null) break block10;
                String msg = this.getClass().getName() + ".readConfiguration():  " + "failed:  Session Invalid for configuration " + configName;
                ConfigurationDebug.logWarning(msg);
                throw new ConfigurationException(msg);
            }
        }
        try {
            String hashKey = tokenString;
            if (useDesc) {
                HashMap mergedConfigHashMap = (HashMap)this.mergedConfigCache.get(hashKey);
                if (mergedConfigHashMap != null) {
                    Configuration tmpConfig = null;
                    Set tmpSet = mergedConfigHashMap.keySet();
                    boolean found = false;
                    Iterator i = tmpSet.iterator();
                    while (i.hasNext()) {
                        String key = (String)i.next();
                        tmpConfig = (Configuration)mergedConfigHashMap.get(key);
                        String tmpConfigName = tmpConfig.getConfigurationName();
                        if (!tmpConfigName.equals(configName)) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        return tmpConfig;
                    }
                    return null;
                }
            } else {
                HashMap rawConfigHashMap = (HashMap)this.rawConfigCache.get(hashKey);
                if (rawConfigHashMap != null) {
                    return (Configuration)rawConfigHashMap.get(configName);
                }
            }
            this.loadCache(request, token, tokenString);
            finalConfig = this.readConfiguration(configName, useDesc, request);
        }
        catch (Exception e) {
            String msg = this.getClass().getName() + ".readConfiguration():  " + "failed:  " + e;
            ConfigurationDebug.logWarning(msg);
            throw new ConfigurationException(msg);
        }
        return finalConfig;
    }

    public boolean isConfigurationUserEditable(String configName, HttpServletRequest request) throws ConfigurationException {
        Configuration rawConfig = this.readConfiguration(configName, false, request);
        return rawConfig != null;
    }

    private void writeHashMap(HashMap configHashMap, HttpServletRequest request) throws Exception {
        HashSet<String> configSet = new HashSet<String>(configHashMap.size());
        Iterator configIter = configHashMap.values().iterator();
        while (configIter.hasNext()) {
            Configuration config = (Configuration)configIter.next();
            String configURL = config.getConfigurationURL();
            configSet.add(configURL);
        }
        try {
            ClientAwareUserContext userContext = this.contextFactory.getClientAwareUserContext(request);
            userContext.setAttribute(this.serviceMap, "default", this.rootAttributeName, configSet);
        }
        catch (Exception e) {
            String msg = this.getClass().getName() + ".writeConfigPropertiesHashtable() failed.  Reason:  " + e.toString();
            ConfigurationDebug.logError(msg);
            throw new ConfigurationException(msg);
        }
    }

    public void writeConfiguration(Configuration config, HttpServletRequest request) throws ConfigurationException {
        String tokenString;
        String configName = config.getConfigurationName();
        try {
            SSOTokenManager tokenManager = SSOTokenManager.getInstance();
            SSOToken token = tokenManager.createSSOToken(request);
            SSOTokenID tokenID = token.getTokenID();
            tokenString = tokenID.toString();
            this.loadCache(request, token, tokenString, true, configName);
        }
        catch (Exception e) {
            String msg = this.getClass().getName() + ".writeConfiguration():  failed.  Reason:  " + e.toString();
            ConfigurationDebug.logError(msg);
            throw new ConfigurationException(msg);
        }
        String hashKey = tokenString;
        if (configName == null) {
            String msg = this.getClass().getName() + ".writeConfiguration():  " + "Cannot write a configuration without a configuration name.";
            ConfigurationDebug.logWarning(msg);
            throw new ConfigurationException(msg);
        }
        String configDescName = config.getConfigurationDescription();
        boolean badConfigDesc = false;
        HashMap rawConfigHashMap = (HashMap)this.rawConfigCache.get(hashKey);
        try {
            if (configDescName == null) {
                rawConfigHashMap.put(configName, config);
                this.writeHashMap(rawConfigHashMap, request);
            } else {
                ConfigurationFactory descFactory = ConfigurationFactory.getInstance(this.serviceName, this.descAttributeName);
                Configuration configDescription = descFactory.readConfiguration(configDescName, false, request);
                if (configDescription == null) {
                    badConfigDesc = true;
                    throw new Exception();
                }
                String[] userDef = configDescription.getPropertyArray("merge");
                String[] defaultDef = configDescription.getPropertyArray("default");
                String[] encodedDef = configDescription.getPropertyArray("encoded");
                if (userDef != null || defaultDef != null) {
                    Object val;
                    String key;
                    int i;
                    Configuration userConfig = new Configuration();
                    userConfig.setConfigurationName(configName);
                    userConfig.setConfigurationDescription(configDescName);
                    if (userDef != null) {
                        for (i = 0; i < userDef.length; ++i) {
                            key = userDef[i];
                            val = config.getPropertyArray(key);
                            if (val == null) continue;
                            userConfig.setPropertyArray(key, (String[])val);
                        }
                    }
                    if (encodedDef != null) {
                        for (i = 0; i < encodedDef.length; ++i) {
                            key = encodedDef[i];
                            val = userConfig.getProperty(key);
                            if (val == null) continue;
                            userConfig.setProperty(key, (String)AccessController.doPrivileged(new EncryptAction((String)val)));
                        }
                    }
                    rawConfigHashMap.put(configName, userConfig);
                    this.writeHashMap(rawConfigHashMap, request);
                }
            }
            this.mergedConfigCache.remove(hashKey);
            this.rawConfigCache.remove(hashKey);
        }
        catch (Exception e) {
            this.mergedConfigCache.remove(hashKey);
            this.rawConfigCache.remove(hashKey);
            String msg = badConfigDesc ? this.getClass().getName() + ".writeConfiguration():  " + "attempt to reference non-existent configuration description, configDescName=" + configDescName : this.getClass().getName() + ".writeConfiguration():  failed.  Reason:  " + e.toString();
            ConfigurationDebug.logError(msg);
            throw new ConfigurationException(msg);
        }
    }

    public void removeConfiguration(String configName, HttpServletRequest request) throws ConfigurationException {
        String hashKey = null;
        try {
            HashMap mergedConfigHashMap;
            Configuration tmpConfig;
            String tokenString;
            SSOTokenManager tokenManager = SSOTokenManager.getInstance();
            SSOToken token = tokenManager.createSSOToken(request);
            SSOTokenID tokenID = token.getTokenID();
            hashKey = tokenString = tokenID.toString();
            this.loadCache(request, token, tokenString);
            HashMap rawConfigHashMap = (HashMap)this.rawConfigCache.get(hashKey);
            if (rawConfigHashMap != null && (tmpConfig = (Configuration)rawConfigHashMap.get(configName)) != null) {
                tmpConfig.setHashMap(tmpConfig.getHashMap());
                rawConfigHashMap.remove(configName);
            }
            if ((mergedConfigHashMap = (HashMap)this.mergedConfigCache.get(hashKey)) != null && (tmpConfig = (Configuration)mergedConfigHashMap.get(configName)) != null) {
                tmpConfig.setHashMap(tmpConfig.getHashMap());
                mergedConfigHashMap.remove(configName);
            }
            this.writeHashMap(rawConfigHashMap, request);
            this.mergedConfigCache.remove(hashKey);
            this.rawConfigCache.remove(hashKey);
        }
        catch (Exception e) {
            if (hashKey != null) {
                this.mergedConfigCache.remove(hashKey);
                this.rawConfigCache.remove(hashKey);
            }
            String msg = this.getClass().getName() + ".removeConfiguration():  failed.  Reason:  " + e.toString();
            ConfigurationDebug.logError(msg);
            throw new ConfigurationException(msg);
        }
    }

    private class HashtableReaper
    implements SSOTokenListener {
        private String key;
        private Hashtable hashTable;

        HashtableReaper(String key, Hashtable hashTable) {
            this.key = key;
            this.hashTable = hashTable;
        }

        public void ssoTokenChanged(SSOTokenEvent evt) {
            try {
                int evtType = evt.getType();
                if (evtType != 3) {
                    if (evtType != 1) {
                        if (evtType != 2) {
                            return;
                        }
                    }
                }
                this.hashTable.remove(this.key);
            }
            catch (Exception e) {
                ConfigurationDebug.logError(this.getClass().getName() + ".ssoTokenChanged():  failed:  " + e);
            }
        }
    }

    private class HashMapKeyEnumeration
    implements Enumeration {
        Iterator hashIter = null;

        HashMapKeyEnumeration(TreeMap map) {
            this.hashIter = map.keySet().iterator();
        }

        public boolean hasMoreElements() {
            return this.hashIter.hasNext();
        }

        public Object nextElement() {
            return this.hashIter.next();
        }
    }
}

