/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers;

import com.sun.portal.providers.ProviderAdapter;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.context.Theme;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterException;
import com.sun.ssoadapter.SSOAdapterFactory;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class ProviderEditUtility {
    private static Properties adapterProperties = new Properties();
    private static URL errorURL = null;
    public static String editContainer = null;
    public static String container = null;

    public static StringBuffer getSSOAdapterPrefs(ProviderAdapter prov, SSOAdapter ssoa) throws Exception {
        Map ssoEditMap = null;
        ProviderContext pc = prov.getProviderContext();
        StringBuffer content = new StringBuffer();
        pc.debugMessage((Object)"ProviderEditUtility.getSSOAdapterPrefs():  called");
        Properties adapterProps = ssoa.getProperties();
        if (adapterProps == null) {
            throw new Exception("ProviderEditUtility::getSSOAdapterPrefs: Unable to retrieve the SSOAdapter properties");
        }
        ProviderEditUtility.setSSOAdapterProperties(adapterProps);
        List pflist = null;
        try {
            pflist = pc.getClientAndLocalePropertiesFilters();
            ssoEditMap = pc.getCollectionProperty(prov.getName(), "ssoEditAttributes", pflist);
        }
        catch (ProviderContextException pce) {
            ssoEditMap = pc.getCollectionProperty(prov.getName(), "ssoEditAttributes");
        }
        pc.debugMessage((Object)("ProviderEditUtility.getSSOAdapterPrefs(): ssoEditMap size= " + Integer.toString(ssoEditMap.size())));
        if (ssoEditMap != null) {
            Set entries = ssoEditMap.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                pc.debugMessage((Object)("ProviderEditUtility.getSSOAdapterPrefs(): key=" + key + " val=" + val));
                StringTokenizer tok = new StringTokenizer(val, "|");
                while (tok.hasMoreElements()) {
                    String type = tok.nextToken();
                    String header = tok.nextToken();
                    pc.debugMessage((Object)("ProviderEditUtility.getSSOAdapterPrefs(): type=" + type + " header=" + header));
                    String editContent = ProviderEditUtility.createEditContent(type, header, key, prov.getName(), pc, false).toString();
                    content.append(editContent);
                }
            }
        }
        return content;
    }

    public static URL getErrorURL() {
        return errorURL;
    }

    private static void setErrorURL(ProviderAdapter prov, SSOAdapterException ssoe, HttpServletRequest req) {
        URL url = null;
        ProviderContext pc = prov.getProviderContext();
        pc.debugMessage((Object)("editContainer=" + editContainer));
        pc.debugMessage((Object)("container=" + container));
        ResourceBundle bundle = null;
        try {
            bundle = prov.getResourceBundle();
        }
        catch (ProviderException pe) {
            pc.debugWarning((Object)("Unable to retrieve the " + prov.getName() + " providers resource bundle"), (Throwable)pe);
        }
        if (ssoe.isInvalid()) {
            String editURL = pc.getDesktopURL(req);
            editURL = editURL + "?action=edit";
            editURL = editURL + "&provider=" + pc.encodeURLParameter(editContainer);
            editURL = editURL + "&targetprovider=" + pc.encodeURLParameter(prov.getName());
            editURL = editURL + "&containerName=" + pc.encodeURLParameter(container);
            String ssoErrMsg = ssoe.getMessage();
            editURL = editURL + "&error=" + pc.encodeURLParameter(ssoErrMsg);
            pc.debugMessage((Object)("Setting errorURL to " + editURL));
            try {
                url = new URL(editURL);
            }
            catch (Exception e) {
                pc.debugWarning((Object)"Setting errorURL to null");
                errorURL = null;
            }
            errorURL = url;
            pc.debugWarning((Object)("Setting errorURL to " + editURL));
        }
    }

    private static void setErrorURL() {
        errorURL = null;
    }

    public static Hashtable setDefaultPresentation(String provName, ProviderContext pc, Hashtable tagTable) throws ProviderContextException {
        String attr = "";
        attr = Theme.getAttribute((String)provName, (ProviderContext)pc, (String)"bgColor");
        pc.debugMessage((Object)("ProviderEditUtility.setDefaultPresentation(): bgColor=" + attr));
        if (attr != null && !attr.equals("")) {
            tagTable.put("bgColor", attr);
        } else {
            tagTable.put("bgColor", "#FFFFFF");
        }
        attr = Theme.getAttribute((String)provName, (ProviderContext)pc, (String)"borderWidth");
        pc.debugMessage((Object)("ProviderEditUtility.setDefaultPresentation(): borderWidth=" + attr));
        if (attr != null && !attr.equals("")) {
            tagTable.put("borderWidth", attr);
        } else {
            tagTable.put("borderWidth", "0");
        }
        attr = Theme.getAttribute((String)provName, (ProviderContext)pc, (String)"fontFace");
        pc.debugMessage((Object)("ProviderEditUtility.setDefaultPresentation(): fontFace=" + attr));
        if (attr != null && !attr.equals("")) {
            tagTable.put("fontFace", attr);
        } else {
            tagTable.put("fontFace", "Sans-serif");
        }
        attr = Theme.getAttribute((String)provName, (ProviderContext)pc, (String)"titleBarColor");
        pc.debugMessage((Object)("ProviderEditUtility.setDefaultPresentation(): titlebarColor=" + attr));
        if (attr != null && !attr.equals("")) {
            tagTable.put("titlebarColor", attr);
        } else {
            tagTable.put("titlebarcolor", "Sans-serif");
        }
        attr = Theme.getAttribute((String)provName, (ProviderContext)pc, (String)"borderColor");
        pc.debugMessage((Object)("ProviderEditUtility.setDefaultPresentation(): borderColor=" + attr));
        if (attr != null && !attr.equals("")) {
            tagTable.put("borderColor", attr);
        } else {
            tagTable.put("borderColor", "#666699");
        }
        attr = Theme.getAttribute((String)provName, (ProviderContext)pc, (String)"fontColor");
        pc.debugMessage((Object)("ProviderEditUtility.setDefaultPresentation(): fontColor=" + attr));
        if (attr != null && !attr.equals("")) {
            tagTable.put("fontColor", attr);
        } else {
            tagTable.put("fontColor", "#000000");
        }
        attr = Theme.getAttribute((String)provName, (ProviderContext)pc, (String)"channelsBackgroundColor");
        pc.debugMessage((Object)("ProviderEditUtility.setDefaultPresentation(): channelBgColor=" + attr));
        if (attr != null && !attr.equals("")) {
            tagTable.put("channelBgColor", attr);
        } else {
            tagTable.put("channelBgColor", "#FFFFFF");
        }
        return tagTable;
    }

    public static SSOAdapter setSSOAdapterPrefs(ProviderAdapter prov, SSOAdapter ssoAdapter, SSOAdapterFactory adapterFactory, HttpServletRequest request) throws Exception {
        Map ssoEditMap = null;
        ProviderContext pc = prov.getProviderContext();
        Object url = null;
        Properties props = new Properties();
        Properties adapterProps = ssoAdapter.getProperties();
        if (adapterProps == null) {
            throw new Exception("ProviderEditUtility::getSSOAdapterPrefs: Unable to retrieve the SSOAdapter properties");
        }
        ProviderEditUtility.setSSOAdapterProperties(adapterProps);
        List pflist = null;
        try {
            pflist = pc.getClientAndLocalePropertiesFilters();
            ssoEditMap = pc.getCollectionProperty(prov.getName(), "ssoEditAttributes", pflist);
        }
        catch (ProviderContextException pce) {
            ProviderEditUtility.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
            ssoEditMap = pc.getCollectionProperty(prov.getName(), "ssoEditAttributes");
        }
        if (ssoEditMap != null) {
            Set entries = ssoEditMap.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                String value = ProviderEditUtility.getRequestParameter(key, request);
                props.setProperty(key, value);
                pc.debugMessage((Object)("ProviderEditUtility.setSSOAdapterPrefs: Saving " + key + " = " + value));
            }
        }
        props.setProperty("channelName", prov.getName());
        props.setProperty("validate", "true");
        SSOAdapter ssoa = null;
        String editContainer = "";
        String container = "";
        String queryString = "";
        ResourceBundle bundle = null;
        try {
            bundle = prov.getResourceBundle();
        }
        catch (ProviderException pe) {
            pc.debugError((Object)"Error retrieving ResourceBundle", (Throwable)pe);
        }
        if (request == null) {
            pc.debugError((Object)"request is null");
        }
        try {
            ssoa = adapterFactory.getSSOAdapter(ssoAdapter, props, request, pc.getLocale(), prov.getName());
            ProviderEditUtility.setErrorURL();
        }
        catch (SSOAdapterException ssoe) {
            ProviderEditUtility.setErrorURL(prov, ssoe, request);
            pc.debugWarning((Object)"Unable to get SSOAdapter from SSOAdapterFactory", (Throwable)ssoe);
            pc.debugWarning((Object)(prov.getName() + "Provider.setSSOAdapterPrefs(): Failed to " + "update SSOAdapter configuration. "), (Throwable)ssoe);
        }
        catch (Exception e) {
            pc.debugWarning((Object)(prov.getName() + "Provider.setSSOAdapterPrefs(): " + "Failed. "), (Throwable)e);
        }
        if (ssoa != null) {
            String ssoaName = ssoa.getName();
            try {
                if (!pc.getStringProperty(prov.getName(), "ssoAdapter").equals(ssoaName)) {
                    pc.setStringProperty(prov.getName(), "ssoAdapter", ssoaName);
                }
            }
            catch (ProviderContextException pce) {
                pc.debugError((Object)"Exception thrown retrieving and setting values from the display profile\n", (Throwable)pce);
            }
        }
        return ssoa;
    }

    public static String getSSOProperty(String key) {
        Properties adapterProperties = ProviderEditUtility.getSSOAdapterProperties();
        String tmp = adapterProperties.getProperty(key);
        if (tmp == null) {
            tmp = "";
        }
        return tmp;
    }

    public static String getRequestParameter(String key, HttpServletRequest req) {
        String tmp = req.getParameter(key);
        if (tmp == null) {
            tmp = "";
        }
        return tmp;
    }

    public static void setSSOAdapterProperties(Properties props) {
        adapterProperties = props;
    }

    public static boolean isAppHandlerSet(HashMap appHandlers, String appValue) {
        if (appHandlers == null || appHandlers.isEmpty() || appValue == null || appValue.equals("")) {
            return false;
        }
        HashMap appMap = appHandlers;
        Set handlers = appMap.entrySet();
        Iterator appHandlerSet = handlers.iterator();
        while (appHandlerSet.hasNext()) {
            Map.Entry appHandler = appHandlerSet.next();
            String key = (String)appHandler.getKey();
            if (!key.equals(appValue)) continue;
            return true;
        }
        return false;
    }

    public static Properties getSSOAdapterProperties() {
        return adapterProperties;
    }

    public static StringBuffer createEditContent(String type, String header, String key, String pName, ProviderContext pc, boolean useDP) {
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        StringBuffer content = new StringBuffer();
        List pflist = null;
        try {
            ProviderEditUtility.setDefaultPresentation(pName, pc, tagTable);
            tagTable.put("iwtDesktop-fontFace1", pc.getStringProperty(pName, "fontFace1", "Sans-serif"));
            pflist = pc.getClientAndLocalePropertiesFilters();
        }
        catch (ProviderContextException pce) {
            ProviderEditUtility.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
        }
        if (type.equals("string")) {
            tagTable.put("header", header);
            tagTable.put("attName", key);
            try {
                if (useDP) {
                    if (pc.existsStringProperty(pName, key, pflist)) {
                        tagTable.put("attValue", pc.getStringProperty(pName, key, "", pflist));
                    } else if (pc.existsStringProperty(pName, key)) {
                        tagTable.put("attValue", pc.getStringProperty(pName, key, ""));
                    } else {
                        tagTable.put("attValue", "");
                    }
                } else {
                    tagTable.put("attValue", ProviderEditUtility.getSSOProperty(key));
                }
                String id = "id" + key;
                tagTable.put("resourceName", id);
                content.append(pc.getTemplate(pName, "edit-string.template", tagTable));
            }
            catch (ProviderContextException pce) {
                ProviderEditUtility.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
            }
        } else if (type.equals("select")) {
            Map selectMap = null;
            String selectedValue = "";
            try {
                selectedValue = useDP ? (pc.existsStringProperty(pName, key, pflist) ? pc.getStringProperty(pName, key, "", pflist) : (pc.existsStringProperty(pName, key) ? pc.getStringProperty(pName, key, "") : "")) : ProviderEditUtility.getSSOProperty(key);
                try {
                    selectMap = pc.getCollectionProperty(pName, key + "SelectOptions", pflist);
                }
                catch (ProviderContextException pce) {
                    selectMap = pc.getCollectionProperty(pName, key + "SelectOptions");
                }
            }
            catch (ProviderContextException pce) {
                ProviderEditUtility.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
            }
            Set selEntries = selectMap.entrySet();
            Iterator selIter = selEntries.iterator();
            StringBuffer options = new StringBuffer();
            while (selIter.hasNext()) {
                Map.Entry selEntry = selIter.next();
                String selKey = (String)selEntry.getKey();
                String selValue = (String)selEntry.getValue();
                tagTable.put("attValue", selKey);
                tagTable.put("string", selValue);
                if (selKey.equals(selectedValue)) {
                    tagTable.put("selected", "SELECTED");
                } else {
                    tagTable.put("selected", "");
                }
                try {
                    options.append(pc.getTemplate(pName, "edit-selectoption.template", tagTable));
                }
                catch (ProviderContextException pce) {
                    ProviderEditUtility.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
                }
            }
            tagTable.put("header", header);
            tagTable.put("attName", key);
            tagTable.put("options", options.toString());
            String id = "id" + key;
            tagTable.put("resourceName", id);
            try {
                content.append(pc.getTemplate(pName, "edit-select.template", tagTable));
            }
            catch (ProviderContextException pce) {
                ProviderEditUtility.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
            }
        } else if (type.equals("check")) {
            tagTable.put("header", header);
            tagTable.put("attName", key);
            String selected = "";
            boolean isSelected = false;
            try {
                if (useDP) {
                    isSelected = pc.existsBooleanProperty(pName, key, pflist) ? pc.getBooleanProperty(pName, key, pflist) : (pc.existsStringProperty(pName, key) ? pc.getBooleanProperty(pName, key) : Boolean.getBoolean("false"));
                } else {
                    Boolean bool = new Boolean(ProviderEditUtility.getSSOProperty(key));
                    isSelected = bool;
                }
                selected = isSelected ? "CHECKED" : "";
                tagTable.put("attSelected", selected);
                String id = "id" + key;
                tagTable.put("resourceName", id);
                content.append(pc.getTemplate(pName, "edit-checkbox.template", tagTable));
            }
            catch (ProviderContextException pce) {
                ProviderEditUtility.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
            }
        } else if (type.equals("password")) {
            tagTable.put("header", header);
            tagTable.put("attName", key);
            String pwd = "";
            try {
                pwd = useDP ? (pc.existsStringProperty(pName, key, pflist) ? pc.getStringProperty(pName, key, "", pflist) : (pc.existsStringProperty(pName, key) ? pc.getStringProperty(pName, key, "") : "")) : ProviderEditUtility.getSSOProperty(key);
                tagTable.put("attValue", pwd);
                String id = "id" + key;
                tagTable.put("resourceName", id);
                content.append(pc.getTemplate(pName, "edit-password.template", tagTable));
            }
            catch (ProviderContextException pce) {
                ProviderEditUtility.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
            }
        } else if (type.equals("int")) {
            tagTable.put("header", header);
            tagTable.put("attName", key);
            try {
                if (useDP) {
                    if (pc.existsIntegerProperty(pName, key, pflist)) {
                        tagTable.put("attValue", Integer.toString(pc.getIntegerProperty(pName, key, pflist)));
                    } else if (pc.existsIntegerProperty(pName, key)) {
                        tagTable.put("attValue", Integer.toString(pc.getIntegerProperty(pName, key)));
                    } else {
                        tagTable.put("attValue", "");
                    }
                } else {
                    tagTable.put("attValue", ProviderEditUtility.getSSOProperty(key));
                }
                String id = "id" + key;
                tagTable.put("resourceName", id);
                content.append(pc.getTemplate(pName, "edit-string.template", tagTable));
            }
            catch (ProviderContextException pce) {
                ProviderEditUtility.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
            }
        }
        return content;
    }

    public static void error(ProviderContext pc, String msg) {
        if (pc.isDebugErrorEnabled()) {
            pc.debugError((Object)msg);
        }
    }

    public static void warning(ProviderContext pc, String msg) {
        if (pc.isDebugWarningEnabled()) {
            pc.debugWarning((Object)msg);
        }
    }

    public static void message(ProviderContext pc, String msg) {
        if (pc.isDebugMessageEnabled()) {
            pc.debugMessage((Object)msg);
        }
    }

    public static void error(ProviderContext pc, String msg, Throwable t) {
        if (pc.isDebugErrorEnabled()) {
            pc.debugError((Object)msg, t);
        }
    }

    public static void warning(ProviderContext pc, String msg, Throwable t) {
        if (pc.isDebugWarningEnabled()) {
            pc.debugWarning((Object)msg, t);
        }
    }

    public static void message(ProviderContext pc, String msg, Throwable t) {
        if (pc.isDebugMessageEnabled()) {
            pc.debugMessage((Object)msg, t);
        }
    }
}

