/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.ui;

import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.tools.LDAPConfigReader;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.ui.SessionObjectFactory;
import com.iplanet.xslui.ui.XSLServlet;
import com.iplanet.xslui.ui.XSLUIEngine;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class XSLUIEngineServlet
extends XSLServlet {
    public static final String CONFIG_FILENAME = "uwcconfig.properties";
    public static final String CONFIG_LOGINPAGETEMPLATE = "loginpagetemplate";
    public static final String CONFIG_UWCLOGINPATH = "uwcloginpath";
    public static final String CONFIG_MAIL_HOST = "webmail.host";
    public static final String CONFIG_MAIL_PORT = "webmail.port";
    public static final String CONFIG_SSL_ENABLED = "uwcauth.ssl.enabled";
    public static final String CONFIG_SESSIONOBJ_PREFIX = "sessionobjfactory.";
    public static final String CONFIG_SESSIONID_SUFFIX = ".sessionid";
    private static final String ERROR_TEMPLATE = "error.xml";
    private XSLUIEngine _xslUIHandler = null;
    private static Hashtable _sessionObjTable = null;
    private String _loginPage;
    private String _uwcloginPath;
    private static String _mailURL;

    public void init(ServletConfig config) throws ServletException {
        this._config_filename = CONFIG_FILENAME;
        super.init(config);
        PropertyReader propertyReader = super.getPropertyReader();
        if (propertyReader == null) {
            throw new ServletException("Couldn't get config from uwcconfig.properties");
        }
        try {
            this._xslUIHandler = new XSLUIEngine(propertyReader.getConfigPath(), Logging.getLogHandler());
        }
        catch (Exception ioe) {
            Logging.error(2, "Couldn't create XSLUIEngine: " + ioe + ioe.getMessage());
            throw new ServletException("Couldn't create XSLUIEngine: " + ioe + ioe.getMessage());
        }
        _sessionObjTable = new Hashtable();
        Enumeration enumeration = propertyReader.getKeyProperty(CONFIG_SESSIONOBJ_PREFIX, ".class");
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String key = CONFIG_SESSIONOBJ_PREFIX + (String)enumeration.nextElement();
                String sessionID = propertyReader.getStringProperty(key + CONFIG_SESSIONID_SUFFIX, null);
                Object factory = null;
                try {
                    factory = propertyReader.getObjectProperty(key, true);
                }
                catch (Exception ex) {
                    Logging.error(2, "Exception thrown while creating Factory for: " + key);
                    Logging.errorPrintStackTrace(ex);
                    throw new ServletException("Exception thrown while creating Factory for: " + key);
                }
                if (sessionID != null && sessionID.length() > 0) {
                    if (factory != null) {
                        _sessionObjTable.put(sessionID, factory);
                        continue;
                    }
                    Logging.error(2, "Couldn't create Factory for: " + key);
                    throw new ServletException("error while creating Factory for: " + key);
                }
                Logging.error(2, "No sessionid for: " + key);
            }
        } else {
            Logging.error(2, "No sessionObject defined");
        }
        this._loginPage = propertyReader.getStringProperty(CONFIG_LOGINPAGETEMPLATE, "login.xml");
        this._uwcloginPath = propertyReader.getStringProperty(CONFIG_UWCLOGINPATH, "/base/UWCMain");
        String mailHost = propertyReader.getStringProperty(CONFIG_MAIL_HOST, null);
        String mailPort = propertyReader.getStringProperty(CONFIG_MAIL_PORT, null);
        String sProtocol = (String)config.getServletContext().getAttribute(CONFIG_SSL_ENABLED);
        Logging.trace(2, "SSL -> " + sProtocol);
        String protocolString = "http";
        if (sProtocol != null && sProtocol.equalsIgnoreCase("true")) {
            protocolString = "https";
        }
        if (mailHost != null) {
            _mailURL = protocolString + "://" + mailHost;
        }
        if (mailPort != null) {
            _mailURL = _mailURL + ":" + mailPort;
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = null;
        String xmlTemplate = null;
        boolean freshLogin = false;
        boolean doLogin = false;
        session = request.getSession(false);
        UserSession userSession = null;
        String integration = null;
        boolean gotError = false;
        if (session != null) {
            userSession = (UserSession)session.getAttribute("com.iplanet.xslui.ui.usersession");
            integration = (String)session.getAttribute("integration");
        }
        String validClientIP = (String)request.getAttribute("validClientIP");
        String uri = request.getRequestURI();
        if (session == null || userSession == null) {
            doLogin = true;
            Logging.trace(2, "<--- Usersession not created yet ---->");
        } else if (validClientIP != null && validClientIP.equals("false")) {
            doLogin = true;
            Logging.error(2, "<--- Client IP conflict --->");
        }
        if (doLogin) {
            if (integration == null) {
                integration = (String)request.getAttribute("integration");
            }
            if (integration != null) {
                StringBuffer uwcUri = new StringBuffer(this._uwcloginPath);
                uwcUri.append("?");
                uwcUri.append("gotoUri");
                uwcUri.append("=");
                uwcUri.append(uri);
                Logging.trace(2, "Forwarding to -> " + new String(uwcUri));
                RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(new String(uwcUri));
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (!uri.endsWith("xsl")) {
                xmlTemplate = this._loginPage;
            }
        } else {
            Enumeration enumeration = _sessionObjTable.keys();
            while (enumeration.hasMoreElements()) {
                String domain;
                String sessionID = (String)enumeration.nextElement();
                Object sessionObj = session.getAttribute(sessionID);
                if (sessionObj != null) continue;
                SessionObjectFactory sessionObjFactory = (SessionObjectFactory)_sessionObjTable.get(sessionID);
                sessionObj = sessionObjFactory.newSessionObject(userSession, domain = (String)session.getAttribute("domainname"));
                if (sessionObj != null) {
                    session.setAttribute(sessionID, sessionObj);
                } else {
                    Logging.error(2, "Can't create SessionObject: " + sessionID + " for user " + userSession.getUserId());
                    xmlTemplate = ERROR_TEMPLATE;
                }
                freshLogin = true;
            }
        }
        if (!gotError) {
            if (freshLogin) {
                session.setAttribute("com.iplanet.xslui.ui.freshlogin", (Object)"true");
            } else {
                session.setAttribute("com.iplanet.xslui.ui.freshlogin", (Object)"false");
            }
            if (uri.endsWith("jsp")) {
                int secondSlash = uri.indexOf("/", 1);
                String newUri = uri.substring(0, secondSlash);
                newUri = newUri.concat("jsp");
                newUri = newUri.concat(uri.substring(secondSlash));
                RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(newUri);
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            } else {
                this._xslUIHandler.process(request, response, xmlTemplate);
            }
        }
    }

    public void destroy() {
        Logging.trace(2, "Destroying LDAPPool for Address Book");
        LDAPConfigReader.destroyPool();
    }

    public static String getMailURL() {
        return _mailURL;
    }

    public static Hashtable getSessionObjectTable() {
        return _sessionObjTable;
    }
}

