/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.ui;

import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.ui.ElementHandler;
import com.iplanet.xslui.ui.XSLUIEngineServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class UserSessionHandler
extends ElementHandler {
    public void expand(HttpServletRequest request, Element xmlElt, Element errorRootElt) {
        String field;
        NamedNodeMap nodeMap;
        HttpSession session = request.getSession(false);
        if (xmlElt == null) {
            this._logHandler.error("UserSessionHandler.expand: null XML Element");
            return;
        }
        Document xmlDoc = xmlElt.getOwnerDocument();
        if (xmlDoc == null) {
            this._logHandler.error("UserSessionHandler.expand: null XML Doc");
            return;
        }
        if (session == null) {
            this._logHandler.error("UserSessionHandler.expand: null session");
            return;
        }
        UserSession user = (UserSession)session.getAttribute("com.iplanet.xslui.ui.usersession");
        if (user == null) {
            this._logHandler.error("UserSessionHandler.expand: null UserSession");
            return;
        }
        if (xmlElt.hasAttributes() && (nodeMap = xmlElt.getAttributes()) != null && nodeMap.getLength() > 0) {
            String sVal = null;
            String tmpValue = null;
            Node tmpNode = null;
            for (int i = 0; i < nodeMap.getLength(); ++i) {
                tmpNode = nodeMap.item(i);
                tmpValue = tmpNode.getNodeValue();
                if (tmpValue == null || tmpValue.length() <= 0) continue;
                try {
                    if (tmpValue.startsWith("'") && tmpValue.endsWith("'")) {
                        xmlElt.setAttribute(tmpNode.getNodeName(), tmpValue.substring(1, tmpValue.length() - 1));
                        continue;
                    }
                    sVal = user.getUserAttrib(tmpValue);
                    if (sVal != null) {
                        xmlElt.setAttribute(tmpNode.getNodeName(), sVal);
                        continue;
                    }
                    xmlElt.setAttribute(tmpNode.getNodeName(), "");
                    continue;
                }
                catch (DOMException de) {
                    this._logHandler.error("UserSessionHandler.expand : Error while expanding attribute " + tmpNode.getNodeName() + ": " + de.getMessage());
                }
            }
        }
        if ((field = user.getUserId()) != null && field.length() > 0) {
            xmlElt.setAttribute("uid", field);
        }
        if ((field = (String)session.getAttribute("username")) != null && field.length() > 0) {
            xmlElt.setAttribute("displayname", field);
        }
        if ((field = user.getDomain()) != null && field.length() > 0) {
            xmlElt.setAttribute("domain", field);
        }
        if ((field = user.getDN()) != null && field.length() > 0) {
            xmlElt.setAttribute("dn", field);
        }
        field = (String)session.getAttribute("integration");
        boolean isIntegrated = false;
        if (field != null && field.equals("true")) {
            isIntegrated = true;
            xmlElt.setAttribute("integration", "true");
        }
        if (isIntegrated) {
            field = (String)session.getAttribute("mail.service.enabled");
            if (field != null && field.equals("true")) {
                xmlElt.setAttribute("mailenabled", "true");
            } else {
                xmlElt.setAttribute("mailenabled", "false");
            }
            field = (String)session.getAttribute("calendar.service.enabled");
            if (field != null && field.equals("true")) {
                xmlElt.setAttribute("calendarenabled", "true");
            } else {
                xmlElt.setAttribute("calendarenabled", "false");
            }
            field = XSLUIEngineServlet.getMailURL();
            if (field != null) {
                xmlElt.setAttribute("mailurl", field);
            }
        }
    }
}

