/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.ui;

import com.iplanet.xslui.xslutil.DefaultXSLXMLLogHandler;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;
import javax.servlet.ServletContext;

public class Logging
implements XSLXMLLogHandler {
    public static final int STATE_OFF = 0;
    public static final int STATE_TRACE = 1;
    public static final int STATE_ERROR = 2;
    public static final int STATE_ALL = 3;
    public static final int DATABASE = 1;
    public static final int XSLT = 2;
    public static final int UTIL = 4;
    public static final int SERVLET = 8;
    public static final int DBTRANS = 16;
    public static final int PSTORE = 32;
    public static final int AUTH = 64;
    public static final int WABP = 128;
    public static final int LDAP = 256;
    public static final int PACKAGE_NONE = 0;
    public static final int PACKAGE_ALL = 255;
    private static int _state = 2;
    private static int _package = 255;
    private static PrintWriter _printWriter = null;
    private static ServletContext _servletContext = null;
    private static XSLXMLLogHandler _logHandler = null;

    public Logging(ServletContext servletContext) {
        _servletContext = servletContext;
        _logHandler = this;
    }

    public Logging(File logFile) {
        try {
            FileWriter fileWriter = new FileWriter(logFile.getAbsolutePath(), true);
            _printWriter = new PrintWriter(fileWriter);
        }
        catch (Exception e) {
            System.err.println("Debug:" + e);
            e.printStackTrace();
        }
        _logHandler = this;
    }

    public static void trace(int pkg, String msg) {
        if ((_state & 1) == 1 && (_package & pkg) == pkg) {
            if (_servletContext == null) {
                Date date = new Date();
                Logging.writeToFile("TRACE [" + date.toString() + "] " + msg);
                Object var2_2 = null;
            } else {
                _servletContext.log("TRACE " + msg);
            }
        }
    }

    public static void error(int pkg, String msg) {
        if ((_state & 2) == 2) {
            if (_servletContext == null) {
                Date date = new Date();
                Logging.writeToFile("ERROR [" + date.toString() + "] " + msg);
                Object var2_2 = null;
            } else {
                _servletContext.log("ERROR " + msg);
            }
        }
    }

    public static synchronized XSLXMLLogHandler getLogHandler() {
        if (_logHandler == null) {
            _logHandler = new DefaultXSLXMLLogHandler();
        }
        return _logHandler;
    }

    public void error(String message) {
        Logging.error(2, message);
    }

    public void debug(String message) {
        Logging.trace(2, message);
    }

    public static void setState(int state) {
        _state = state == 0 || state == 3 ? state : (_state |= state);
    }

    public static int getState() {
        return _state;
    }

    public boolean isLogEnabled() {
        return _state > 0;
    }

    public static void setPackage(int pkg) {
        _package = pkg == 0 || pkg == 255 ? pkg : (_package |= pkg);
    }

    public static int getPackage() {
        return _package;
    }

    public static void errorPrintStackTrace(Exception ex) {
        if (_servletContext == null) {
            if (_printWriter == null) {
                ex.printStackTrace();
            } else {
                ex.printStackTrace(_printWriter);
                _printWriter.flush();
            }
        } else {
            _servletContext.log("Exception", (Throwable)ex);
        }
    }

    private static synchronized void writeToFile(String msg) {
        if (_printWriter == null) {
            System.err.println(msg);
        } else {
            _printWriter.println(msg);
            _printWriter.flush();
        }
    }
}

