/*
 * Decompiled with CFR 0.152.
 */
package com.webworks.wwhelp4;

import com.webworks.wwhelp4.PropertyChangeSupport;
import com.webworks.wwhelp4.VetoableChangeSupport;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Beans;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class Timer
implements Runnable,
Serializable {
    protected Component target;
    protected int eventType;
    protected boolean repeat;
    protected boolean repeating;
    protected boolean execute;
    protected boolean live;
    protected boolean isDesignTime;
    protected int delay;
    protected String actionCommand;
    protected ActionListener actionListener = null;
    protected transient Thread thread;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public Timer() {
        this(1000, false);
    }

    public Timer(int n) {
        this(n, false);
    }

    public Timer(boolean bl) {
        this(1000, bl);
    }

    public Timer(int n, boolean bl) {
        this.delay = n;
        this.repeat = bl;
        this.execute = false;
        this.live = false;
        this.isDesignTime = Beans.isDesignTime();
        if (!this.isDesignTime) {
            this.thread = new Thread(this);
        }
    }

    public Timer(Component component) {
        this(1000);
    }

    public Timer(Component component, int n) {
        this(n, false);
    }

    public Timer(Component component, int n, boolean bl) {
        this(n, bl);
    }

    public Timer(Component component, int n, boolean bl, int n2) {
        this(n, bl);
    }

    public void setDelay(int n) throws PropertyVetoException {
        Integer n2 = new Integer(n);
        Integer n3 = new Integer(this.delay);
        this.vetos.fireVetoableChange("delay", n3, n2);
        this.delay = n;
        this.changes.firePropertyChange("delay", n3, n2);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setRepeat(boolean bl) throws PropertyVetoException {
        Boolean bl2 = new Boolean(bl);
        Boolean bl3 = new Boolean(this.repeat);
        this.vetos.fireVetoableChange("repeat", bl3, bl2);
        this.repeat = bl;
        this.changes.firePropertyChange("repeat", bl3, bl2);
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public boolean getRepeat() {
        return this.isRepeat();
    }

    public boolean isEnabled() {
        return this.live;
    }

    public boolean getEnabled() {
        return this.isEnabled();
    }

    public synchronized void pause() {
        this.execute = false;
        if (this.thread.isAlive()) {
            this.thread.suspend();
        }
        if (this.thread.isAlive()) {
            this.thread.suspend();
        }
    }

    public synchronized void resume() {
        if (!this.execute) {
            this.execute = true;
            if (this.thread.isAlive()) {
                this.thread.resume();
            } else {
                this.start();
            }
        }
    }

    public synchronized void start() {
        this.execute = true;
        this.live = true;
        if (!this.isDesignTime) {
            if (this.thread.isAlive() && !this.thread.isInterrupted()) {
                if (this.thread.isAlive()) {
                    this.thread.resume();
                }
            } else {
                this.thread = new Thread(this);
                this.thread.start();
            }
        }
    }

    public synchronized void start(int n) throws PropertyVetoException {
        this.setDelay(n);
        this.start();
    }

    public synchronized void start(boolean bl) throws PropertyVetoException {
        this.setRepeat(bl);
        this.start();
    }

    public synchronized void start(int n, boolean bl) throws PropertyVetoException {
        this.setDelay(n);
        this.setRepeat(bl);
        this.start();
    }

    public synchronized void restart() {
        this.stop();
        this.start();
    }

    public synchronized void stop() {
        this.execute = false;
        this.live = false;
        if (!this.isDesignTime && this.thread.isAlive()) {
            this.thread.interrupt();
        }
    }

    public void run() {
        if (!this.execute) {
            this.thread.suspend();
        }
        while (this.live) {
            do {
                this.repeating = this.repeat;
                try {
                    Thread.sleep(this.delay);
                    if (!this.execute) continue;
                    this.sourceActionEvent();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            } while (this.repeating && this.live);
            if ((this.execute || !this.live) && this.repeating) continue;
            this.thread.suspend();
        }
    }

    public void setActionCommand(String string) throws PropertyVetoException {
        String string2 = this.actionCommand;
        this.vetos.fireVetoableChange("actionCommand", string2, string);
        this.actionCommand = string;
        this.changes.firePropertyChange("actionCommand", string2, string);
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void sourceActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.execute = false;
        this.thread = new Thread(this);
    }
}

