/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.jhdemo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.help.DefaultHelpModel;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.JHelp;
import javax.help.JHelpContentViewer;
import javax.help.TextHelpModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import sunw.demo.jhdemo.ElementTreePanel;

public class JHLauncher {
    private static JFrame frame;
    public static int WIDTH;
    public static int HEIGHT;
    protected static boolean debug;
    protected static boolean setHS;
    private static boolean on12;
    private static Font[] fonts;
    private static JHelp jh;
    HelpSet hs = null;
    private JFrame elementTreeFrame;
    private static String hsName;
    private static String hsPath;
    private static String spec;
    private JDialog selectionDialog = null;
    private JTextField helpSetName;
    private JTextField helpSetURL;
    private String title = "";

    protected void initialize(String string, ClassLoader classLoader) {
        URL uRL = HelpSet.findHelpSet((ClassLoader)classLoader, (String)string, (String)"", (Locale)Locale.getDefault());
        if (uRL == null && (uRL = HelpSet.findHelpSet((ClassLoader)classLoader, (String)string, (String)".hs", (Locale)Locale.getDefault())) == null) {
            JOptionPane.showMessageDialog(null, "HelpSet not found", "Error", 0);
            return;
        }
        this.initialize(uRL, classLoader);
    }

    protected void initialize(URL uRL, ClassLoader classLoader) {
        try {
            this.hs = new HelpSet(classLoader, uRL);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "HelpSet not found", "Error", 0);
            return;
        }
        jh = new JHelp(this.hs);
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = jMenuBar.add(new JMenu("File"));
        jMenu.setMnemonic('F');
        JMenuItem jMenuItem = jMenu.add(new JMenuItem("Open page"));
        OpenPageListener openPageListener = new OpenPageListener();
        jMenuItem.addActionListener(openPageListener);
        if (setHS) {
            jMenuItem = jMenu.add(new JMenuItem("Set HelpSet"));
            jMenuItem.setMnemonic('s');
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (JHLauncher.this.selectionDialog == null) {
                        JHLauncher.this.initializeSDGUI();
                    }
                    JHLauncher.this.showSD();
                }
            });
        }
        jMenuItem = jMenu.add(new JMenuItem("Exit"));
        jMenuItem.setMnemonic('x');
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        JMenu jMenu2 = jMenuBar.add(new JMenu("Options"));
        jMenu2.setMnemonic('O');
        jMenuItem = jMenu2.add(new JMenuItem("Set Font..."));
        SetFontListener setFontListener = new SetFontListener();
        jMenuItem.addActionListener(setFontListener);
        if (debug) {
            jMenuItem = jMenu2.add(new JMenuItem("Show Element Tree"));
            ShowElementTreeListener showElementTreeListener = new ShowElementTreeListener();
            jMenuItem.addActionListener(showElementTreeListener);
        }
        return jMenuBar;
    }

    public Frame getFrame() {
        return frame;
    }

    private JTextComponent getEditor() {
        JHelpContentViewer jHelpContentViewer = jh.getContentViewer();
        JScrollPane jScrollPane = (JScrollPane)jHelpContentViewer.getComponent(0);
        JViewport jViewport = jScrollPane.getViewport();
        return (JTextComponent)jViewport.getView();
    }

    public static void main(String[] stringArray) {
        Object object;
        boolean bl = true;
        String string = System.getProperty("java.version");
        if (string.startsWith("1.0")) {
            System.out.println("!!!WARNING: JavaHelp & Swing must be runwith JDK 1.1.2 or higher version VM!!!");
        }
        try {
            object = Class.forName("javax.swing.JComponent");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Frame frame = new Frame("Error");
            TextArea textArea = new TextArea("Java Foundation Classes not found.\n\nThe program can only be run using JDK 1.2 and higher.\nIf you are using JDK 1.1 use the hsviewer1_1 utility", 4, 53, 3);
            frame.add(textArea);
            WindowAdapter windowAdapter = new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }

                public void windowClosed(WindowEvent windowEvent) {
                    System.exit(0);
                }
            };
            frame.addWindowListener(windowAdapter);
            frame.pack();
            frame.show();
            bl = false;
        }
        if (bl) {
            object = new JHLauncher();
            super.setup(stringArray);
        }
    }

    private String[] shiftArgs(String[] stringArray, int n) {
        int n2 = stringArray.length;
        String[] stringArray2 = new String[n2 - n];
        int n3 = 0;
        while (n3 < n2 - n) {
            stringArray2[n3] = stringArray[n3 + n];
            ++n3;
        }
        return stringArray2;
    }

    private static URL[] parseURLs(String string) {
        Object[] objectArray;
        Vector<Object[]> vector = new Vector<Object[]>();
        try {
            objectArray = new URL(string);
            vector.addElement(objectArray);
        }
        catch (Exception exception) {
            System.err.println("cannot create URL for " + string);
        }
        objectArray = new URL[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void setup(String[] stringArray) {
        Object object;
        ClassLoader classLoader = this.getClass().getClassLoader();
        Object var3_3 = null;
        URL uRL = null;
        String string = null;
        while (stringArray.length > 0) {
            URL[] uRLArray;
            if (stringArray[0].equals("-helpset")) {
                stringArray = this.shiftArgs(stringArray, 1);
                if (on12) {
                    object = new File(stringArray[0]);
                    this.handleHSFile((File)object);
                    uRLArray = JHLauncher.parseURLs(hsPath);
                    try {
                        classLoader = URLClassLoader.newInstance(uRLArray, classLoader);
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                    }
                    catch (NoSuchMethodError noSuchMethodError) {}
                } else {
                    hsName = stringArray[0];
                }
                stringArray = this.shiftArgs(stringArray, 1);
                continue;
            }
            if (stringArray[0].equals("-classpath")) {
                object = (stringArray = this.shiftArgs(stringArray, 1))[0];
                if (((String)object).startsWith("//")) {
                    object = ((String)object).substring(1);
                }
                if (((String)object).startsWith("..")) {
                    uRLArray = System.getProperty("user.dir");
                    object = (String)uRLArray + File.separator + (String)object;
                }
                object = new String("file:" + (String)object);
                uRLArray = JHLauncher.parseURLs((String)object);
                stringArray = this.shiftArgs(stringArray, 1);
                try {
                    classLoader = URLClassLoader.newInstance(uRLArray, classLoader);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    System.err.println("-classpath not supported in 1.1");
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    System.err.println("-classpath not supported in 1.1");
                }
                continue;
            }
            if (stringArray[0].equals("-hsURL")) {
                stringArray = this.shiftArgs(stringArray, 1);
                string = stringArray[0];
                stringArray = this.shiftArgs(stringArray, 1);
                continue;
            }
            if (stringArray[0].equals("-debug")) {
                debug = true;
                stringArray = this.shiftArgs(stringArray, 1);
                continue;
            }
            this.usage();
        }
        if (string != null) {
            try {
                JHLauncher.debug("hsSpec=" + string);
                uRL = new URL(string);
            }
            catch (Exception exception) {
                this.usage("Invalid URL spec for HelpSet");
            }
        }
        if (hsName != null && uRL != null) {
            this.usage();
        }
        if (hsName == null && uRL == null) {
            object = classLoader == null ? ClassLoader.getSystemResource("JHLauncher.data") : classLoader.getResource("JHLauncher.data");
            if (object != null) {
                System.err.println("Found JHLauncher.data at " + object);
            } else {
                setHS = true;
                this.initializeSDGUI();
                this.showSD();
                return;
            }
        }
        if (debug) {
            JHLauncher.debug("hsName: " + hsName);
            JHLauncher.debug("hsURL: " + uRL);
            JHLauncher.debug("loader: " + classLoader);
        }
        if (uRL != null) {
            this.initialize(uRL, classLoader);
        } else {
            this.initialize(hsName, classLoader);
        }
        if (this.hs == null) {
            setHS = true;
            this.initializeSDGUI();
            this.showSD();
            return;
        }
        this.createFrame(null, null);
        this.launch();
    }

    private void showSD() {
        if (this.selectionDialog != null) {
            this.selectionDialog.pack();
            this.selectionDialog.show();
        }
    }

    private void initializeSDGUI() {
        if (!on12) {
            JOptionPane.showMessageDialog(null, "Cannot set the HelpSet on JDK1.1 Platforms", "Error", 0);
            if (jh == null) {
                System.exit(0);
            } else {
                return;
            }
        }
        this.selectionDialog = new JDialog((Frame)null, "Set HelpSet...", true);
        Box box = Box.createVerticalBox();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "HelpSet Information"));
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createRigidArea(new Dimension(15, 0)));
        box2.add(new JLabel("HelpSet Name: "));
        this.helpSetName = new JTextField("HolidayHistory.hs", 40);
        this.helpSetName.setEditable(true);
        box2.add(this.helpSetName);
        box2.add(Box.createRigidArea(new Dimension(15, 0)));
        jPanel.add(box2);
        jPanel.add(Box.createVerticalStrut(5));
        box2 = Box.createHorizontalBox();
        box2.add(Box.createRigidArea(new Dimension(15, 0)));
        box2.add(new JLabel("HelpSet URL:  "));
        this.helpSetURL = new JTextField(40);
        box2.add(this.helpSetURL);
        box2.add(Box.createRigidArea(new Dimension(15, 0)));
        JButton jButton = new JButton("Browse...");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                JFileChooser jFileChooser = new JFileChooser();
                if (jFileChooser.showOpenDialog(JHLauncher.this.selectionDialog) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                    JHLauncher.this.handleHSFile(file);
                    JHLauncher.this.helpSetURL.setText(hsPath);
                    JHLauncher.this.helpSetName.setText(hsName);
                }
            }
        });
        box2.add(jButton);
        box2.add(Box.createRigidArea(new Dimension(15, 0)));
        jPanel.add(box2);
        jPanel.add(Box.createVerticalStrut(5));
        Box box3 = Box.createHorizontalBox();
        jButton = new JButton("Display");
        jButton.setEnabled(true);
        jButton.addActionListener(new DisplayAction());
        box3.add(jButton);
        box3.add(Box.createRigidArea(new Dimension(15, 0)));
        jButton = new JButton("Cancel");
        jButton.addActionListener(new CancelAction());
        box3.add(jButton);
        box3.add(Box.createRigidArea(new Dimension(15, 0)));
        box.add(Box.createRigidArea(new Dimension(0, 10)));
        box.add(jPanel);
        box.add(Box.createRigidArea(new Dimension(0, 10)));
        box.add(box3);
        box.add(Box.createRigidArea(new Dimension(0, 10)));
        this.selectionDialog.getContentPane().add(box);
    }

    private void handleHSFile(File file) {
        Object object;
        String string = null;
        hsName = file.getName();
        if (hsName.endsWith(".jar")) {
            string = file.getPath();
            hsName = "";
            try {
                object = new JarFile(file);
                Enumeration<JarEntry> enumeration = ((JarFile)object).entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    String string2 = zipEntry.getName();
                    if (!string2.endsWith(".hs")) continue;
                    hsName = string2;
                    break;
                }
            }
            catch (IOException iOException) {}
        } else {
            string = file.getParent();
            string = string == null ? File.separator : string.concat(File.separator);
        }
        if (string.startsWith("//")) {
            string = string.substring(1);
        }
        if (string.startsWith("..")) {
            object = System.getProperty("user.dir");
            string = (String)object + File.separator + string;
        }
        hsPath = new String("file:" + string);
    }

    private String breakPath(String string) {
        StringBuffer stringBuffer = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append("\n");
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    protected JFrame createFrame(String string, JMenuBar jMenuBar) {
        Object object;
        if (jh == null) {
            return null;
        }
        if (string == null || string.equals("")) {
            object = jh.getModel();
            HelpSet helpSet = object.getHelpSet();
            String string2 = helpSet.getTitle();
            if (string2 == null || string2.equals("")) {
                this.setTitle("Unnamed HelpSet");
            } else {
                this.setTitle(string2);
            }
        } else {
            this.setTitle(string);
        }
        if (frame == null) {
            object = new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }

                public void windowClosed(WindowEvent windowEvent) {
                    System.exit(0);
                }
            };
            frame = new JFrame(this.getTitle());
            ((Component)frame).setSize(WIDTH, HEIGHT);
            frame.setForeground(Color.black);
            ((Component)frame).setBackground(Color.lightGray);
            frame.addWindowListener((WindowListener)object);
            frame.getContentPane().add((Component)jh);
            if (jMenuBar == null) {
                jMenuBar = this.createMenuBar();
            }
            frame.setJMenuBar(jMenuBar);
        } else {
            frame.setTitle(this.getTitle());
        }
        frame.pack();
        return frame;
    }

    protected void setMenuBar(JMenuBar jMenuBar) {
        frame.setJMenuBar(jMenuBar);
    }

    protected void launch() {
        if (frame == null) {
            return;
        }
        ((Component)frame).setVisible(true);
    }

    protected void usage() {
        this.usage(null);
    }

    protected void usage(String string) {
        if (string != null) {
            System.err.println("JHLauncher: " + string);
        }
        System.err.println("Usage: [-helpset name | -classpath path | -hsURL spec]");
        System.exit(1);
    }

    protected static void debug(String string) {
        if (debug) {
            System.err.println("JHLauncher: " + string);
        }
    }

    static {
        WIDTH = 645;
        HEIGHT = 495;
        debug = false;
        setHS = false;
        jh = null;
        hsName = null;
        hsPath = null;
        spec = "";
        try {
            AccessControlException accessControlException = new AccessControlException("");
            on12 = true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            on12 = false;
        }
    }

    private class DisplayAction
    implements ActionListener {
        private DisplayAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            URLClassLoader uRLClassLoader;
            Object object;
            HelpSet helpSet = null;
            String string = JHLauncher.this.helpSetURL.getText();
            String string2 = JHLauncher.this.helpSetName.getText();
            if (on12) {
                object = JHLauncher.parseURLs(string);
                uRLClassLoader = new URLClassLoader((URL[])object);
            } else {
                uRLClassLoader = null;
            }
            object = HelpSet.findHelpSet(uRLClassLoader, (String)string2);
            if (object == null) {
                JOptionPane.showMessageDialog(JHLauncher.this.selectionDialog, "HelpSet not found", "Error", 0);
                return;
            }
            try {
                helpSet = new HelpSet((ClassLoader)uRLClassLoader, (URL)object);
            }
            catch (HelpSetException helpSetException) {
                System.err.println("Could not create HelpSet for " + object);
            }
            if (jh == null) {
                jh = new JHelp(helpSet);
            } else {
                DefaultHelpModel defaultHelpModel = new DefaultHelpModel(helpSet);
                jh.setModel((TextHelpModel)defaultHelpModel);
            }
            JHLauncher.this.createFrame(helpSet.getTitle(), null);
            JHLauncher.this.launch();
            JHLauncher.this.selectionDialog.hide();
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (frame == null) {
                System.exit(0);
            }
            ((Component)JHLauncher.this.selectionDialog).setVisible(false);
        }
    }

    class ShowElementTreeListener
    implements ActionListener {
        ShowElementTreeListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JHLauncher.this.elementTreeFrame = null;
            if (JHLauncher.this.elementTreeFrame == null) {
                Object object;
                try {
                    object = "Element Tree For Current Document";
                    JHLauncher.this.elementTreeFrame = new JFrame((String)object);
                }
                catch (MissingResourceException missingResourceException) {
                    JHLauncher.this.elementTreeFrame = new JFrame();
                }
                JHLauncher.this.elementTreeFrame.addWindowListener(new WindowAdapter(this){
                    private final /* synthetic */ ShowElementTreeListener this$1;
                    {
                        this.this$1 = showElementTreeListener;
                    }

                    public void windowClosing(WindowEvent windowEvent) {
                        ((Component)JHLauncher.access$100(ShowElementTreeListener.access$200(this.this$1))).setVisible(false);
                    }
                });
                object = JHLauncher.this.elementTreeFrame.getContentPane();
                ((Container)object).setLayout(new BorderLayout());
                ((Container)object).add(new ElementTreePanel(JHLauncher.this.getEditor()));
                JHLauncher.this.elementTreeFrame.pack();
            }
            JHLauncher.this.elementTreeFrame.show();
        }

        static /* synthetic */ JHLauncher access$200(ShowElementTreeListener showElementTreeListener) {
            return showElementTreeListener.JHLauncher.this;
        }
    }

    private class MyFont {
        private Font f;

        public MyFont(Font font) {
            this.f = font;
        }

        public Font getFont() {
            return this.f;
        }

        public String toString() {
            String string = this.f.getFamily();
            String string2 = this.f.getFontName();
            String string3 = string2.substring(string.length());
            if (string3.length() == 0) {
                string3 = "Plain";
            }
            return string3;
        }
    }

    private class SetFontListener
    implements ActionListener,
    TreeSelectionListener,
    ItemListener {
        JDialog sfDialog = null;
        JComboBox cb;
        JTree fontTree;
        JTextArea preview;
        JButton okButton;
        JButton cancelButton;
        Font font;

        private SetFontListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                JOptionPane.showMessageDialog(null, "Setting Fonts on JDK1.1 not allowed", "Set Font...", 0);
                return;
            }
            if (this.sfDialog == null) {
                this.sfDialog = new JDialog(JHLauncher.this.getFrame(), "Set Font...", false);
                this.initSetFontComponents();
                this.sfDialog.pack();
                this.cancelButton.addActionListener(new ActionListener(this){
                    private final /* synthetic */ SetFontListener this$1;
                    {
                        this.this$1 = setFontListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        ((Component)this.this$1.sfDialog).setVisible(false);
                        this.this$1.sfDialog.dispose();
                    }
                });
                this.okButton.addActionListener(new ActionListener(this){
                    private final /* synthetic */ SetFontListener this$1;
                    {
                        this.this$1 = setFontListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        JHLauncher.access$000().setFont(this.this$1.font);
                        ((Component)this.this$1.sfDialog).setVisible(false);
                        this.this$1.sfDialog.dispose();
                    }
                });
            }
            this.font = jh.getFont();
            this.preview.setFont(this.font);
            this.sfDialog.show();
        }

        private void initSetFontComponents() {
            Serializable serializable;
            Object object;
            Serializable serializable2;
            Object object2;
            Object object3;
            Serializable serializable3;
            Vector vector = new Vector();
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Font[] fontArray = graphicsEnvironment.getAllFonts();
            int n = 0;
            while (n < fontArray.length) {
                serializable3 = new DefaultMutableTreeNode(new MyFont(fontArray[n]));
                object3 = fontArray[n].getFamily();
                object2 = null;
                serializable2 = null;
                object = defaultMutableTreeNode.children();
                while (object.hasMoreElements()) {
                    serializable2 = (DefaultMutableTreeNode)object.nextElement();
                    object2 = (String)((DefaultMutableTreeNode)serializable2).getUserObject();
                    if (((String)object2).compareTo((String)object3) == 0) break;
                    serializable2 = null;
                }
                if (serializable2 == null) {
                    serializable = new DefaultMutableTreeNode(object3);
                    defaultMutableTreeNode.add((MutableTreeNode)((Object)serializable));
                    ((DefaultMutableTreeNode)serializable).add((MutableTreeNode)((Object)serializable3));
                } else {
                    ((DefaultMutableTreeNode)serializable2).add((MutableTreeNode)((Object)serializable3));
                }
                ++n;
            }
            serializable3 = Box.createVerticalBox();
            object3 = Box.createHorizontalBox();
            this.fontTree = new JTree(defaultMutableTreeNode);
            this.fontTree.setShowsRootHandles(true);
            this.fontTree.setRootVisible(false);
            object2 = this.fontTree.getSelectionModel();
            object2.addTreeSelectionListener(this);
            serializable2 = new JScrollPane();
            ((JScrollPane)serializable2).getViewport().add(this.fontTree);
            TitledBorder titledBorder = BorderFactory.createTitledBorder("Fonts");
            ((JComponent)serializable2).setBorder(titledBorder);
            ((Container)object3).add(Box.createHorizontalStrut(5));
            ((Container)object3).add((Component)serializable2);
            ((Container)object3).add(Box.createHorizontalStrut(5));
            object = Box.createHorizontalBox();
            this.cb = new JComboBox();
            titledBorder = BorderFactory.createTitledBorder("Size");
            this.cb.setBorder(titledBorder);
            this.cb.setEditable(true);
            this.cb.addItem("8");
            this.cb.addItem("9");
            this.cb.addItem("10");
            this.cb.addItem("11");
            this.cb.addItem("12");
            this.cb.addItem("13");
            this.cb.addItem("14");
            this.cb.addItem("16");
            this.cb.addItem("18");
            this.cb.addItem("20");
            this.cb.addItem("24");
            this.cb.addItem("28");
            this.cb.addItem("32");
            this.cb.addItem("36");
            this.cb.addItem("48");
            this.cb.addItem("72");
            this.cb.setSelectedItem("12");
            this.cb.addItemListener(this);
            ((Container)object).add(Box.createHorizontalStrut(5));
            ((Container)object).add(this.cb);
            ((Container)object).add(Box.createHorizontalStrut(5));
            ((Container)object3).add((Component)object);
            ((Container)object3).add(Box.createHorizontalStrut(5));
            ((Container)serializable3).add(Box.createVerticalStrut(10));
            ((Container)serializable3).add(Box.createVerticalStrut(5));
            ((Container)serializable3).add((Component)object3);
            serializable = Box.createHorizontalBox();
            JPanel jPanel = new JPanel();
            titledBorder = BorderFactory.createTitledBorder("Preview");
            jPanel.setBorder(titledBorder);
            this.preview = new JTextArea("\nAaBbCc...XxYyZz\n");
            jPanel.add(this.preview);
            ((Container)serializable).add(Box.createHorizontalStrut(5));
            ((Container)serializable).add(jPanel);
            ((Container)serializable).add(Box.createHorizontalStrut(5));
            ((Container)serializable3).add(Box.createVerticalStrut(10));
            ((Container)serializable3).add((Component)serializable);
            Box box = Box.createHorizontalBox();
            this.okButton = new JButton("OK");
            this.cancelButton = new JButton("Cancel");
            box.add(this.okButton);
            box.add(this.cancelButton);
            Box box2 = Box.createHorizontalBox();
            box2.add(Box.createHorizontalStrut(5));
            box2.add(new JSeparator());
            box2.add(Box.createHorizontalStrut(5));
            ((Container)serializable3).add(Box.createVerticalStrut(10));
            ((Container)serializable3).add(box2);
            ((Container)serializable3).add(box);
            this.sfDialog.getContentPane().add((Component)serializable3);
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            JHLauncher.debug("ValueChanged: " + treeSelectionEvent);
            TreePath treePath = this.fontTree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof MyFont) {
                MyFont myFont = (MyFont)object;
                String string = (String)this.cb.getSelectedItem();
                this.font = myFont.getFont().deriveFont(Integer.valueOf(string).floatValue());
                this.preview.setFont(this.font);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            JHLauncher.debug("ValueChanged: " + itemEvent);
            String string = (String)this.cb.getSelectedItem();
            this.font = this.font.deriveFont(Integer.valueOf(string).floatValue());
            this.preview.setFont(this.font);
        }
    }

    private class OpenPageListener
    implements ActionListener {
        JDialog opDialog = null;
        JButton okButton;
        JButton cancelButton;
        JButton chooseFileButton;
        JTextField page;

        private OpenPageListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.opDialog == null) {
                this.opDialog = new JDialog(JHLauncher.this.getFrame(), "Open Page", false);
                this.initOpenPageComponents();
                this.opDialog.pack();
                this.cancelButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ((Component)opDialog).setVisible(false);
                        opDialog.dispose();
                    }
                });
                this.okButton.addActionListener(new ActionListener(this){
                    private final /* synthetic */ OpenPageListener this$1;
                    {
                        this.this$1 = openPageListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            URL uRL = new URL(this.this$1.page.getText());
                            JHLauncher.access$000().setCurrentURL(uRL);
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                        ((Component)this.this$1.opDialog).setVisible(false);
                        this.this$1.opDialog.dispose();
                    }
                });
                this.chooseFileButton.addActionListener(new ActionListener(this){
                    private final /* synthetic */ OpenPageListener this$1;
                    {
                        this.this$1 = openPageListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        File file;
                        JFileChooser jFileChooser = new JFileChooser();
                        if (jFileChooser.showOpenDialog((Component)JHLauncher.access$000()) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                            String string = file.getPath();
                            if (string.startsWith("//")) {
                                string = string.substring(1);
                            }
                            this.this$1.page.setText(new String("file:" + string));
                        }
                    }
                });
            }
            this.opDialog.show();
        }

        private void initOpenPageComponents() {
            Box box = Box.createVerticalBox();
            Box box2 = Box.createHorizontalBox();
            JLabel jLabel = new JLabel("Enter the WWW location (URL) or specify the local file you would like to open");
            box2.add(Box.createHorizontalStrut(5));
            box2.add(jLabel);
            box2.add(Box.createHorizontalStrut(5));
            box.add(Box.createVerticalStrut(5));
            box.add(box2);
            Box box3 = Box.createHorizontalBox();
            JLabel jLabel2 = new JLabel("URL: ");
            this.page = new JTextField(20);
            this.page.setEditable(true);
            this.chooseFileButton = new JButton("Choose File...");
            this.chooseFileButton.setAlignmentY(0.5f);
            box3.add(Box.createHorizontalStrut(5));
            box3.add(jLabel2);
            box3.add(this.page);
            box3.add(Box.createHorizontalStrut(5));
            box3.add(this.chooseFileButton);
            box3.add(Box.createHorizontalStrut(5));
            box.add(Box.createVerticalStrut(10));
            box.add(box3);
            Box box4 = Box.createHorizontalBox();
            this.okButton = new JButton("OK");
            this.cancelButton = new JButton("Cancel");
            box4.add(this.okButton);
            box4.add(this.cancelButton);
            Box box5 = Box.createHorizontalBox();
            box5.add(Box.createHorizontalStrut(5));
            box5.add(new JSeparator());
            box5.add(Box.createHorizontalStrut(5));
            box.add(Box.createVerticalStrut(10));
            box.add(box5);
            box.add(box4);
            this.opDialog.getContentPane().add(box);
        }
    }
}

