/*
 * Decompiled with CFR 0.152.
 */
package com.webworks.wwhelp4;

import com.webworks.wwhelp4.TreeView;
import java.awt.Image;
import java.io.Serializable;

public class TreeNode
implements Serializable {
    TreeNode sibling;
    TreeNode child;
    TreeNode parent;
    String text;
    public String collapsedIcon;
    public String expandedIcon;
    transient Image collapsedImage;
    transient Image expandedImage;
    int numberOfChildren;
    Object dataObject;
    TreeView treeView;
    int depth = -1;
    boolean isExpanded = false;
    boolean hidden;

    public TreeNode() {
    }

    public TreeNode(String string) {
        this(string, null, null, null);
    }

    public TreeNode(String string, Image image, Image image2) {
        this(string, image, image2, null);
    }

    public TreeNode(String string, TreeView treeView) {
        this(string, null, null, treeView);
    }

    public TreeNode(String string, Image image, Image image2, TreeView treeView) {
        this.text = string;
        this.sibling = null;
        this.child = null;
        this.collapsedImage = image;
        this.expandedImage = image2;
        this.numberOfChildren = 0;
        this.dataObject = null;
        this.treeView = treeView;
    }

    void setDepth(int n) {
        this.depth = n;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public boolean isExpandable() {
        return this.child != null;
    }

    public void expand() {
        if (this.isExpandable()) {
            this.isExpanded = true;
            if (this.treeView != null) {
                this.treeView.triggerRedraw();
            }
        }
    }

    public void collapse() {
        this.isExpanded = false;
        if (this.treeView != null) {
            this.treeView.triggerRedraw();
        }
    }

    public void toggle() {
        if (this.isExpanded) {
            this.collapse();
        } else if (this.isExpandable()) {
            this.expand();
        }
    }

    public Image getImage() {
        return this.isExpanded && this.expandedImage != null ? this.expandedImage : this.collapsedImage;
    }

    public void setExpandedImage(Image image) {
        this.expandedImage = image;
        if (this.isExpanded() && this.treeView != null) {
            this.treeView.triggerRedraw();
        }
    }

    public void setCollapsedImage(Image image) {
        this.collapsedImage = image;
        if (!this.isExpanded() && this.treeView != null) {
            this.treeView.triggerRedraw();
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = new String(string);
        if (this.treeView != null) {
            this.treeView.triggerRedraw();
        }
    }

    public Object getDataObject() {
        return this.dataObject;
    }

    public void setDataObject(Object object) {
        this.dataObject = object;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public TreeNode getChild() {
        return this.child;
    }

    public TreeNode getSibling() {
        return this.sibling;
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
        if (this.treeView != null) {
            this.treeView.repaint(true);
        }
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isASiblingVisible() {
        if (this.sibling == null) {
            return false;
        }
        if (!this.sibling.isHidden()) {
            return true;
        }
        TreeNode treeNode = this.sibling;
        while (treeNode.sibling != null) {
            treeNode = treeNode.sibling;
            if (treeNode.isHidden()) continue;
            return true;
        }
        return false;
    }

    public boolean isAChildVisible() {
        if (this.child == null) {
            return false;
        }
        if (!this.child.isHidden()) {
            return true;
        }
        if (this.child.sibling == null) {
            return false;
        }
        return this.child.isASiblingVisible();
    }
}

