/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.providers.containers.util;

import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ContainerProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ChannelOrder {
    public static final String CHANNELSROW = "channelsRow";
    public static final String DEFAULTCHANNELROW = "defaultChannelRow";
    public static final String DEFAULTCHANNELISMOVABLE = "defaultChannelIsMovable";
    public static final String CHANNELSISMOVABLE = "channelsIsMovable";

    public static List order(List channels, String container, ContainerProviderContext context, boolean onlyMovable) throws ProviderException {
        Map channelsRow = null;
        Map channelsIsMovable = null;
        String defaultChannelRow = null;
        boolean defaultChannelIsMovable = false;
        try {
            channelsRow = context.getCollectionProperty(container, CHANNELSROW);
            channelsIsMovable = context.getCollectionProperty(container, CHANNELSISMOVABLE);
            defaultChannelRow = context.getStringProperty(container, DEFAULTCHANNELROW);
            defaultChannelIsMovable = context.getBooleanProperty(container, DEFAULTCHANNELISMOVABLE);
        }
        catch (ProviderContextException e) {
            throw new ProviderException("ChannelOrder.order(): ", (Throwable)e);
        }
        ChannelElementComparator comparator = new ChannelElementComparator();
        TreeMap<ChannelElement, String> orderedMap = new TreeMap<ChannelElement, String>(comparator);
        TreeMap<ChannelElement, String> nonMovableMap = new TreeMap<ChannelElement, String>(comparator);
        for (int i = 0; i < channels.size(); ++i) {
            String name = (String)channels.get(i);
            String row = channelsRow.containsKey(name) ? (String)channelsRow.get(name) : defaultChannelRow;
            boolean isMovable = channelsIsMovable.containsKey(name) ? (Boolean)channelsIsMovable.get(name) : defaultChannelIsMovable;
            ChannelElement element = new ChannelElement(Integer.parseInt(row), i);
            if (isMovable) {
                orderedMap.put(element, name);
                continue;
            }
            nonMovableMap.put(element, name);
        }
        ArrayList<Object> orderedList = null;
        if (orderedMap.size() > 0) {
            orderedList = new ArrayList(orderedMap.values());
            context.debugMessage((Object)"ChannelOrder.order(): orderedMap size is > 0");
        } else {
            context.debugMessage((Object)"ChannelOrder.order(): orderedMap size is <= 0");
            orderedList = new ArrayList();
        }
        if (onlyMovable) {
            return orderedList;
        }
        Set nonMovableEntries = nonMovableMap.entrySet();
        Iterator iterator = nonMovableEntries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ChannelElement key = (ChannelElement)entry.getKey();
            String value = (String)entry.getValue();
            int idx = key.row;
            context.debugMessage((Object)("ChannelOrder.order Index = " + String.valueOf(idx)));
            if (idx <= orderedList.size()) {
                orderedList.add(idx - 1, value);
                continue;
            }
            context.debugMessage((Object)"ChannelOrder.order(): Index > size, so appending");
            orderedList.add(orderedList.size(), value);
        }
        return orderedList;
    }

    public static class ChannelElementComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            ChannelElement channel1 = (ChannelElement)o1;
            ChannelElement channel2 = (ChannelElement)o2;
            if (channel1.row == channel2.row) {
                return channel1.index - channel2.index;
            }
            return channel1.row - channel2.row;
        }
    }

    public static class ChannelElement {
        public int row;
        public int index;

        public ChannelElement(int row, int index) {
            this.row = row;
            this.index = index;
        }
    }
}

