/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.providers.containers.template;

import com.sun.portal.providers.Provider;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ContainerProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.wireless.providers.containers.template.WirelessContainerProviderAdapter;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TemplateNativeContainerProvider
extends WirelessContainerProviderAdapter {
    private List minimizedChannelsList = null;
    private static int[] supportedStates = new int[2];
    ContainerProviderContext context = null;
    ResourceBundle bundle = null;
    Map serviceMap = null;

    public StringBuffer getContent(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        StringBuffer content = null;
        this.context = this.getContainerProviderContext();
        String maximizedChannel = this.getMaximizedChannel(request);
        if (maximizedChannel != null) {
            if (this.context.isDebugMessageEnabled()) {
                this.context.debugMessage((Object)("WirelessTemplateDesktop.getContent(): displaying maximizedChannel=" + maximizedChannel));
            }
            content = this.buildMaximizedChannel(request, response);
        } else {
            if (this.context.isDebugMessageEnabled()) {
                this.context.debugMessage((Object)"WirelessTemplateDesktop.getContent(): displaying desktop");
            }
            content = this.buildPage(request, response);
        }
        return content;
    }

    private StringBuffer buildMaximizedChannel(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        this.context = this.getContainerProviderContext();
        String maximizedChannel = this.getMaximizedChannel(request);
        Provider provider = this.context.getProvider(request, this.getName(), maximizedChannel);
        Hashtable<String, CharSequence> channelTags = new Hashtable<String, CharSequence>();
        channelTags.put("provider", maximizedChannel);
        channelTags.put("title", provider.getTitle());
        channelTags.put("content", provider.getContent(request, response));
        URL helpURL = null;
        try {
            helpURL = provider.getHelp(request);
        }
        catch (ProviderException e) {
            this.context.debugWarning((Object)"WirelessTemplateDesktop.buildMaximizedChannel(): no help file found", (Throwable)e);
        }
        if (helpURL != null) {
            channelTags.put("prov_help", this.getTemplate("provHelpLink.template"));
            channelTags.put("help_link", helpURL.toString());
        }
        return this.getTemplate("maximizedChannel.template", channelTags);
    }

    private StringBuffer buildPage(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        Hashtable<String, String> pageTags;
        StringBuffer maximizeQuerystring;
        List userChannels;
        this.context = this.getContainerProviderContext();
        this.bundle = this.getResourceBundle();
        this.serviceMap = new HashMap();
        this.minimizedChannelsList = userChannels = this.getOrderedSelectedChannels(request);
        boolean channelsAreMinimized = this.getBooleanProperty("defaultChannelIsMinimized");
        StringBuffer links = new StringBuffer();
        StringBuffer content = new StringBuffer();
        StringBuffer channelContent = null;
        StringBuffer linkContent = null;
        StringBuffer pagelinkContent = null;
        Hashtable<String, CharSequence> channelTags = new Hashtable<String, CharSequence>();
        Hashtable<String, CharSequence> mainTags = new Hashtable<String, CharSequence>();
        String name = null;
        String title = null;
        URL helpURL = null;
        String providerContent = null;
        Provider provider = null;
        mainTags.put("productName", this.getStringProperty("productName"));
        URL mainHelpURL = null;
        try {
            mainHelpURL = this.getHelp(request);
        }
        catch (ProviderException e) {
            this.context.debugWarning((Object)"WirelessTemplateDesktop.buildPage(): no help file found", (Throwable)e);
        }
        if (mainHelpURL != null) {
            mainTags.put("front_help", this.getTemplate("frontHelpLink.template"));
            mainTags.put("help_link", mainHelpURL.toString());
        }
        Map editPages = this.getMapProperty("editPages");
        StringBuffer contentQuerystring = new StringBuffer();
        StringBuffer layoutQuerystring = new StringBuffer();
        contentQuerystring = contentQuerystring.append("action").append('=').append("edit").append('&').append("provider").append('=').append(editPages.get("content")).append('&').append("client").append('=').append(this.context.getClientType());
        layoutQuerystring = layoutQuerystring.append("action").append('=').append("edit").append('&').append("provider").append('=').append(editPages.get("layout")).append('&').append("client").append('=').append(this.context.getClientType());
        mainTags.put("content_link", this.context.getDesktopURL(request, contentQuerystring.toString(), true));
        mainTags.put("layout_link", this.context.getDesktopURL(request, layoutQuerystring.toString(), true));
        mainTags.put("logout_link", this.context.getLogoutURL());
        int maxSize = 32000;
        String maxSizeStr = this.context.getClientTypeProperty("WmlDeckSize");
        try {
            if (maxSizeStr != null && (maxSize = Integer.parseInt(maxSizeStr)) < 0) {
                maxSize = 32000;
            }
        }
        catch (NumberFormatException nfe) {
            this.context.debugError((Object)("WirelessTemplateDesktop.getContent(): WmlDeckSize=" + maxSizeStr), (Throwable)nfe);
        }
        if (this.context.isDebugMessageEnabled()) {
            this.context.debugMessage((Object)("WirelessTemplateDesktop.getContent(): maxSize=" + maxSize));
        }
        int currentSize = this.getTemplate("frontProvider.template", mainTags).length();
        if (this.context.isDebugMessageEnabled()) {
            this.context.debugMessage((Object)("WirelessTemplateDesktop.getContent(): currentSize=" + currentSize));
        }
        int startChannel = 1;
        String page = request.getParameter("page");
        try {
            startChannel = Integer.parseInt(request.getParameter("startChannel"));
            if (startChannel < 1 || startChannel > userChannels.size()) {
                startChannel = 1;
            }
        }
        catch (NumberFormatException nfe) {
            startChannel = 1;
        }
        if (this.context.isDebugMessageEnabled()) {
            this.context.debugMessage((Object)("WirelessTemplateDesktop.getContent(): page=" + page + " startChannel=" + startChannel));
        }
        if (page != null && page.equalsIgnoreCase("next") && startChannel > 1) {
            if (this.context.isDebugMessageEnabled()) {
                this.context.debugMessage((Object)"WirelessTemplateDesktop.getContent(): handling next");
            }
            Hashtable<String, String> pageTags2 = new Hashtable<String, String>();
            pageTags2.put("textMsg", this.bundle.getString("prevPage"));
            StringBuffer prevQuerystring = new StringBuffer();
            prevQuerystring.append("page").append('=').append("prev").append('&').append("startChannel").append('=').append(startChannel - 1);
            pageTags2.put("changePageURL", this.context.getDesktopURL(request, prevQuerystring.toString(), true));
            StringBuffer previousTemplate = this.getTemplate("changePage.template", pageTags2);
            links.append(previousTemplate.toString());
            currentSize += previousTemplate.length();
            if (this.context.isDebugMessageEnabled()) {
                this.context.debugMessage((Object)("WirelessTemplateDesktop.getContent(): next::inserting previous link currentSize=" + currentSize + " link=" + previousTemplate.toString()));
            }
        }
        int currentChannel = startChannel + 1;
        if (page != null && page.equalsIgnoreCase("prev") && startChannel > 1) {
            if (this.context.isDebugMessageEnabled()) {
                this.context.debugMessage((Object)"WirelessTemplateDesktop.getContent(): handling previous");
            }
            int forecastSize = currentSize;
            ListIterator li = userChannels.listIterator(startChannel);
            while (li.hasPrevious()) {
                --currentChannel;
                name = (String)li.previous();
                if (this.context.isDebugMessageEnabled()) {
                    this.context.debugMessage((Object)("WirelesTemplateDesktop.getContent(): prev::currentChannel=" + currentChannel + " name=" + name));
                }
                provider = this.context.getProvider(request, this.getName(), name);
                title = provider.getTitle();
                channelTags.put("title", title);
                if (channelsAreMinimized) {
                    maximizeQuerystring = new StringBuffer();
                    maximizeQuerystring = maximizeQuerystring.append("provider").append('=').append(this.getName()).append('&').append("m").append('=').append(userChannels.indexOf(name));
                    channelTags.put("maximize_link", this.context.getDesktopURL(request, maximizeQuerystring.toString(), true));
                    linkContent = this.getTemplate("maximizeLinkWrapper.template", channelTags);
                } else {
                    providerContent = provider.getContent(request, response).toString();
                    channelTags.put("provider", name);
                    channelTags.put("content", providerContent);
                    try {
                        helpURL = provider.getHelp(request);
                    }
                    catch (ProviderException e) {
                        this.context.debugWarning((Object)"WirelessTemplateDesktop.buildPage(): no help file found", (Throwable)e);
                    }
                    if (helpURL != null) {
                        channelTags.put("prov_help", this.getTemplate("provHelpLink.template"));
                        channelTags.put("help_link", helpURL.toString());
                    }
                    channelContent = this.getTemplate("providerWrapper.template", channelTags);
                    forecastSize += channelContent.length();
                    linkContent = this.getTemplate("linkWrapper.template", channelTags);
                }
                forecastSize += linkContent.length();
                pagelinkContent = this.getTemplate("changePage.template");
                forecastSize += pagelinkContent.length();
                if (this.context.isDebugMessageEnabled()) {
                    this.context.debugMessage((Object)("WirelessTemplateDesktop.getContent(): prev::forecastSize=" + forecastSize + " ?> " + maxSize + "=maxSize"));
                }
                if (forecastSize > maxSize) {
                    if (currentChannel < startChannel) {
                        startChannel = currentChannel + 1;
                    }
                    pageTags = new Hashtable();
                    pageTags.put("textMsg", this.bundle.getString("prevPage"));
                    StringBuffer prevQuerystring = new StringBuffer();
                    prevQuerystring.append("page").append('=').append("prev").append('&').append("startChannel").append('=').append(startChannel - 1);
                    pageTags.put("changePageURL", this.context.getDesktopURL(request, prevQuerystring.toString(), true));
                    StringBuffer previousTemplate = this.getTemplate("changePage.template", pageTags);
                    links.append(previousTemplate.toString());
                    currentSize += previousTemplate.length();
                    if (!this.context.isDebugMessageEnabled()) break;
                    this.context.debugMessage((Object)("WirelessTemplateDesktop.getContent(): prev::inserting previous link currentSize=" + currentSize + "link=" + previousTemplate.toString()));
                    break;
                }
                startChannel = currentChannel;
            }
        }
        currentChannel = 0;
        Iterator i = userChannels.iterator();
        while (i.hasNext()) {
            int additionalSize = 0;
            name = (String)i.next();
            if (++currentChannel < startChannel) {
                if (!this.context.isDebugMessageEnabled()) continue;
                this.context.debugMessage((Object)("WirelessTemplateDesktop.getContent(): skippin currentChannel=" + currentChannel + " name=" + name));
                continue;
            }
            if (this.context.isDebugMessageEnabled()) {
                this.context.debugMessage((Object)("WirelessTemplateDesktop.getContent(): currentChannel=" + currentChannel + " name=" + name));
            }
            provider = this.context.getProvider(request, this.getName(), name);
            title = provider.getTitle();
            channelTags.put("title", title);
            if (channelsAreMinimized) {
                maximizeQuerystring = new StringBuffer();
                maximizeQuerystring = maximizeQuerystring.append("provider").append('=').append(this.getName()).append('&').append("m").append('=').append(userChannels.indexOf(name));
                channelTags.put("maximize_link", this.context.getDesktopURL(request, maximizeQuerystring.toString(), true));
                linkContent = this.getTemplate("maximizeLinkWrapper.template", channelTags);
            } else {
                providerContent = provider.getContent(request, response).toString();
                channelTags.put("provider", name);
                channelTags.put("content", providerContent);
                try {
                    helpURL = provider.getHelp(request);
                }
                catch (ProviderException e) {
                    this.context.debugWarning((Object)"WirelessTemplateDesktop.buildPage(): no help file found", (Throwable)e);
                }
                if (helpURL != null) {
                    channelTags.put("prov_help", this.getTemplate("provHelpLink.template"));
                    channelTags.put("help_link", helpURL.toString());
                }
                channelContent = this.getTemplate("providerWrapper.template", channelTags);
                additionalSize = channelContent.length();
                linkContent = this.getTemplate("linkWrapper.template", channelTags);
            }
            additionalSize += linkContent.length();
            if (this.context.isDebugMessageEnabled()) {
                this.context.debugMessage((Object)("WirelessTemplateDesktop.getContent(): current=" + currentSize + "+added=" + additionalSize + " ?> " + maxSize + "=maxSize"));
            }
            if (currentSize + additionalSize > maxSize) {
                if (currentChannel <= startChannel && !channelsAreMinimized) {
                    Hashtable<String, String> errorTags = new Hashtable<String, String>();
                    errorTags.put("noContentMsg", this.bundle.getString("contentTooLarge"));
                    channelTags.put("content", this.getTemplate("noContent.template", errorTags).toString());
                    channelContent = this.getTemplate("providerWrapper.template", channelTags);
                    content.append(channelContent.toString());
                    links.append(linkContent.toString());
                    if (this.context.isDebugMessageEnabled()) {
                        this.context.debugMessage((Object)("WirelessTemplateDesktop.getContent(): inserting too large msg link=" + linkContent.toString() + " content=" + channelContent.toString()));
                    }
                }
                if (++currentChannel > userChannels.size()) break;
                pageTags = new Hashtable<String, String>();
                pageTags.put("textMsg", this.bundle.getString("nextPage"));
                StringBuffer nextQuerystring = new StringBuffer();
                nextQuerystring.append("page").append('=').append("next").append('&').append("startChannel").append('=').append(currentChannel);
                pageTags.put("changePageURL", this.context.getDesktopURL(request, nextQuerystring.toString(), true));
                StringBuffer nextTemplate = this.getTemplate("changePage.template", pageTags);
                links.append(nextTemplate.toString());
                if (!this.context.isDebugMessageEnabled()) break;
                this.context.debugMessage((Object)("WirelessTemplateDesktop.getContent(): inserting next link link=" + nextTemplate.toString()));
                break;
            }
            if (channelContent != null) {
                content.append(channelContent.toString());
            }
            links.append(linkContent.toString());
            currentSize += additionalSize;
        }
        mainTags.put("content", content.toString());
        if (links.length() == 0) {
            String noContent = this.bundle.getString("noContent");
            channelTags.put("title", noContent);
            linkContent = this.getTemplate("linkWrapper.template", channelTags);
            links.append(linkContent.toString());
        }
        mainTags.put("links", links.toString());
        return this.getTemplate("frontProvider.template", mainTags);
    }

    public boolean isPresentable(HttpServletRequest request) {
        try {
            if (this.getProviderContext().isDebugMessageEnabled()) {
                this.getProviderContext().debugMessage((Object)("WirelessTemplateDesktop.isPresentable(): clientType= " + this.getProviderContext().getClientType() + " filePath= " + this.getProviderContext().getClientPath() + " templatePath= " + this.getProviderContext().getTemplatePath(this.getName(), "frontProvider.template")));
            }
            if (this.getProviderContext().getTemplatePath(this.getName(), "frontProvider.template") != null) {
                return this.getTemplate("frontProvider.template") != null;
            }
            return false;
        }
        catch (ProviderContextException e) {
            return false;
        }
        catch (ProviderException e) {
            return false;
        }
    }

    public int getWindowState(String channelName) throws ProviderException {
        boolean channelsAreMinimized = this.getBooleanProperty("defaultChannelIsMinimized");
        if (channelsAreMinimized) {
            return 1;
        }
        return 2;
    }

    public int[] getSupportedWindowStates() throws ProviderException {
        return supportedStates;
    }

    public String getMaximizedChannel(HttpServletRequest request) throws ProviderException {
        String maximizedChannel = null;
        String maximizedChannelParam = request.getParameter("m");
        if (maximizedChannelParam != null) {
            List userChannels = !this.getProviderContext().isAuthless(request) && this.minimizedChannelsList != null ? this.minimizedChannelsList : this.getOrderedSelectedChannels(request);
            try {
                maximizedChannel = (String)userChannels.get(Integer.parseInt(maximizedChannelParam));
            }
            catch (Exception e) {
                throw new ProviderException("WirelessTemplateDesktop.getMaximizedChannel(): ", (Throwable)e);
            }
        }
        return maximizedChannel;
    }

    static {
        TemplateNativeContainerProvider.supportedStates[0] = 1;
        TemplateNativeContainerProvider.supportedStates[1] = 2;
    }
}

