/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.providers.containers.template;

import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.wireless.providers.containers.DesktopDispatcherProvider;
import com.sun.portal.wireless.providers.containers.WirelessContainerProvider;
import com.sun.portal.wireless.providers.containers.template.WirelessContainerProviderAdapter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TemplateLayoutProvider
extends WirelessContainerProviderAdapter {
    public StringBuffer getEdit(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        String client = request.getParameter("client");
        if (client == null) {
            throw new ProviderException("WirelessTemplateLayout.getEdit():client parameter missing");
        }
        String containerName = null;
        WirelessContainerProvider clientContainer = null;
        List userChannels = null;
        try {
            containerName = DesktopDispatcherProvider.getClientContainerName(this.getContainerProviderContext(), client);
            clientContainer = (WirelessContainerProvider)this.getContainerProviderContext().getProvider(request, null, containerName);
            userChannels = clientContainer.getOrderedSelectedChannels(request, true);
        }
        catch (ProviderContextException e) {
            throw new ProviderException("WirelessTemplateContent.getEdit():", (Throwable)e);
        }
        StringBuffer content = new StringBuffer();
        Hashtable<String, String> channelTags = new Hashtable<String, String>();
        Hashtable<String, CharSequence> mainTags = new Hashtable<String, CharSequence>();
        String name = null;
        String title = null;
        int channelCount = 0;
        if (this.getTemplatePath("banner.template") != null) {
            mainTags.put("banner", this.getTemplate("banner.template"));
        }
        if (this.getTemplatePath("bulletColor.js") != null) {
            mainTags.put("bulletColor", this.getTemplate("bulletColor.js"));
        }
        if (this.getTemplatePath("menubar.template") != null) {
            mainTags.put("devicemenubar", this.getTemplate("menubar.template"));
        }
        if (client != null) {
            ResourceBundle bundle = null;
            try {
                bundle = this.getResourceBundle("DeviceNames");
                mainTags.put("clientName", bundle.getString(client));
            }
            catch (Exception e) {
                mainTags.put("clientName", client);
            }
        }
        StringBuffer clientconfigQuerystring = new StringBuffer();
        Map editPages = this.getMapProperty("editPages");
        clientconfigQuerystring = clientconfigQuerystring.append("action").append('=').append("edit").append('&').append("provider").append('=').append(editPages.get("clientconfig"));
        mainTags.put("clientconfig_link", this.getProviderContext().getDesktopURL(request, clientconfigQuerystring.toString(), true));
        mainTags.put("logout_link", this.getProviderContext().getLogoutURL());
        mainTags.put("productName", this.getStringProperty("productName"));
        mainTags.put("layout_provider", (CharSequence)editPages.get("layout"));
        mainTags.put("clientContainer", containerName);
        URL helpURL = null;
        try {
            helpURL = this.getHelp(request);
        }
        catch (ProviderException e) {
            this.getProviderContext().debugWarning((Object)"WirelessTemplateLayout.getEdit(): no help file found", (Throwable)e);
        }
        if (helpURL != null) {
            mainTags.put("help_link", helpURL.toString());
        }
        Iterator i = userChannels.iterator();
        while (i.hasNext()) {
            name = (String)i.next();
            try {
                title = this.getProviderContext().getStringProperty(name, "title");
            }
            catch (ProviderContextException e) {
                throw new ProviderException("WirelessTemplateLayout.getEdit(): ", (Throwable)e);
            }
            channelTags.put("provider", name);
            channelTags.put("title", title);
            ++channelCount;
            content.append(this.getTemplate("anchorWrapper.template", channelTags));
        }
        if (channelCount == 0) {
            ResourceBundle bundle = this.getResourceBundle("WirelessTemplateDesktopProvider");
            channelTags.put("title", bundle.getString("noAvailableChannels"));
            channelTags.put("provider", "");
            content.append(this.getTemplate("anchorWrapper.template", channelTags));
        }
        mainTags.put("content", content.toString());
        mainTags.put("providerCount", Integer.toString(channelCount));
        boolean minimizable = false;
        boolean maximizable = false;
        try {
            minimizable = this.getContainerProviderContext().getBooleanProperty(containerName, "defaultChannelIsMinimizable", false);
            maximizable = this.getContainerProviderContext().getBooleanProperty(containerName, "defaultChannelIsMaximizable", false);
            if (minimizable && maximizable && this.getTemplatePath("minimizeOption.template") != null) {
                Hashtable<String, StringBuffer> minimizeTags = new Hashtable<String, StringBuffer>();
                boolean isMinimized = this.getContainerProviderContext().getBooleanProperty(containerName, "defaultChannelIsMinimized");
                if (!isMinimized) {
                    minimizeTags.put("checked", this.getTemplate("checked.template"));
                }
                mainTags.put("minimize_option", this.getTemplate("minimizeOption.template", minimizeTags));
            }
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("WirelessTemplateLayout.getEdit(): ", (Throwable)pce);
        }
        return this.getTemplate("layoutProvider.template", mainTags);
    }

    public URL processEdit(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        int i;
        String currentChannel;
        int rowIndex;
        String containerName = request.getParameter("container");
        if (containerName == null) {
            throw new ProviderException("WirelessTemplateLayout.processEdit():container parameter missing.");
        }
        List userChannels = null;
        Map channelsRow = null;
        WirelessContainerProvider clientContainer = null;
        clientContainer = (WirelessContainerProvider)this.getContainerProviderContext().getProvider(request, null, containerName);
        userChannels = clientContainer.getOrderedSelectedChannels(request, true);
        try {
            channelsRow = this.getContainerProviderContext().getCollectionProperty(containerName, "channelsRow");
        }
        catch (ProviderContextException e) {
            throw new ProviderException("WirelessTemplateLayout.processEdit(): ", (Throwable)e);
        }
        String moveUp = request.getParameter("moveUp");
        String moveDown = request.getParameter("moveDown");
        String[] order = request.getParameterValues("order");
        if (moveUp != null) {
            String moveChannel = request.getParameter("moveChannel");
            if (moveChannel != null) {
                rowIndex = userChannels.indexOf(moveChannel);
                if (rowIndex == -1 && this.getProviderContext().isDebugWarningEnabled()) {
                    this.getProviderContext().debugWarning((Object)("WirelessTemplateLayout.processEdit(): channel=" + moveChannel + " not on user's channel list."));
                } else if (rowIndex > 0) {
                    userChannels.remove(rowIndex);
                    userChannels.add(rowIndex - 1, moveChannel);
                    currentChannel = null;
                    for (i = 0; i < userChannels.size(); ++i) {
                        currentChannel = (String)userChannels.get(i);
                        if (channelsRow.containsKey(currentChannel)) {
                            channelsRow.remove(currentChannel);
                        }
                        channelsRow.put(currentChannel, new Integer(i).toString());
                    }
                    if (this.getProviderContext().isDebugMessageEnabled()) {
                        this.getProviderContext().debugMessage((Object)("WirelessTemplateLayout.processEdit(): moving channel=" + moveChannel + "up from " + rowIndex + " to " + (rowIndex - 1)));
                    }
                }
            } else if (this.getProviderContext().isDebugWarningEnabled()) {
                this.getProviderContext().debugWarning((Object)"WirelessTemplateLayout.processEdit(): moveChannel is not defined");
            }
        } else if (moveDown != null) {
            String moveChannel = request.getParameter("moveChannel");
            if (moveChannel != null) {
                rowIndex = userChannels.indexOf(moveChannel);
                if (rowIndex == -1 && this.getProviderContext().isDebugWarningEnabled()) {
                    this.getProviderContext().debugWarning((Object)("WirelessTemplateLayout.processEdit(): channel=" + moveChannel + " not on user's channel list."));
                } else if (rowIndex < userChannels.size() - 1) {
                    userChannels.remove(rowIndex);
                    userChannels.add(rowIndex + 1, moveChannel);
                    currentChannel = null;
                    for (i = 0; i < userChannels.size(); ++i) {
                        currentChannel = (String)userChannels.get(i);
                        if (channelsRow.containsKey(currentChannel)) {
                            channelsRow.remove(currentChannel);
                        }
                        channelsRow.put(currentChannel, new Integer(i).toString());
                    }
                    if (this.getProviderContext().isDebugMessageEnabled()) {
                        this.getProviderContext().debugMessage((Object)("WirelessTemplateLayout.processEdit(): moving channel=" + moveChannel + "down from " + rowIndex + " to " + (rowIndex + 1)));
                    }
                }
            } else if (this.getProviderContext().isDebugWarningEnabled()) {
                this.getProviderContext().debugWarning((Object)"WirelessTemplateLayout.processEdit(): moveChannel is not defined");
            }
        } else if (order != null) {
            for (int i2 = 0; i2 < order.length; ++i2) {
                channelsRow.put(order[i2], String.valueOf(i2 + 1));
            }
            if (this.getProviderContext().isDebugMessageEnabled()) {
                this.getProviderContext().debugMessage((Object)("WirelessTemplateLayout.processEdit(): channelsRow=" + channelsRow));
            }
        }
        try {
            this.getContainerProviderContext().setCollectionProperty(containerName, "channelsRow", channelsRow);
        }
        catch (ProviderContextException e) {
            throw new ProviderException("WirelessTemplateLayout.processedit(): ", (Throwable)e);
        }
        boolean genericHTML = false;
        try {
            genericHTML = Boolean.valueOf(this.getProviderContext().getClientTypeProperty("genericHTML"));
        }
        catch (Exception e) {
            genericHTML = false;
        }
        try {
            if (genericHTML && this.getContainerProviderContext().existsBooleanProperty(containerName, "defaultChannelIsMinimized")) {
                String loadChannels = request.getParameter("loadChannels");
                if (loadChannels != null) {
                    this.getContainerProviderContext().setBooleanProperty(containerName, "defaultChannelIsMinimized", false);
                } else {
                    this.getContainerProviderContext().setBooleanProperty(containerName, "defaultChannelIsMinimized", true);
                }
            }
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("WirelessTemplateLayout.processEdit(): ", (Throwable)pce);
        }
        URL nextUrl = null;
        StringBuffer nextQuerystring = new StringBuffer();
        if (genericHTML) {
            Map editPages = this.getMapProperty("editPages");
            nextQuerystring.append("provider").append('=').append(editPages.get("clientconfig")).append('&').append("action").append('=').append("edit");
        } else {
            nextQuerystring.append("provider").append('=').append(this.getName()).append('&').append("action").append('=').append("edit").append('&').append("client").append('=').append(this.getProviderContext().getClientType());
        }
        String next = this.getProviderContext().getDesktopURL(request, nextQuerystring.toString(), false);
        try {
            nextUrl = new URL(next);
        }
        catch (MalformedURLException e) {
            throw new ProviderException("WirelessTemplateLayout.processEdit(): ", (Throwable)e);
        }
        return nextUrl;
    }
}

