/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.providers.containers.template;

import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.wireless.providers.containers.DesktopDispatcherProvider;
import com.sun.portal.wireless.providers.containers.WirelessContainerProvider;
import com.sun.portal.wireless.providers.containers.template.WirelessContainerProviderAdapter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TemplateContentProvider
extends WirelessContainerProviderAdapter {
    public StringBuffer getEdit(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        String client = request.getParameter("client");
        if (client == null) {
            throw new ProviderException("WirelessTemplateContent.getEdit():client parameter missing.");
        }
        String containerName = null;
        WirelessContainerProvider clientContainer = null;
        List allChannels = null;
        List userChannels = null;
        try {
            containerName = DesktopDispatcherProvider.getClientContainerName(this.getContainerProviderContext(), client);
            clientContainer = (WirelessContainerProvider)this.getContainerProviderContext().getProvider(request, null, containerName);
            allChannels = clientContainer.getAvailableChannels(request);
            userChannels = clientContainer.getOrderedSelectedChannels(request);
        }
        catch (ProviderContextException e) {
            throw new ProviderException("WirelessTemplateContent.getEdit():", (Throwable)e);
        }
        StringBuffer content = new StringBuffer();
        StringBuffer semicolonSelectedList = new StringBuffer();
        Hashtable<String, String> channelTags = new Hashtable<String, String>();
        Hashtable<String, CharSequence> mainTags = new Hashtable<String, CharSequence>();
        if (this.getTemplatePath("banner.template") != null) {
            mainTags.put("banner", this.getTemplate("banner.template"));
        }
        if (this.getTemplatePath("bulletColor.js") != null) {
            mainTags.put("bulletColor", this.getTemplate("bulletColor.js"));
        }
        if (this.getTemplatePath("menubar.template") != null) {
            mainTags.put("devicemenubar", this.getTemplate("menubar.template"));
        }
        if (client != null) {
            ResourceBundle bundle = null;
            try {
                bundle = this.getResourceBundle("DeviceNames");
                mainTags.put("clientName", bundle.getString(client));
            }
            catch (Exception e) {
                mainTags.put("clientName", client);
            }
        }
        StringBuffer clientconfigQuerystring = new StringBuffer();
        Map editPages = this.getMapProperty("editPages");
        clientconfigQuerystring = clientconfigQuerystring.append("action").append('=').append("edit").append('&').append("provider").append('=').append(editPages.get("clientconfig"));
        mainTags.put("clientconfig_link", this.getProviderContext().getDesktopURL(request, clientconfigQuerystring.toString(), true));
        mainTags.put("logout_link", this.getProviderContext().getLogoutURL());
        mainTags.put("productName", this.getStringProperty("productName"));
        mainTags.put("content_provider", (CharSequence)editPages.get("content"));
        mainTags.put("clientContainer", containerName);
        URL helpURL = null;
        try {
            helpURL = this.getHelp(request);
        }
        catch (ProviderException e) {
            this.getProviderContext().debugWarning((Object)"WirelessTemplateContent.getEdit(): no help file found", (Throwable)e);
        }
        if (helpURL != null) {
            mainTags.put("help_link", helpURL.toString());
        }
        Iterator i = allChannels.iterator();
        while (i.hasNext()) {
            String description;
            String title;
            String name = (String)i.next();
            try {
                title = this.getProviderContext().getStringProperty(name, "title");
                description = this.getProviderContext().getStringProperty(name, "description");
            }
            catch (ProviderContextException e) {
                throw new ProviderException("WirelessTemplateContent.getEdit(): ", (Throwable)e);
            }
            channelTags.put("provider", name);
            channelTags.put("title", title);
            channelTags.put("description", description);
            if (userChannels.contains(name)) {
                semicolonSelectedList.append(name).append(';');
                content.append(this.getTemplate("selectWrapperTrue.template", channelTags));
                continue;
            }
            content.append(this.getTemplate("selectWrapperFalse.template", channelTags));
        }
        mainTags.put("semiColonSelectedList", semicolonSelectedList.toString());
        if (content.length() == 0) {
            ResourceBundle bundle = this.getResourceBundle("WirelessTemplateDesktopProvider");
            channelTags.put("title", bundle.getString("noAvailableChannels"));
            channelTags.put("provider", "");
            content.append(this.getTemplate("optionWrapper.template", channelTags));
        }
        mainTags.put("content", content.toString());
        return this.getTemplate("contentProvider.template", mainTags);
    }

    public URL processEdit(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        boolean genericHTML;
        String containerName = request.getParameter("container");
        if (containerName == null) {
            throw new ProviderException("WirelessTemplateContent.processEdit():container parameter missing.");
        }
        List allChannels = null;
        List userChannels = null;
        WirelessContainerProvider clientContainer = null;
        String name = null;
        clientContainer = (WirelessContainerProvider)this.getContainerProviderContext().getProvider(request, null, containerName);
        allChannels = clientContainer.getAvailableChannels(request);
        userChannels = clientContainer.getOrderedSelectedChannels(request);
        String selectedChannelsParam = request.getParameter("selectedChannels");
        Vector<String> selected = new Vector<String>();
        if (selectedChannelsParam != null) {
            StringTokenizer channelList = new StringTokenizer(selectedChannelsParam, ";");
            while (channelList.hasMoreElements()) {
                selected.add(channelList.nextToken());
            }
        }
        Iterator i = allChannels.iterator();
        while (i.hasNext()) {
            name = (String)i.next();
            String checkBoxValue = request.getParameter(name);
            if (checkBoxValue == null && !selected.contains(name)) {
                userChannels.remove(name);
                if (!this.getProviderContext().isDebugMessageEnabled()) continue;
                this.getProviderContext().debugMessage((Object)("WirelessTemplateContent.processEdit(): removing channel=" + name));
                continue;
            }
            if (selected.contains(name) || "1".equals(checkBoxValue)) {
                if (userChannels.contains(name)) continue;
                userChannels.add(name);
                if (!this.getProviderContext().isDebugMessageEnabled()) continue;
                this.getProviderContext().debugMessage((Object)("WirelessTemplateContent.processEdit(): adding channel=" + name));
                continue;
            }
            if (!this.getProviderContext().isDebugMessageEnabled()) continue;
            this.getProviderContext().debugMessage((Object)("WirelessTemplateContent.processEdit(): doing nothing with channel=" + name));
        }
        try {
            this.getContainerProviderContext().setSelectedChannels(containerName, userChannels);
        }
        catch (ProviderContextException e) {
            throw new ProviderException("WirelessTemplateContent.processEdit(): ", (Throwable)e);
        }
        URL nextUrl = null;
        try {
            genericHTML = Boolean.valueOf(this.getProviderContext().getClientTypeProperty("genericHTML"));
        }
        catch (Exception e) {
            genericHTML = false;
        }
        if (genericHTML) {
            StringBuffer nextQuerystring = new StringBuffer();
            Map editPages = this.getMapProperty("editPages");
            nextQuerystring.append("provider").append('=').append(editPages.get("clientconfig")).append('&').append("action").append('=').append("edit");
            String next = this.getProviderContext().getDesktopURL(request, nextQuerystring.toString(), false);
            try {
                nextUrl = new URL(next);
            }
            catch (MalformedURLException e) {
                throw new ProviderException("WirelessTemplateContent.processEdit(): ", (Throwable)e);
            }
        }
        return nextUrl;
    }
}

