/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.providers.containers.template;

import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.wireless.providers.containers.DesktopDispatcherProvider;
import com.sun.portal.wireless.providers.containers.template.WirelessContainerProviderAdapter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TemplateClientConfigProvider
extends WirelessContainerProviderAdapter {
    public StringBuffer getEdit(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        Hashtable<String, CharSequence> mainTags = new Hashtable<String, CharSequence>();
        mainTags.put("banner", this.getTemplate("banner.template"));
        mainTags.put("bulletColor", this.getTemplate("bulletColor.js"));
        mainTags.put("productName", this.getStringProperty("productName"));
        mainTags.put("devicemenubar", this.getTemplate("menubar.template"));
        StringBuffer contentQuerystring = new StringBuffer();
        StringBuffer layoutQuerystring = new StringBuffer();
        StringBuffer clientconfigQuerystring = new StringBuffer();
        Map editPages = this.getMapProperty("editPages");
        contentQuerystring = contentQuerystring.append("action").append('=').append("edit").append('&').append("provider").append('=').append(editPages.get("content"));
        layoutQuerystring = layoutQuerystring.append("action").append('=').append("edit").append('&').append("provider").append('=').append(editPages.get("layout"));
        clientconfigQuerystring = clientconfigQuerystring.append("action").append('=').append("edit").append('&').append("provider").append('=').append(editPages.get("clientconfig"));
        mainTags.put("content_link", this.getProviderContext().getDesktopURL(request, contentQuerystring.toString(), false));
        mainTags.put("layout_link", this.getProviderContext().getDesktopURL(request, layoutQuerystring.toString(), false));
        mainTags.put("clientconfig_link", this.getProviderContext().getDesktopURL(request, clientconfigQuerystring.toString(), false));
        mainTags.put("logout_link", this.getProviderContext().getLogoutURL());
        mainTags.put("clientconfig_provider", (CharSequence)editPages.get("clientconfig"));
        URL helpURL = null;
        try {
            helpURL = this.getHelp(request);
        }
        catch (ProviderException e) {
            this.getProviderContext().debugWarning((Object)"WirelessTemplateClientConfig.getEdit(): no help file found", (Throwable)e);
        }
        if (helpURL != null) {
            mainTags.put("help_link", helpURL.toString());
        }
        Map selectedClients = null;
        try {
            selectedClients = DesktopDispatcherProvider.getSelectedClients(this.getContainerProviderContext());
        }
        catch (ProviderContextException e) {
            throw new ProviderException("WirelessTemplateClientConfig.getEdit():", (Throwable)e);
        }
        Hashtable<String, String> optionTags = new Hashtable<String, String>();
        Hashtable<String, CharSequence> selectTags = new Hashtable<String, CharSequence>();
        StringBuffer clientOptions = new StringBuffer();
        StringBuffer clientSelect = new StringBuffer();
        int size = selectedClients.size();
        String clientType = null;
        String clientName = null;
        Iterator i = selectedClients.keySet().iterator();
        while (i.hasNext()) {
            clientType = (String)i.next();
            ResourceBundle clientBundle = null;
            try {
                clientBundle = this.getResourceBundle("DeviceNames");
                clientName = clientBundle.getString(clientType);
            }
            catch (Exception e) {
                clientName = clientType;
            }
            optionTags.clear();
            optionTags.put("client", clientType);
            optionTags.put("clientName", clientName);
            clientOptions.append(this.getTemplate("clientOption.template", optionTags));
        }
        selectTags.clear();
        selectTags.put("clientSize", String.valueOf(size));
        selectTags.put("clientOptions", clientOptions);
        clientSelect.append(this.getTemplate("clientSelect.template", selectTags));
        mainTags.put("selectClients", clientSelect);
        return this.getTemplate("clientConfiguration.template", mainTags);
    }

    public URL processEdit(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        String client = request.getParameter("client");
        if (client != null) {
            try {
                DesktopDispatcherProvider.removeClient(request, this.getContainerProviderContext(), client);
            }
            catch (ProviderContextException e) {
                throw new ProviderException("WirelessTemplateClientConfig.processEdit():", (Throwable)e);
            }
        }
        URL nextUrl = null;
        StringBuffer nextQuerystring = new StringBuffer();
        nextQuerystring.append("provider").append('=').append(this.getName()).append('&').append("action").append('=').append("edit");
        String next = this.getProviderContext().getDesktopURL(request, nextQuerystring.toString(), false);
        try {
            nextUrl = new URL(next);
        }
        catch (MalformedURLException e) {
            throw new ProviderException("WirelessTemplateClientConfigProvider.processEdit(): ", (Throwable)e);
        }
        return nextUrl;
    }
}

