/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.providers.containers.jsp.list;

import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ContainerProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.wireless.providers.containers.jsp.WirelessJSPContainerProviderAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JSPNativeContainerProvider
extends WirelessJSPContainerProviderAdapter {
    public static final int MAXSIZE = 32000;
    public static final String PARALLEL_CHANNELS_INIT = "parallelChannelsInit";
    public static final String START_CHANNEL_PARAM = "startChannel";
    public static final String MAXSIZE_KEY = "WmlDeckSize";
    public static final String FRONT_PAGE_SIZE = "frontPageSize";
    public static final String TIMEOUT = "timeout";

    public void init(String name, HttpServletRequest httpReq) throws ProviderException {
        super.init(name, httpReq);
        boolean isParallel = false;
        ContainerProviderContext cpc = this.getContainerProviderContext();
        try {
            isParallel = cpc.getBooleanProperty(this.getName(), PARALLEL_CHANNELS_INIT);
        }
        catch (ProviderContextException e) {
            throw new ProviderException("JSPNativeContainerProvider.init(): ", (Throwable)e);
        }
        if (isParallel) {
            cpc.initProviders(httpReq, name, this.getSelectedChannels(), 0);
        }
    }

    public Map getChunkedContentMap(HttpServletRequest httpReq, HttpServletResponse httpRes) throws ProviderException {
        ContainerProviderContext cpc = this.getContainerProviderContext();
        List orderedChannelList = this.getOrderedSelectedChannels(httpReq);
        int timeout = 0;
        try {
            timeout = cpc.getIntegerProperty(this.getName(), TIMEOUT, 180);
        }
        catch (ProviderContextException e) {
            throw new ProviderException("JSPNativeContainerProvider.getChunkedContentMap(): ", (Throwable)e);
        }
        Map contentMap = new HashMap();
        if (orderedChannelList != null) {
            contentMap = cpc.getContent(httpReq, httpRes, this.getName(), orderedChannelList, timeout);
        }
        int maxSize = 32000;
        String maxSizeStr = cpc.getClientTypeProperty(MAXSIZE_KEY);
        try {
            if (maxSizeStr != null && (maxSize = Integer.parseInt(maxSizeStr)) < 0) {
                maxSize = 32000;
            }
        }
        catch (NumberFormatException nfe) {
            cpc.debugError((Object)("JSPNativeContainerProvider.getChunkedContentMap(): WmlDeckSize=" + maxSizeStr), (Throwable)nfe);
        }
        int frontPageSize = 0;
        try {
            frontPageSize = cpc.getIntegerProperty(this.getName(), FRONT_PAGE_SIZE, 1000);
        }
        catch (ProviderContextException e) {
            throw new ProviderException("JSPNativeContainerProvider.getChunkedContentMap(): ", (Throwable)e);
        }
        if (maxSize < frontPageSize) {
            cpc.debugError((Object)("JSPNativeContainerProvider.getChunkedContentMap(): MaxSize = " + maxSize + " is smaller than frontPageSize = " + frontPageSize));
        } else if (cpc.isDebugMessageEnabled()) {
            cpc.debugMessage((Object)("JSPNativeContainerProvider:getChunkedContentMap(): MaxSize = " + maxSize + " frontPageSize = " + frontPageSize));
        }
        HashMap<Integer, Object> chunkedChannelMap = new HashMap<Integer, Object>();
        int numOrderedChannels = 0;
        if (orderedChannelList != null) {
            numOrderedChannels = orderedChannelList.size();
        }
        int currentSize = frontPageSize;
        int currentPage = 1;
        ArrayList<String> currentPageList = new ArrayList<String>();
        for (int i = 0; i < numOrderedChannels; ++i) {
            String channelName = (String)orderedChannelList.get(i);
            Object channelContent = contentMap.get(channelName);
            if (channelContent == null) continue;
            int channelContentSize = ((StringBuffer)channelContent).length();
            if (maxSize - currentSize > channelContentSize) {
                currentPageList.add(channelName);
                if (cpc.isDebugMessageEnabled()) {
                    cpc.debugMessage((Object)("JSPNativeContainerProvider.getChunkedContentMap(): Page - " + currentPage + " contains channel - " + channelName));
                }
                currentSize += channelContentSize;
                continue;
            }
            chunkedChannelMap.put(new Integer(currentPage), currentPageList.clone());
            ++currentPage;
            currentPageList.clear();
            currentSize = frontPageSize;
            currentPageList.add(channelName);
            currentSize += channelContentSize;
            if (!cpc.isDebugMessageEnabled()) continue;
            cpc.debugMessage((Object)("JSPNativeContainerProvider.getChunkedContentMap(): Page - " + currentPage + " contains channel - " + channelName));
        }
        if (currentPageList.size() > 0) {
            chunkedChannelMap.put(new Integer(currentPage), currentPageList.clone());
        }
        return chunkedChannelMap;
    }
}

