/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.providers.containers.jsp;

import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.containers.JSPContainerProviderAdapter;
import com.sun.portal.providers.context.ContainerProviderContext;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.wireless.providers.containers.WirelessContainerProvider;
import com.sun.portal.wireless.providers.containers.util.ChannelOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class WirelessJSPContainerProviderAdapter
extends JSPContainerProviderAdapter
implements WirelessContainerProvider {
    public static final String CHANNELS_ROW = "channelsRow";
    public static final String DEFAULT_CHANNEL_IS_REMOVABLE = "defaultChannelIsRemovable";
    public static final String CHANNELS_IS_REMOVABLE = "channelsIsRemovable";
    public static final String DEFAULT_CHANNEL_IS_MINIMIZED = "defaultChannelIsMinimized";
    public static final String MAXIMIZEDCHANNEL = "m";
    public static final String USER_DEFINED_CHANNELS = "userDefinedChannels";
    private List minimizedChannelsList = null;
    private static int[] supportedStates = new int[3];

    public String getRow(HttpServletRequest httpReq, String channel) throws ProviderException {
        return this.getStringAttrFromCollection(httpReq, channel, CHANNELS_ROW, null, "1");
    }

    public void upRow(HttpServletRequest httpReq, String channel) throws ProviderException {
        List orderedChannelList = this.getOrderedSelectedChannels(httpReq, true);
        int rowIndex = orderedChannelList.indexOf(channel);
        if (rowIndex == -1) {
            this.getProviderContext().debugWarning((Object)(this.getClass().getName() + ".upRow() Channel - " + channel + "not found in ordered list"));
            return;
        }
        if (rowIndex > 0) {
            orderedChannelList.remove(rowIndex);
            orderedChannelList.add(rowIndex - 1, channel);
        }
        this.setRowOrder(httpReq, this.getName(), this.getContainerProviderContext(), orderedChannelList);
    }

    public void downRow(HttpServletRequest httpReq, String channel) throws ProviderException {
        List orderedChannelList = this.getOrderedSelectedChannels(httpReq, true);
        int rowIndex = orderedChannelList.indexOf(channel);
        if (rowIndex == -1) {
            this.getProviderContext().debugWarning((Object)(this.getClass().getName() + ".downRow(): Channel - " + channel + "not found in ordered list"));
            return;
        }
        if (rowIndex < orderedChannelList.size() - 1) {
            orderedChannelList.remove(rowIndex);
            orderedChannelList.add(rowIndex + 1, channel);
        }
        this.setRowOrder(httpReq, this.getName(), this.getContainerProviderContext(), orderedChannelList);
    }

    public List getUserDefinedChannels() throws ProviderException {
        ArrayList userDefinedChannels = new ArrayList();
        if (this.existsListProperty(USER_DEFINED_CHANNELS)) {
            userDefinedChannels.addAll(this.getListProperty(USER_DEFINED_CHANNELS));
        }
        return userDefinedChannels;
    }

    public List getAvailableChannels(HttpServletRequest req, boolean onlyRemovable) throws ProviderException {
        String channel = null;
        ContainerProviderContext cpc = this.getContainerProviderContext();
        ArrayList<String> newChannelList = new ArrayList<String>();
        boolean defaultIsRemovable = false;
        Map isRemovableMap = null;
        try {
            if (onlyRemovable) {
                defaultIsRemovable = cpc.getBooleanProperty(this.getName(), DEFAULT_CHANNEL_IS_REMOVABLE);
                isRemovableMap = cpc.getCollectionProperty(this.getName(), CHANNELS_IS_REMOVABLE);
            }
        }
        catch (ProviderContextException e) {
            throw new ProviderException("", (Throwable)e);
        }
        ArrayList availableChannels = this.getAvailableChannels();
        if (availableChannels == null) {
            availableChannels = new ArrayList();
        }
        availableChannels.addAll(this.getUserDefinedChannels());
        for (int i = 0; i < availableChannels.size(); ++i) {
            channel = (String)availableChannels.get(i);
            if (!cpc.existsChannel(channel)) {
                if (!cpc.isDebugErrorEnabled()) continue;
                cpc.debugError((Object)("WirelessJSPContainerProviderAdapter.getOrderedAvailableChannels(): channel=" + channel + " does not exist."));
                continue;
            }
            if (!cpc.getProvider(req, this.getName(), channel).isPresentable(req)) {
                if (!cpc.isDebugWarningEnabled()) continue;
                cpc.debugWarning((Object)("WirelessJSPContainerProviderAdapter.getOrderedAvailableChannels(): channel=" + channel + " is not presentable for this client"));
                continue;
            }
            if (onlyRemovable) {
                boolean isRemovable = isRemovableMap.containsKey(channel) ? (Boolean)isRemovableMap.get(channel) : defaultIsRemovable;
                if (!isRemovable) {
                    if (!cpc.isDebugWarningEnabled()) continue;
                    cpc.debugWarning((Object)("WirelessJSPContainerProviderAdapter.getOrderedAvailableChannels(): channel=" + channel + " is locked"));
                    continue;
                }
                newChannelList.add(channel);
                continue;
            }
            newChannelList.add(channel);
        }
        return newChannelList;
    }

    public List getAvailableChannels(HttpServletRequest req) throws ProviderException {
        return this.getAvailableChannels(req, true);
    }

    public List getOrderedSelectedChannels(HttpServletRequest req, boolean onlyMovable) throws ProviderException {
        ContainerProviderContext cpc;
        String channel = null;
        List selectedChannels = this.getSelectedChannels();
        if (selectedChannels == null) {
            selectedChannels = new ArrayList();
        }
        if ((cpc = this.getContainerProviderContext()).isDebugMessageEnabled()) {
            cpc.debugMessage((Object)("WirelessJSPContainerProviderAdapter.getOrderedSelectedChannels(): " + selectedChannels.size() + " selected channels"));
        }
        for (int i = 0; i < selectedChannels.size(); ++i) {
            channel = (String)selectedChannels.get(i);
            if (!cpc.existsChannel(channel)) {
                if (cpc.isDebugErrorEnabled()) {
                    cpc.debugError((Object)("WirelessJSPContainerProviderAdapter.getOrderedSelectedChannels(): channel=" + channel + " does not exist."));
                }
                selectedChannels.remove(channel);
                continue;
            }
            if (cpc.getProvider(req, this.getName(), channel).isPresentable(req)) continue;
            if (cpc.isDebugWarningEnabled()) {
                cpc.debugWarning((Object)("WirelessJSPContainerProviderAdapter.getOrderedSelectedChannels(): channel=" + channel + " is not presentable for this client"));
            }
            selectedChannels.remove(channel);
        }
        if (selectedChannels.size() > 0) {
            selectedChannels = ChannelOrder.order(selectedChannels, this.getName(), this.getContainerProviderContext(), onlyMovable);
        }
        this.minimizedChannelsList = selectedChannels;
        return selectedChannels;
    }

    public List getOrderedSelectedChannels(HttpServletRequest req) throws ProviderException {
        this.minimizedChannelsList = this.getOrderedSelectedChannels(req, false);
        return this.minimizedChannelsList;
    }

    protected String getStringAttrFromCollection(HttpServletRequest httpReq, String channel, String mapKey, String defaultKey, String defaultVal) throws ProviderException {
        String chosenDefaultVal = null;
        ProviderContext pc = this.getProviderContext();
        Map map = null;
        try {
            map = pc.getCollectionProperty(this.getName(), mapKey);
            chosenDefaultVal = defaultKey != null && pc.existsStringProperty(this.getName(), defaultKey) ? pc.getStringProperty(this.getName(), defaultKey) : defaultVal;
        }
        catch (ProviderContextException e) {
            throw new ProviderException("WirelessJSPContainerProviderAdapter.getStringAttrFromCollection(): ", (Throwable)e);
        }
        return this.getStringValueFromMap(map, channel, chosenDefaultVal);
    }

    private String getStringValueFromMap(Map map, String key, String defaultValue) {
        String retVal = null;
        try {
            retVal = (String)map.get(key);
            if (retVal == null) {
                retVal = defaultValue;
            }
        }
        catch (Throwable t) {
            this.getProviderContext().debugWarning((Object)(this.getClass().getName() + ".getStringValueFromMap(): " + t.getMessage()));
            retVal = defaultValue;
        }
        return retVal;
    }

    protected void setRowOrder(HttpServletRequest httpReq, String container, ContainerProviderContext cpc, List channelList) throws ProviderException {
        try {
            Map channelsRow = cpc.getCollectionProperty(container, CHANNELS_ROW);
            int numChannel = channelList.size();
            for (int i = 0; i < numChannel; ++i) {
                String channel = (String)channelList.get(i);
                channelsRow.remove(channel);
                channelsRow.put(channel, new Integer(i).toString());
            }
            cpc.setCollectionProperty(this.getName(), CHANNELS_ROW, channelsRow);
        }
        catch (ProviderContextException e) {
            throw new ProviderException("WirelessJSPContainerProviderAdapter.setRowOrder(): ", (Throwable)e);
        }
    }

    public String getMaximizedChannel(HttpServletRequest request) throws ProviderException {
        String maximizedChannel = null;
        String maximizedChannelParam = request.getParameter(MAXIMIZEDCHANNEL);
        if (maximizedChannelParam != null) {
            List userChannels = !this.getProviderContext().isAuthless(request) && this.minimizedChannelsList != null ? this.minimizedChannelsList : this.getOrderedSelectedChannels(request);
            try {
                maximizedChannel = (String)userChannels.get(Integer.parseInt(maximizedChannelParam));
            }
            catch (Exception e) {
                throw new ProviderException("WirelessJSPContainerProviderAdapter.getMaximizedChannel(): ", (Throwable)e);
            }
        }
        return maximizedChannel;
    }

    public int getWindowState(String channelName) throws ProviderException {
        boolean channelsAreMinimized = this.getBooleanProperty(DEFAULT_CHANNEL_IS_MINIMIZED);
        if (channelsAreMinimized) {
            return 1;
        }
        return 2;
    }

    public void processContentChannelSelection(HttpServletRequest request) throws ProviderException {
        ContainerProviderContext cpc = this.getContainerProviderContext();
        cpc.debugMessage((Object)(this.getName() + ":" + "Entering processContentChannelSelection .."));
        boolean defaultIsRemovable = this.getBooleanProperty(DEFAULT_CHANNEL_IS_REMOVABLE, false);
        boolean isRemovableFlag = false;
        Map isRemovableChannels = this.getMapProperty(CHANNELS_IS_REMOVABLE);
        ArrayList<String> newList = new ArrayList<String>();
        List selectedChannels = this.getOrderedSelectedChannels(request);
        List availableChannels = this.getAvailableChannels(request);
        int numavailableChannels = availableChannels.size();
        String[] selected = null;
        String selChannels = null;
        String content = request.getParameter("content");
        if (content != null && !content.equals("")) {
            if (content.indexOf(";") == -1) {
                selected = request.getParameterValues("content");
                for (int j = 0; j < selected.length; ++j) {
                    newList.add(selected[j]);
                }
            } else {
                selChannels = content;
                if (selChannels != null) {
                    StringTokenizer tok = new StringTokenizer(selChannels, ";");
                    while (tok.hasMoreElements()) {
                        String chan = tok.nextToken();
                        newList.add(chan);
                    }
                }
            }
        } else {
            cpc.debugMessage((Object)(this.getClass().getName() + " : " + "Param content = null "));
        }
        for (int i = 0; i < numavailableChannels; ++i) {
            String channel = (String)availableChannels.get(i);
            Object isRemovableValue = isRemovableChannels.get(channel);
            isRemovableFlag = isRemovableValue != null ? (Boolean)isRemovableValue : defaultIsRemovable;
            if (!isRemovableFlag) continue;
            if (!newList.contains(channel) && selectedChannels.contains(channel)) {
                selectedChannels.remove(channel);
                continue;
            }
            if (!newList.contains(channel) || selectedChannels.contains(channel)) continue;
            selectedChannels.add(channel);
        }
        this.setSelectedChannels(selectedChannels);
    }

    static {
        WirelessJSPContainerProviderAdapter.supportedStates[0] = 1;
        WirelessJSPContainerProviderAdapter.supportedStates[1] = 2;
    }
}

