/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.providers.containers;

import com.sun.mobile.util.MAPConfigProperties;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.UnknownEditTypeException;
import com.sun.portal.providers.containers.ContainerProviderAdapter;
import com.sun.portal.providers.context.ContainerProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DesktopDispatcherProvider
extends ContainerProviderAdapter {
    private static final String DESKTOP_DISPATCHER = "WirelessDesktopDispatcher";
    private static final String DESKTOPCONTAINER = "desktopContainer";
    private static final String SELECTEDCLIENTS = "selectedClients";
    private static final String GENERICHTML = "genericHTML";
    private static final String PARENTCLIENTS = "parentId";
    private static final String STOREPROFILEINCLIENT = "storeProfileInClient";
    private Provider desktop = null;

    public void init(String n, HttpServletRequest req) throws ProviderException {
        super.init(n, req);
        this.desktop = this.getDesktopProvider(req);
    }

    private Provider getDesktopProvider(HttpServletRequest request) throws ProviderException {
        if (this.desktop == null || this.getContainerProviderContext().isAuthless(request)) {
            this.desktop = this.initDesktopProvider(request);
        }
        return this.desktop;
    }

    private Provider initDesktopProvider(HttpServletRequest request) throws ProviderException {
        ContainerProviderContext context = this.getContainerProviderContext();
        List filters = null;
        try {
            filters = context.getClientPropertiesFilters();
        }
        catch (ProviderContextException e) {
            throw new ProviderException("WirelessDesktopDispatcher.initDesktopProvider(): ", (Throwable)e);
        }
        String desktopName = this.getStringProperty(DESKTOPCONTAINER, filters);
        if (context.isDebugMessageEnabled()) {
            context.debugMessage((Object)("WirelessDesktopDispatcher.initDesktopProvider(): clientFilters=" + filters + " desktopName=" + desktopName));
        }
        if (!context.isAuthless(request)) {
            boolean isUAProf;
            boolean genericHTML;
            Map selectedClients = this.getMapProperty(SELECTEDCLIENTS);
            String clientType = context.getClientType();
            try {
                genericHTML = Boolean.valueOf(context.getClientTypeProperty(GENERICHTML));
            }
            catch (Exception e) {
                genericHTML = false;
            }
            boolean bl = isUAProf = context.getClientTypeProperties(clientType, MAPConfigProperties.get((String)STOREPROFILEINCLIENT, null)) != null;
            if (isUAProf) {
                try {
                    Set parents = context.getClientTypeProperties(clientType, PARENTCLIENTS);
                    clientType = (String)parents.iterator().next();
                    if (this.getProviderContext().isDebugMessageEnabled()) {
                        this.getProviderContext().debugMessage((Object)("WirelessDesktopDispatcher.initDesktopProvider(): clientType=" + clientType + " first ancestor client was used for UAProf device."));
                    }
                }
                catch (Exception e) {
                    context.debugWarning((Object)"WirelessDesktopDispatcher.initDesktopProvider(): could not find parent for UAProf device.", (Throwable)e);
                }
            }
            if (!genericHTML && !selectedClients.containsKey(clientType)) {
                selectedClients.put(clientType, "");
                this.setMapProperty(SELECTEDCLIENTS, selectedClients);
                if (this.getProviderContext().isDebugMessageEnabled()) {
                    this.getProviderContext().debugMessage((Object)("WirelessDesktopDispatcher.initDesktopProvider(): clientType=" + clientType + " has been added to list of selected clients."));
                }
            }
        }
        return context.getProvider(request, this.getName(), desktopName);
    }

    public boolean isPresentable(HttpServletRequest request) {
        try {
            return this.getDesktopProvider(request).isPresentable(request);
        }
        catch (ProviderException prEx) {
            try {
                this.getContainerProviderContext().debugError((Object)"WirelessDesktopDispatcher.isPresentable():", (Throwable)prEx);
            }
            catch (ProviderException e) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public StringBuffer getContent(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        return this.getDesktopProvider(request).getContent(request, response);
    }

    public int getEditType() throws UnknownEditTypeException {
        return this.desktop.getEditType();
    }

    public boolean isEditable() throws ProviderException {
        return this.desktop.isEditable();
    }

    public StringBuffer getEdit(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        return this.getDesktopProvider(request).getEdit(request, response);
    }

    public URL processEdit(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        return this.getDesktopProvider(request).processEdit(request, response);
    }

    public static Map getSelectedClients(ContainerProviderContext context) throws ProviderContextException {
        return context.getCollectionProperty(DESKTOP_DISPATCHER, SELECTEDCLIENTS);
    }

    public static String getClientContainerName(ContainerProviderContext context, String clientType) throws ProviderContextException {
        List filters = context.getClientPropertiesFilters(clientType);
        return context.getStringProperty(DESKTOP_DISPATCHER, DESKTOPCONTAINER, filters);
    }

    public static void removeClient(HttpServletRequest request, ContainerProviderContext context, String clientType) throws ProviderContextException {
        if (!context.isAuthless(request)) {
            Map selectedClients = DesktopDispatcherProvider.getSelectedClients(context);
            selectedClients.remove(clientType);
            context.setCollectionProperty(DESKTOP_DISPATCHER, SELECTEDCLIENTS, selectedClients);
        }
    }
}

