/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.dispatcher;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.wireless.taglibs.base.Util;
import com.sun.portal.wireless.taglibs.dispatcher.Compressor;
import com.sun.portal.wireless.util.MAConfigProperties;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Dispatcher
extends HttpServlet {
    private static String dispatchServletName = MAConfigProperties.get((String)"ma.dispatch.servlet.name", (String)"ma");
    private static boolean compressorEnable;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SSOToken token = null;
        String urlString = null;
        try {
            SSOTokenManager tokenManager = SSOTokenManager.getInstance();
            token = tokenManager.createSSOToken(request);
            String charset = token.getProperty("CharSet");
            if (charset != null && charset.length() > 0) {
                request.setCharacterEncoding(charset);
            }
        }
        catch (SSOException ex) {
            urlString = MAConfigProperties.get((String)"ma.dispatch.error.page", (String)"/jsp/default/errorpage.jsp");
            Util.logWarning(((Object)((Object)this)).getClass().getName() + ".doGet:  failed with exception:  " + (Object)((Object)ex));
        }
        if (request.getParameter("file") != null && request.getParameter("comp") != null) {
            try {
                request.getRequestDispatcher("/jsp/default/launchVoice.jsp").forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (Exception e) {
                Util.logWarning(((Object)((Object)this)).getClass().getName() + ".doGet: forward to launchVoice.jsp failed : " + e);
            }
            return;
        }
        String target = request.getParameter("target");
        if (!compressorEnable && target != null && !target.equals(dispatchServletName)) {
            urlString = target;
        } else if (token != null) {
            Compressor compressor = Compressor.getCompressor(token);
            urlString = compressor.retrieveURL(request);
        }
        request.getRequestDispatcher(urlString).forward((ServletRequest)request, (ServletResponse)response);
    }

    static {
        dispatchServletName = "/" + dispatchServletName;
        String compressorEnableString = MAConfigProperties.get((String)"ma.compressor.enable", (String)"true");
        compressorEnable = Boolean.valueOf(compressorEnableString);
    }
}

