/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.ab;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.sun.addressbook.Element;
import com.sun.portal.wireless.taglibs.ab.ContactDB;
import com.sun.portal.wireless.taglibs.base.Context;
import com.sun.portal.wireless.taglibs.base.Util;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.config.Configuration;
import com.sun.ssoadapter.config.ConfigurationFactory;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class ABContext
extends Context {
    public static final String DESCENDING = "dsc";
    public static final String ASCENDING = "asc";
    protected String sortBy = null;
    protected String sortOrder = null;
    protected List entries = null;
    protected List groupmembers = null;
    protected List memberchoices = null;
    protected List contacts = null;
    protected int numEntries = 0;
    protected int numGroupmembers = 0;
    protected int numMemberchoices = 0;
    protected int numContacts = 0;
    protected ContactDB contactdb = null;
    public static final String CONTEXT_CLASS_NAME = "com.sun.portal.wireless.taglibs.ab.ABContext";
    public static final String CONTEXT_CACHE_CLASS_NAME = "com.sun.portal.wireless.taglibs.ab.ABContextCache";
    public static final String CONTEXT_TYPE = "abcontext";
    public static final String SSO_CONFIG_TYPE = "AB-TYPE";
    private static final boolean SUCCESS = true;
    private static final boolean FAIL = false;
    private static final String PIM_CDO = "cdo";
    private static final String PIM_INTERFACE_TYPE = "ab.pimInterfaceType";
    private Configuration appConfig = null;
    protected String pabLang = null;

    public void init(HttpServletRequest request, SSOToken session, SSOAdapter ssoAdapter) throws Exception {
        super.init(request, session, "SunMobileAppABService", ssoAdapter);
        ConfigurationFactory configFactory = ConfigurationFactory.getInstance((String)"SunMobileAppABService", (String)"sunMobileAppABConfig", (String)"sunConfigurationTemplates");
        try {
            String configName = ssoAdapter.getName();
            this.appConfig = configFactory.readConfiguration(configName, true, request);
            if (this.appConfig == null) {
                int i = configName.indexOf(95);
                if (i >= 0) {
                    this.appConfig = configFactory.readConfiguration(configName.substring(0, i), true, request);
                }
                if (this.appConfig == null) {
                    this.appConfig = new Configuration();
                }
            }
        }
        catch (Exception e) {
            this.appConfig = new Configuration();
        }
        this.sortBy = this.appConfig.getProperty("sortBy", "cn");
        this.sortOrder = this.appConfig.getProperty("sortOrder", ASCENDING);
        if (this.contactdb == null) {
            this.contactdb = new ContactDB(ssoAdapter, request, this);
        }
    }

    public static ABContext getContext(PageContext pageContext) throws Exception {
        return (ABContext)Context.getContext((PageContext)pageContext, (String)CONTEXT_CLASS_NAME, (String)CONTEXT_CACHE_CLASS_NAME, (String)CONTEXT_TYPE);
    }

    public ContactDB getContactDB() {
        return this.contactdb;
    }

    public void setContactDB(ContactDB contactdb) {
        this.contactdb = contactdb;
    }

    public List getEntries() {
        return this.entries;
    }

    public void setEntries(List res) {
        this.entries = res;
    }

    public Element getEntry(int entryid) {
        if (this.entries == null) {
            return null;
        }
        Element element = (Element)this.entries.get(entryid);
        return element;
    }

    public boolean isEntriesEmpty() {
        return this.numEntries <= 0;
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public void setNumEntries(int numEntries) {
        this.numEntries = numEntries;
    }

    public List getGroupmembers() {
        return this.groupmembers;
    }

    public void setGroupmembers(List res) {
        this.groupmembers = res;
    }

    public Element getGroupmember(int entryid) {
        if (this.groupmembers == null) {
            return null;
        }
        Element element = (Element)this.groupmembers.get(entryid);
        return element;
    }

    public boolean isGroupmembersEmpty() {
        return this.numGroupmembers <= 0;
    }

    public int getNumGroupmembers() {
        return this.numGroupmembers;
    }

    public void setNumGroupmembers(int numGroupmembers) {
        this.numGroupmembers = numGroupmembers;
    }

    public List getMemberchoices() {
        return this.memberchoices;
    }

    public void setMemberchoices(List res) {
        this.memberchoices = res;
    }

    public Element getMemberchoice(int entryid) {
        if (this.memberchoices == null) {
            return null;
        }
        Element element = (Element)this.memberchoices.get(entryid);
        return element;
    }

    public boolean isMemberchoicesEmpty() {
        return this.numMemberchoices <= 0;
    }

    public int getNumMemberchoices() {
        return this.numMemberchoices;
    }

    public void setNumMemberchoices(int numMemberchoices) {
        this.numMemberchoices = numMemberchoices;
    }

    public List getContacts() {
        return this.contacts;
    }

    public void setContacts(List res) {
        this.contacts = res;
    }

    public Element getContact(int entryid) {
        if (this.contacts == null) {
            return null;
        }
        Element element = (Element)this.contacts.get(entryid);
        return element;
    }

    public boolean isContactsEmpty() {
        return this.numContacts <= 0;
    }

    public int getNumContacts() {
        return this.numContacts;
    }

    public void setNumContacts(int numContacts) {
        this.numContacts = numContacts;
    }

    public String getPabLang() {
        return this.pabLang;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public boolean isGroupSupported() {
        String pimInterfaceType = this.getContactDB().getABStore().getSession().getProperty(PIM_INTERFACE_TYPE);
        Util.logMessage((String)("ABContext.isGroupSupported() pimInterfaceType : " + pimInterfaceType));
        return pimInterfaceType == null || !pimInterfaceType.equalsIgnoreCase(PIM_CDO);
    }

    public static void log(String x) {
        Util.logMessage((String)x);
    }

    public static void log(String x, Exception e) {
        Util.logMessage((String)x, (Throwable)e);
    }

    public static void errorLog(String x) {
        Util.logError((String)x);
    }

    public static void errorLog(String x, Exception e) {
        Util.logError((String)x, (Throwable)e);
    }

    public static void warningLog(String x) {
        Util.logWarning((String)x);
    }

    public static void warningLog(String x, Exception e) {
        Util.logWarning((String)x, (Throwable)e);
    }

    public void release() {
        this.pabLang = null;
        this.contactdb.release();
        this.contactdb = null;
    }

    public void ssoTokenChanged(SSOTokenEvent evt) {
        try {
            int evtType = evt.getType();
            if (evtType != 3) {
                if (evtType != 1) {
                    if (evtType != 2) {
                        return;
                    }
                }
            }
            if (this.contactdb != null) {
                this.contactdb.release();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.ssoTokenChanged(evt);
    }
}

