/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.util;

import com.aligo.engine.logging.LoggerContainer;
import java.util.Vector;

class ObjectPool
extends LoggerContainer {
    private static final String DBC_PATH = "/Aligo/Messages/util/ObjectCache/";
    private Class clss;
    private int poolDepth;
    private Vector free;
    private Vector inUse;
    private int numObjs;

    ObjectPool(int pd, Class cls) {
        this.clss = cls;
        this.poolDepth = pd;
        this.free = new Vector(this.poolDepth);
        this.inUse = new Vector();
        this.numObjs = 0;
    }

    public int freeObjects() {
        if (this.numObjs < this.poolDepth) {
            return this.poolDepth - this.numObjs;
        }
        return this.free.size();
    }

    public int inUseObjects() {
        return this.inUse.size();
    }

    public synchronized Object getObject() {
        try {
            if (this.free.size() == 0 && this.numObjs < this.poolDepth) {
                Object obj = this.clss.newInstance();
                ++this.numObjs;
                this.inUse.add(obj);
                return obj;
            }
            if (this.numObjs < this.poolDepth) {
                Object obj = this.free.remove(0);
                this.inUse.add(obj);
                return obj;
            }
            return null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.logger.logError((Throwable)e);
        }
        catch (InstantiationException e) {
            this.logger.logError((Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.logger.logError((Throwable)e);
        }
        return null;
    }

    public synchronized void putObject(Object obj) throws IllegalAccessException {
        if (!this.inUse.removeElement(obj)) {
            throw new IllegalAccessException("No such element in object pool");
        }
        this.free.addElement(obj);
    }

    public String toXML() {
        String xmlStr = "<ObjectPool class=\"" + this.clss + "\" poolDepth=\"" + this.poolDepth + "\" ";
        xmlStr = xmlStr + " freeObjects=\"" + this.freeObjects() + "\" inUseObjects=\"" + this.inUseObjects() + "\" />";
        return xmlStr;
    }
}

