/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.util;

import com.aligo.engine.logging.LoggerContainer;
import com.aligo.util.ObjectPool;
import java.util.HashMap;
import java.util.Iterator;

public class ObjectCache
extends LoggerContainer {
    private HashMap objectCache;

    public ObjectCache() {
        this.init(2048);
    }

    public ObjectCache(int hashMapSize) {
        this.init(hashMapSize);
    }

    public void init(int hashMapSize) {
        this.objectCache = new HashMap(hashMapSize);
    }

    public Class getClass(String classPath, int poolSize) {
        Class<?> cls = null;
        try {
            if (this.logger.debugEnabled()) {
                this.logger.logDebug("Object cache getting class..." + classPath);
            }
            cls = Class.forName(classPath);
        }
        catch (ClassNotFoundException e) {
            this.logger.logError((Throwable)e);
            return null;
        }
        ObjectPool op = (ObjectPool)((Object)this.objectCache.get(cls));
        if (op == null) {
            op = new ObjectPool(poolSize, cls);
            op.setLogger(this.logger);
            this.objectCache.put(cls, op);
        }
        return cls;
    }

    public ObjectPool getObjectPool(Class cls) {
        return (ObjectPool)((Object)this.objectCache.get(cls));
    }

    public Object getObject(String className) {
        try {
            Class<?> cls = Class.forName(className);
            return this.getObject(cls);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public Object getObject(Class cls) {
        ObjectPool op = (ObjectPool)((Object)this.objectCache.get(cls));
        if (op == null) {
            return null;
        }
        return op.getObject();
    }

    public boolean putObject(Object obj) throws IllegalAccessException {
        ObjectPool op = (ObjectPool)((Object)this.objectCache.get(obj.getClass()));
        if (op == null) {
            return false;
        }
        op.putObject(obj);
        return true;
    }

    public String toXML() {
        Iterator clsss = this.objectCache.values().iterator();
        String rstr = "<ObjectCache>\n";
        while (clsss.hasNext()) {
            rstr = rstr + ((ObjectPool)((Object)clsss.next())).toXML() + "\n";
        }
        rstr = rstr + "\n</ObjectCache>";
        return rstr;
    }

    public static void main(String[] args) {
        try {
            ObjectCache oc = new ObjectCache();
            Class strClass = oc.getClass("java.lang.String", 20);
            String[] str = new String[15];
            int i = 0;
            while (i < 15) {
                str[i] = (String)oc.getObject(strClass);
                ++i;
            }
            System.out.println(oc.toXML());
            oc.putObject(str[3]);
            System.out.println(oc.toXML());
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }
}

