/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tagext;

import com.aligo.aml.AmlImage;
import com.aligo.exceptions.AttributeCannotBeAddedException;
import com.aligo.image.ImageFactory;
import com.aligo.profile.interfaces.UAProfile;
import com.aligo.tagext.AligoSupport;
import com.iplanet.sso.SSOException;
import javax.servlet.jsp.JspTagException;

public class ImageTag
extends AligoSupport {
    private static final String DBC_PATH = "/Aligo/Messages/jsp/tagext/ImageTag/";
    private String src_;

    public String getSrc() {
        return this.src_;
    }

    public void setSrc(String src) {
        this.src_ = src;
    }

    public int doStartTag() throws JspTagException {
        return 1;
    }

    public int doEndTag() throws JspTagException {
        String retVal = "";
        if (this.src_ == null) {
            if (this.logger.debugEnabled()) {
                this.logger.logDebug("Image src is null");
            }
            return 6;
        }
        try {
            AmlImage image = this.getImageFromFactory(this.src_);
            if (image != null) {
                retVal = image.getContents();
                if (this.logger.debugEnabled()) {
                    this.logger.logDebug("Image tag image = " + retVal);
                }
                this.pageContext.getOut().write(retVal);
            } else if (this.logger.debugEnabled()) {
                this.logger.logDebug("No Image");
            }
        }
        catch (Exception e) {
            this.logger.logError((Throwable)e);
            return 6;
        }
        return 6;
    }

    public AmlImage getImageFromFactory(String imageKey) throws AttributeCannotBeAddedException {
        try {
            UAProfile uap = this.getUAProfile();
            ImageFactory imf = this.getImageFactory();
            AmlImage aImage = imf.getLocalAmlImage(imageKey, uap);
            if (aImage != null) {
                return aImage;
            }
            return this.getDefaultUndefinedImage();
        }
        catch (SSOException se) {
            se.printStackTrace();
            return this.getDefaultUndefinedImage();
        }
    }

    public AmlImage getDefaultUndefinedImage() {
        AmlImage defaultUndefinedImage = null;
        try {
            defaultUndefinedImage = new AmlImage();
            defaultUndefinedImage.setSrc("");
            defaultUndefinedImage.setAlt("No image for this device");
        }
        catch (AttributeCannotBeAddedException noAdd) {
            this.logger.logError((Throwable)noAdd);
        }
        return defaultUndefinedImage;
    }
}

