/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tagext;

import com.aligo.engine.logging.interfaces.LoggerInterface;
import com.aligo.exceptions.AligoException;
import com.aligo.exceptions.AligoExtensionException;
import com.aligo.image.ImageFactory;
import com.aligo.image.ImageModule;
import com.aligo.portal.wireless.services.rendering.CommonLogger;
import com.aligo.portal.wireless.services.rendering.Logger;
import com.aligo.profile.UAProfileClient;
import com.aligo.profile.UAQueryManager;
import com.aligo.profile.UAQueryModule;
import com.aligo.profile.interfaces.UAProfile;
import com.aligo.profile.interfaces.UAQueryManagerFactory;
import com.aligo.servlet.SessionHash;
import com.aligo.tagext.TagCache;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

public class AligoSupport
extends TagSupport {
    public static final String CONFIG_NAME = "ALIGO_TAG_CONFIG_NAME";
    public static final String PROFILE = "ALIGO_TAG_UAPROF";
    public static final String UAQUERY = "ALIGO_TAG_UAQUERY";
    public static final String IMAGE = "ALIGO_TAG_IMAGE";
    public static final String LOGGER = "ALIGO_TAG_LOGGER";
    public static final String CLIENT_TYPE = "clientType";
    public static final String UQM_PATH = "com.aligo.profile.UAQueryManager";
    public static final String UQM_CONFIG_PATH = "/com/aligo/tagext/config/UAQueryInternal.xml";
    public static final String IMAGE_PREFIX = "/com/aligo/";
    public static final String IMAGE_SUFFIX = "/config/ImageLibrary.xml";
    private static boolean firstTime = true;
    private static LoggerInterface globalLogger = null;
    protected SessionHash sessionHash = null;
    protected LoggerInterface logger = null;

    protected void setConfigName(String name) {
        this.pageContext.setAttribute(CONFIG_NAME, (Object)name);
    }

    protected String getConfigName() {
        return AligoSupport.getConfigName(this.pageContext);
    }

    protected static String getConfigName(PageContext pageContext) {
        return (String)pageContext.getAttribute(CONFIG_NAME);
    }

    public LoggerInterface getLogger() {
        return AligoSupport.getLogger(this.pageContext);
    }

    public static LoggerInterface getLogger(PageContext pageContext) {
        Object logger = (LoggerInterface)pageContext.getAttribute(LOGGER);
        if (logger == null) {
            String name = AligoSupport.getConfigName(pageContext);
            logger = name != null ? new Logger(name) : globalLogger;
            pageContext.setAttribute(LOGGER, logger);
        }
        return logger;
    }

    private void chkInit() {
        if (firstTime) {
            this.init();
        }
    }

    private synchronized void init() {
        if (firstTime) {
            this.logInit();
            this.uaInit(UQM_CONFIG_PATH);
            firstTime = false;
        }
    }

    private synchronized void uaInit(String path) {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(path);
        if (is != null) {
            try {
                UAQueryModule.setConfigFile(new InputStreamReader(is));
                UAQueryModule.init();
            }
            catch (AligoExtensionException ae) {
                globalLogger.logError((Throwable)ae);
            }
        } else {
            globalLogger.logError("Could not find resource..UAQuery..");
        }
    }

    private synchronized void logInit() {
        globalLogger = new CommonLogger();
        TagCache.getActionCache().setLogger(globalLogger);
    }

    protected SSOToken getSSOToken() throws SSOException {
        return SSOTokenManager.getInstance().createSSOToken((HttpServletRequest)this.pageContext.getRequest());
    }

    protected UAProfile getUAProfile() throws SSOException {
        UAProfile profile = (UAProfile)this.pageContext.getAttribute(PROFILE);
        if (profile == null) {
            try {
                SSOToken token = this.getSSOToken();
                String clientType = token.getProperty(CLIENT_TYPE);
                Client client = Client.getInstance((String)clientType);
                profile = new UAProfileClient(client);
                this.pageContext.setAttribute(PROFILE, (Object)profile);
            }
            catch (ClientException ce) {
                this.logger.logError((Throwable)ce);
            }
        }
        return profile;
    }

    protected UAQueryManager getUAQueryManager() {
        UAQueryManager uqm = (UAQueryManager)this.pageContext.getAttribute(UAQUERY);
        if (uqm == null) {
            try {
                uqm = (UAQueryManager)UAQueryManagerFactory.getUAQueryManager(UQM_PATH);
                this.pageContext.setAttribute(UAQUERY, (Object)uqm);
            }
            catch (AligoException ae) {
                this.logger.logError((Throwable)ae);
            }
        }
        return uqm;
    }

    protected ImageFactory getImageFactory() {
        String name;
        ImageFactory imf = (ImageFactory)this.pageContext.getAttribute(IMAGE);
        if (imf == null && (name = this.getConfigName()) != null) {
            InputStream is;
            String path = IMAGE_PREFIX + name + IMAGE_SUFFIX;
            if (this.logger.debugEnabled()) {
                this.logger.logDebug("Image library path.." + path);
            }
            if ((is = ((Object)((Object)this)).getClass().getResourceAsStream(path)) == null) {
                this.logger.logError("Error getting image library resource...");
            }
            try {
                imf = ImageModule.getImageFactory(new InputStreamReader(is));
                this.pageContext.setAttribute(IMAGE, (Object)imf);
            }
            catch (AligoExtensionException ae) {
                this.logger.logError((Throwable)ae);
            }
        }
        return imf;
    }

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.chkInit();
        this.sessionHash = this.getNativeSessionHash(pageContext);
        this.logger = this.getLogger();
    }

    private SessionHash getNativeSessionHash(PageContext pageContext) {
        return new SessionHash(pageContext);
    }

    public static SessionHash getSessionHash(PageContext ctx) {
        return AligoSupport.getSessionHash(ctx);
    }
}

