/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.profile;

import com.aligo.exceptions.AligoAccessException;
import com.aligo.exceptions.AligoException;
import com.aligo.profile.interfaces.QueryObjectInterface;
import com.aligo.profile.interfaces.UAProfile;
import com.aligo.profile.interfaces.UAQueryInterface;
import java.util.ArrayList;

public class UAQuery
implements UAQueryInterface {
    private ArrayList queryObjects = new ArrayList();
    private int priority = 1;
    private String queryName;

    public UAQuery() {
    }

    public UAQuery(String qName) {
        this.queryName = qName;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newPriority) {
        this.priority = newPriority;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public void setQueryName(String newQueryName) {
        this.queryName = newQueryName;
    }

    public void addQueryOption(QueryObjectInterface qo) throws AligoException {
        if (!qo.validateQueryOption()) {
            throw new AligoAccessException("invalid query object");
        }
        this.queryObjects.add(qo);
    }

    public QueryObjectInterface getQueryOption(int key) {
        return (QueryObjectInterface)this.queryObjects.get(key);
    }

    public int numberOfQueryOptions() {
        return this.queryObjects.size();
    }

    public boolean match(UAProfile uap) {
        boolean retVal = true;
        int size = this.queryObjects.size();
        int i = 0;
        while (i < size) {
            Object uaValue = this.getQueryOption(i).yourValue(uap);
            if (uaValue != null && !this.getQueryOption(i).yeaOrNea(uaValue)) {
                retVal = false;
                break;
            }
            if (uaValue == null) {
                retVal = false;
                break;
            }
            ++i;
        }
        return retVal;
    }
}

