/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.providers.mail;

import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.mail.MailApplicationHelper;
import com.sun.portal.providers.mail.MailProvider;
import com.sun.portal.wireless.providers.mail.DeviceSelectConstants;
import com.sun.portal.wireless.providers.util.ProviderUtility;
import com.sun.ssoadapter.config.ClientAwareUserContext;
import com.sun.ssoadapter.config.Configuration;
import com.sun.ssoadapter.config.ConfigurationException;
import com.sun.ssoadapter.config.ConfigurationFactory;
import com.sun.ssoadapter.config.DSAMEConnection;
import com.sun.ssoadapter.config.PSClientAwareContextFactory;
import com.sun.ssoadapter.config.SAALException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MailViews
implements DeviceSelectConstants {
    private static final String VIEWCLIENTATTR = "sunMobileAppMailViewClients";
    private String caller = null;
    private String client = null;
    private String errMsg = null;
    private String containerName = null;
    private String desktopURL = null;
    private String editContainer = null;
    private String page = null;
    private String providerName = null;
    private Map serviceMap = null;
    private ResourceBundle bundle = null;
    private ResourceBundle deviceBundle = null;
    private StringBuffer edit = new StringBuffer(0);
    private ClientAwareUserContext mailViewUserContext = null;
    private ConfigurationFactory rulesFactory = null;
    private ConfigurationFactory viewsFactory = null;
    private MailApplicationHelper appHelper = null;
    private MailProvider provider = null;
    private DSAMEConnection dsameConn = null;

    public void init(MailProvider mprov, String container, String editContainer, MailApplicationHelper mAppHelper, HttpServletRequest request) throws ProviderException {
        this.provider = mprov;
        this.appHelper = mAppHelper;
        this.containerName = container;
        this.editContainer = editContainer;
        PSClientAwareContextFactory mapFac = null;
        this.serviceMap = new HashMap();
        this.serviceMap.put("serviceName", "SunMobileAppMailService");
        try {
            mapFac = PSClientAwareContextFactory.getInstance();
            this.mailViewUserContext = mapFac.getClientAwareUserContext(request);
        }
        catch (IllegalStateException ie) {
            this.debugError("MailViewProvider.init(): ", ie);
            return;
        }
        catch (SAALException se) {
            this.debugError("MailViewProvider.init(): ", se);
            return;
        }
        this.dsameConn = new DSAMEConnection(request);
        this.rulesFactory = ConfigurationFactory.getInstance((String)"SunMobileAppMailService", (String)"sunMobileAppMailViewRules");
        this.viewsFactory = ConfigurationFactory.getInstance((String)"SunMobileAppMailService", (String)"sunMobileAppMailViews");
        if (this.bundle == null) {
            this.bundle = this.provider.getResourceBundle("MailViews");
        }
        if (this.deviceBundle == null) {
            this.deviceBundle = this.provider.getResourceBundle("DeviceNames");
        }
    }

    public StringBuffer getEdit(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        this.debugMessage("MailViews.getEdit(): Entering..");
        boolean isErr = false;
        String errMsg = request.getParameter("err");
        this.debugMessage("MailViews.getEdit(): errMsg = " + errMsg);
        if (errMsg != null) {
            return this.getErrorMessage(request, errMsg, request.getParameter("page"));
        }
        this.client = request.getParameter("client");
        this.page = request.getParameter("page");
        if (this.editContainer == null) {
            this.editContainer = request.getParameter("provider");
        }
        String viewMode = request.getParameter("viewmode");
        Enumeration availableRules = null;
        Enumeration availableViews = null;
        if (viewMode.equals("Device")) {
            try {
                availableViews = this.viewsFactory.getConfigurationNames(request);
                if (!availableViews.hasMoreElements()) {
                    errMsg = "MailViews-NoViews";
                    return this.getErrorMessage(request, errMsg, "NoViews");
                }
                this.edit = this.getDeviceViews(request);
            }
            catch (Throwable t) {
                this.debugError("MailViews.getEdit(): ", t);
                this.edit = new StringBuffer(t.toString());
            }
            return this.edit;
        }
        if (viewMode.equals("Rules")) {
            this.edit = this.getRules(request);
            return this.edit;
        }
        if (viewMode.equals("Views")) {
            availableRules = this.rulesFactory.getConfigurationNames(request);
            if (!availableRules.hasMoreElements()) {
                errMsg = "MailViews-NoRules";
                return this.getErrorMessage(request, errMsg, "NoRules");
            }
            this.edit = this.getViews(request);
            return this.edit;
        }
        if (this.page != null) {
            if (this.page.equalsIgnoreCase("AddRule")) {
                this.edit = this.getRuleConfig(request);
            }
            if (this.page.equalsIgnoreCase("EditRule")) {
                String selectedRule = request.getParameter("order");
                this.debugMessage("MailViews.getEdit(): selectedRule = " + selectedRule);
                if (selectedRule != null && !selectedRule.equals("") && !selectedRule.equals("null")) {
                    this.edit = this.getRuleConfig(request, selectedRule);
                } else {
                    errMsg = "MailViews-NoRuleValue";
                    return this.getErrorMessage(request, errMsg, "RulesError");
                }
            }
            if (this.page.equalsIgnoreCase("AddView")) {
                this.edit = this.getViewConfig(request);
            }
            if (this.page.equalsIgnoreCase("EditView")) {
                String selectedView = request.getParameter("order");
                this.debugMessage("MailViews.getEdit(): selectedView = " + selectedView);
                if (selectedView != null && !selectedView.equals("") && !selectedView.equals("null")) {
                    this.edit = this.getViewConfig(request, selectedView);
                } else {
                    errMsg = "MailViews-NoViewValue";
                    return this.getErrorMessage(request, errMsg, "ViewsError");
                }
            }
            return this.edit;
        }
        if (this.client == null || this.client.equalsIgnoreCase("")) {
            this.debugMessage("MailViews.getEdit(): client is null");
            this.edit = this.getDeviceViews(request);
        } else {
            this.edit = this.getViewEdit(request, this.client);
        }
        return this.edit;
    }

    private StringBuffer getRules(HttpServletRequest request) throws ProviderException {
        this.debugMessage("Entering MailViews.getRules().....");
        StringBuffer ruleConfigs = new StringBuffer(0);
        Hashtable<String, CharSequence> manageRulesHash = new Hashtable<String, CharSequence>();
        Hashtable<String, String> ruleOptionHash = new Hashtable<String, String>();
        try {
            ProviderUtility.setDefaultPresentation(this.provider.getName(), this.provider.getProviderContext(), ruleOptionHash);
            ProviderUtility.setDefaultPresentation(this.provider.getName(), this.provider.getProviderContext(), manageRulesHash);
        }
        catch (ProviderContextException pce) {
            this.debugMessage("MailViews.getRules: setDefaultPresentation", pce);
        }
        try {
            manageRulesHash.put("iwtDesktop-fontFace1", this.provider.getStringProperty("fontFace1", "Sans-serif"));
            Enumeration availableRules = this.rulesFactory.getConfigurationNames(request);
            while (availableRules.hasMoreElements()) {
                String ruleName = String.valueOf(availableRules.nextElement());
                this.debugMessage("MailViews.getRules(): ruleName = " + ruleName);
                ruleOptionHash.put("ruleId", ruleName);
                ruleConfigs.append(this.provider.getTemplate("views-rule-options.template", ruleOptionHash));
            }
            manageRulesHash.put("ruleConfigs", ruleConfigs);
            manageRulesHash.put("isAppHandler", this.appHelper.getName());
            return this.provider.getTemplate("views-manage-rules.template", manageRulesHash);
        }
        catch (Exception e) {
            this.debugError("MailViews.getRules()", e);
            throw new ProviderException(e.getMessage());
        }
    }

    private StringBuffer getRuleConfig(HttpServletRequest request) throws ProviderException {
        Hashtable<String, String> rulesHash = new Hashtable<String, String>();
        try {
            ProviderUtility.setDefaultPresentation(this.provider.getName(), this.provider.getProviderContext(), rulesHash);
            rulesHash.put("action", "Add");
            rulesHash.put("iwtDesktop-fontFace1", this.provider.getStringProperty("fontFace1", "Sans-serif"));
            rulesHash.put("ruleName", "");
            rulesHash.put("recentReadChecked", "");
            rulesHash.put("isSelected", "SELECTED");
            rulesHash.put("isntSelected", "");
            rulesHash.put("recentSelected", "SELECTED");
            rulesHash.put("readSelected", "");
            rulesHash.put("headerChecked", "CHECKED");
            rulesHash.put("subjectSelected", "SELECTED");
            rulesHash.put("senderSelected", "");
            rulesHash.put("dateSelected", "");
            rulesHash.put("prioritySelected", "");
            rulesHash.put("toSelected", "");
            rulesHash.put("ccSelected", "");
            rulesHash.put("containsSelected", "SELECTED");
            rulesHash.put("doesntSelected", "");
            rulesHash.put("ruleValue", "");
            rulesHash.put("isAppHandler", this.appHelper.getName());
            return this.provider.getTemplate("views-rule-config.template", rulesHash);
        }
        catch (Exception e) {
            this.debugError("MailViews.getRuleConfig(): ", e);
            throw new ProviderException(e.getMessage());
        }
    }

    private StringBuffer getRuleConfig(HttpServletRequest request, String selected) throws ProviderException {
        String configName = null;
        Object ruleStr = null;
        String target = null;
        String opr = null;
        String str = null;
        boolean match = false;
        Hashtable<String, String> rulesHash = new Hashtable<String, String>();
        Configuration ruleConfig = null;
        try {
            ruleConfig = this.rulesFactory.readConfiguration(selected, false, request);
            match = true;
        }
        catch (Exception e) {
            this.debugMessage("MailViews.getRuleConfig(): Can not obtain rule: " + selected);
        }
        if (match) {
            configName = selected;
            target = ruleConfig.getProperty("target");
            this.debugMessage("MailViews.getRuleConfig(): target = " + target);
            opr = ruleConfig.getProperty("op");
            this.debugMessage("MailViews.getRuleConfig(): op = " + opr);
            str = ruleConfig.getProperty("ruleValue");
            this.debugMessage("MailViews.getRuleConfig(): ruleValue = " + str);
        }
        try {
            rulesHash.put("action", "Edit");
            rulesHash.put("iwtDesktop-fontFace1", this.provider.getStringProperty("fontFace1", "Sans-serif"));
            rulesHash.put("ruleName", configName);
            rulesHash.put("recentReadChecked", "");
            rulesHash.put("isSelected", "SELECTED");
            rulesHash.put("isntSelected", "");
            rulesHash.put("recentSelected", "SELECTED");
            rulesHash.put("readSelected", "");
            rulesHash.put("headerChecked", "CHECKED");
            rulesHash.put("subjectSelected", "");
            rulesHash.put("senderSelected", "");
            rulesHash.put("dateSelected", "");
            rulesHash.put("prioritySelected", "");
            rulesHash.put("toSelected", "");
            rulesHash.put("ccSelected", "");
            rulesHash.put("containsSelected", "SELECTED");
            rulesHash.put("doesntSelected", "");
            rulesHash.put("ruleValue", "");
            if (match) {
                if (target.equalsIgnoreCase("flag")) {
                    rulesHash.put("recentReadChecked", "CHECKED");
                    rulesHash.put("headerChecked", "");
                } else if (target.equalsIgnoreCase("subject")) {
                    rulesHash.put("subjectSelected", "SELECTED");
                } else if (target.equalsIgnoreCase("sender")) {
                    rulesHash.put("senderSelected", "SELECTED");
                } else if (target.equalsIgnoreCase("date")) {
                    rulesHash.put("dateSelected", "SELECTED");
                } else if (target.equalsIgnoreCase("priority")) {
                    rulesHash.put("prioritySelected", "SELECTED");
                } else if (target.equalsIgnoreCase("to")) {
                    rulesHash.put("toSelected", "SELECTED");
                } else if (target.equalsIgnoreCase("cc")) {
                    rulesHash.put("ccSelected", "SELECTED");
                }
                if (opr.startsWith("does")) {
                    rulesHash.put("containsSelected", "");
                    rulesHash.put("doesntSelected", "SELECTED");
                } else if (opr.startsWith("isn")) {
                    rulesHash.put("isSelected", "");
                    rulesHash.put("isntSelected", "SELECTED");
                }
                if (str.equalsIgnoreCase("read")) {
                    rulesHash.put("recentSelected", "");
                    rulesHash.put("readSelected", "SELECTED");
                } else if (!str.equalsIgnoreCase("recent") && !str.equalsIgnoreCase("read")) {
                    rulesHash.put("ruleValue", str);
                }
            }
            rulesHash.put("isAppHandler", this.appHelper.getName());
            ProviderUtility.setDefaultPresentation(this.provider.getName(), this.provider.getProviderContext(), rulesHash);
            return this.provider.getTemplate("views-rule-config.template", rulesHash);
        }
        catch (Exception e) {
            this.debugError("MailViews.getRuleConfig(): ", e);
            throw new ProviderException(e.getMessage());
        }
    }

    private StringBuffer getViews(HttpServletRequest request) throws ProviderException {
        this.debugMessage("Entering MailViews.getViews().....");
        StringBuffer viewConfigs = new StringBuffer(0);
        Hashtable<String, CharSequence> manageViewsHash = new Hashtable<String, CharSequence>();
        Hashtable<String, String> viewOptionHash = new Hashtable<String, String>();
        try {
            ProviderUtility.setDefaultPresentation(this.provider.getName(), this.provider.getProviderContext(), viewOptionHash);
            ProviderUtility.setDefaultPresentation(this.provider.getName(), this.provider.getProviderContext(), manageViewsHash);
        }
        catch (ProviderContextException pce) {
            this.debugMessage("MailViews.getViews: setDefaultPresentation", pce);
        }
        try {
            manageViewsHash.put("iwtDesktop-fontFace1", this.provider.getStringProperty("fontFace1", "Sans-serif"));
            Enumeration availableViews = this.viewsFactory.getConfigurationNames(request);
            while (availableViews.hasMoreElements()) {
                String viewName = String.valueOf(availableViews.nextElement());
                this.debugMessage("MailViews.getViews(): viewName = " + viewName);
                viewOptionHash.put("viewName", viewName);
                viewConfigs.append(this.provider.getTemplate("views-options.template", viewOptionHash));
            }
            manageViewsHash.put("viewConfigs", viewConfigs);
            manageViewsHash.put("isAppHandler", this.appHelper.getName());
            return this.provider.getTemplate("views-manage-views.template", manageViewsHash);
        }
        catch (Exception e) {
            this.debugError("MailViews.getViews()", e);
            throw new ProviderException(e.getMessage());
        }
    }

    private StringBuffer getViewConfig(HttpServletRequest request) throws ProviderException {
        this.debugMessage("Entering MailViews.getAddViewConfig().....");
        Object addViewPage = null;
        StringBuffer ruleConfigs = new StringBuffer(0);
        Hashtable<String, CharSequence> addViewHash = new Hashtable<String, CharSequence>();
        Hashtable<String, String> ruleOptionHash = new Hashtable<String, String>();
        try {
            ProviderUtility.setDefaultPresentation(this.provider.getName(), this.provider.getProviderContext(), ruleOptionHash);
            ProviderUtility.setDefaultPresentation(this.provider.getName(), this.provider.getProviderContext(), addViewHash);
        }
        catch (ProviderContextException pce) {
            this.debugMessage("MailViews.getViewConfig: setDefaultPresentation", pce);
        }
        this.desktopURL = this.makeReturnURL(request);
        try {
            addViewHash.put("action", "Add");
            addViewHash.put("iwtDesktop-fontFace1", this.provider.getStringProperty("fontFace1", "Sans-serif"));
            addViewHash.put("viewName", "");
            addViewHash.put("selectedRules", "");
            addViewHash.put("anyCheck", "CHECKED");
            addViewHash.put("allCheck", "");
            Enumeration availableRules = this.rulesFactory.getConfigurationNames(request);
            while (availableRules.hasMoreElements()) {
                String ruleName = String.valueOf(availableRules.nextElement());
                this.debugMessage("MailViews.getViewConfig(): ruleName = " + ruleName);
                ruleOptionHash.put("ruleId", ruleName);
                ruleConfigs.append(this.provider.getTemplate("views-rule-options.template", ruleOptionHash));
            }
            addViewHash.put("availableRules", ruleConfigs);
            addViewHash.put("isAppHandler", this.appHelper.getName());
            return this.provider.getTemplate("views-rule-selection.template", addViewHash);
        }
        catch (Exception e) {
            this.debugError("MailViews.getViewConfig()", e);
            throw new ProviderException(e.getMessage());
        }
    }

    public StringBuffer getViewConfig(HttpServletRequest request, String selected) throws ProviderException {
        this.debugMessage("Entering MailViews.getViewConfig().....");
        Object rule = null;
        String ruleName = null;
        String selectedRule = "";
        Hashtable<String, CharSequence> editViewHash = new Hashtable<String, CharSequence>();
        Hashtable<String, String> selectRuleHash = new Hashtable<String, String>();
        Hashtable<String, String> availRuleHash = new Hashtable<String, String>();
        StringBuffer selectRules = new StringBuffer(0);
        StringBuffer availRules = new StringBuffer(0);
        String providerName = this.editContainer;
        this.desktopURL = this.makeReturnURL(request);
        Configuration viewConfig = null;
        try {
            Enumeration availableRules;
            editViewHash.put("action", "Edit");
            editViewHash.put("iwtDesktop-fontFace1", this.provider.getStringProperty("fontFace1", "Sans-serif"));
            ProviderUtility.setDefaultPresentation(this.provider.getName(), this.provider.getProviderContext(), editViewHash);
            ProviderUtility.setDefaultPresentation(this.provider.getName(), this.provider.getProviderContext(), selectRuleHash);
            ProviderUtility.setDefaultPresentation(this.provider.getName(), this.provider.getProviderContext(), availRuleHash);
            try {
                viewConfig = this.viewsFactory.readConfiguration(selected, false, request);
                editViewHash.put("viewName", selected);
            }
            catch (Exception e) {
                this.debugMessage("MailViews.getViewConfig(): Can not obtain view: " + selected);
            }
            String[] selectedRules = viewConfig.getPropertyArray("ruleName");
            if (selectedRules != null) {
                for (int j = 0; j < selectedRules.length; ++j) {
                    selectRuleHash.put("ruleId", selectedRules[j]);
                    selectRuleHash.put("preSelect", "selected");
                    selectRules.append(this.provider.getTemplate("views-rule-options.template", selectRuleHash));
                }
                this.debugMessage("MailViews.getViewConfig(): Selected Rules = " + selectRules.toString());
                editViewHash.put("selectedRules", selectRules);
                availableRules = this.rulesFactory.getConfigurationNames(request);
                while (availableRules.hasMoreElements()) {
                    ruleName = (String)availableRules.nextElement();
                    boolean alreadySelected = false;
                    for (int j = 0; j < selectedRules.length; ++j) {
                        if (!ruleName.equals(selectedRules[j])) continue;
                        alreadySelected = true;
                        break;
                    }
                    if (alreadySelected) continue;
                    availRuleHash.put("ruleId", ruleName);
                    availRules.append(this.provider.getTemplate("views-rule-options.template", availRuleHash));
                }
                this.debugMessage("MailViews.getViewConfig(): Available Rules = " + availRules.toString());
            } else {
                this.debugMessage("MailViews.getViewConfig(): No rules for selected view");
                availableRules = this.rulesFactory.getConfigurationNames(request);
                while (availableRules.hasMoreElements()) {
                    ruleName = (String)availableRules.nextElement();
                    availRuleHash.put("ruleId", ruleName);
                    availRules.append(this.provider.getTemplate("views-rule-options.template", availRuleHash));
                }
            }
            editViewHash.put("availableRules", availRules);
            String applyVal = viewConfig.getProperty("applyAll");
            this.debugMessage("MailViews.getViewConfig(): applyVal = " + applyVal);
            if (applyVal.equalsIgnoreCase("true")) {
                editViewHash.put("anyCheck", "");
                editViewHash.put("allCheck", "CHECKED");
            } else {
                editViewHash.put("anyCheck", "CHECKED");
                editViewHash.put("allCheck", "");
            }
            editViewHash.put("isAppHandler", this.appHelper.getName());
            return this.provider.getTemplate("views-rule-selection.template", editViewHash);
        }
        catch (Exception e) {
            this.debugError("MailViews.getViewConfig()", e);
            throw new ProviderException(e.getMessage());
        }
    }

    private StringBuffer getDeviceViews(HttpServletRequest request) throws ProviderException {
        StringBuffer editContent = new StringBuffer(0);
        String client = request.getParameter("client");
        try {
            editContent = client == null || client.equalsIgnoreCase("") ? this.getClientConfigEdit(request) : new StringBuffer("You have selected " + client + " device");
        }
        catch (Exception e) {
            throw new ProviderException("MailViews.getDeviceViews(): ", (Throwable)e);
        }
        return editContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer getClientConfigEdit(HttpServletRequest request) throws Exception {
        this.debugMessage("Entering DeviceSelect.getClientConfigEdit()");
        Hashtable<String, CharSequence> mainTags = new Hashtable<String, CharSequence>();
        Hashtable<String, String> optionTags = new Hashtable<String, String>();
        Hashtable<String, CharSequence> selectTags = new Hashtable<String, CharSequence>();
        try {
            ProviderUtility.setDefaultPresentation(this.provider.getName(), this.provider.getProviderContext(), optionTags);
            ProviderUtility.setDefaultPresentation(this.provider.getName(), this.provider.getProviderContext(), selectTags);
            ProviderUtility.setDefaultPresentation(this.provider.getName(), this.provider.getProviderContext(), mainTags);
        }
        catch (ProviderContextException pce) {
            this.debugMessage("MailViews.getClientConfigEdit: setDefaultPresentation", pce);
        }
        ProviderContext pcontext = this.provider.getProviderContext();
        String desktopURL = pcontext.getDesktopURL(request);
        StringBuffer clientOptions = new StringBuffer(0);
        StringBuffer clientSelect = new StringBuffer(0);
        StringBuffer viewselectURL = new StringBuffer(desktopURL);
        StringBuffer mailviewURL = new StringBuffer(desktopURL);
        String clientType = null;
        Object clientName = null;
        String client_type_name = null;
        Set selectedClients = null;
        this.debugMessage("MailViews.getClientConfigEdit(): desktopURL = " + desktopURL);
        mailviewURL = mailviewURL.append('?').append("action").append('=').append("edit").append(this.getAmpersand()).append("provider").append('=').append(URLEncoder.encode(this.editContainer)).append(this.getAmpersand()).append("targetprovider").append('=').append(this.provider.getName()).append(this.getAmpersand()).append("containerName=").append(URLEncoder.encode(this.containerName)).append(this.getAmpersand()).append("appPref=").append(URLEncoder.encode(this.appHelper.getName())).append(this.getAmpersand()).append("viewmode=edit");
        this.debugMessage("MailViews.getClientConfigEdit(): mailviewURL = " + mailviewURL);
        mainTags.put("viewselect_link", pcontext.encodeURL(mailviewURL.toString()));
        selectedClients = pcontext.getCollectionProperty("WirelessDesktopDispatcher", "selectedClients").keySet();
        int size = selectedClients.size();
        Iterator i = selectedClients.iterator();
        while (i.hasNext()) {
            clientType = (String)i.next();
            if (clientType == null) {
                String invc = null;
                try {
                    invc = this.bundle.getString("MailViews-invalidClient");
                    if (invc != null) {
                        throw new ProviderException(invc);
                    }
                }
                catch (Throwable t) {
                    this.debugMessage("MailViews.getClientConfigEdit(): ", t);
                }
                finally {
                    invc = null;
                }
            }
            if (clientType == null) continue;
            this.debugMessage("MailViews.getClientConfigEdit():  clientType = " + clientType);
            try {
                client_type_name = this.deviceBundle.getString(clientType);
            }
            catch (MissingResourceException mre) {
                this.debugMessage("MailViews.getClientConfigEdit(): " + mre.getMessage());
                client_type_name = clientType;
            }
            try {
                optionTags.clear();
                optionTags.put("client_type_name", clientType);
                optionTags.put("client", client_type_name);
                clientOptions.append(pcontext.getTemplate(this.provider.getName(), "clientOption.template", optionTags));
            }
            catch (Throwable e) {
                client_type_name = null;
                this.debugError("MailViews.getClientConfigEdit():", e);
            }
        }
        selectTags.clear();
        selectTags.put("clientSize", String.valueOf(size));
        selectTags.put("clientOptions", clientOptions);
        clientSelect.append(pcontext.getTemplate(this.provider.getName(), "clientSelect.template", selectTags));
        mainTags.put("selectClients", clientSelect);
        mainTags.put("isAppHandler", this.appHelper.getName());
        mainTags.put("views-display-error", this.bundle.getString("MailViews-NoClientValue"));
        return pcontext.getTemplate(this.provider.getName(), "clientConfiguration.template", mainTags);
    }

    public String getAmpersand() {
        return "&amp;";
    }

    public URL processEdit(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        String err;
        this.debugMessage("Entering MailViews.processEdit()....");
        Object errMsg = null;
        URL url = null;
        Object selected = null;
        String editURL = null;
        if (request.getParameter("RulesError") != null || request.getParameter("EditRule") != null || request.getParameter("DeleteRule") != null) {
            editURL = this.makeReturnURL(request, "Rules");
        } else if (request.getParameter("ViewsError") != null || request.getParameter("EditView") != null || request.getParameter("DeleteView") != null) {
            editURL = this.makeReturnURL(request, "Views");
        } else if (request.getParameter("Submit") != null) {
            if (request.getParameter("Submit").equalsIgnoreCase("Finished")) {
                if (request.getParameter("Rules") != null) {
                    editURL = this.makeReturnURL(request, "Rules");
                } else if (request.getParameter("Views") != null) {
                    editURL = this.makeReturnURL(request, "Views");
                } else {
                    this.debugMessage("MailViews.processEdit(): processEdit -> mail");
                    editURL = this.makeReturnURL(request);
                }
            }
        } else {
            editURL = this.makeReturnURL(request);
        }
        if (request.getParameter("addRule") != null) {
            editURL = editURL + "&page=AddRule&viewmode=edit";
        }
        if (request.getParameter("editRule") != null) {
            editURL = editURL + "&page=EditRule&viewmode=edit";
            editURL = editURL + "&order=" + request.getParameter("order");
        }
        if (request.getParameter("deleteRule") != null) {
            if (request.getParameter("order") != null) {
                editURL = editURL + "&viewmode=Rules";
                url = this.deleteRule(request, editURL);
                return url;
            }
            err = "MailViews-NoRuleValue";
            editURL = editURL + "&err=" + err;
            editURL = editURL + "&page=DeleteRule&viewmode=edit";
        }
        if (request.getParameter("action") != null && request.getParameter("Rules") != null) {
            url = this.processRuleConfig(request, editURL);
            return url;
        }
        if (request.getParameter("addView") != null) {
            editURL = editURL + "&page=AddView&viewmode=edit";
        }
        if (request.getParameter("editView") != null) {
            editURL = editURL + "&page=EditView&viewmode=edit";
            editURL = editURL + "&order=" + request.getParameter("order");
        }
        if (request.getParameter("deleteView") != null) {
            if (request.getParameter("order") != null) {
                editURL = editURL + "&viewmode=Views";
                url = this.deleteView(request, editURL);
                return url;
            }
            err = "MailViews-NoViewValue";
            editURL = editURL + "&err=" + err;
            editURL = editURL + "&page=DeleteView&viewmode=edit";
        }
        if (request.getParameter("action") != null && request.getParameter("Views") != null) {
            url = this.processViewConfig(request, editURL);
            return url;
        }
        if (request.getParameter("viewClient") != null && request.getParameter("addView") == null && request.getParameter("editView") == null && request.getParameter("deleteView") == null && request.getParameter("Submit").equalsIgnoreCase("Finished")) {
            url = this.processClientViews(request, editURL);
            return url;
        }
        try {
            this.debugMessage("MailViews.processEdit(): Return URL = " + editURL);
            url = new URL(editURL);
        }
        catch (MalformedURLException e) {
            this.debugError("MailViews.processEdit(): ", e);
            throw new ProviderException(e.getMessage());
        }
        return url;
    }

    private URL processRuleConfig(HttpServletRequest request, String editURL) {
        String errMsg;
        this.debugMessage("Entering MailViews.processRuleConfig...");
        URL returnURL = null;
        String ruleName = null;
        String ruleType = null;
        String action = request.getParameter("action");
        String returnPage = "RulesError";
        ruleName = request.getParameter("ruleName");
        ruleType = request.getParameter("ruleType");
        if (ruleName == null || ruleName.equals("") || ruleType == null || ruleType.equals("")) {
            String errMsg2 = "MailViews-NoRuleName";
            return this.getEditReturnURL(request, errMsg2, returnPage);
        }
        Configuration ruleConfig = new Configuration();
        if (action.equals("Edit")) {
            try {
                ruleConfig = this.rulesFactory.readConfiguration(ruleName, false, request);
            }
            catch (Exception e) {
                this.debugMessage("MailViews.processRuleConfigEdit(): Can not obtain rule: " + ruleName);
            }
        } else {
            ruleConfig.setConfigurationName(ruleName);
        }
        if (ruleType.equalsIgnoreCase("recentRead")) {
            String op = request.getParameter("operation_recent");
            String age = request.getParameter("age");
            ruleConfig.setProperty("target", "flag");
            ruleConfig.setProperty("op", op);
            ruleConfig.setProperty("ruleValue", age);
        } else if (ruleType.equalsIgnoreCase("header")) {
            String target = request.getParameter("target");
            String op = request.getParameter("operation_header");
            String ruleValue = request.getParameter("ruleValue");
            ruleConfig.setProperty("target", target);
            ruleConfig.setProperty("op", op);
            if (ruleValue != null || !ruleValue.equals("")) {
                ruleConfig.setProperty("ruleValue", ruleValue);
            } else {
                String errMsg3 = "MailViews-NoRuleValue";
                return this.getEditReturnURL(request, errMsg3, returnPage);
            }
        }
        try {
            this.rulesFactory.writeConfiguration(ruleConfig, request);
        }
        catch (Exception e) {
            this.debugError("MailViews.processRuleConfigEdit(): Can not add configuration: " + ruleConfig, e);
            errMsg = "MailViews-addRuleFailed";
            return this.getEditReturnURL(request, errMsg, returnPage);
        }
        try {
            returnURL = new URL(editURL);
        }
        catch (MalformedURLException me) {
            this.debugError("MailViews.processRuleConfigEdit()Can not make URL from " + editURL, me);
            errMsg = "MailViews-invalidURLErr";
            return this.getEditReturnURL(request, errMsg, returnPage);
        }
        return returnURL;
    }

    private URL deleteRule(HttpServletRequest request, String editURL) {
        this.debugMessage("MailViews.deleteRule(): Entering deleteRule()...");
        Configuration viewConf = new Configuration();
        String ruleName = request.getParameter("order");
        this.debugMessage("MailViews.deleteRule(): Rule Name to be deleted = " + ruleName);
        try {
            Enumeration availableViews = this.viewsFactory.getConfigurationNames(request);
            while (availableViews.hasMoreElements()) {
                viewConf = this.viewsFactory.readConfiguration((String)availableViews.nextElement(), false, request);
                String[] viewRules = viewConf.getPropertyArray("ruleName");
                boolean inUse = false;
                for (int j = 0; j < viewRules.length; ++j) {
                    if (!ruleName.equals(viewRules[j])) continue;
                    inUse = true;
                    break;
                }
                if (!inUse) continue;
                this.errMsg = "MailViews-deleteRuleViewFailed";
                editURL = editURL + "&err=" + this.errMsg;
                editURL = editURL + "&page=DeleteRule&viewmode=edit";
                try {
                    return new URL(editURL);
                }
                catch (MalformedURLException mf) {
                    this.debugError("MailViews.deleteRule(): ", mf);
                }
            }
        }
        catch (Exception e) {
            this.debugError("MailViews.deleteRule(): ", e);
        }
        try {
            this.rulesFactory.removeConfiguration(ruleName, request);
        }
        catch (ConfigurationException ce) {
            this.debugError("MailViews.deleteRule(): ", ce);
            this.errMsg = "MailViews-deleteRuleFailed";
            editURL = editURL + "&err=" + this.errMsg;
            editURL = editURL + "&page=DeleteRule&viewmode=edit";
        }
        try {
            return new URL(editURL);
        }
        catch (MalformedURLException mf) {
            this.debugError("MailViews.deleteRule(): ", mf);
            return null;
        }
    }

    private URL processViewConfig(HttpServletRequest request, String editURL) throws ProviderException {
        this.debugMessage("Entering MailViews.processViewConfig...");
        Object viewsConfigURL = null;
        String errMsg = null;
        URL returnURL = null;
        String action = request.getParameter("action");
        String returnPage = "ViewsError";
        String viewName = request.getParameter("viewName");
        this.debugMessage("MailViews.processViewConfig(): viewName = " + viewName);
        if (viewName == null || viewName.equals("")) {
            errMsg = "MailViews-NoViewName";
            return this.getEditReturnURL(request, errMsg, returnPage);
        }
        String rules = request.getParameter("selectedRules");
        this.debugMessage("MailViews.processViewConfig(): selectedRules = null");
        if (rules == null || rules.equals("")) {
            errMsg = "MailViews-NoSelectedRule";
            return this.getEditReturnURL(request, errMsg, returnPage);
        }
        Configuration viewConfig = new Configuration();
        if (action.equals("Edit")) {
            try {
                viewConfig = this.viewsFactory.readConfiguration(viewName, false, request);
            }
            catch (Exception e) {
                this.debugMessage("MailViews.processViewConfigEdit(): Can not obtain view: " + viewName);
            }
        } else {
            viewConfig.setConfigurationName(viewName);
        }
        if (request.getParameter("ruleMatch") != null && request.getParameter("ruleMatch").equalsIgnoreCase("all")) {
            viewConfig.setProperty("applyAll", "true");
        } else {
            viewConfig.setProperty("applyAll", "false");
        }
        ArrayList<String> ruleList = new ArrayList<String>();
        Enumeration paramEnum = request.getParameterNames();
        while (paramEnum.hasMoreElements()) {
            String key = String.valueOf(paramEnum.nextElement());
            String[] values = request.getParameterValues(key);
            for (int i = 0; i < values.length; ++i) {
                if (!key.equals("selectedRules")) continue;
                ruleList.add(values[i]);
            }
        }
        String[] ruleArray = ruleList.toArray(new String[0]);
        viewConfig.setPropertyArray("ruleName", ruleArray);
        try {
            this.viewsFactory.writeConfiguration(viewConfig, request);
        }
        catch (Exception e) {
            this.debugError("MailViews.processViewConfig(): Can not add configuration: " + viewConfig, e);
            errMsg = "MailViews-addViewFailed";
            return this.getEditReturnURL(request, errMsg, returnPage);
        }
        try {
            returnURL = new URL(editURL);
        }
        catch (MalformedURLException me) {
            this.debugError("MailViews.processRuleConfigEdit()Can not make URL from " + editURL, me);
            errMsg = "MailViews-invalidURLErr";
            return this.getEditReturnURL(request, errMsg, returnPage);
        }
        return returnURL;
    }

    private URL deleteView(HttpServletRequest request, String editURL) throws ProviderException {
        this.debugMessage("MailViews.deleteView(): Entering deleteView...");
        boolean inselected = false;
        boolean match = false;
        Object returnURL = null;
        Object viewStr = null;
        Object viewConfigURL = null;
        String viewName = request.getParameter("order");
        this.debugMessage("MailViews.deleteView(): view to be deleted is = " + viewName);
        Set viewclientSet = null;
        try {
            viewclientSet = this.dsameConn.getAttribute(VIEWCLIENTATTR);
        }
        catch (Exception e) {
            this.debugError("MailViews.deleteView(): ", e);
            throw new ProviderException(e.getMessage());
        }
        if (viewclientSet != null) {
            Iterator viewclient = viewclientSet.iterator();
            while (viewclient.hasNext()) {
                String viewcl = String.valueOf(viewclient.next());
                this.debugMessage("MailViews.deleteView(): existing view-client = " + viewcl);
                if (viewcl == null) break;
                String vwname = viewcl.substring(viewcl.lastIndexOf(124) + 1).trim();
                this.debugMessage("MailViews.deleteView(): Existing vwname = " + vwname);
                if (!vwname.equals(viewName)) continue;
                inselected = true;
                this.debugMessage("MailViews.deleteView(): View " + viewName + "exists in selected views list.");
                this.errMsg = "MailViews-deleteViewClient";
                editURL = editURL + "&err=" + this.errMsg;
                editURL = editURL + "&page=DeleteView&viewmode=edit";
                try {
                    return new URL(editURL);
                }
                catch (MalformedURLException mf) {
                    this.debugError("MailViews.deleteView(): ", mf);
                }
            }
        }
        if (!inselected) {
            try {
                this.viewsFactory.removeConfiguration(viewName, request);
            }
            catch (ConfigurationException ce) {
                this.debugError("MailViews.deleteView(): ", ce);
                String errMsg = "MailViews-deleteViewFailed";
                editURL = editURL + "&err=" + errMsg;
                editURL = editURL + "&page=DeleteView&viewmode=edit";
            }
        }
        try {
            return new URL(editURL);
        }
        catch (MalformedURLException me) {
            this.debugError("MailViews.deleteView(): ", me);
            throw new ProviderException(me.getMessage());
        }
    }

    private StringBuffer getViewEdit(HttpServletRequest request, String client) throws ProviderException {
        Hashtable<String, CharSequence> viewHash = new Hashtable<String, CharSequence>();
        Hashtable<String, String> avlHash = new Hashtable<String, String>();
        Hashtable<String, String> selHash = new Hashtable<String, String>();
        StringBuffer selViews = new StringBuffer(0);
        try {
            ProviderUtility.setDefaultPresentation(this.provider.getName(), this.provider.getProviderContext(), viewHash);
            ProviderUtility.setDefaultPresentation(this.provider.getName(), this.provider.getProviderContext(), avlHash);
            ProviderUtility.setDefaultPresentation(this.provider.getName(), this.provider.getProviderContext(), selHash);
        }
        catch (ProviderContextException pce) {
            this.debugMessage("MailViews.getViewEdit: setDefaultPresentation", pce);
        }
        String selName = null;
        Object viewClient = null;
        Object views = null;
        this.debugMessage("MailViews.getViewEdit()...entering..");
        viewHash.put("clientName", client);
        client = request.getParameter("client");
        this.debugMessage("MailViews.getViewEdit(): client = " + client);
        Set viewsSet = this.getSAALAttribute(VIEWCLIENTATTR, client);
        ArrayList<String> selList = new ArrayList<String>();
        if (viewsSet != null) {
            this.debugMessage("MailViews.getViewEdit(): viewsSet has " + viewsSet.size() + " elements");
            Iterator l = viewsSet.iterator();
            while (l.hasNext()) {
                selName = String.valueOf(l.next());
                selHash.put("viewName", selName);
                selList.add(selName);
                selViews.append(this.provider.getTemplate("views-selected-options.template", selHash));
            }
            viewHash.put("selectedViews", selViews);
        }
        StringBuffer avlViews = new StringBuffer(0);
        String avlName = null;
        Enumeration avlConfigs = this.viewsFactory.getConfigurationNames(request);
        while (avlConfigs.hasMoreElements()) {
            avlName = (String)avlConfigs.nextElement();
            if (!selList.contains(avlName)) {
                avlHash.put("viewName", avlName);
                avlViews.append(this.provider.getTemplate("views-options.template", avlHash));
                this.debugMessage("MailViews.getViewEdit(): Available View = " + avlName);
                continue;
            }
            this.debugMessage("MailViews.getSelectedViews(): " + avlName + " already selected");
        }
        viewHash.put("availableViews", avlViews);
        viewHash.put("isAppHandler", this.appHelper.getName());
        return this.provider.getTemplate("views.template", viewHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL processClientViews(HttpServletRequest request, String editURL) throws ProviderException {
        String[] selectedViews;
        this.debugMessage("Entering MailViews.processClientViews()...");
        String clientName = request.getParameter("client");
        this.debugMessage("MailViews.processClientViews():  Client Name = " + clientName);
        String returnURL = this.provider.getProviderContext().getDesktopURL(request);
        returnURL = returnURL + "?action=edit";
        returnURL = returnURL + "&provider=" + URLEncoder.encode(this.editContainer);
        returnURL = returnURL + "&targetprovider=" + URLEncoder.encode(this.provider.getName());
        returnURL = returnURL + "&appPref=" + URLEncoder.encode(this.appHelper.getName());
        returnURL = returnURL + "&viewmode=Device";
        this.debugMessage("MailViews.processClientViews(): returnURL = " + returnURL);
        HashSet<String> viewClientSet = this.getSAALAttribute(VIEWCLIENTATTR, clientName);
        if (viewClientSet == null) {
            this.debugMessage("MailViews.processClientViews(): viewClientSet is null");
            viewClientSet = new HashSet<String>();
        }
        if ((selectedViews = request.getParameterValues("selectedViews")) == null) {
            HashSet<String> hashSet = viewClientSet;
            synchronized (hashSet) {
                if (!viewClientSet.isEmpty()) {
                    viewClientSet.clear();
                }
                try {
                    this.setSAALAttribute(VIEWCLIENTATTR, viewClientSet, clientName);
                    return new URL(returnURL);
                }
                catch (Exception e) {
                    throw new ProviderException(e.getMessage());
                }
            }
        }
        this.debugMessage("MailViews.processClientViews(): selection is not null");
        HashSet<String> hashSet = viewClientSet;
        synchronized (hashSet) {
            if (viewClientSet.size() != 0) {
                viewClientSet.clear();
            }
            for (int k = 0; k < selectedViews.length; ++k) {
                String viewclientURL = String.valueOf(selectedViews[k]);
                if (viewClientSet.add(viewclientURL)) {
                    this.debugMessage("MailViews.processClientViews(): Adding URL " + viewclientURL);
                    try {
                        this.setSAALAttribute(VIEWCLIENTATTR, viewClientSet, clientName);
                        continue;
                    }
                    catch (Exception ee) {
                        throw new ProviderException(ee.getMessage());
                    }
                }
                this.debugMessage("MailViews.processClientViews(): Failed to add URL : " + viewclientURL);
            }
        }
        try {
            return new URL(returnURL);
        }
        catch (MalformedURLException mex) {
            this.debugError("MailViews.processClientViews(): ", mex);
            throw new ProviderException(mex.getMessage());
        }
    }

    private StringBuffer getErrorMessage(HttpServletRequest request, String errMesg, String errPage) {
        if (errMesg != null) {
            Hashtable<String, String> errHash = new Hashtable<String, String>();
            try {
                ProviderUtility.setDefaultPresentation(this.provider.getName(), this.provider.getProviderContext(), errHash);
                errHash.put("page", errPage);
                errHash.put("views-display-error", this.bundle.getString(errMesg));
                errHash.put("iwtDesktop-fontFace1", this.provider.getStringProperty("fontFace1", "Sans-serif"));
                errHash.put("isAppHandler", this.appHelper.getName());
                return this.provider.getTemplate("views-display-error.template", errHash);
            }
            catch (Throwable np) {
                this.debugError("MailViews.getErrorMessage(): ", np);
                return new StringBuffer(0);
            }
        }
        return new StringBuffer(0);
    }

    private void logParams(HttpServletRequest request) {
        Enumeration paramEnum = request.getParameterNames();
        this.debugMessage("***** ======BEGIN REQUEST PARAMS===== ******");
        while (paramEnum.hasMoreElements()) {
            String key = String.valueOf(paramEnum.nextElement());
            String[] values = request.getParameterValues(key);
            for (int i = 0; i < values.length; ++i) {
                this.debugMessage(key + " = " + values[i]);
            }
        }
        this.debugMessage("***** ======END REQUEST PARAMS===== ******");
    }

    private void debugMessage(Object o) {
        if (this.provider.getProviderContext().isDebugMessageEnabled()) {
            this.provider.getProviderContext().debugMessage(o);
        }
    }

    private void debugMessage(Object o, Throwable t) {
        if (this.provider.getProviderContext().isDebugMessageEnabled()) {
            this.provider.getProviderContext().debugMessage(o, t);
        }
    }

    private void debugError(Object o, Throwable t) {
        if (this.provider.getProviderContext().isDebugErrorEnabled()) {
            this.provider.getProviderContext().debugError(o, t);
        }
    }

    private void debugError(Object o) {
        if (this.provider.getProviderContext().isDebugErrorEnabled()) {
            this.provider.getProviderContext().debugError(o);
        }
    }

    private void setSAALStringAttribute(String name, String value) throws IllegalStateException, MissingResourceException, IOException {
        try {
            this.mailViewUserContext.setStringAttribute(this.serviceMap, name, value);
        }
        catch (IOException e) {
            this.debugError("MailViews.setSAALStringAttribute(): Can not set attribute " + name + " with value " + value, e);
            throw e;
        }
    }

    private Set getSAALAttribute(String name, String clientType) throws IllegalStateException {
        Set value = null;
        try {
            value = this.mailViewUserContext.getAttribute(this.serviceMap, clientType, name);
        }
        catch (Exception e) {
            this.debugError("MailViews.getSAALAttribute(): Can not get attribute " + name, e);
        }
        return value;
    }

    private void setSAALAttribute(String name, Set value) throws IllegalStateException, MissingResourceException, IOException {
        if (value == null || value.size() == 0) {
            try {
                this.removeSAALAttribute(name);
            }
            catch (Exception ie) {
                this.debugError("MailViews.setSAALAttribute(): Can not remove attribute " + name, ie);
            }
        } else {
            try {
                this.mailViewUserContext.setAttribute(this.serviceMap, name, value);
                this.mailViewUserContext.store();
            }
            catch (IOException e) {
                this.debugError("MailViews.setSAALAttribute(): Can not set attribute " + name + " with value " + value, e);
                throw e;
            }
        }
    }

    private void setSAALAttribute(String name, Set value, String clientType) throws IllegalStateException, MissingResourceException, IOException {
        if (value == null || value.size() == 0) {
            try {
                this.mailViewUserContext.setAttribute(this.serviceMap, clientType, name, null);
                this.mailViewUserContext.store();
            }
            catch (Exception ie) {
                this.debugError("MailViews.setSAALAttribute(): Can not remove attribute " + name, ie);
            }
        } else {
            try {
                this.mailViewUserContext.setAttribute(this.serviceMap, clientType, name, value);
                this.mailViewUserContext.store();
            }
            catch (IOException e) {
                this.debugError("MailViews.setSAALAttribute(): Can not set attribute " + name + " with value " + value, e);
                throw e;
            }
            catch (IllegalStateException ise) {
                this.debugError("MailViews.setSAALAttribute(): Can not set attribute " + name + " with value " + value, ise);
                throw ise;
            }
            catch (MissingResourceException me) {
                this.debugError("MailViews.setSAALAttribute(): Can not set attribute " + name + " with value " + value, me);
                throw me;
            }
        }
    }

    private void removeSAALAttribute(String name) throws IllegalStateException, MissingResourceException, IOException {
        try {
            this.mailViewUserContext.removeAttribute(this.serviceMap, name);
            this.mailViewUserContext.store();
        }
        catch (IOException e) {
            this.debugError("MailViews.removeSAALStringAttribute(): Can not remove attribute " + name, e);
            throw e;
        }
    }

    private String makeReturnURL(HttpServletRequest request) {
        String client = request.getParameter("client");
        String desktopURL = this.provider.getProviderContext().getDesktopURL(request);
        desktopURL = desktopURL + "?action=edit";
        desktopURL = desktopURL + "&provider=" + URLEncoder.encode(this.editContainer);
        desktopURL = desktopURL + "&targetprovider=" + URLEncoder.encode(this.provider.getName());
        desktopURL = desktopURL + "&appPref=" + URLEncoder.encode(this.appHelper.getName());
        return desktopURL;
    }

    private String makeReturnURL(HttpServletRequest request, String target) {
        String desktopURL = this.provider.getProviderContext().getDesktopURL(request);
        desktopURL = desktopURL + "?action=edit";
        desktopURL = desktopURL + "&provider=" + URLEncoder.encode(this.editContainer);
        desktopURL = desktopURL + "&targetprovider=" + URLEncoder.encode(this.provider.getName());
        desktopURL = desktopURL + "&appPref=" + URLEncoder.encode(this.appHelper.getName());
        desktopURL = desktopURL + "&viewmode=" + target;
        return desktopURL;
    }

    private URL getEditReturnURL(HttpServletRequest request, String errMsg, String returnPage) {
        URL url = null;
        String editURL = this.makeReturnURL(request, returnPage);
        editURL = editURL + "&err=" + errMsg;
        editURL = editURL + "&page=" + returnPage;
        try {
            url = new URL(editURL);
        }
        catch (MalformedURLException e) {
            this.debugError("MailViews.getEditReturnURL(): ", e);
        }
        return url;
    }
}

